/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.TimestampTZ;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.exec.UDFMethodResolver;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastDateToBoolean;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastDecimalToBoolean;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastStringToBoolean;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastStringToLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastTimestampToBoolean;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.CastDoubleToBooleanViaDoubleToLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.CastLongToBooleanViaLongToLong;
import org.apache.hadoop.hive.ql.udf.TimestampCastRestrictorResolver;
import org.apache.hadoop.hive.ql.udf.UDFUtils;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;

@VectorizedExpressions(value={CastLongToBooleanViaLongToLong.class, CastDateToBoolean.class, CastTimestampToBoolean.class, CastStringToBoolean.class, CastDoubleToBooleanViaDoubleToLong.class, CastDecimalToBoolean.class, CastStringToLong.class})
@Description(name="boolean", value="_FUNC_(x) - converts it's parameter to _FUNC_", extended="- x is NULL -> NULL\n- byte, short, integer, long, float, double, decimal:\n  x == 0 -> false\n  x != 0 -> true\n- string:\n  x is '', 'false', 'no', 'zero', 'off' -> false\n  true otherwise\n- date: always NULL\n- timestamp\n  seconds or nanos are 0 -> false\n  true otherwise\nExample:\n   > SELECT _FUNC_(0);\n  false")
public class UDFToBoolean
extends UDF {
    private final BooleanWritable booleanWritable = new BooleanWritable();

    public UDFMethodResolver getResolver() {
        return new TimestampCastRestrictorResolver(super.getResolver());
    }

    public BooleanWritable evaluate(NullWritable i) {
        return null;
    }

    public BooleanWritable evaluate(ByteWritable i) {
        if (i == null) {
            return null;
        }
        this.booleanWritable.set(i.get() != 0);
        return this.booleanWritable;
    }

    public BooleanWritable evaluate(ShortWritable i) {
        if (i == null) {
            return null;
        }
        this.booleanWritable.set(i.get() != 0);
        return this.booleanWritable;
    }

    public BooleanWritable evaluate(IntWritable i) {
        if (i == null) {
            return null;
        }
        this.booleanWritable.set(i.get() != 0);
        return this.booleanWritable;
    }

    public BooleanWritable evaluate(LongWritable i) {
        if (i == null) {
            return null;
        }
        this.booleanWritable.set(i.get() != 0L);
        return this.booleanWritable;
    }

    public BooleanWritable evaluate(FloatWritable i) {
        if (i == null) {
            return null;
        }
        this.booleanWritable.set(i.get() != 0.0f);
        return this.booleanWritable;
    }

    public BooleanWritable evaluate(DoubleWritable i) {
        if (i == null) {
            return null;
        }
        this.booleanWritable.set(i.get() != 0.0);
        return this.booleanWritable;
    }

    public BooleanWritable evaluate(Text i) {
        if (i == null) {
            return null;
        }
        boolean b = PrimitiveObjectInspectorUtils.parseBoolean((byte[])i.getBytes(), (int)0, (int)i.getLength());
        this.booleanWritable.set(b);
        return this.booleanWritable;
    }

    public BooleanWritable evaluate(DateWritableV2 d) {
        return null;
    }

    public BooleanWritable evaluate(TimestampWritableV2 i) {
        if (i == null) {
            return null;
        }
        TimestampTZ timestamp = UDFUtils.getTimestampTZFromTimestamp(i.getTimestamp());
        this.booleanWritable.set(timestamp.getEpochSecond() != 0L || timestamp.getNanos() != 0);
        return this.booleanWritable;
    }

    public BooleanWritable evaluate(HiveDecimalWritable i) {
        if (i == null || !i.isSet()) {
            return null;
        }
        this.booleanWritable.set(i.compareTo(HiveDecimal.ZERO) != 0);
        return this.booleanWritable;
    }
}

