/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor.handler;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.ListUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.ValidCleanerWriteIdList;
import org.apache.hadoop.hive.common.ValidReadTxnList;
import org.apache.hadoop.hive.common.ValidReaderWriteIdList;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.GetValidWriteIdsRequest;
import org.apache.hadoop.hive.metastore.api.GetValidWriteIdsResponse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TableValidWriteIds;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.metrics.AcidMetricService;
import org.apache.hadoop.hive.metastore.txn.TxnCommonUtils;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.txn.entities.CompactionInfo;
import org.apache.hadoop.hive.ql.io.AcidDirectory;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.txn.compactor.CleanupRequest;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorUtil;
import org.apache.hadoop.hive.ql.txn.compactor.FSRemover;
import org.apache.hadoop.hive.ql.txn.compactor.MetadataCache;
import org.apache.hive.common.util.Ref;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TaskHandler {
    private static final Logger LOG = LoggerFactory.getLogger((String)TaskHandler.class.getName());
    protected final TxnStore txnHandler;
    private final ThreadLocal<HiveConf> threadLocalConf = ThreadLocal.withInitial(() -> new HiveConf(conf));
    protected final boolean metricsEnabled;
    private final MetadataCache metadataCache;
    protected final FSRemover fsRemover;
    private final long defaultRetention;

    TaskHandler(HiveConf conf, TxnStore txnHandler, MetadataCache metadataCache, boolean metricsEnabled, FSRemover fsRemover) {
        this.txnHandler = txnHandler;
        this.metadataCache = metadataCache;
        this.metricsEnabled = metricsEnabled;
        this.fsRemover = fsRemover;
        this.defaultRetention = MetastoreConf.getTimeVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_COMPACTOR_CLEANER_RETRY_RETENTION_TIME, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public abstract List<Runnable> getTasks(HiveConf var1) throws MetaException;

    protected HiveConf getConf() {
        return this.threadLocalConf.get();
    }

    protected GetOpenTxnsResponse getOpenTxns() throws Exception {
        return this.metadataCache.computeIfAbsent("openTxns", () -> ((TxnStore)this.txnHandler).getOpenTxns());
    }

    protected Table resolveTable(CompactionInfo info) throws Exception {
        return this.metadataCache.computeIfAbsent(info.getFullTableName(), () -> this.resolveTable(info.dbname, info.tableName));
    }

    @VisibleForTesting
    Table resolveTable(String dbName, String tableName) throws MetaException {
        return CompactorUtil.resolveTable(this.getConf(), dbName, tableName);
    }

    protected Partition resolvePartition(String dbName, String tableName, String partName) throws MetaException {
        return CompactorUtil.resolvePartition(this.getConf(), null, dbName, tableName, partName, CompactorUtil.METADATA_FETCH_MODE.LOCAL);
    }

    protected ValidReaderWriteIdList getValidCleanerWriteIdList(CompactionInfo info, ValidTxnList validTxnList) throws Exception {
        List<String> tblNames = Collections.singletonList(TxnUtils.getFullTableName((String)info.dbname, (String)info.tableName));
        GetValidWriteIdsRequest request = new GetValidWriteIdsRequest(tblNames);
        request.setValidTxnList(validTxnList.writeToString());
        GetValidWriteIdsResponse rsp = this.metadataCache.computeIfAbsent(info.getFullTableName() + validTxnList.writeToString(), () -> this.txnHandler.getValidWriteIds(request));
        assert (rsp != null && rsp.getTblValidWriteIdsSize() == 1);
        ValidReaderWriteIdList validWriteIdList = TxnCommonUtils.createValidReaderWriteIdList((TableValidWriteIds)((TableValidWriteIds)rsp.getTblValidWriteIds().getFirst()));
        return new ValidCleanerWriteIdList(validWriteIdList);
    }

    protected boolean cleanAndVerifyObsoleteDirectories(CompactionInfo info, String location, ValidReaderWriteIdList validWriteIdList, Table table) throws MetaException, IOException {
        List<Path> deleted;
        Path path = new Path(location);
        FileSystem fs = path.getFileSystem((Configuration)this.getConf());
        Map<Path, AcidUtils.HdfsDirSnapshot> dirSnapshots = AcidUtils.getHdfsDirSnapshotsForCleaner(fs, path);
        AcidDirectory dir = AcidUtils.getAcidState(fs, path, (Configuration)this.getConf(), (ValidWriteIdList)validWriteIdList, (Ref<Boolean>)Ref.from((Object)false), false, dirSnapshots);
        boolean isDynPartAbort = CompactorUtil.isDynPartAbort(table, info.partName);
        List<Path> obsoleteDirs = CompactorUtil.getObsoleteDirs(dir, isDynPartAbort);
        if (isDynPartAbort || dir.hasUncompactedAborts()) {
            info.setWriteIds(dir.hasUncompactedAborts(), dir.getAbortedWriteIds());
        }
        if (!(deleted = this.fsRemover.clean(new CleanupRequest.CleanupRequestBuilder().setLocation(location).setDbName(info.dbname).setFullPartitionName(info.getFullPartitionName()).setRunAs(info.runAs).setObsoleteDirs(obsoleteDirs).setPurge(true).build())).isEmpty()) {
            AcidMetricService.updateMetricsFromCleaner((String)info.dbname, (String)info.tableName, (String)info.partName, dir.getObsolete(), (Configuration)this.getConf(), (TxnStore)this.txnHandler);
        }
        boolean success = false;
        this.getConf().set("hive.txn.valid.txns", new ValidReadTxnList().toString());
        dir = AcidUtils.getAcidState(fs, path, (Configuration)this.getConf(), (ValidWriteIdList)new ValidCleanerWriteIdList(info.getFullTableName(), info.highestWriteId), (Ref<Boolean>)Ref.from((Object)false), false, dirSnapshots);
        List remained = ListUtils.subtract(CompactorUtil.getObsoleteDirs(dir, isDynPartAbort), deleted);
        if (!remained.isEmpty()) {
            LOG.warn("Remained {} obsolete directories from {}. {}", new Object[]{remained.size(), location, CompactorUtil.getDebugInfo(remained)});
        } else {
            LOG.debug("All cleared below the watermark: {} from {}", (Object)info.highestWriteId, (Object)location);
            success = true;
        }
        return success;
    }

    protected void handleCleanerAttemptFailure(CompactionInfo info, String errorMessage) throws MetaException {
        int cleanAttempts = 0;
        info.errorMessage = errorMessage;
        if (info.isAbortedTxnCleanup()) {
            info.retryRetention = info.retryRetention > 0L ? info.retryRetention * 2L : this.defaultRetention;
            info.errorMessage = errorMessage;
            this.txnHandler.setCleanerRetryRetentionTimeOnError(info);
        } else {
            if (info.retryRetention > 0L) {
                cleanAttempts = (int)(Math.log(info.retryRetention / this.defaultRetention) / Math.log(2.0)) + 1;
            }
            if (cleanAttempts >= MetastoreConf.getIntVar((Configuration)this.getConf(), (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_COMPACTOR_CLEANER_MAX_RETRY_ATTEMPTS)) {
                this.txnHandler.markFailed(info);
            } else {
                info.retryRetention = (long)Math.pow(2.0, cleanAttempts) * this.defaultRetention;
                this.txnHandler.setCleanerRetryRetentionTimeOnError(info);
            }
        }
    }
}

