/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.txn.TxnCommonUtils;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.entities.CompactionInfo;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorUtil;
import org.apache.hadoop.hive.ql.txn.compactor.MetadataCache;
import org.apache.hadoop.hive.ql.txn.compactor.TableOptimizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcidTableOptimizer
extends TableOptimizer {
    private static final String CLASS_NAME = AcidTableOptimizer.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLASS_NAME);

    public AcidTableOptimizer(HiveConf conf, TxnStore txnHandler, MetadataCache metadataCache) {
        super(conf, txnHandler, metadataCache);
    }

    @Override
    public Set<CompactionInfo> findPotentialCompactions(long lastChecked, ShowCompactResponse currentCompactions, Set<String> skipDBs, Set<String> skipTables) throws MetaException {
        long abortedTimeThreshold;
        int abortedThreshold = HiveConf.getIntVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_COMPACTOR_ABORTEDTXN_THRESHOLD);
        Set<CompactionInfo> potentials = this.txnHandler.findPotentialCompactions(abortedThreshold, abortedTimeThreshold = HiveConf.getTimeVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_COMPACTOR_ABORTEDTXN_TIME_THRESHOLD, (TimeUnit)TimeUnit.MILLISECONDS), lastChecked).parallelStream().filter(ci -> this.isEligibleForCompaction((CompactionInfo)ci, currentCompactions, skipDBs, skipTables)).collect(Collectors.toSet());
        if (!potentials.isEmpty()) {
            ValidTxnList validTxnList = TxnCommonUtils.createValidReadTxnList((GetOpenTxnsResponse)this.txnHandler.getOpenTxns(), (long)0L);
            this.conf.set("hive.txn.valid.txns", validTxnList.writeToString());
        }
        return potentials;
    }

    @Override
    protected boolean isEligibleForCompaction(CompactionInfo ci, ShowCompactResponse currentCompactions, Set<String> skipDBs, Set<String> skipTables) {
        try {
            if (!super.isEligibleForCompaction(ci, currentCompactions, skipDBs, skipTables)) {
                return false;
            }
            String qualifiedTableName = ci.getFullTableName();
            Table t = this.metadataCache.computeIfAbsent(qualifiedTableName, () -> CompactorUtil.resolveTable(this.conf, ci.dbname, ci.tableName));
            if (AcidUtils.isInsertOnlyTable(t.getParameters()) && !HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_COMPACTOR_COMPACT_MM)) {
                skipTables.add(ci.getFullTableName());
                LOG.info("Table {} is insert only and {}=false so we will not compact it.", (Object)qualifiedTableName, (Object)HiveConf.ConfVars.HIVE_COMPACTOR_COMPACT_MM.varname);
                return false;
            }
            if (AcidTableOptimizer.isDynPartIngest(t, ci)) {
                return false;
            }
        }
        catch (Exception e) {
            LOG.error("Caught exception while checking compaction eligibility.", (Throwable)e);
            try {
                ci.errorMessage = e.getMessage();
                this.txnHandler.markFailed(ci);
            }
            catch (MetaException ex) {
                LOG.error("Caught exception while marking compaction as failed.", (Throwable)e);
            }
            return false;
        }
        return true;
    }

    protected static boolean isDynPartIngest(Table t, CompactionInfo ci) {
        if (t.getPartitionKeys() != null && !t.getPartitionKeys().isEmpty() && ci.partName == null && !ci.hasOldAbort) {
            LOG.info("Skipping entry for {} as it is from dynamic partitioning", (Object)ci.getFullTableName());
            return true;
        }
        return false;
    }
}

