/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.stats;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.HiveStatsUtils;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.SetPartitionsStatsRequest;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.FetchOperator;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManager;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ColumnStatsDesc;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.stats.ColumnStatisticsObjTranslator;
import org.apache.hadoop.hive.ql.stats.IStatsProcessor;
import org.apache.hadoop.hive.serde2.objectinspector.InspectableObject;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.mapred.JobConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColStatsProcessor
implements IStatsProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ColStatsProcessor.class);
    private FetchOperator ftOp;
    private FetchWork fWork;
    private ColumnStatsDesc colStatDesc;
    private HiveConf conf;
    private boolean isStatsReliable;

    public ColStatsProcessor(ColumnStatsDesc colStats, HiveConf conf) {
        this.conf = conf;
        this.fWork = colStats.getFWork();
        this.colStatDesc = colStats;
        this.isStatsReliable = conf.getBoolVar(HiveConf.ConfVars.HIVE_STATS_RELIABLE);
    }

    @Override
    public void initialize(CompilationOpContext opContext) {
        try {
            this.fWork.initializeForFetch(opContext);
            JobConf job = new JobConf((Configuration)this.conf);
            this.ftOp = new FetchOperator(this.fWork, job);
        }
        catch (Exception e) {
            LOG.error("Failed to initialize", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public int process(Hive db, Table tbl) throws Exception {
        return this.persistColumnStats(db, tbl);
    }

    private boolean constructColumnStatsFromPackedRows(Table tbl, List<ColumnStatistics> stats, long maxNumStats) throws HiveException, MetaException, IOException {
        InspectableObject packedRow;
        String partName = null;
        List<String> colName = this.colStatDesc.getColName();
        List<String> colType = this.colStatDesc.getColType();
        boolean isTblLevel = this.colStatDesc.isTblLevel();
        long numStats = 0L;
        while ((packedRow = this.ftOp.getNextRow()) != null) {
            if (packedRow.oi.getCategory() != ObjectInspector.Category.STRUCT) {
                throw new HiveException("Unexpected object type encountered while unpacking row");
            }
            ArrayList<ColumnStatisticsObj> statsObjs = new ArrayList<ColumnStatisticsObj>();
            StructObjectInspector soi = (StructObjectInspector)packedRow.oi;
            List fields = soi.getAllStructFieldRefs();
            List values = soi.getStructFieldsDataAsList(packedRow.o);
            int pos = 0;
            for (int i = 0; i < colName.size(); ++i) {
                String columnName = colName.get(i);
                String columnType = colType.get(i);
                PrimitiveTypeInfo typeInfo = (PrimitiveTypeInfo)TypeInfoUtils.getTypeInfoFromTypeString((String)columnType);
                List<ColumnStatsField> columnStatsFields = ColumnStatsType.getColumnStats(typeInfo);
                columnStatsFields = ColumnStatsType.removeDisabledStatistics(this.conf, columnStatsFields);
                try {
                    ColumnStatisticsObj statObj = ColumnStatisticsObjTranslator.readHiveColumnStatistics(columnName, columnType, columnStatsFields, pos, fields, values);
                    statsObjs.add(statObj);
                    ++numStats;
                }
                catch (Exception e) {
                    if (this.isStatsReliable) {
                        throw new HiveException("Statistics collection failed while (hive.stats.reliable)", (Throwable)e);
                    }
                    LOG.debug("Because {} is infinite or NaN, we skip stats.", (Object)columnName, (Object)e);
                }
                pos += columnStatsFields.size();
            }
            if (statsObjs.isEmpty()) continue;
            if (!isTblLevel) {
                ArrayList<FieldSchema> partColSchema = new ArrayList<FieldSchema>();
                ArrayList<String> partVals = new ArrayList<String>();
                if (tbl.hasNonNativePartitionSupport()) {
                    ObjectInspector inspector = ((StructField)fields.get(pos)).getFieldObjectInspector();
                    if (inspector.getCategory() == ObjectInspector.Category.STRUCT) {
                        Object obj = values.get(pos);
                        StructObjectInspector oi = (StructObjectInspector)inspector;
                        for (StructField field : oi.getAllStructFieldRefs()) {
                            partColSchema.add(new FieldSchema(field.getFieldName(), null, ""));
                            partVals.add(String.valueOf(oi.getStructFieldData(obj, field)));
                        }
                    }
                } else {
                    partColSchema.addAll(tbl.getPartCols());
                    for (int i = pos; i < pos + partColSchema.size(); ++i) {
                        Object partVal = ((PrimitiveObjectInspector)((StructField)fields.get(i)).getFieldObjectInspector()).getPrimitiveJavaObject(values.get(i));
                        partVals.add(partVal == null ? this.conf.getVar(HiveConf.ConfVars.DEFAULT_PARTITION_NAME) : partVal.toString());
                    }
                }
                partName = Warehouse.makePartName(partColSchema, partVals);
            }
            ColumnStatisticsDesc statsDesc = this.buildColumnStatsDesc(tbl, partName, isTblLevel);
            ColumnStatistics colStats = new ColumnStatistics();
            colStats.setStatsDesc(statsDesc);
            colStats.setStatsObj(statsObjs);
            colStats.setEngine("hive");
            stats.add(colStats);
            if (numStats < maxNumStats) continue;
            return false;
        }
        this.ftOp.clearFetchContext();
        return true;
    }

    private ColumnStatisticsDesc buildColumnStatsDesc(Table table, String partName, boolean isTblLevel) {
        String dbName = table.getDbName();
        assert (dbName != null);
        ColumnStatisticsDesc statsDesc = new ColumnStatisticsDesc();
        statsDesc.setDbName(dbName);
        statsDesc.setTableName(table.getTableName());
        statsDesc.setIsTblLevel(isTblLevel);
        if (!isTblLevel) {
            statsDesc.setPartName(partName);
        } else {
            statsDesc.setPartName(null);
        }
        return statsDesc;
    }

    public int persistColumnStats(Hive db, Table tbl) throws HiveException, MetaException, IOException {
        HiveTxnManager txnMgr;
        long writeId = -1L;
        ValidWriteIdList validWriteIdList = null;
        HiveTxnManager hiveTxnManager = txnMgr = AcidUtils.isTransactionalTable(tbl) ? SessionState.get().getTxnMgr() : null;
        if (txnMgr != null) {
            writeId = txnMgr.getAllocatedTableWriteId(tbl.getDbName(), tbl.getTableName());
            validWriteIdList = AcidUtils.getTableValidWriteIdList((Configuration)this.conf, AcidUtils.getFullTableName(tbl.getDbName(), tbl.getTableName()));
        }
        boolean done = false;
        long maxNumStats = this.conf.getLongVar(HiveConf.ConfVars.HIVE_STATS_MAX_NUM_STATS);
        while (!done) {
            ArrayList<ColumnStatistics> colStats = new ArrayList<ColumnStatistics>();
            long start = System.currentTimeMillis();
            done = this.constructColumnStatsFromPackedRows(tbl, colStats, maxNumStats);
            long end = System.currentTimeMillis();
            LOG.info("Time taken to build " + colStats.size() + " stats desc : " + (float)(end - start) / 1000.0f + " seconds.");
            if (colStats.isEmpty()) continue;
            SetPartitionsStatsRequest request = new SetPartitionsStatsRequest(colStats);
            request.setNeedMerge(this.colStatDesc.isNeedMerge());
            if (txnMgr != null) {
                request.setWriteId(writeId);
                if (validWriteIdList != null) {
                    request.setValidWriteIdList(validWriteIdList.toString());
                }
            }
            start = System.currentTimeMillis();
            if (tbl.isNonNative() && tbl.getStorageHandler().canSetColStatistics(tbl)) {
                boolean success = tbl.getStorageHandler().setColStatistics(tbl, colStats);
                if (!(tbl.isMaterializedView() || tbl.isView() || tbl.isTemporary())) {
                    this.setOrRemoveColumnStatsAccurateProperty(db, tbl, this.colStatDesc.getColName(), success);
                }
            } else {
                db.setPartitionColumnStatistics(request);
            }
            end = System.currentTimeMillis();
            LOG.info("Time taken to update " + colStats.size() + " stats : " + (float)(end - start) / 1000.0f + " seconds.");
        }
        return 0;
    }

    @Override
    public void setDpPartSpecs(Collection<Partition> dpPartSpecs) {
    }

    private void setOrRemoveColumnStatsAccurateProperty(Hive db, Table tbl, List<String> colNames, boolean success) throws HiveException {
        if (CollectionUtils.isEmpty(colNames) || !this.colStatDesc.isTblLevel()) {
            return;
        }
        EnvironmentContext environmentContext = new EnvironmentContext();
        environmentContext.putToProperties("DO_NOT_UPDATE_STATS", "true");
        if (success) {
            StatsSetupConst.setColumnStatsState(tbl.getParameters(), colNames);
        } else {
            StatsSetupConst.removeColumnStatsState(tbl.getParameters(), colNames);
        }
        db.alterTable(tbl.getFullyQualifiedName(), tbl, environmentContext, false);
    }

    public static enum ColumnStatsType {
        BOOLEAN((List<ColumnStatsField>)ImmutableList.of((Object)((Object)ColumnStatsField.COLUMN_STATS_TYPE), (Object)((Object)ColumnStatsField.COUNT_TRUES), (Object)((Object)ColumnStatsField.COUNT_FALSES), (Object)((Object)ColumnStatsField.COUNT_NULLS))),
        LONG((List<ColumnStatsField>)ImmutableList.of((Object)((Object)ColumnStatsField.COLUMN_STATS_TYPE), (Object)((Object)ColumnStatsField.MIN), (Object)((Object)ColumnStatsField.MAX), (Object)((Object)ColumnStatsField.COUNT_NULLS), (Object)((Object)ColumnStatsField.NDV), (Object)((Object)ColumnStatsField.BITVECTOR), (Object)((Object)ColumnStatsField.KLL_SKETCH))),
        DOUBLE((List<ColumnStatsField>)ImmutableList.of((Object)((Object)ColumnStatsField.COLUMN_STATS_TYPE), (Object)((Object)ColumnStatsField.MIN), (Object)((Object)ColumnStatsField.MAX), (Object)((Object)ColumnStatsField.COUNT_NULLS), (Object)((Object)ColumnStatsField.NDV), (Object)((Object)ColumnStatsField.BITVECTOR), (Object)((Object)ColumnStatsField.KLL_SKETCH))),
        STRING((List<ColumnStatsField>)ImmutableList.of((Object)((Object)ColumnStatsField.COLUMN_STATS_TYPE), (Object)((Object)ColumnStatsField.MAX_LENGTH), (Object)((Object)ColumnStatsField.AVG_LENGTH), (Object)((Object)ColumnStatsField.COUNT_NULLS), (Object)((Object)ColumnStatsField.NDV), (Object)((Object)ColumnStatsField.BITVECTOR))),
        BINARY((List<ColumnStatsField>)ImmutableList.of((Object)((Object)ColumnStatsField.COLUMN_STATS_TYPE), (Object)((Object)ColumnStatsField.MAX_LENGTH), (Object)((Object)ColumnStatsField.AVG_LENGTH), (Object)((Object)ColumnStatsField.COUNT_NULLS))),
        DECIMAL((List<ColumnStatsField>)ImmutableList.of((Object)((Object)ColumnStatsField.COLUMN_STATS_TYPE), (Object)((Object)ColumnStatsField.MIN), (Object)((Object)ColumnStatsField.MAX), (Object)((Object)ColumnStatsField.COUNT_NULLS), (Object)((Object)ColumnStatsField.NDV), (Object)((Object)ColumnStatsField.BITVECTOR), (Object)((Object)ColumnStatsField.KLL_SKETCH))),
        DATE((List<ColumnStatsField>)ImmutableList.of((Object)((Object)ColumnStatsField.COLUMN_STATS_TYPE), (Object)((Object)ColumnStatsField.MIN), (Object)((Object)ColumnStatsField.MAX), (Object)((Object)ColumnStatsField.COUNT_NULLS), (Object)((Object)ColumnStatsField.NDV), (Object)((Object)ColumnStatsField.BITVECTOR), (Object)((Object)ColumnStatsField.KLL_SKETCH))),
        TIMESTAMP((List<ColumnStatsField>)ImmutableList.of((Object)((Object)ColumnStatsField.COLUMN_STATS_TYPE), (Object)((Object)ColumnStatsField.MIN), (Object)((Object)ColumnStatsField.MAX), (Object)((Object)ColumnStatsField.COUNT_NULLS), (Object)((Object)ColumnStatsField.NDV), (Object)((Object)ColumnStatsField.BITVECTOR), (Object)((Object)ColumnStatsField.KLL_SKETCH)));

        private final List<ColumnStatsField> columnStats;

        private ColumnStatsType(List<ColumnStatsField> columnStats) {
            this.columnStats = columnStats;
        }

        public List<ColumnStatsField> getColumnStats() {
            return this.columnStats;
        }

        public static ColumnStatsType getColumnStatsType(PrimitiveTypeInfo typeInfo) throws SemanticException {
            switch (typeInfo.getPrimitiveCategory()) {
                case BOOLEAN: {
                    return BOOLEAN;
                }
                case BYTE: 
                case SHORT: 
                case INT: 
                case LONG: 
                case TIMESTAMPLOCALTZ: {
                    return LONG;
                }
                case FLOAT: 
                case DOUBLE: {
                    return DOUBLE;
                }
                case DECIMAL: {
                    return DECIMAL;
                }
                case DATE: {
                    return DATE;
                }
                case TIMESTAMP: {
                    return TIMESTAMP;
                }
                case STRING: 
                case CHAR: 
                case VARCHAR: {
                    return STRING;
                }
                case BINARY: {
                    return BINARY;
                }
            }
            throw new SemanticException("Not supported type " + typeInfo.getTypeName() + " for statistics computation");
        }

        public static List<ColumnStatsField> getColumnStats(PrimitiveTypeInfo typeInfo) throws SemanticException {
            return ColumnStatsType.getColumnStatsType(typeInfo).getColumnStats();
        }

        public static List<ColumnStatsField> removeDisabledStatistics(HiveConf conf, List<ColumnStatsField> columnStatsFields) {
            if (!HiveStatsUtils.computeHistograms((Configuration)conf)) {
                return columnStatsFields.stream().filter(f -> f != ColumnStatsField.KLL_SKETCH).collect(Collectors.toList());
            }
            return columnStatsFields;
        }
    }

    public static enum ColumnStatsField {
        COLUMN_STATS_TYPE("columntype"),
        COUNT_TRUES("counttrues"),
        COUNT_FALSES("countfalses"),
        COUNT_NULLS("countnulls"),
        MIN("min"),
        MAX("max"),
        NDV("numdistinctvalues"),
        BITVECTOR("ndvbitvector"),
        KLL_SKETCH("kllsketch"),
        MAX_LENGTH("maxlength"),
        AVG_LENGTH("avglength");

        private final String fieldName;

        private ColumnStatsField(String fieldName) {
            this.fieldName = fieldName;
        }

        public String getFieldName() {
            return this.fieldName;
        }
    }
}

