/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.filtercontext;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.HiveMetaStoreAuthorizableEvent;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.HiveMetaStoreAuthzInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseFilterContext
extends HiveMetaStoreAuthorizableEvent {
    private static final Logger LOG = LoggerFactory.getLogger(DatabaseFilterContext.class);
    String catName = null;
    List<String> databaseNames = null;
    Map<String, Database> databaseMap = null;

    public DatabaseFilterContext(String catName, List<String> dbNames) {
        super(null);
        this.catName = catName;
        this.databaseNames = dbNames;
        this.getAuthzContext();
    }

    private DatabaseFilterContext(List<String> dbNames, Map<String, Database> dbMap) {
        super(null);
        this.databaseNames = dbNames != null ? dbNames : new ArrayList();
        this.databaseMap = dbMap != null ? dbMap : new HashMap();
        this.getAuthzContext();
    }

    public static DatabaseFilterContext createFromDatabases(List<Database> databases) {
        ArrayList<String> dbNames = new ArrayList<String>();
        HashMap<String, Database> dbMap = new HashMap<String, Database>();
        if (databases != null) {
            for (Database db : databases) {
                if (db == null) continue;
                String dbName = db.getName();
                dbNames.add(dbName);
                dbMap.put(dbName, db);
            }
        }
        return new DatabaseFilterContext(dbNames, dbMap);
    }

    @Override
    public HiveMetaStoreAuthzInfo getAuthzContext() {
        HiveMetaStoreAuthzInfo ret = new HiveMetaStoreAuthzInfo(this.preEventContext, HiveOperationType.QUERY, this.getInputHObjs(), this.getOutputHObjs(), null);
        return ret;
    }

    private List<HivePrivilegeObject> getInputHObjs() {
        LOG.debug("==> DatabaseFilterContext.getInputHObjs()");
        ArrayList<HivePrivilegeObject> ret = new ArrayList<HivePrivilegeObject>();
        HivePrivilegeObject.HivePrivilegeObjectType type = HivePrivilegeObject.HivePrivilegeObjectType.DATABASE;
        for (String dbName : this.databaseNames) {
            Database db;
            Database database = db = this.databaseMap != null ? this.databaseMap.get(dbName) : null;
            if (db != null) {
                ret.add(this.getHivePrivilegeObject(db));
                continue;
            }
            HivePrivilegeObject hivePrivilegeObject = new HivePrivilegeObject(type, dbName);
            ret.add(hivePrivilegeObject);
        }
        LOG.debug("<== DatabaseFilterContext.getInputHObjs(): ret=" + String.valueOf(ret));
        return ret;
    }

    private List<HivePrivilegeObject> getOutputHObjs() {
        return Collections.emptyList();
    }

    public List<String> getDatabaseNames() {
        return this.databaseNames;
    }
}

