/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.events;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.events.PreAddPartitionEvent;
import org.apache.hadoop.hive.metastore.events.PreEventContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.HiveMetaStoreAuthorizableEvent;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.HiveMetaStoreAuthzInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddPartitionEvent
extends HiveMetaStoreAuthorizableEvent {
    private static final Logger LOG = LoggerFactory.getLogger(AddPartitionEvent.class);
    private String COMMAND_STR = "alter table %s add partition %s";

    public AddPartitionEvent(PreEventContext preEventContext) {
        super(preEventContext);
    }

    @Override
    public HiveMetaStoreAuthzInfo getAuthzContext() {
        HiveMetaStoreAuthzInfo ret = new HiveMetaStoreAuthzInfo(this.preEventContext, HiveOperationType.ALTERTABLE_ADDPARTS, this.getInputHObjs(), this.getOutputHObjs(), this.COMMAND_STR);
        return ret;
    }

    private List<HivePrivilegeObject> getInputHObjs() {
        return Collections.emptyList();
    }

    private List<HivePrivilegeObject> getOutputHObjs() {
        LOG.debug("==> AddPartitionEvent.getOutputHObjs()");
        ArrayList<HivePrivilegeObject> ret = new ArrayList<HivePrivilegeObject>();
        PreAddPartitionEvent event = (PreAddPartitionEvent)this.preEventContext;
        Table table = event.getTable();
        ret.add(this.getHivePrivilegeObject(table));
        List partitions = event.getPartitions();
        if (partitions != null) {
            for (Partition partition : partitions) {
                String uri = this.getSdLocation(partition.getSd());
                if (!StringUtils.isNotEmpty((CharSequence)uri)) continue;
                ret.add(this.getHivePrivilegeObjectDfsUri(uri));
            }
        }
        this.COMMAND_STR = this.buildCommandString(this.COMMAND_STR, table);
        LOG.debug("<== AddPartitionEvent.getOutputHObjs(): ret={}", ret);
        return ret;
    }

    private String buildCommandString(String cmdStr, Table tbl) {
        String ret = cmdStr;
        if (tbl != null) {
            String tblName = StringUtils.isNotEmpty((CharSequence)tbl.getTableName()) ? " " + tbl.getTableName() : "";
            StringBuilder partitions = new StringBuilder();
            List fieldSchemas = tbl.getPartitionKeys();
            for (FieldSchema fieldSchema : fieldSchemas) {
                partitions.append(" ");
                partitions.append(fieldSchema.getName());
            }
            ret = String.format(cmdStr, tblName, partitions.toString());
        }
        return ret;
    }
}

