/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.reexec;

import org.apache.hadoop.hive.ql.reexec.IReExecutionPlugin;
import org.apache.hadoop.hive.ql.reexec.ReCompileWithoutCBOPlugin;
import org.apache.hadoop.hive.ql.reexec.ReExecuteLostAMQueryPlugin;
import org.apache.hadoop.hive.ql.reexec.ReExecuteOnWriteConflictPlugin;
import org.apache.hadoop.hive.ql.reexec.ReExecutionDagSubmitPlugin;
import org.apache.hadoop.hive.ql.reexec.ReExecutionOverlayPlugin;
import org.apache.hadoop.hive.ql.reexec.ReOptimizePlugin;

public enum ReExecutionStrategyType {
    OVERLAY(ReExecutionOverlayPlugin.class),
    REOPTIMIZE(ReOptimizePlugin.class),
    REEXECUTE_LOST_AM(ReExecuteLostAMQueryPlugin.class),
    RECOMPILE_WITHOUT_CBO(ReCompileWithoutCBOPlugin.class),
    DAGSUBMIT(ReExecutionDagSubmitPlugin.class),
    WRITE_CONFLICT(ReExecuteOnWriteConflictPlugin.class);

    private final Class<? extends IReExecutionPlugin> pluginClass;

    private ReExecutionStrategyType(Class<? extends IReExecutionPlugin> pluginClass) {
        this.pluginClass = pluginClass;
    }

    public Class<? extends IReExecutionPlugin> getPluginClass() {
        return this.pluginClass;
    }

    public static Class<? extends IReExecutionPlugin> getPluginClassByName(String strategy) {
        return ReExecutionStrategyType.valueOf(strategy.toUpperCase()).getPluginClass();
    }
}

