/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.processors;

import com.google.common.base.Joiner;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Schema;
import org.apache.hadoop.hive.ql.processors.CommandProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessorException;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.processors.HiveCommand;
import org.apache.hadoop.hive.ql.session.ProcessListInfo;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShowProcessListProcessor
implements CommandProcessor {
    private static final Logger LOG = LoggerFactory.getLogger((String)ShowProcessListProcessor.class.getName());
    private static final SessionState.LogHelper console = new SessionState.LogHelper(LOG);
    private List<ProcessListInfo> liveQueries = null;

    public void setup(List<ProcessListInfo> liveQueries) {
        this.liveQueries = liveQueries;
    }

    private Schema getSchema() {
        Schema sch = new Schema();
        sch.addToFieldSchemas(new FieldSchema("User Name", "string", ""));
        sch.addToFieldSchemas(new FieldSchema("Ip Addr", "string", ""));
        sch.addToFieldSchemas(new FieldSchema("Execution Engine", "string", ""));
        sch.addToFieldSchemas(new FieldSchema("Session Id", "string", ""));
        sch.addToFieldSchemas(new FieldSchema("Session Active Time (s)", "string", ""));
        sch.addToFieldSchemas(new FieldSchema("Session Idle Time (s)", "string", ""));
        sch.addToFieldSchemas(new FieldSchema("Query ID", "string", ""));
        sch.addToFieldSchemas(new FieldSchema("State", "string", ""));
        sch.addToFieldSchemas(new FieldSchema("Txn ID", "string", ""));
        sch.addToFieldSchemas(new FieldSchema("Opened Timestamp (s)", "string", ""));
        sch.addToFieldSchemas(new FieldSchema("Elapsed Time (s)", "string", ""));
        sch.addToFieldSchemas(new FieldSchema("Runtime (s)", "string", ""));
        sch.putToProperties("serialization.null.format", "\\N");
        return sch;
    }

    @Override
    public CommandProcessorResponse run(String command) throws CommandProcessorException {
        try {
            String[] tokens = command.split("\\s+");
            boolean isCorrectSubCommand = HiveCommand.PROCESSLIST.name().equalsIgnoreCase(tokens[0]);
            if (tokens.length != 1 || !isCorrectSubCommand) {
                throw new CommandProcessorException("Show ProcessList Failed: Unsupported sub-command option");
            }
            if (CollectionUtils.isEmpty(this.liveQueries)) {
                return new CommandProcessorResponse(this.getSchema(), "No queries running currently");
            }
            SessionState ss = SessionState.get();
            this.liveQueries.forEach(query -> ss.out.println(Joiner.on((String)"\t").join((Object)query.getUserName(), (Object)query.getIpAddr(), new Object[]{query.getExecutionEngine(), query.getSessionId(), query.getSessionActiveTime(), query.getSessionIdleTime(), query.getQueryId(), query.getState(), query.getTxnId(), query.getBeginTime(), query.getElapsedTime(), query.getRuntime()})));
            return new CommandProcessorResponse(this.getSchema(), null);
        }
        catch (Exception e) {
            console.printError("Exception raised from ShowProcessListProcessor.run " + e.getLocalizedMessage(), StringUtils.stringifyException((Throwable)e));
            throw new CommandProcessorException(e.getLocalizedMessage(), e);
        }
    }

    @Override
    public void close() throws Exception {
    }
}

