/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan.mapper;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.optimizer.signature.OpTreeSignature;
import org.apache.hadoop.hive.ql.optimizer.signature.RelTreeSignature;
import org.apache.hadoop.hive.ql.plan.mapper.CachingStatsSource;
import org.apache.hadoop.hive.ql.plan.mapper.EmptyStatsSource;
import org.apache.hadoop.hive.ql.plan.mapper.MapBackedStatsSource;
import org.apache.hadoop.hive.ql.plan.mapper.MetastoreStatsConnector;
import org.apache.hadoop.hive.ql.plan.mapper.PersistedRuntimeStats;
import org.apache.hadoop.hive.ql.plan.mapper.PlanMapper;
import org.apache.hadoop.hive.ql.plan.mapper.StatsSource;
import org.apache.hadoop.hive.ql.stats.OperatorStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatsSources {
    private static final Logger LOG = LoggerFactory.getLogger(StatsSources.class);
    private static StatsSource globalStatsSource;
    private static MetastoreStatsConnector metastoreStatsConnector;

    public static void initialize(HiveConf hiveConf) {
        StatsSources.getStatsSource(hiveConf);
    }

    public static StatsSource getStatsSource(HiveConf conf) {
        String mode = conf.getVar(HiveConf.ConfVars.HIVE_QUERY_REEXECUTION_STATS_PERSISTENCE);
        int cacheSize = conf.getIntVar(HiveConf.ConfVars.HIVE_QUERY_REEXECUTION_STATS_CACHE_SIZE);
        int batchSize = conf.getIntVar(HiveConf.ConfVars.HIVE_QUERY_REEXECUTION_STATS_CACHE_BATCH_SIZE);
        switch (mode) {
            case "query": {
                return new MapBackedStatsSource();
            }
            case "hiveserver": {
                return StatsSources.globalStatsSource(cacheSize);
            }
            case "metastore": {
                return StatsSources.metastoreBackedStatsSource(cacheSize, batchSize, StatsSources.globalStatsSource(cacheSize));
            }
        }
        throw new RuntimeException("Unknown StatsSource setting: " + mode);
    }

    public static StatsSource getStatsSourceContaining(StatsSource currentStatsSource, PlanMapper pm) {
        StatsSource statsSource = currentStatsSource;
        if (currentStatsSource == EmptyStatsSource.INSTANCE) {
            statsSource = new MapBackedStatsSource();
        }
        ImmutableList<PersistedRuntimeStats> statMap = StatsSources.extractStatsFromPlanMapper(pm);
        statsSource.load((List<PersistedRuntimeStats>)statMap);
        return statsSource;
    }

    private static ImmutableList<PersistedRuntimeStats> extractStatsFromPlanMapper(PlanMapper pm) {
        ImmutableList.Builder li = ImmutableList.builder();
        Iterator<PlanMapper.EquivGroup> it = pm.iterateGroups();
        while (it.hasNext()) {
            PlanMapper.EquivGroup e = it.next();
            List<OperatorStats> stat = e.getAll(OperatorStats.class);
            List<OpTreeSignature> sig = e.getAll(OpTreeSignature.class);
            List<RelTreeSignature> rSig = e.getAll(RelTreeSignature.class);
            if (stat.size() > 1 || sig.size() > 1) {
                StringBuffer sb = new StringBuffer();
                sb.append(String.format("expected(stat-sig) 1-1, got {}-{} ;", stat.size(), sig.size()));
                for (OperatorStats operatorStats : stat) {
                    sb.append(operatorStats);
                    sb.append(";");
                }
                for (OpTreeSignature opTreeSignature : sig) {
                    sb.append(opTreeSignature);
                    sb.append(";");
                }
                LOG.debug(sb.toString());
            }
            if (stat.size() < 1 || sig.size() < 1) continue;
            if (e.getAll(OperatorStats.IncorrectRuntimeStatsMarker.class).size() > 0) {
                LOG.debug("Ignoring {}, marked with OperatorStats.IncorrectRuntimeStatsMarker", (Object)sig.get(0));
                continue;
            }
            if (e.getAll(OperatorStats.MayNotUseForRelNodes.class).size() > 0) {
                rSig = new ArrayList<RelTreeSignature>();
            }
            li.add((Object)new PersistedRuntimeStats(StatsSources.first(sig), StatsSources.first(stat), StatsSources.first(rSig)));
        }
        return li.build();
    }

    private static <T> T first(List<T> rSig) {
        if (rSig.size() > 0) {
            return rSig.iterator().next();
        }
        return null;
    }

    public static StatsSource globalStatsSource(int cacheSize) {
        if (globalStatsSource == null) {
            globalStatsSource = new CachingStatsSource(cacheSize);
        }
        return globalStatsSource;
    }

    public static StatsSource metastoreBackedStatsSource(int cacheSize, int batchSize, StatsSource parent) {
        if (metastoreStatsConnector == null) {
            metastoreStatsConnector = new MetastoreStatsConnector(cacheSize, batchSize, parent);
        }
        return metastoreStatsConnector;
    }

    @VisibleForTesting
    public static void clearGlobalStats() {
        if (metastoreStatsConnector != null) {
            metastoreStatsConnector.destroy();
        }
        globalStatsSource = null;
        metastoreStatsConnector = null;
    }

    static enum StatsSourceMode {
        query,
        hiveserver,
        metastore;

    }
}

