/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan.mapper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.SemanticNodeProcessor;
import org.apache.hadoop.hive.ql.lib.SemanticRule;
import org.apache.hadoop.hive.ql.optimizer.signature.OpTreeSignature;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.mapper.PlanMapper;

public final class AuxOpTreeSignature {
    private OpTreeSignature sig;

    public AuxOpTreeSignature(OpTreeSignature sig) {
        this.sig = sig;
    }

    public int hashCode() {
        return this.sig.hashCode();
    }

    public boolean equals(Object obj) {
        return obj.getClass() == AuxOpTreeSignature.class && this.sig.equals(((AuxOpTreeSignature)obj).sig);
    }

    public String toString() {
        return this.sig.toString();
    }

    private static void linkAuxSignatures(ParseContext pctx, ArrayList<Node> topNodes) throws SemanticException {
        PlanMapper pm = pctx.getContext().getPlanMapper();
        pm.clearSignatureCache();
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(new AuxSignatureLinker(pm), new HashMap<SemanticRule, SemanticNodeProcessor>(), null);
        DefaultGraphWalker ogw = new DefaultGraphWalker(disp);
        ogw.startWalking(topNodes, null);
    }

    public static void linkAuxSignatures(ParseContext parseContext) throws SemanticException {
        if (parseContext.getConf().getBoolVar(HiveConf.ConfVars.HIVE_QUERY_PLANMAPPER_LINK_RELNODES)) {
            AuxOpTreeSignature.linkAuxSignatures(parseContext, new ArrayList<Node>(parseContext.getTopOps().values()));
        }
    }

    static class AuxSignatureLinker
    implements SemanticNodeProcessor {
        private PlanMapper pm;

        public AuxSignatureLinker(PlanMapper pm) {
            this.pm = pm;
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            Operator op = (Operator)nd;
            AuxOpTreeSignature treeSig = this.pm.getAuxSignatureOf(op);
            this.pm.merge(op, treeSig);
            return nd;
        }
    }
}

