/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hive.metastore.api.ReplLastIdInfo;
import org.apache.hadoop.hive.metastore.api.TxnToWriteId;
import org.apache.hadoop.hive.metastore.api.WriteEventInfo;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.repl.metric.ReplicationMetricCollector;
import org.apache.hadoop.hive.ql.plan.Explain;

@Explain(displayName="Replication Transaction", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class ReplTxnWork
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String replPolicy;
    private String dbName;
    private String tableName;
    private List<String> partNames;
    private String validWriteIdList;
    private List<Long> txnIds;
    private List<TxnToWriteId> txnToWriteIdList;
    private ReplicationSpec replicationSpec;
    private List<WriteEventInfo> writeEventInfos;
    private ReplLastIdInfo replLastIdInfo;
    private String dumpDirectory;
    private transient ReplicationMetricCollector metricCollector;
    OperationType operation;

    public ReplTxnWork(String replPolicy, String dbName, String tableName, List<Long> txnIds, OperationType type, List<TxnToWriteId> txnToWriteIdList, ReplicationSpec replicationSpec) {
        this.txnIds = txnIds;
        this.dbName = dbName;
        this.tableName = tableName;
        this.operation = type;
        this.replPolicy = replPolicy;
        this.txnToWriteIdList = txnToWriteIdList;
        this.replicationSpec = replicationSpec;
        this.writeEventInfos = null;
        this.replLastIdInfo = null;
    }

    public ReplTxnWork(String replPolicy, String dbName, String tableName, List<Long> txnIds, OperationType type, ReplicationSpec replicationSpec) {
        this(replPolicy, dbName, tableName, txnIds, type, null, replicationSpec);
    }

    public ReplTxnWork(String replPolicy, String dbName, String tableName, List<Long> txnIds, OperationType type, ReplicationSpec replicationSpec, String dumpDirectory, ReplicationMetricCollector metricCollector) {
        this(replPolicy, dbName, tableName, txnIds, type, null, replicationSpec);
        this.dumpDirectory = dumpDirectory;
        this.metricCollector = metricCollector;
    }

    public ReplTxnWork(String replPolicy, String dbName, String tableName, Long txnId, OperationType type, ReplicationSpec replicationSpec) {
        this(replPolicy, dbName, tableName, Collections.singletonList(txnId), type, null, replicationSpec);
    }

    public ReplTxnWork(String replPolicy, String dbName, String tableName, Long txnId, OperationType type, ReplicationSpec replicationSpec, String dumpDirectory, ReplicationMetricCollector metricCollector) {
        this(replPolicy, dbName, tableName, Collections.singletonList(txnId), type, null, replicationSpec);
        this.dumpDirectory = dumpDirectory;
        this.metricCollector = metricCollector;
    }

    public ReplTxnWork(String replPolicy, String dbName, String tableName, OperationType type, List<TxnToWriteId> txnToWriteIdList, ReplicationSpec replicationSpec) {
        this(replPolicy, dbName, tableName, null, type, txnToWriteIdList, replicationSpec);
    }

    public ReplTxnWork(String replPolicy, String dbName, String tableName, OperationType type, List<TxnToWriteId> txnToWriteIdList, ReplicationSpec replicationSpec, String dumpDirectory, ReplicationMetricCollector metricCollector) {
        this(replPolicy, dbName, tableName, null, type, txnToWriteIdList, replicationSpec);
        this.dumpDirectory = dumpDirectory;
        this.metricCollector = metricCollector;
    }

    public ReplTxnWork(String dbName, String tableName, List<String> partNames, String validWriteIdList, OperationType type) {
        this.dbName = dbName;
        this.tableName = tableName;
        this.partNames = partNames;
        this.validWriteIdList = validWriteIdList;
        this.operation = type;
    }

    public ReplTxnWork(String dbName, String tableName, List<String> partNames, String validWriteIdList, OperationType type, String dumpDirectory, ReplicationMetricCollector metricCollector) {
        this.dbName = dbName;
        this.tableName = tableName;
        this.partNames = partNames;
        this.validWriteIdList = validWriteIdList;
        this.operation = type;
        this.dumpDirectory = dumpDirectory;
        this.metricCollector = metricCollector;
    }

    public void addWriteEventInfo(WriteEventInfo writeEventInfo) {
        if (this.writeEventInfos == null) {
            this.writeEventInfos = new ArrayList<WriteEventInfo>();
        }
        this.writeEventInfos.add(writeEventInfo);
    }

    public List<Long> getTxnIds() {
        return this.txnIds;
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getTableName() {
        return this.tableName == null || this.tableName.isEmpty() ? null : this.tableName;
    }

    public String getReplPolicy() {
        return this.replPolicy;
    }

    public List<String> getPartNames() {
        return this.partNames;
    }

    public String getValidWriteIdList() {
        return this.validWriteIdList;
    }

    public OperationType getOperationType() {
        return this.operation;
    }

    public List<TxnToWriteId> getTxnToWriteIdList() {
        return this.txnToWriteIdList;
    }

    public ReplicationSpec getReplicationSpec() {
        return this.replicationSpec;
    }

    public List<WriteEventInfo> getWriteEventInfos() {
        return this.writeEventInfos;
    }

    public ReplLastIdInfo getReplLastIdInfo() {
        return this.replLastIdInfo;
    }

    public ReplicationMetricCollector getMetricCollector() {
        return this.metricCollector;
    }

    public String getDumpDirectory() {
        return this.dumpDirectory;
    }

    public static enum OperationType {
        REPL_OPEN_TXN,
        REPL_ABORT_TXN,
        REPL_COMMIT_TXN,
        REPL_ALLOC_WRITE_ID,
        REPL_WRITEID_STATE;

    }
}

