/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.load.message;

import java.util.List;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc;
import org.apache.hadoop.hive.metastore.messaging.UpdatePartitionColumnStatMessage;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.repl.util.ReplUtils;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.load.message.AbstractMessageHandler;
import org.apache.hadoop.hive.ql.parse.repl.load.message.MessageHandler;

public class UpdatePartColStatHandler
extends AbstractMessageHandler {
    @Override
    public List<Task<?>> handle(MessageHandler.Context context) throws SemanticException {
        UpdatePartitionColumnStatMessage upcsm = this.deserializer.getUpdatePartitionColumnStatMessage(context.dmd.getPayload());
        ColumnStatistics colStats = upcsm.getColumnStatistics();
        if (colStats.getEngine() == null) {
            colStats.setEngine("hive");
        }
        ColumnStatisticsDesc colStatsDesc = colStats.getStatsDesc();
        if (!context.isDbNameEmpty()) {
            colStatsDesc.setDbName(context.dbName);
            this.updatedMetadata.set(context.dmd.getEventTo().toString(), context.dbName, colStatsDesc.getTableName(), null);
        }
        try {
            return ReplUtils.addTasksForLoadingColStats(colStats, context.hiveConf, this.updatedMetadata, upcsm.getTableObject(), upcsm.getWriteId(), context.getDumpDirectory(), context.getMetricCollector());
        }
        catch (Exception e) {
            throw new SemanticException((Throwable)e);
        }
    }
}

