/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.load.log;

import org.apache.hadoop.hive.ql.parse.repl.ReplLogger;
import org.apache.hadoop.hive.ql.parse.repl.ReplState;
import org.apache.hadoop.hive.ql.parse.repl.load.log.state.RangerLoadBegin;
import org.apache.hadoop.hive.ql.parse.repl.load.log.state.RangerLoadEnd;

public class RangerLoadLogger
extends ReplLogger<Long> {
    private String sourceDbName;
    private String targetDbName;
    private String dumpDir;
    private long estimatedNumPolicies;

    public RangerLoadLogger(String sourceDbName, String targetDbName, String dumpDir, long estimatedNumPolicies) {
        this.sourceDbName = sourceDbName;
        this.targetDbName = targetDbName;
        this.estimatedNumPolicies = estimatedNumPolicies;
        this.dumpDir = dumpDir;
    }

    @Override
    public void startLog() {
        new RangerLoadBegin(this.sourceDbName, this.targetDbName, this.estimatedNumPolicies).log(ReplState.LogTag.RANGER_LOAD_START);
    }

    @Override
    public void endLog(Long count) {
        new RangerLoadEnd(this.sourceDbName, this.targetDbName, count, this.dumpDir).log(ReplState.LogTag.RANGER_LOAD_END);
    }
}

