/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.load.log;

import org.apache.hadoop.hive.ql.exec.repl.ReplStatsTracker;
import org.apache.hadoop.hive.ql.parse.repl.ReplLogger;
import org.apache.hadoop.hive.ql.parse.repl.ReplState;
import org.apache.hadoop.hive.ql.parse.repl.load.log.state.IncrementalLoadBegin;
import org.apache.hadoop.hive.ql.parse.repl.load.log.state.IncrementalLoadEnd;
import org.apache.hadoop.hive.ql.parse.repl.load.log.state.IncrementalLoadEvent;

public class IncrementalLoadLogger
extends ReplLogger<String> {
    private final ReplStatsTracker replStatsTracker;
    private String dbName;
    private String dumpDir;
    private long numEvents;
    private long eventSeqNo;
    private long currentEventTimestamp;

    public IncrementalLoadLogger(String dbName, String dumpDir, int numEvents, ReplStatsTracker replStatsTracker) {
        this.dbName = dbName;
        this.dumpDir = dumpDir;
        this.numEvents = numEvents;
        this.eventSeqNo = 0L;
        this.currentEventTimestamp = 0L;
        this.replStatsTracker = replStatsTracker;
    }

    public void initiateEventTimestamp(long timestamp) {
        if (this.currentEventTimestamp == 0L) {
            this.currentEventTimestamp = timestamp;
        }
    }

    @Override
    public void startLog() {
        new IncrementalLoadBegin(this.dbName, this.dumpDir, this.numEvents).log(ReplState.LogTag.START);
    }

    @Override
    public void eventLog(String eventId, String eventType) {
        ++this.eventSeqNo;
        long previousEventTimestamp = this.currentEventTimestamp;
        IncrementalLoadEvent incEvent = new IncrementalLoadEvent(this.dbName, eventId, eventType, this.eventSeqNo, this.numEvents, previousEventTimestamp, this.replStatsTracker);
        incEvent.log(ReplState.LogTag.EVENT_LOAD);
        this.currentEventTimestamp = incEvent.getLoadTimeMillis();
    }

    @Override
    public void endLog(String lastReplId) {
        new IncrementalLoadEnd(this.dbName, this.numEvents, this.dumpDir, lastReplId).log(ReplState.LogTag.END);
    }

    @Override
    public ReplStatsTracker getReplStatsTracker() {
        return this.replStatsTracker;
    }
}

