/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.relnodegen;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.RelColumnMapping;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.optimizer.calcite.TraitsUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTableFunctionScan;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.TypeConverter;
import org.apache.hadoop.hive.ql.parse.ASTErrorUtils;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.CalcitePlanner;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.UnparseTranslator;
import org.apache.hadoop.hive.ql.parse.type.FunctionHelper;
import org.apache.hadoop.hive.ql.parse.type.TypeCheckCtx;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LateralViewPlan {
    protected static final Logger LOG = LoggerFactory.getLogger((String)LateralViewPlan.class.getName());
    public static final ImmutableSet<Integer> TABLE_ALIAS_TOKEN_TYPES = ImmutableSet.of((Object)1242, (Object)1280, (Object)1159);
    public final RelNode lateralViewRel;
    public final RowResolver outputRR;
    public final String lateralTableAlias;
    private final RelOptCluster cluster;
    private final UnparseTranslator unparseTranslator;
    private final HiveConf conf;
    private final FunctionHelper functionHelper;

    public LateralViewPlan(ASTNode lateralView, RelOptCluster cluster, RelNode inputRel, RowResolver inputRR, UnparseTranslator unparseTranslator, HiveConf conf, FunctionHelper functionHelper) throws SemanticException {
        this.cluster = cluster;
        this.unparseTranslator = unparseTranslator;
        this.conf = conf;
        this.functionHelper = functionHelper;
        ASTNode selExprAST = (ASTNode)lateralView.getChild(0).getChild(0);
        ASTNode functionAST = (ASTNode)selExprAST.getChild(0);
        this.lateralTableAlias = this.getTableAliasFromASTNode(selExprAST);
        RexCall udtfCall = this.getLateralFunction(functionAST, inputRR, inputRel);
        List<String> columnAliases = this.getColumnAliasesFromASTNode(selExprAST, udtfCall);
        this.outputRR = this.getOutputRR(inputRR, udtfCall, columnAliases, this.lateralTableAlias);
        RelDataType retType = this.getRetType(cluster, inputRel, (RexNode)udtfCall, columnAliases);
        this.lateralViewRel = HiveTableFunctionScan.create(cluster, TraitsUtil.getDefaultTraitSet(cluster), (List<RelNode>)ImmutableList.of((Object)inputRel), (RexNode)udtfCall, null, retType, this.createColumnMappings(inputRel));
    }

    public static void validateLateralView(ASTNode lateralView) throws SemanticException {
        if (lateralView.getChildCount() != 2) {
            throw new SemanticException("Token Lateral View contains " + lateralView.getChildCount() + " children.");
        }
        ASTNode next = (ASTNode)lateralView.getChild(1);
        if (!TABLE_ALIAS_TOKEN_TYPES.contains((Object)next.getToken().getType()) && 1079 != next.getToken().getType()) {
            throw new SemanticException(ASTErrorUtils.getMsg((String)ErrorMsg.LATERAL_VIEW_INVALID_CHILD.getMsg(), (ASTNode)lateralView));
        }
    }

    private RexCall getLateralFunction(ASTNode functionAST, RowResolver inputRR, RelNode inputRel) throws SemanticException {
        RexCall udtfCall = this.getUDTFFunction(functionAST, inputRR);
        ArrayList<Object> operands = new ArrayList<Object>();
        operands.add(udtfCall);
        for (int i = 0; i < inputRel.getRowType().getFieldCount(); ++i) {
            RelDataType type = ((RelDataTypeField)inputRel.getRowType().getFieldList().get(i)).getType();
            operands.add(this.cluster.getRexBuilder().makeInputRef(type, i));
        }
        return (RexCall)this.cluster.getRexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.LATERAL, operands);
    }

    private RexCall getUDTFFunction(ASTNode functionAST, RowResolver inputRR) throws SemanticException {
        String functionName = functionAST.getChild(0).getText().toLowerCase();
        List<RexNode> operandsForUDTF = this.getOperandsForUDTF(functionAST, inputRR);
        return this.functionHelper.getUDTFFunction(functionName, operandsForUDTF);
    }

    private String getTableAliasFromASTNode(ASTNode selExprClause) throws SemanticException {
        for (Node obj : selExprClause.getChildren()) {
            ASTNode child = (ASTNode)obj;
            if (child.getToken().getType() != 1250) continue;
            return BaseSemanticAnalyzer.unescapeIdentifier(child.getChild(0).getText().toLowerCase());
        }
        throw new SemanticException("Alias should be specified LVJ");
    }

    private List<String> getColumnAliasesFromASTNode(ASTNode selExprClause, RexCall udtfCall) throws SemanticException {
        HashSet<String> uniqueNames = new HashSet<String>();
        ArrayList<String> colAliases = new ArrayList<String>();
        for (Node obj : selExprClause.getChildren()) {
            ASTNode child = (ASTNode)obj;
            if (child.getToken().getType() == 1250 || child.getToken().getType() == 1039) continue;
            String colAlias = BaseSemanticAnalyzer.unescapeIdentifier(child.getText().toLowerCase());
            if (uniqueNames.contains(colAlias)) {
                throw new SemanticException(ErrorMsg.COLUMN_ALIAS_ALREADY_EXISTS.getMsg(colAlias));
            }
            uniqueNames.add(colAlias);
            colAliases.add(colAlias);
        }
        if (colAliases.isEmpty()) {
            colAliases.addAll(Lists.transform((List)udtfCall.getType().getFieldList(), RelDataTypeField::getName));
        }
        int udtfFieldCount = udtfCall.getType().getFieldCount();
        if (colAliases.size() != udtfFieldCount) {
            throw new SemanticException(ErrorMsg.UDTF_ALIAS_MISMATCH.getMsg("expected " + udtfFieldCount + " aliases but got " + colAliases.size()));
        }
        return colAliases;
    }

    private List<RexNode> getOperandsForUDTF(ASTNode functionCall, RowResolver inputRR) throws SemanticException {
        ArrayList<RexNode> operands = new ArrayList<RexNode>();
        TypeCheckCtx tcCtx = new TypeCheckCtx(inputRR, this.cluster.getRexBuilder(), false, false);
        tcCtx.setUnparseTranslator(this.unparseTranslator);
        for (int i = 1; i < functionCall.getChildren().size(); ++i) {
            ASTNode functionParam = (ASTNode)functionCall.getChild(i);
            operands.add(CalcitePlanner.genRexNode(functionParam, inputRR, tcCtx, this.conf));
        }
        return operands;
    }

    private RowResolver getOutputRR(RowResolver inputRR, RexCall udtfCall, List<String> columnAliases, String lateralTableAlias) throws SemanticException {
        RowResolver localOutputRR = new RowResolver();
        if (!RowResolver.add(localOutputRR, inputRR)) {
            LOG.warn("Duplicates detected when adding columns to RR: see previous message");
        }
        TypeInfo typeInfo = TypeConverter.convert(udtfCall.getType());
        Preconditions.checkState((boolean)(typeInfo instanceof StructTypeInfo));
        StructTypeInfo typeInfos = (StructTypeInfo)typeInfo;
        int j = 0;
        for (int i = 0; i < columnAliases.size(); ++i) {
            String internalColName;
            while (localOutputRR.getPosition(internalColName = SemanticAnalyzer.getColumnInternalName(j++)) != -1) {
            }
            localOutputRR.put(lateralTableAlias, columnAliases.get(i), new ColumnInfo(internalColName, (TypeInfo)typeInfos.getAllStructFieldTypeInfos().get(i), lateralTableAlias, false));
        }
        return localOutputRR;
    }

    private RelDataType getRetType(RelOptCluster cluster, RelNode inputRel, RexNode udtfCall, List<String> columnAliases) {
        ArrayList allDataTypes = new ArrayList(Lists.transform((List)inputRel.getRowType().getFieldList(), RelDataTypeField::getType));
        ArrayList<CallSite> allDataTypeNames = new ArrayList<CallSite>(Lists.transform((List)inputRel.getRowType().getFieldList(), RelDataTypeField::getName));
        RelDataType retType = udtfCall.getType();
        Preconditions.checkState((boolean)retType.isStruct());
        allDataTypes.addAll(Lists.transform((List)retType.getFieldList(), RelDataTypeField::getType));
        for (String s : columnAliases) {
            allDataTypeNames.add((CallSite)((Object)(this.lateralTableAlias + "." + s)));
        }
        return cluster.getTypeFactory().createStructType(allDataTypes, allDataTypeNames);
    }

    private Set<RelColumnMapping> createColumnMappings(RelNode inputRel) {
        HashSet<RelColumnMapping> colMappings = new HashSet<RelColumnMapping>();
        for (int i = 0; i < inputRel.getRowType().getFieldCount(); ++i) {
            colMappings.add(new RelColumnMapping(i, 0, i, false));
        }
        return colMappings;
    }
}

