/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.correlation;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.PTFOperator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.optimizer.correlation.CorrelationUtilities;
import org.apache.hadoop.hive.ql.optimizer.correlation.ReduceSinkDeDuplication;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDescUtils;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.stats.StatsUtils;

public class ReduceSinkDeDuplicationUtils {
    /*
     * WARNING - void declaration
     */
    public static boolean merge(ReduceSinkOperator cRS, JoinOperator pJoin, int minReducer) throws SemanticException {
        void var9_13;
        List<Operator<OperatorDesc>> parents = pJoin.getParentOperators();
        Operator[] pRSs = parents.toArray(new ReduceSinkOperator[parents.size()]);
        ReduceSinkDesc cRSc = (ReduceSinkDesc)cRS.getConf();
        for (ReduceSinkOperator reduceSinkOperator : pRSs) {
            ReduceSinkDesc pRSNc = (ReduceSinkDesc)reduceSinkOperator.getConf();
            if (cRSc.getKeyCols().size() != pRSNc.getKeyCols().size()) {
                return false;
            }
            if (cRSc.getPartitionCols().size() != pRSNc.getPartitionCols().size()) {
                return false;
            }
            Integer moveReducerNumTo = ReduceSinkDeDuplicationUtils.checkNumReducer(cRSc.getNumReducers(), pRSNc.getNumReducers());
            if (moveReducerNumTo == null || moveReducerNumTo > 0 && cRSc.getNumReducers() < minReducer) {
                return false;
            }
            Integer moveRSOrderTo = ReduceSinkDeDuplicationUtils.checkOrder(true, cRSc.getOrder(), pRSNc.getOrder(), cRSc.getNullOrder(), pRSNc.getNullOrder());
            if (moveRSOrderTo != null) continue;
            return false;
        }
        boolean[] sorted = CorrelationUtilities.getSortedTags(pJoin);
        int cKeySize = cRSc.getKeyCols().size();
        for (int i = 0; i < cKeySize; ++i) {
            ExprNodeDesc exprNodeDesc = cRSc.getKeyCols().get(i);
            ExprNodeDesc[] pexprs = new ExprNodeDesc[pRSs.length];
            for (int tag = 0; tag < pRSs.length; ++tag) {
                pexprs[tag] = ((ReduceSinkDesc)pRSs[tag].getConf()).getKeyCols().get(i);
            }
            int found = CorrelationUtilities.indexOf(exprNodeDesc, pexprs, cRS, pRSs, sorted);
            if (found == i) continue;
            return false;
        }
        int cPartSize = cRSc.getPartitionCols().size();
        boolean bl = false;
        while (var9_13 < cPartSize) {
            ExprNodeDesc cexpr = cRSc.getPartitionCols().get((int)var9_13);
            ExprNodeDesc[] pexprs = new ExprNodeDesc[pRSs.length];
            for (int tag = 0; tag < pRSs.length; ++tag) {
                pexprs[tag] = ((ReduceSinkDesc)pRSs[tag].getConf()).getPartitionCols().get((int)var9_13);
            }
            int found = CorrelationUtilities.indexOf(cexpr, pexprs, cRS, pRSs, sorted);
            if (found != var9_13) {
                return false;
            }
            ++var9_13;
        }
        for (Operator pRS : pRSs) {
            ((ReduceSinkDesc)pRS.getConf()).setNumReducers(((ReduceSinkDesc)cRS.getConf()).getNumReducers());
        }
        return true;
    }

    public static boolean merge(HiveConf hiveConf, ReduceSinkOperator cRS, ReduceSinkOperator pRS, int minReducer) throws SemanticException {
        int[] result = ReduceSinkDeDuplicationUtils.extractMergeDirections(hiveConf, cRS, pRS, minReducer);
        if (result == null) {
            return false;
        }
        if (result[0] > 0) {
            List<ExprNodeDesc> childKCs = ((ReduceSinkDesc)cRS.getConf()).getKeyCols();
            ((ReduceSinkDesc)pRS.getConf()).setKeyCols(ExprNodeDescUtils.backtrack(childKCs, cRS, pRS));
        }
        List<ExprNodeDesc> childPCs = ((ReduceSinkDesc)cRS.getConf()).getPartitionCols();
        List<ExprNodeDesc> parentPCs = ((ReduceSinkDesc)pRS.getConf()).getPartitionCols();
        if (ReduceSinkDeDuplicationUtils.canReplaceParentWithChildPartioning(result[1], childPCs, parentPCs)) {
            ((ReduceSinkDesc)pRS.getConf()).setPartitionCols(ExprNodeDescUtils.backtrack(childPCs, cRS, pRS));
        }
        if (result[2] > 0) {
            if (result[0] <= 0) {
                throw new SemanticException("Sorting columns and order don't match. Try set " + String.valueOf(HiveConf.ConfVars.HIVE_OPT_REDUCE_DEDUPLICATION) + "=false;");
            }
            ((ReduceSinkDesc)pRS.getConf()).setOrder(((ReduceSinkDesc)cRS.getConf()).getOrder());
            ((ReduceSinkDesc)pRS.getConf()).setNullOrder(((ReduceSinkDesc)cRS.getConf()).getNullOrder());
        } else {
            StringBuilder order = new StringBuilder(((ReduceSinkDesc)cRS.getConf()).getOrder());
            StringBuilder orderNull = new StringBuilder(((ReduceSinkDesc)cRS.getConf()).getNullOrder());
            order.append(((ReduceSinkDesc)pRS.getConf()).getOrder().substring(order.length()));
            orderNull.append(((ReduceSinkDesc)pRS.getConf()).getNullOrder().substring(orderNull.length()));
            ((ReduceSinkDesc)pRS.getConf()).setOrder(order.toString());
            ((ReduceSinkDesc)pRS.getConf()).setNullOrder(orderNull.toString());
        }
        if (result[3] > 0) {
            ((ReduceSinkDesc)pRS.getConf()).setNumReducers(((ReduceSinkDesc)cRS.getConf()).getNumReducers());
        }
        if (result[4] > 0) {
            if (((ReduceSinkDesc)pRS.getConf()).getKeyCols() != null && ((ReduceSinkDesc)pRS.getConf()).getKeyCols().size() == 0 && ((ReduceSinkDesc)cRS.getConf()).getKeyCols() != null && ((ReduceSinkDesc)cRS.getConf()).getKeyCols().size() == 0) {
                TableDesc keyTable = PlanUtils.getReduceKeyTableDesc(new ArrayList<FieldSchema>(), ((ReduceSinkDesc)pRS.getConf()).getOrder(), ((ReduceSinkDesc)pRS.getConf()).getNullOrder());
                ((ReduceSinkDesc)pRS.getConf()).setKeySerializeInfo(keyTable);
            } else if (((ReduceSinkDesc)cRS.getConf()).getKeyCols() != null && ((ReduceSinkDesc)cRS.getConf()).getKeyCols().size() > 0) {
                ArrayList keyColNames = Lists.newArrayList();
                for (ExprNodeDesc keyCol : ((ReduceSinkDesc)pRS.getConf()).getKeyCols()) {
                    String keyColName = keyCol.getExprString();
                    keyColNames.add(keyColName);
                }
                List<FieldSchema> fields = PlanUtils.getFieldSchemasFromColumnList(((ReduceSinkDesc)pRS.getConf()).getKeyCols(), keyColNames, 0, "");
                TableDesc keyTable = PlanUtils.getReduceKeyTableDesc(fields, ((ReduceSinkDesc)pRS.getConf()).getOrder(), ((ReduceSinkDesc)pRS.getConf()).getNullOrder());
                ArrayList outputKeyCols = Lists.newArrayList();
                for (int i = 0; i < fields.size(); ++i) {
                    outputKeyCols.add(fields.get(i).getName());
                }
                ((ReduceSinkDesc)pRS.getConf()).setOutputKeyColumnNames(outputKeyCols);
                ((ReduceSinkDesc)pRS.getConf()).setKeySerializeInfo(keyTable);
                ((ReduceSinkDesc)pRS.getConf()).setNumDistributionKeys(((ReduceSinkDesc)cRS.getConf()).getNumDistributionKeys());
            }
        }
        return true;
    }

    private static long estimateReducers(HiveConf conf, ReduceSinkOperator rs) {
        if (((ReduceSinkDesc)rs.getConf()).getNumReducers() > 0) {
            return ((ReduceSinkDesc)rs.getConf()).getNumReducers();
        }
        int constantReducers = conf.getIntVar(HiveConf.ConfVars.HADOOP_NUM_REDUCERS);
        if (constantReducers > 0) {
            return constantReducers;
        }
        long inputTotalBytes = 0L;
        List<Operator<OperatorDesc>> rsSiblings = rs.getChildOperators().get(0).getParentOperators();
        for (Operator<OperatorDesc> sibling : rsSiblings) {
            if (sibling.getStatistics() == null) continue;
            inputTotalBytes = StatsUtils.safeAdd(inputTotalBytes, sibling.getStatistics().getDataSize());
        }
        int maxReducers = conf.getIntVar(HiveConf.ConfVars.MAX_REDUCERS);
        long bytesPerReducer = conf.getLongVar(HiveConf.ConfVars.BYTES_PER_REDUCER);
        return Utilities.estimateReducers(inputTotalBytes, bytesPerReducer, maxReducers, false);
    }

    public static boolean strictMerge(ReduceSinkOperator cRS, ReduceSinkOperator pRS) throws SemanticException {
        return ReduceSinkDeDuplicationUtils.strictMerge(cRS, (List<ReduceSinkOperator>)ImmutableList.of((Object)pRS));
    }

    public static boolean strictMerge(ReduceSinkOperator cRS, List<ReduceSinkOperator> pRSs) throws SemanticException {
        ReduceSinkDesc cRSc = (ReduceSinkDesc)cRS.getConf();
        Iterator<ReduceSinkOperator> iterator = pRSs.iterator();
        if (iterator.hasNext()) {
            ReduceSinkOperator pRS = iterator.next();
            ReduceSinkDesc pRSc = (ReduceSinkDesc)pRS.getConf();
            if (cRSc.getKeyCols().size() != pRSc.getKeyCols().size()) {
                return false;
            }
            if (cRSc.getPartitionCols().size() != pRSc.getPartitionCols().size()) {
                return false;
            }
            Integer moveRSOrderTo = ReduceSinkDeDuplicationUtils.checkOrder(true, cRSc.getOrder(), pRSc.getOrder(), cRSc.getNullOrder(), pRSc.getNullOrder());
            if (moveRSOrderTo == null) {
                return false;
            }
            int cKeySize = cRSc.getKeyCols().size();
            for (int i = 0; i < cKeySize; ++i) {
                ExprNodeDesc cExpr = cRSc.getKeyCols().get(i);
                ExprNodeDesc pExpr = pRSc.getKeyCols().get(i);
                if (cExpr instanceof ExprNodeConstantDesc || pExpr instanceof ExprNodeConstantDesc) {
                    return false;
                }
                ExprNodeDesc backtrackCExpr = ExprNodeDescUtils.backtrack(cExpr, cRS, pRS);
                if (backtrackCExpr != null && pExpr.isSame(backtrackCExpr)) continue;
                return false;
            }
            int cPartSize = cRSc.getPartitionCols().size();
            for (int i = 0; i < cPartSize; ++i) {
                ExprNodeDesc cExpr = cRSc.getPartitionCols().get(i);
                ExprNodeDesc pExpr = pRSc.getPartitionCols().get(i);
                if (cExpr instanceof ExprNodeConstantDesc || pExpr instanceof ExprNodeConstantDesc) {
                    return false;
                }
                ExprNodeDesc backtrackCExpr = ExprNodeDescUtils.backtrack(cExpr, cRS, pRS);
                if (backtrackCExpr != null && pExpr.isSame(backtrackCExpr)) continue;
                return false;
            }
            if (cRSc.getBucketCols() != null || pRSc.getBucketCols() != null) {
                if (cRSc.getBucketCols() == null || pRSc.getBucketCols() == null) {
                    return false;
                }
                if (cRSc.getBucketCols().size() != pRSc.getBucketCols().size()) {
                    return false;
                }
                int cBucketColsSize = cRSc.getBucketCols().size();
                for (int i = 0; i < cBucketColsSize; ++i) {
                    ExprNodeDesc cExpr = cRSc.getBucketCols().get(i);
                    ExprNodeDesc pExpr = pRSc.getBucketCols().get(i);
                    if (cExpr instanceof ExprNodeConstantDesc || pExpr instanceof ExprNodeConstantDesc) {
                        return false;
                    }
                    ExprNodeDesc backtrackCExpr = ExprNodeDescUtils.backtrack(cExpr, cRS, pRS);
                    if (backtrackCExpr != null && pExpr.isSame(backtrackCExpr)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private static int[] extractMergeDirections(HiveConf hiveConf, ReduceSinkOperator cRS, ReduceSinkOperator pRS, int minReducer) throws SemanticException {
        List<ExprNodeDesc> ppars;
        List<ExprNodeDesc> pkeys;
        ReduceSinkDesc cConf = (ReduceSinkDesc)cRS.getConf();
        ReduceSinkDesc pConf = (ReduceSinkDesc)pRS.getConf();
        boolean checkStrictEquality = ReduceSinkDeDuplicationUtils.isStrictEqualityNeeded(cRS, pRS);
        Integer moveRSOrderTo = ReduceSinkDeDuplicationUtils.checkOrder(checkStrictEquality, cConf.getOrder(), pConf.getOrder(), cConf.getNullOrder(), pConf.getNullOrder());
        if (moveRSOrderTo == null) {
            return null;
        }
        if (cConf.getDistinctColumnIndices().size() >= 2) {
            return null;
        }
        if (cConf.getBucketingVersion() != pConf.getBucketingVersion()) {
            return null;
        }
        Integer moveReducerNumTo = ReduceSinkDeDuplicationUtils.checkNumReducer(cConf.getNumReducers(), pConf.getNumReducers());
        if (moveReducerNumTo == null || moveReducerNumTo > 0 && cConf.getNumReducers() < minReducer) {
            return null;
        }
        List<ExprNodeDesc> ckeys = cConf.getKeyCols();
        Integer moveKeyColTo = ReduceSinkDeDuplicationUtils.checkExprs(ckeys, pkeys = pConf.getKeyCols(), cRS, pRS);
        if (moveKeyColTo == null) {
            return null;
        }
        List<ExprNodeDesc> cpars = cConf.getPartitionCols();
        Integer movePartitionColTo = ReduceSinkDeDuplicationUtils.checkExprs(cpars, ppars = pConf.getPartitionCols(), cRS, pRS);
        if (movePartitionColTo == null) {
            return null;
        }
        if (ReduceSinkDeDuplicationUtils.canReplaceParentWithChildPartioning(movePartitionColTo, cpars, ppars)) {
            long oldParallelism = ReduceSinkDeDuplicationUtils.estimateReducers(hiveConf, pRS);
            long newParallelism = ReduceSinkDeDuplicationUtils.estimateReducers(hiveConf, cRS);
            if (newParallelism < oldParallelism && newParallelism < (long)minReducer) {
                return null;
            }
        }
        Integer moveNumDistKeyTo = ReduceSinkDeDuplicationUtils.checkNumDistributionKey(cConf.getNumDistributionKeys(), pConf.getNumDistributionKeys());
        return new int[]{moveKeyColTo, movePartitionColTo, moveRSOrderTo, moveReducerNumTo, moveNumDistKeyTo};
    }

    private static boolean isStrictEqualityNeeded(ReduceSinkOperator cRS, ReduceSinkOperator pRS) {
        Operator<OperatorDesc> parent = cRS.getParentOperators().get(0);
        while (parent != pRS) {
            assert (parent.getNumParent() == 1);
            if (parent instanceof PTFOperator) {
                return true;
            }
            parent = parent.getParentOperators().get(0);
        }
        return false;
    }

    private static boolean canReplaceParentWithChildPartioning(Integer moveColTo, List<ExprNodeDesc> cpars, List<ExprNodeDesc> ppars) {
        return moveColTo < 0 && cpars != null && !cpars.isEmpty() || moveColTo > 0 && (ppars == null || ppars.isEmpty());
    }

    private static Integer checkNumDistributionKey(int cnd, int pnd) {
        if (pnd <= 0) {
            return 1;
        }
        return 0;
    }

    private static Integer checkExprs(List<ExprNodeDesc> ckeys, List<ExprNodeDesc> pkeys, ReduceSinkOperator cRS, ReduceSinkOperator pRS) throws SemanticException {
        for (ExprNodeDesc ck : ckeys) {
            if (!(ck instanceof ExprNodeConstantDesc)) continue;
            return null;
        }
        for (ExprNodeDesc pk : pkeys) {
            if (!(pk instanceof ExprNodeConstantDesc)) continue;
            return null;
        }
        Integer moveKeyColTo = 0;
        if (ckeys == null || ckeys.isEmpty()) {
            if (pkeys != null && !pkeys.isEmpty()) {
                moveKeyColTo = -1;
            }
        } else if (pkeys == null || pkeys.isEmpty()) {
            for (ExprNodeDesc ckey : ckeys) {
                if (ExprNodeDescUtils.backtrack(ckey, cRS, pRS) != null) continue;
                return null;
            }
            moveKeyColTo = 1;
        } else {
            moveKeyColTo = ReduceSinkDeDuplicationUtils.sameKeys(ckeys, pkeys, cRS, pRS);
        }
        return moveKeyColTo;
    }

    protected static Integer sameKeys(List<ExprNodeDesc> cexprs, List<ExprNodeDesc> pexprs, Operator<?> child, Operator<?> parent) throws SemanticException {
        int i;
        int common = Math.min(cexprs.size(), pexprs.size());
        int limit = Math.max(cexprs.size(), pexprs.size());
        for (i = 0; i < common; ++i) {
            ExprNodeDesc pexpr = pexprs.get(i);
            ExprNodeDesc cexpr = ExprNodeDescUtils.backtrack(cexprs.get(i), child, parent);
            if (cexpr != null && pexpr.isSame(cexpr)) continue;
            return null;
        }
        while (i < limit) {
            if (cexprs.size() > pexprs.size() && ExprNodeDescUtils.backtrack(cexprs.get(i), child, parent) == null) {
                return null;
            }
            ++i;
        }
        return Integer.valueOf(cexprs.size()).compareTo(pexprs.size());
    }

    protected static Integer checkOrder(boolean checkStrictEquality, String corder, String porder, String cNullOrder, String pNullOrder) {
        assert (corder.length() == cNullOrder.length());
        assert (porder.length() == pNullOrder.length());
        if (corder == null || corder.trim().equals("")) {
            if (porder == null || porder.trim().equals("")) {
                return 0;
            }
            return -1;
        }
        if (porder == null || porder.trim().equals("")) {
            return 1;
        }
        corder = corder.trim();
        porder = porder.trim();
        if (checkStrictEquality) {
            cNullOrder = cNullOrder.trim();
            pNullOrder = pNullOrder.trim();
            int target = Math.min(corder.length(), porder.length());
            if (!corder.substring(0, target).equals(porder.substring(0, target)) || !cNullOrder.substring(0, target).equals(pNullOrder.substring(0, target))) {
                return null;
            }
        }
        return Integer.valueOf(corder.length()).compareTo(porder.length());
    }

    protected static Integer checkNumReducer(int creduce, int preduce) {
        if (creduce < 0) {
            if (preduce < 0) {
                return 0;
            }
            return -1;
        }
        if (preduce < 0) {
            return 1;
        }
        if (creduce != preduce) {
            return null;
        }
        return 0;
    }

    protected static boolean checkSelectSingleBranchOnly(ReduceSinkOperator cRS, ReduceSinkOperator pRS) {
        Operator<OperatorDesc> parent = cRS.getParentOperators().get(0);
        if (((ReduceSinkDesc)cRS.getConf()).getBucketingVersion() != ((ReduceSinkDesc)pRS.getConf()).getBucketingVersion()) {
            return false;
        }
        while (parent != pRS) {
            assert (parent.getNumParent() == 1);
            if (!(parent instanceof SelectOperator)) {
                return false;
            }
            if (parent.getChildOperators().size() > 1) {
                return false;
            }
            parent = parent.getParentOperators().get(0);
        }
        return true;
    }

    protected static boolean aggressiveDedup(ReduceSinkOperator cRS, ReduceSinkOperator pRS, ReduceSinkDeDuplication.ReduceSinkDeduplicateProcCtx dedupCtx) throws SemanticException {
        assert (cRS.getNumParent() == 1);
        ReduceSinkDesc cConf = (ReduceSinkDesc)cRS.getConf();
        ReduceSinkDesc pConf = (ReduceSinkDesc)pRS.getConf();
        List<ExprNodeDesc> cKeys = cConf.getKeyCols();
        List<ExprNodeDesc> pKeys = pConf.getKeyCols();
        if (!ReduceSinkDeDuplicationUtils.checkSelectSingleBranchOnly(cRS, pRS)) {
            return false;
        }
        if (cKeys == null || cKeys.isEmpty()) {
            return false;
        }
        if (pKeys == null || pKeys.isEmpty()) {
            return false;
        }
        ArrayList<ExprNodeDesc> cKeysInParentRS = ExprNodeDescUtils.backtrack(cKeys, cRS, pRS);
        for (int i = 0; i < cKeysInParentRS.size(); ++i) {
            ExprNodeDesc pexpr = (ExprNodeDesc)cKeysInParentRS.get(i);
            if (pexpr != null) continue;
            return false;
        }
        ((ReduceSinkDesc)cRS.getConf()).setKeyCols(cKeysInParentRS);
        ArrayList<ExprNodeDesc> cPartitionInParentRS = ExprNodeDescUtils.backtrack(cConf.getPartitionCols(), cRS, pRS);
        for (int i = 0; i < cPartitionInParentRS.size(); ++i) {
            ExprNodeDesc pexpr = (ExprNodeDesc)cPartitionInParentRS.get(i);
            if (pexpr != null) continue;
            return false;
        }
        ((ReduceSinkDesc)cRS.getConf()).setPartitionCols(cPartitionInParentRS);
        ArrayList<ExprNodeDesc> cValueInParentRS = ExprNodeDescUtils.backtrack(cConf.getValueCols(), cRS, pRS);
        for (int i = 0; i < cValueInParentRS.size(); ++i) {
            ExprNodeDesc pexpr = (ExprNodeDesc)cValueInParentRS.get(i);
            if (pexpr != null) continue;
            return false;
        }
        ((ReduceSinkDesc)cRS.getConf()).setValueCols(cValueInParentRS);
        if (cConf.getBucketCols() != null) {
            ArrayList<ExprNodeDesc> cBucketInParentRS = ExprNodeDescUtils.backtrack(cConf.getBucketCols(), cRS, pRS);
            for (int i = 0; i < cBucketInParentRS.size(); ++i) {
                ExprNodeDesc pexpr = (ExprNodeDesc)cBucketInParentRS.get(i);
                if (pexpr != null) continue;
                return false;
            }
            ((ReduceSinkDesc)cRS.getConf()).setBucketCols(cBucketInParentRS);
        }
        for (Map.Entry<String, ExprNodeDesc> e : cRS.getColumnExprMap().entrySet()) {
            e.setValue(ExprNodeDescUtils.backtrack(e.getValue(), cRS, pRS));
        }
        Operator<OperatorDesc> parent = cRS.getParentOperators().get(0);
        while (parent != pRS) {
            dedupCtx.addRemovedOperator(parent);
            parent = parent.getParentOperators().get(0);
        }
        dedupCtx.addRemovedOperator(pRS);
        cRS.getParentOperators().clear();
        for (Operator<OperatorDesc> op : pRS.getParentOperators()) {
            op.replaceChild(pRS, cRS);
            cRS.getParentOperators().add(op);
        }
        pRS.getParentOperators().clear();
        pRS.getChildOperators().clear();
        return true;
    }
}

