/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules.views;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.tools.RelBuilder;
import org.apache.hadoop.hive.common.type.SnapshotContext;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.optimizer.calcite.RelOptHiveTable;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveRuleConfig;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.TypeConverter;

public class HiveAugmentSnapshotMaterializationRule
extends RelRule<Config> {
    private static RelDataType snapshotIdType = null;
    private final Set<RelNode> visited;
    private final Map<String, SnapshotContext> mvMetaStoredSnapshot;

    public static RelOptRule with(Map<String, SnapshotContext> mvMetaStoredSnapshot) {
        return new Config().withMvMetaStoredSnapshot(mvMetaStoredSnapshot).withOperandSupplier(operandBuilder -> operandBuilder.operand(TableScan.class).anyInputs()).withDescription("HiveAugmentSnapshotMaterializationRule").toRule();
    }

    @VisibleForTesting
    static RelDataType snapshotIdType(RelDataTypeFactory typeFactory) {
        if (snapshotIdType == null) {
            snapshotIdType = typeFactory.createSqlType(TypeConverter.convert(VirtualColumn.SNAPSHOT_ID.getTypeInfo(), typeFactory).getSqlTypeName());
        }
        return snapshotIdType;
    }

    public HiveAugmentSnapshotMaterializationRule(Config config) {
        super((RelRule.Config)config);
        this.mvMetaStoredSnapshot = config.getMvMetaStoredSnapshot();
        this.visited = new HashSet<RelNode>();
    }

    public void onMatch(RelOptRuleCall call) {
        TableScan tableScan = (TableScan)call.rel(0);
        if (!this.visited.add((RelNode)tableScan)) {
            return;
        }
        RelOptHiveTable hiveTable = (RelOptHiveTable)tableScan.getTable();
        Table table = hiveTable.getHiveTableMD();
        SnapshotContext mvMetaTableSnapshot = this.mvMetaStoredSnapshot.get(table.getFullyQualifiedName());
        if (table.getStorageHandler() == null) {
            throw new UnsupportedOperationException(String.format("Table %s does not have Storage handler defined. Mixing native and non-native tables in a materialized view definition is currently not supported!", table.getFullyQualifiedName()));
        }
        if (Objects.equals(mvMetaTableSnapshot, table.getStorageHandler().getCurrentSnapshotContext(table))) {
            return;
        }
        Long snapshotId = mvMetaTableSnapshot != null ? Long.valueOf(mvMetaTableSnapshot.getSnapshotId()) : null;
        table.setVersionIntervalFrom(Objects.toString(snapshotId, null));
        RexBuilder rexBuilder = call.builder().getRexBuilder();
        int snapshotIdIndex = tableScan.getTable().getRowType().getField(VirtualColumn.SNAPSHOT_ID.getName(), false, false).getIndex();
        RexInputRef snapshotIdInputRef = rexBuilder.makeInputRef(((RelDataTypeField)tableScan.getTable().getRowType().getFieldList().get(snapshotIdIndex)).getType(), snapshotIdIndex);
        RelBuilder relBuilder = call.builder();
        relBuilder.push((RelNode)tableScan);
        RexNode snapshotIdLiteral = rexBuilder.makeLiteral((Object)snapshotId, HiveAugmentSnapshotMaterializationRule.snapshotIdType(relBuilder.getTypeFactory()), false);
        RexNode predicateWithSnapShotId = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{snapshotIdInputRef, snapshotIdLiteral});
        relBuilder.filter(Collections.singletonList(predicateWithSnapShotId));
        call.transformTo(relBuilder.build());
    }

    public static class Config
    extends HiveRuleConfig {
        private Map<String, SnapshotContext> mvMetaStoredSnapshot;

        public Config withMvMetaStoredSnapshot(Map<String, SnapshotContext> mvMetaStoredSnapshot) {
            this.mvMetaStoredSnapshot = mvMetaStoredSnapshot;
            return this;
        }

        public Map<String, SnapshotContext> getMvMetaStoredSnapshot() {
            return this.mvMetaStoredSnapshot;
        }

        public HiveAugmentSnapshotMaterializationRule toRule() {
            return new HiveAugmentSnapshotMaterializationRule(this);
        }
    }
}

