/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.SetOp;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.ReflectUtil;
import org.apache.calcite.util.ReflectiveVisitor;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveAggregate;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.jdbc.HiveJdbcConverter;

public class HiveRelColumnsAlignment
implements ReflectiveVisitor {
    private final ReflectUtil.MethodDispatcher<RelNode> alignDispatcher;
    private final RelBuilder relBuilder;

    public HiveRelColumnsAlignment(RelBuilder relBuilder) {
        this.relBuilder = relBuilder;
        this.alignDispatcher = ReflectUtil.createMethodDispatcher(RelNode.class, (ReflectiveVisitor)this, (String)"align", RelNode.class, (Class[])new Class[]{List.class});
    }

    public RelNode align(RelNode root) {
        RelNode newRoot = this.dispatchAlign(root, (List<RelFieldCollation>)ImmutableList.of());
        return newRoot;
    }

    protected final RelNode dispatchAlign(RelNode node, List<RelFieldCollation> collations) {
        if (node instanceof HiveJdbcConverter) {
            return node;
        }
        return (RelNode)this.alignDispatcher.invoke(new Object[]{node, collations});
    }

    public RelNode align(Aggregate rel, List<RelFieldCollation> collations) {
        LinkedHashSet<Integer> aggregateColumnsOrder = new LinkedHashSet<Integer>();
        ImmutableList.Builder propagateCollations = ImmutableList.builder();
        if (rel.getGroupType() == Aggregate.Group.SIMPLE && !collations.isEmpty()) {
            for (RelFieldCollation c : collations) {
                if (c.getFieldIndex() >= rel.getGroupCount() || !aggregateColumnsOrder.add(c.getFieldIndex())) continue;
                propagateCollations.add((Object)c.copy(rel.getGroupSet().nth(c.getFieldIndex())));
            }
        }
        for (int i = 0; i < rel.getGroupCount(); ++i) {
            if (aggregateColumnsOrder.contains(i)) continue;
            propagateCollations.add((Object)new RelFieldCollation(rel.getGroupSet().nth(i)));
        }
        RelNode child = this.dispatchAlign(rel.getInput(), (List<RelFieldCollation>)propagateCollations.build());
        HiveAggregate newAggregate = (HiveAggregate)rel.copy(rel.getTraitSet(), (List)ImmutableList.of((Object)child));
        newAggregate.setAggregateColumnsOrder(aggregateColumnsOrder);
        return newAggregate;
    }

    public RelNode align(Join rel, List<RelFieldCollation> collations) {
        ImmutableList.Builder propagateCollationsLeft = ImmutableList.builder();
        ImmutableList.Builder propagateCollationsRight = ImmutableList.builder();
        int nLeftColumns = rel.getLeft().getRowType().getFieldList().size();
        HashMap<Integer, RexCall> idxToConjuncts = new HashMap<Integer, RexCall>();
        HashMap<Integer, Integer> refToRef = new HashMap<Integer, Integer>();
        ArrayList<Object> conjuncts = new ArrayList<Object>();
        ArrayList<RexNode> otherConjuncts = new ArrayList<RexNode>();
        for (RexNode rexNode : RelOptUtil.conjunctions((RexNode)rel.getCondition())) {
            if (rexNode.getKind() != SqlKind.EQUALS) {
                otherConjuncts.add(rexNode);
                continue;
            }
            RexCall rexCall = (RexCall)rexNode;
            if (!(rexCall.getOperands().get(0) instanceof RexInputRef) || !(rexCall.getOperands().get(1) instanceof RexInputRef)) {
                otherConjuncts.add(rexNode);
                continue;
            }
            RexInputRef ref0 = (RexInputRef)rexCall.getOperands().get(0);
            RexInputRef ref1 = (RexInputRef)rexCall.getOperands().get(1);
            if (ref0.getIndex() < nLeftColumns && ref1.getIndex() >= nLeftColumns || ref1.getIndex() < nLeftColumns && ref0.getIndex() >= nLeftColumns) {
                idxToConjuncts.put(ref0.getIndex(), rexCall);
                idxToConjuncts.put(ref1.getIndex(), rexCall);
                refToRef.put(ref0.getIndex(), ref1.getIndex());
                refToRef.put(ref1.getIndex(), ref0.getIndex());
                continue;
            }
            otherConjuncts.add(rexNode);
        }
        for (RelFieldCollation relFieldCollation : collations) {
            RexNode rexNode = (RexNode)idxToConjuncts.get(relFieldCollation.getFieldIndex());
            if (rexNode == null) continue;
            conjuncts.add(rexNode);
            idxToConjuncts.remove(relFieldCollation.getFieldIndex());
            idxToConjuncts.remove(refToRef.get(relFieldCollation.getFieldIndex()));
            if (relFieldCollation.getFieldIndex() < nLeftColumns) {
                propagateCollationsLeft.add((Object)relFieldCollation.copy(relFieldCollation.getFieldIndex()));
                propagateCollationsRight.add((Object)relFieldCollation.copy((Integer)refToRef.get(relFieldCollation.getFieldIndex()) - nLeftColumns));
                continue;
            }
            propagateCollationsLeft.add((Object)relFieldCollation.copy(((Integer)refToRef.get(relFieldCollation.getFieldIndex())).intValue()));
            propagateCollationsRight.add((Object)relFieldCollation.copy(relFieldCollation.getFieldIndex() - nLeftColumns));
        }
        HashSet<RexNode> visited = new HashSet<RexNode>();
        for (Map.Entry entry : idxToConjuncts.entrySet()) {
            if (!visited.add((RexNode)entry.getValue())) continue;
            conjuncts.add((RexNode)entry.getValue());
            if ((Integer)entry.getKey() < nLeftColumns) {
                propagateCollationsLeft.add((Object)new RelFieldCollation(((Integer)entry.getKey()).intValue()));
                propagateCollationsRight.add((Object)new RelFieldCollation((Integer)refToRef.get(entry.getKey()) - nLeftColumns));
                continue;
            }
            propagateCollationsLeft.add((Object)new RelFieldCollation(((Integer)refToRef.get(entry.getKey())).intValue()));
            propagateCollationsRight.add((Object)new RelFieldCollation((Integer)entry.getKey() - nLeftColumns));
        }
        conjuncts.addAll(otherConjuncts);
        RelNode relNode = this.dispatchAlign(rel.getLeft(), (List<RelFieldCollation>)propagateCollationsLeft.build());
        RelNode relNode2 = this.dispatchAlign(rel.getRight(), (List<RelFieldCollation>)propagateCollationsRight.build());
        Join newJoin = rel.copy(rel.getTraitSet(), RexUtil.composeConjunction((RexBuilder)this.relBuilder.getRexBuilder(), conjuncts, (boolean)false), relNode, relNode2, rel.getJoinType(), rel.isSemiJoinDone());
        return newJoin;
    }

    public RelNode align(SetOp rel, List<RelFieldCollation> collations) {
        ImmutableList.Builder newInputs = new ImmutableList.Builder();
        for (RelNode input : rel.getInputs()) {
            newInputs.add((Object)this.dispatchAlign(input, collations));
        }
        return rel.copy(rel.getTraitSet(), (List)newInputs.build());
    }

    public RelNode align(Project rel, List<RelFieldCollation> collations) {
        boolean containsWindowing = false;
        for (Object childExp : rel.getProjects()) {
            if (!(childExp instanceof RexOver)) continue;
            containsWindowing = true;
            break;
        }
        ImmutableList.Builder propagateCollations = ImmutableList.builder();
        if (!containsWindowing) {
            for (RelFieldCollation c : collations) {
                RexNode rexNode = (RexNode)rel.getProjects().get(c.getFieldIndex());
                if (!(rexNode instanceof RexInputRef)) continue;
                int newIdx = ((RexInputRef)rexNode).getIndex();
                propagateCollations.add((Object)c.copy(newIdx));
            }
        }
        RelNode child = this.dispatchAlign(rel.getInput(), (List<RelFieldCollation>)propagateCollations.build());
        return rel.copy(rel.getTraitSet(), (List)ImmutableList.of((Object)child));
    }

    public RelNode align(Filter rel, List<RelFieldCollation> collations) {
        RelNode child = this.dispatchAlign(rel.getInput(), collations);
        return rel.copy(rel.getTraitSet(), (List)ImmutableList.of((Object)child));
    }

    public RelNode align(Sort rel, List<RelFieldCollation> collations) {
        RelNode child = this.dispatchAlign(rel.getInput(), rel.collation.getFieldCollations());
        return rel.copy(rel.getTraitSet(), (List)ImmutableList.of((Object)child));
    }

    public RelNode align(RelNode rel, List<RelFieldCollation> collations) {
        ImmutableList.Builder newInputs = new ImmutableList.Builder();
        for (RelNode input : rel.getInputs()) {
            newInputs.add((Object)this.dispatchAlign(input, (List<RelFieldCollation>)ImmutableList.of()));
        }
        return rel.copy(rel.getTraitSet(), (List)newInputs.build());
    }
}

