/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.reloperators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.util.Util;
import org.apache.hadoop.hive.ql.optimizer.calcite.CalciteSemanticException;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelShuttle;
import org.apache.hadoop.hive.ql.optimizer.calcite.TraitsUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.correlation.CorrelationInfoVisitor;
import org.apache.hadoop.hive.ql.optimizer.calcite.correlation.HiveCorrelationInfo;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveRelNode;

public class HiveProject
extends Project
implements HiveRelNode {
    private final CorrelationInfoSupplier correlationInfos = new CorrelationInfoSupplier(this.getProjects());
    private boolean isSysnthetic;

    public HiveProject(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, List<? extends RexNode> exps, RelDataType rowType) {
        super(cluster, traitSet, child, exps, rowType);
        assert (traitSet.containsIfApplicable((RelTrait)HiveRelNode.CONVENTION));
    }

    public static HiveProject create(RelNode child, List<? extends RexNode> exps, List<String> fieldNames) throws CalciteSemanticException {
        RelOptCluster cluster = child.getCluster();
        if (fieldNames != null && !Util.isDistinct(fieldNames)) {
            String msg = "Select list contains multiple expressions with the same name." + String.valueOf(fieldNames);
            throw new CalciteSemanticException(msg, CalciteSemanticException.UnsupportedFeature.Same_name_in_multiple_expressions);
        }
        RelDataType rowType = RexUtil.createStructType((RelDataTypeFactory)cluster.getTypeFactory(), exps, fieldNames, (SqlValidatorUtil.Suggester)SqlValidatorUtil.EXPR_SUGGESTER);
        return HiveProject.create(cluster, child, exps, rowType, Collections.emptyList());
    }

    public static HiveProject create(RelOptCluster cluster, RelNode child, List<? extends RexNode> exps, RelDataType rowType, List<RelCollation> collationList) {
        RelTraitSet traitSet = TraitsUtil.getDefaultTraitSet(cluster);
        return new HiveProject(cluster, traitSet, child, exps, rowType);
    }

    public static HiveProject create(RelOptCluster cluster, RelNode child, List<? extends RexNode> exps, RelDataType rowType, RelTraitSet traitSet, List<RelCollation> collationList) {
        return new HiveProject(cluster, traitSet, child, exps, rowType);
    }

    public Project copy(RelTraitSet traitSet, RelNode input, List<RexNode> exps, RelDataType rowType) {
        assert (traitSet.containsIfApplicable((RelTrait)HiveRelNode.CONVENTION));
        HiveProject hp = new HiveProject(this.getCluster(), traitSet, input, exps, rowType);
        if (this.isSynthetic()) {
            hp.setSynthetic();
        }
        return hp;
    }

    public void setSynthetic() {
        this.isSysnthetic = true;
    }

    public boolean isSynthetic() {
        return this.isSysnthetic;
    }

    public RelNode accept(RelShuttle shuttle) {
        if (shuttle instanceof HiveRelShuttle) {
            return ((HiveRelShuttle)shuttle).visit(this);
        }
        return shuttle.visit((RelNode)this);
    }

    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).itemIf("synthetic", (Object)this.isSysnthetic, pw.getDetailLevel() == SqlExplainLevel.DIGEST_ATTRIBUTES);
    }

    public List<HiveCorrelationInfo> getCorrelationInfos() {
        return this.correlationInfos.get();
    }

    private static class CorrelationInfoSupplier {
        public final List<RexNode> projects;
        private List<HiveCorrelationInfo> correlationInfos;

        public CorrelationInfoSupplier(List<RexNode> projects) {
            this.projects = projects;
        }

        public List<HiveCorrelationInfo> get() {
            if (this.correlationInfos == null) {
                this.correlationInfos = new ArrayList<HiveCorrelationInfo>();
                for (RexNode r : this.projects) {
                    this.correlationInfos.addAll(CorrelationInfoVisitor.getCorrelationInfos(r));
                }
            }
            return this.correlationInfos;
        }
    }
}

