/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.AbstractMapJoinOperator;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.LateralViewJoinOperator;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.SMBMapJoinOperator;
import org.apache.hadoop.hive.ql.exec.ScriptOperator;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.UnionOperator;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinKey;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.lib.SemanticNodeProcessor;
import org.apache.hadoop.hive.ql.lib.SemanticRule;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.optimizer.physical.Vectorizer;
import org.apache.hadoop.hive.ql.parse.GenMapRedWalker;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDescUtils;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.JoinCondDesc;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.MapredLocalWork;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.SMBJoinDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapJoinProcessor
extends Transform {
    private static final String MAPJOINKEY_FIELDPREFIX = "mapjoinkey";
    private static final Logger LOG = LoggerFactory.getLogger((String)MapJoinProcessor.class.getName());

    private static void genMapJoinLocalWork(MapredWork newWork, MapJoinOperator mapJoinOp, int bigTablePos) throws SemanticException {
        ArrayList<String> smallTableAliasList = new ArrayList<String>();
        MapredLocalWork newLocalWork = new MapredLocalWork(new LinkedHashMap<String, Operator<? extends OperatorDesc>>(), new LinkedHashMap<String, FetchWork>());
        for (Map.Entry<String, Operator<? extends OperatorDesc>> entry : newWork.getMapWork().getAliasToWork().entrySet()) {
            Operator<? extends OperatorDesc> op;
            String alias = entry.getKey();
            Operator<? extends OperatorDesc> parentOp = op = entry.getValue();
            Operator<OperatorDesc> childOp = op.getChildOperators().get(0);
            while (childOp != null && !childOp.equals(mapJoinOp)) {
                parentOp = childOp;
                assert (parentOp.getChildOperators().size() == 1);
                childOp = parentOp.getChildOperators().get(0);
            }
            if (childOp == null) {
                throw new SemanticException("Cannot find join op by tracing down the table scan operator tree");
            }
            int i = childOp.getParentOperators().indexOf(parentOp);
            if (i == bigTablePos) continue;
            newLocalWork.getAliasToWork().put(alias, op);
            smallTableAliasList.add(alias);
            Map<Path, List<String>> pathToAliases = newWork.getMapWork().getPathToAliases();
            HashSet<Path> pathSet = new HashSet<Path>();
            HashSet<Path> emptyPath = new HashSet<Path>();
            for (Map.Entry<Path, List<String>> entry2 : pathToAliases.entrySet()) {
                Path path = entry2.getKey();
                List<String> list = entry2.getValue();
                if (!list.contains(alias)) continue;
                pathSet.add(path);
                list.remove(alias);
                if (list.size() != 0) continue;
                emptyPath.add(path);
            }
            for (Path path : emptyPath) {
                newWork.getMapWork().removePathToAlias(path);
            }
            FetchWork fetchWork = null;
            ArrayList<Path> partDir = new ArrayList<Path>();
            ArrayList<PartitionDesc> partDesc = new ArrayList<PartitionDesc>();
            for (Path tablePath : pathSet) {
                PartitionDesc partitionDesc = newWork.getMapWork().getPathToPartitionInfo().get(tablePath);
                if (partitionDesc.getPartSpec() == null || partitionDesc.getPartSpec().size() == 0) {
                    fetchWork = new FetchWork(tablePath, partitionDesc.getTableDesc());
                    break;
                }
                partDir.add(tablePath);
                partDesc.add(partitionDesc);
            }
            if (fetchWork == null) {
                TableDesc table = newWork.getMapWork().getAliasToPartnInfo().get(alias).getTableDesc();
                fetchWork = new FetchWork(partDir, partDesc, table);
            }
            newLocalWork.getAliasToFetchWork().put(alias, fetchWork);
        }
        for (String alias : smallTableAliasList) {
            newWork.getMapWork().getAliasToWork().remove(alias);
        }
        newWork.getMapWork().setMapRedLocalWork(newLocalWork);
        newWork.setReduceWork(null);
    }

    public static void genMapJoinOpAndLocalWork(HiveConf conf, MapredWork newWork, JoinOperator op, int mapJoinPos) throws SemanticException {
        MapJoinOperator newMapJoinOp = new MapJoinProcessor().convertMapJoin(conf, op, newWork.getMapWork().isLeftInputJoin(), newWork.getMapWork().getBaseSrc(), newWork.getMapWork().getMapAliases(), mapJoinPos, true, false);
        MapJoinProcessor.genLocalWorkForMapJoin(newWork, newMapJoinOp, mapJoinPos);
    }

    public static void genLocalWorkForMapJoin(MapredWork newWork, MapJoinOperator newMapJoinOp, int mapJoinPos) throws SemanticException {
        try {
            MapJoinProcessor.genMapJoinLocalWork(newWork, newMapJoinOp, mapJoinPos);
            newWork.getMapWork().setLeftInputJoin(false);
            newWork.getMapWork().setBaseSrc(null);
            newWork.getMapWork().setMapAliases(null);
        }
        catch (Exception e) {
            throw new SemanticException("Failed to generate new mapJoin operator by exception : ", (Throwable)e);
        }
    }

    private static void checkParentOperatorType(Operator<? extends OperatorDesc> op) throws SemanticException {
        if (!op.opAllowedBeforeMapJoin()) {
            throw new SemanticException(ErrorMsg.OPERATOR_NOT_ALLOWED_WITH_MAPJOIN.getMsg());
        }
        if (op.getParentOperators() != null) {
            for (Operator<OperatorDesc> parentOp : op.getParentOperators()) {
                MapJoinProcessor.checkParentOperatorType(parentOp);
            }
        }
    }

    private static void checkChildOperatorType(Operator<? extends OperatorDesc> op) throws SemanticException {
        if (!op.opAllowedAfterMapJoin()) {
            throw new SemanticException(ErrorMsg.OPERATOR_NOT_ALLOWED_WITH_MAPJOIN.getMsg());
        }
        for (Operator<OperatorDesc> childOp : op.getChildOperators()) {
            MapJoinProcessor.checkChildOperatorType(childOp);
        }
    }

    private static void validateMapJoinTypes(Operator<? extends OperatorDesc> op) throws SemanticException {
        for (Operator<OperatorDesc> parentOp : op.getParentOperators()) {
            MapJoinProcessor.checkParentOperatorType(parentOp);
        }
        for (Operator<OperatorDesc> childOp : op.getChildOperators()) {
            MapJoinProcessor.checkChildOperatorType(childOp);
        }
    }

    public MapJoinOperator convertMapJoin(HiveConf conf, JoinOperator op, boolean leftInputJoin, String[] baseSrc, List<String> mapAliases, int mapJoinPos, boolean noCheckOuterJoin, boolean validateMapJoinTree) throws SemanticException {
        JoinDesc desc = (JoinDesc)op.getConf();
        JoinCondDesc[] condns = desc.getConds();
        if (!noCheckOuterJoin && MapJoinProcessor.checkMapJoin(mapJoinPos, condns) < 0) {
            throw new SemanticException(ErrorMsg.NO_OUTER_MAPJOIN.getMsg());
        }
        List<Operator<OperatorDesc>> parentOps = op.getParentOperators();
        ArrayList<Operator<? extends OperatorDesc>> newParentOps = new ArrayList<Operator<? extends OperatorDesc>>();
        ArrayList<Operator<OperatorDesc>> oldReduceSinkParentOps = new ArrayList<Operator<OperatorDesc>>();
        if (leftInputJoin) {
            Operator<OperatorDesc> parentOp = parentOps.get(0);
            assert (parentOp.getParentOperators().size() == 1);
            Operator<OperatorDesc> operator = parentOp.getParentOperators().get(0);
            oldReduceSinkParentOps.add(parentOp);
            newParentOps.add(operator);
        }
        int pos = 0;
        for (String src : baseSrc) {
            if (src != null) {
                Operator<OperatorDesc> parentOp = parentOps.get(pos);
                assert (parentOp.getParentOperators().size() == 1);
                Operator<OperatorDesc> grandParentOp = parentOp.getParentOperators().get(0);
                oldReduceSinkParentOps.add(parentOp);
                newParentOps.add(grandParentOp);
            }
            pos = (byte)(pos + 1);
        }
        MapJoinOperator mapJoinOperator = MapJoinProcessor.convertJoinOpMapJoinOp(conf, op, leftInputJoin, baseSrc, mapAliases, mapJoinPos, noCheckOuterJoin);
        if (mapJoinOperator == null) {
            return null;
        }
        for (pos = 0; pos < newParentOps.size(); pos = (int)((byte)(pos + 1))) {
            ((Operator)newParentOps.get(pos)).replaceChild((Operator)oldReduceSinkParentOps.get(pos), mapJoinOperator);
        }
        mapJoinOperator.getParentOperators().removeAll(oldReduceSinkParentOps);
        mapJoinOperator.setParentOperators(newParentOps);
        if (validateMapJoinTree) {
            MapJoinProcessor.validateMapJoinTypes(mapJoinOperator);
        }
        return mapJoinOperator;
    }

    public static boolean onExpressionHasNullSafes(JoinDesc desc) {
        boolean[] nullSafes = desc.getNullSafes();
        if (nullSafes == null) {
            return false;
        }
        for (boolean nullSafe : nullSafes) {
            if (!nullSafe) continue;
            return true;
        }
        return false;
    }

    private static boolean checkFullOuterMapJoinCompatible(HiveConf hiveConf, JoinOperator joinOp) throws SemanticException {
        boolean hasFullOuterJoinWithFilter;
        JoinDesc joinDesc = (JoinDesc)joinOp.getConf();
        for (Map.Entry<Byte, List<ExprNodeDesc>> mapEntry : joinDesc.getExprs().entrySet()) {
            List<ExprNodeDesc> exprList = mapEntry.getValue();
            for (ExprNodeDesc expr : exprList) {
                if (expr instanceof ExprNodeColumnDesc) continue;
                LOG.debug("FULL OUTER MapJoin: only column expressions are supported " + expr.toString());
                return false;
            }
        }
        Byte[] order = joinDesc.getTagOrder();
        ExprNodeDesc[][] joinKeysArray = joinDesc.getJoinKeys();
        for (int i = 0; i < order.length; ++i) {
            ExprNodeDesc[] keyExprs;
            byte pos = order[i];
            for (ExprNodeDesc keyExpr : keyExprs = joinKeysArray[pos]) {
                TypeInfo typeInfo = keyExpr.getTypeInfo();
                if (MapJoinKey.isSupportedField(typeInfo)) continue;
                LOG.debug("FULL OUTER MapJoin not enabled: key type {} not supported", (Object)typeInfo);
                return false;
            }
        }
        if (MapJoinProcessor.onExpressionHasNullSafes(joinDesc)) {
            LOG.debug("FULL OUTER MapJoin not enabled: nullsafe not supported");
            return false;
        }
        boolean isVectorizationMapJoinNativeEnabled = HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_VECTORIZATION_MAPJOIN_NATIVE_ENABLED);
        boolean isHybridHashJoin = HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_USE_HYBRIDGRACE_HASHJOIN);
        if (isVectorizationMapJoinNativeEnabled && isHybridHashJoin) {
            LOG.debug("FULL OUTER MapJoin not enabled: Native Vector MapJoin and Hybrid Grace not supported");
            return false;
        }
        if (joinDesc.getResidualFilterExprs() != null && joinDesc.getResidualFilterExprs().size() != 0) {
            LOG.debug("FULL OUTER MapJoin not enabled: non-equi joins not supported");
            return false;
        }
        if (joinDesc.getFilters() != null && (hasFullOuterJoinWithFilter = Arrays.stream(joinDesc.getConds()).anyMatch(cond -> {
            if (cond.getType() == 3) {
                Byte left = (byte)cond.getLeft();
                Byte right = (byte)cond.getRight();
                boolean leftHasFilter = joinDesc.getFilters().containsKey(left) && !joinDesc.getFilters().get(left).isEmpty();
                boolean rightHasFilter = joinDesc.getFilters().containsKey(right) && !joinDesc.getFilters().get(right).isEmpty();
                return leftHasFilter || rightHasFilter;
            }
            return false;
        }))) {
            LOG.debug("FULL OUTER MapJoin not enabled: FullOuterJoin with filters not supported");
            return false;
        }
        return true;
    }

    public static boolean precheckFullOuter(HiveConf hiveConf, JoinOperator joinOp) throws SemanticException {
        JoinDesc joinDesc = (JoinDesc)joinOp.getConf();
        JoinCondDesc[] conds = joinDesc.getConds();
        boolean hasFullOuterJoin = false;
        for (JoinCondDesc cond : conds) {
            if (cond.getType() != 3) continue;
            hasFullOuterJoin = true;
            break;
        }
        if (!hasFullOuterJoin) {
            return false;
        }
        if (conds.length > 1) {
            LOG.debug("FULL OUTER MapJoin not enabled: multiple JOIN conditions not supported");
            return false;
        }
        return true;
    }

    public static boolean isFullOuterMapEnabled(HiveConf hiveConf, JoinOperator joinOp) throws SemanticException {
        String engine;
        boolean isTezEngine;
        String testMapJoinFullOuterOverrideString = HiveConf.getVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_TEST_MAPJOINFULLOUTER_OVERRIDE);
        Vectorizer.EnabledOverride mapJoinFullOuterOverride = Vectorizer.EnabledOverride.NAME_MAP.get(testMapJoinFullOuterOverrideString);
        boolean isEnabled = HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_MAPJOIN_FULL_OUTER);
        switch (mapJoinFullOuterOverride) {
            case NONE: {
                if (isEnabled) break;
                LOG.debug("FULL OUTER MapJoin not enabled: {} is false", (Object)HiveConf.ConfVars.HIVE_MAPJOIN_FULL_OUTER.varname);
                return false;
            }
            case DISABLE: {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("FULL OUTER MapJoin not enabled: " + HiveConf.ConfVars.HIVE_TEST_MAPJOINFULLOUTER_OVERRIDE.varname + " is disable ( " + HiveConf.ConfVars.HIVE_MAPJOIN_FULL_OUTER.varname + " is " + isEnabled + ")");
                }
                return false;
            }
            case ENABLE: {
                HiveConf.setBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_MAPJOIN_FULL_OUTER, (boolean)true);
                if (!LOG.isDebugEnabled()) break;
                LOG.debug("FULL OUTER MapJoin is enabled: " + HiveConf.ConfVars.HIVE_TEST_MAPJOINFULLOUTER_OVERRIDE.varname + " is enable ( " + HiveConf.ConfVars.HIVE_MAPJOIN_FULL_OUTER.varname + " is " + isEnabled + ")");
                break;
            }
            default: {
                throw new RuntimeException("Unexpected vectorization enabled override " + String.valueOf((Object)mapJoinFullOuterOverride));
            }
        }
        if (!(isTezEngine = (engine = HiveConf.getVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_EXECUTION_ENGINE)).equalsIgnoreCase("tez"))) {
            LOG.debug("FULL OUTER MapJoin not enabled: Only Tez engine supported");
            return false;
        }
        boolean isOptimizedHashTableEnabled = HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_MAPJOIN_USE_OPTIMIZED_TABLE);
        if (!isOptimizedHashTableEnabled) {
            LOG.debug("FULL OUTER MapJoin not enabled: {} is false", (Object)HiveConf.ConfVars.HIVE_MAPJOIN_USE_OPTIMIZED_TABLE.varname);
            return false;
        }
        boolean isCompatibleFullOuterMapJoin = MapJoinProcessor.checkFullOuterMapJoinCompatible(hiveConf, joinOp);
        if (!isCompatibleFullOuterMapJoin) {
            return false;
        }
        LOG.debug("FULL OUTER MapJoin enabled");
        return true;
    }

    public static boolean isFullOuterEnabledForDynamicPartitionHashJoin(HiveConf hiveConf, JoinOperator joinOp) throws SemanticException {
        return true;
    }

    public static MapJoinOperator convertJoinOpMapJoinOp(HiveConf hconf, JoinOperator op, boolean leftInputJoin, String[] baseSrc, List<String> mapAliases, int mapJoinPos, boolean noCheckOuterJoin) throws SemanticException {
        return MapJoinProcessor.convertJoinOpMapJoinOp(hconf, op, leftInputJoin, baseSrc, mapAliases, mapJoinPos, noCheckOuterJoin, true);
    }

    public static MapJoinOperator convertJoinOpMapJoinOp(HiveConf hconf, JoinOperator op, boolean leftInputJoin, String[] baseSrc, List<String> mapAliases, int mapJoinPos, boolean noCheckOuterJoin, boolean adjustParentsChildren) throws SemanticException {
        MapJoinDesc mapJoinDescriptor = MapJoinProcessor.getMapJoinDesc(hconf, op, leftInputJoin, baseSrc, mapAliases, mapJoinPos, noCheckOuterJoin, adjustParentsChildren);
        if (mapJoinDescriptor == null) {
            return null;
        }
        RowSchema outputRS = op.getSchema();
        MapJoinOperator mapJoinOp = (MapJoinOperator)OperatorFactory.getAndMakeChild(op.getCompilationOpContext(), mapJoinDescriptor, new RowSchema(outputRS.getSignature()), op.getParentOperators());
        ((MapJoinDesc)mapJoinOp.getConf()).setReversedExprs(((JoinDesc)op.getConf()).getReversedExprs());
        Map<String, ExprNodeDesc> colExprMap = op.getColumnExprMap();
        mapJoinOp.setColumnExprMap(colExprMap);
        List<Operator<? extends OperatorDesc>> childOps = op.getChildOperators();
        for (Operator<OperatorDesc> operator : childOps) {
            operator.replaceParent(op, mapJoinOp);
        }
        mapJoinOp.setPosToAliasMap(op.getPosToAliasMap());
        mapJoinOp.setChildOperators(childOps);
        op.setChildOperators(null);
        op.setParentOperators(null);
        return mapJoinOp;
    }

    private static boolean needValueIndex(int[] valueIndex) {
        for (int i = 0; i < valueIndex.length; ++i) {
            if (valueIndex[i] == -i - 1) continue;
            return true;
        }
        return false;
    }

    public static MapJoinOperator convertSMBJoinToMapJoin(HiveConf hconf, SMBMapJoinOperator smbJoinOp, int bigTablePos, boolean noCheckOuterJoin) throws SemanticException {
        SMBJoinDesc smbJoinDesc = (SMBJoinDesc)smbJoinOp.getConf();
        List<ExprNodeDesc> keyCols = smbJoinDesc.getKeys().get((byte)0);
        TableDesc keyTableDesc = PlanUtils.getMapJoinKeyTableDesc((Configuration)hconf, PlanUtils.getFieldSchemasFromColumnList(keyCols, MAPJOINKEY_FIELDPREFIX));
        MapJoinDesc mapJoinDesc = new MapJoinDesc(smbJoinDesc.getKeys(), keyTableDesc, smbJoinDesc.getExprs(), smbJoinDesc.getValueTblDescs(), smbJoinDesc.getValueTblDescs(), smbJoinDesc.getOutputColumnNames(), bigTablePos, smbJoinDesc.getConds(), smbJoinDesc.getFilters(), smbJoinDesc.isNoOuterJoin(), smbJoinDesc.getDumpFilePrefix(), smbJoinDesc.getMemoryMonitorInfo(), smbJoinDesc.getInMemoryDataSize());
        mapJoinDesc.setStatistics(smbJoinDesc.getStatistics());
        mapJoinDesc.setColumnExprMap(smbJoinDesc.getColumnExprMap());
        RowSchema joinRS = smbJoinOp.getSchema();
        MapJoinOperator mapJoinOp = (MapJoinOperator)OperatorFactory.getAndMakeChild(smbJoinOp.getCompilationOpContext(), mapJoinDesc, joinRS, new ArrayList<Operator<? extends OperatorDesc>>());
        List<Operator<? extends OperatorDesc>> childOps = smbJoinOp.getChildOperators();
        for (Operator<OperatorDesc> operator : childOps) {
            operator.replaceParent(smbJoinOp, mapJoinOp);
        }
        mapJoinOp.setChildOperators(childOps);
        smbJoinOp.setChildOperators(null);
        List<Operator<? extends OperatorDesc>> parentOps = smbJoinOp.getParentOperators();
        for (Operator<OperatorDesc> operator : parentOps) {
            operator.replaceChild(smbJoinOp, mapJoinOp);
        }
        mapJoinOp.setParentOperators(parentOps);
        smbJoinOp.setParentOperators(null);
        return mapJoinOp;
    }

    public MapJoinOperator generateMapJoinOperator(ParseContext pctx, JoinOperator op, int mapJoinPos) throws SemanticException {
        HiveConf hiveConf = pctx.getConf();
        boolean noCheckOuterJoin = HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_OPT_SORT_MERGE_BUCKET_MAPJOIN) && HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_OPT_BUCKET_MAPJOIN);
        MapJoinOperator mapJoinOp = this.convertMapJoin(pctx.getConf(), op, ((JoinDesc)op.getConf()).isLeftInputJoin(), ((JoinDesc)op.getConf()).getBaseSrc(), ((JoinDesc)op.getConf()).getMapAliases(), mapJoinPos, noCheckOuterJoin, true);
        if (mapJoinOp == null) {
            return null;
        }
        this.genSelectPlan(pctx, mapJoinOp);
        return mapJoinOp;
    }

    public static Set<Integer> getBigTableCandidates(JoinCondDesc[] condns) {
        return MapJoinProcessor.getBigTableCandidates(condns, false);
    }

    public static Set<Integer> getBigTableCandidates(JoinCondDesc[] condns, boolean isSupportFullOuter) {
        JoinCondDesc condn;
        HashSet<Integer> bigTableCandidates = new HashSet<Integer>();
        if (condns.length == 1 && (condn = condns[0]).getType() == 3) {
            if (!isSupportFullOuter) {
                return new HashSet<Integer>();
            }
            bigTableCandidates.add(condn.getLeft());
            bigTableCandidates.add(condn.getRight());
            return bigTableCandidates;
        }
        boolean seenOuterJoin = false;
        HashSet<Integer> seenPostitions = new HashSet<Integer>();
        HashSet<Integer> leftPosListOfLastRightOuterJoin = new HashSet<Integer>();
        boolean lastSeenRightOuterJoin = false;
        for (JoinCondDesc condn2 : condns) {
            int joinType = condn2.getType();
            if (joinType == 3) {
                return new HashSet<Integer>();
            }
            seenPostitions.add(condn2.getLeft());
            seenPostitions.add(condn2.getRight());
            if (joinType == 1 || joinType == 5 || joinType == 6) {
                seenOuterJoin = true;
                if (bigTableCandidates.size() == 0) {
                    bigTableCandidates.add(condn2.getLeft());
                }
                lastSeenRightOuterJoin = false;
                continue;
            }
            if (joinType == 2) {
                seenOuterJoin = true;
                lastSeenRightOuterJoin = true;
                leftPosListOfLastRightOuterJoin.clear();
                leftPosListOfLastRightOuterJoin.addAll(seenPostitions);
                leftPosListOfLastRightOuterJoin.remove(condn2.getRight());
                bigTableCandidates.clear();
                bigTableCandidates.add(condn2.getRight());
                continue;
            }
            if (joinType != 0 || seenOuterJoin && !lastSeenRightOuterJoin) continue;
            if (!leftPosListOfLastRightOuterJoin.contains(condn2.getLeft())) {
                bigTableCandidates.add(condn2.getLeft());
            }
            if (leftPosListOfLastRightOuterJoin.contains(condn2.getRight())) continue;
            bigTableCandidates.add(condn2.getRight());
        }
        return bigTableCandidates;
    }

    public static int checkMapJoin(int mapJoinPos, JoinCondDesc[] condns) {
        Set<Integer> bigTableCandidates = MapJoinProcessor.getBigTableCandidates(condns, true);
        if (!bigTableCandidates.contains(mapJoinPos)) {
            return -1;
        }
        return mapJoinPos;
    }

    protected void genSelectPlan(ParseContext pctx, MapJoinOperator input) throws SemanticException {
        List<Operator<? extends OperatorDesc>> childOps = input.getChildOperators();
        input.setChildOperators(null);
        RowSchema inputRS = input.getSchema();
        ArrayList<ExprNodeDesc> exprs = new ArrayList<ExprNodeDesc>();
        ArrayList<String> outputs = new ArrayList<String>();
        List<String> outputCols = ((MapJoinDesc)input.getConf()).getOutputColumnNames();
        ArrayList<ColumnInfo> outputRS = new ArrayList<ColumnInfo>();
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        for (int i = 0; i < outputCols.size(); ++i) {
            String internalName = outputCols.get(i);
            ColumnInfo valueInfo = inputRS.getColumnInfo(internalName);
            ExprNodeColumnDesc colDesc = new ExprNodeColumnDesc(valueInfo.getType(), valueInfo.getInternalName(), valueInfo.getTabAlias(), valueInfo.getIsVirtualCol());
            exprs.add(colDesc);
            outputs.add(internalName);
            ColumnInfo newCol = new ColumnInfo(internalName, valueInfo.getType(), valueInfo.getTabAlias(), valueInfo.getIsVirtualCol(), valueInfo.isHiddenVirtualCol());
            newCol.setAlias(valueInfo.getAlias());
            outputRS.add(newCol);
            colExprMap.put(internalName, colDesc);
        }
        SelectDesc select = new SelectDesc(exprs, outputs, false);
        SelectOperator sel = (SelectOperator)OperatorFactory.getAndMakeChild(select, new RowSchema(outputRS), (Operator)input, new Operator[0]);
        sel.setColumnExprMap(colExprMap);
        sel.setChildOperators(childOps);
        for (Operator<? extends OperatorDesc> ch : childOps) {
            ch.replaceParent(input, sel);
        }
    }

    private int mapSideJoin(JoinOperator op) throws SemanticException {
        int mapJoinPos = -1;
        if (((JoinDesc)op.getConf()).isMapSideJoin()) {
            int pos = 0;
            if (((JoinDesc)op.getConf()).isLeftInputJoin()) {
                mapJoinPos = pos;
            }
            for (String src : ((JoinDesc)op.getConf()).getBaseSrc()) {
                if (src != null && !((JoinDesc)op.getConf()).getMapAliases().contains(src)) {
                    if (mapJoinPos >= 0) {
                        return -1;
                    }
                    mapJoinPos = pos;
                }
                ++pos;
            }
            if (mapJoinPos == -1) {
                throw new SemanticException(ErrorMsg.INVALID_MAPJOIN_HINT.getMsg(Arrays.toString(((JoinDesc)op.getConf()).getBaseSrc())));
            }
        }
        return mapJoinPos;
    }

    @Override
    public ParseContext transform(ParseContext pactx) throws SemanticException {
        ArrayList<MapJoinOperator> listMapJoinOps = new ArrayList<MapJoinOperator>();
        if (pactx.getJoinOps() != null) {
            HashSet<JoinOperator> joinMap = new HashSet<JoinOperator>();
            Set<MapJoinOperator> mapJoinMap = pactx.getMapJoinOps();
            if (mapJoinMap == null) {
                mapJoinMap = new HashSet<MapJoinOperator>();
                pactx.setMapJoinOps(mapJoinMap);
            }
            for (JoinOperator joinOp : pactx.getJoinOps()) {
                int mapJoinPos = this.mapSideJoin(joinOp);
                if (mapJoinPos >= 0) {
                    MapJoinOperator mapJoinOp = this.generateMapJoinOperator(pactx, joinOp, mapJoinPos);
                    listMapJoinOps.add(mapJoinOp);
                    ((MapJoinDesc)mapJoinOp.getConf()).setQBJoinTreeProps((JoinDesc)joinOp.getConf());
                    mapJoinMap.add(mapJoinOp);
                    continue;
                }
                ((JoinDesc)joinOp.getConf()).setQBJoinTreeProps((JoinDesc)joinOp.getConf());
                joinMap.add(joinOp);
            }
            pactx.setJoinOps(joinMap);
        }
        ArrayList<AbstractMapJoinOperator<? extends MapJoinDesc>> listMapJoinOpsNoRed = new ArrayList<AbstractMapJoinOperator<? extends MapJoinDesc>>();
        LinkedHashMap<SemanticRule, SemanticNodeProcessor> opRules = new LinkedHashMap<SemanticRule, SemanticNodeProcessor>();
        opRules.put(new RuleRegExp("R0", MapJoinOperator.getOperatorName() + "%"), MapJoinProcessor.getCurrentMapJoin());
        opRules.put(new RuleRegExp("R1", MapJoinOperator.getOperatorName() + "%.*" + FileSinkOperator.getOperatorName() + "%"), MapJoinProcessor.getMapJoinFS());
        opRules.put(new RuleRegExp("R2", MapJoinOperator.getOperatorName() + "%.*" + ReduceSinkOperator.getOperatorName() + "%"), MapJoinProcessor.getMapJoinDefault());
        opRules.put(new RuleRegExp("R4", MapJoinOperator.getOperatorName() + "%.*" + UnionOperator.getOperatorName() + "%"), MapJoinProcessor.getMapJoinDefault());
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(MapJoinProcessor.getDefault(), opRules, new MapJoinWalkerCtx(listMapJoinOpsNoRed, pactx));
        GenMapRedWalker ogw = new GenMapRedWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(listMapJoinOps);
        ogw.startWalking(topNodes, null);
        pactx.setListMapJoinOpsNoReducer(listMapJoinOpsNoRed);
        return pactx;
    }

    private static void addNoReducerMapJoinToCtx(MapJoinWalkerCtx ctx, AbstractMapJoinOperator<? extends MapJoinDesc> mapJoin) {
        if (ctx.getListRejectedMapJoins() != null && ctx.getListRejectedMapJoins().contains(mapJoin)) {
            return;
        }
        List<AbstractMapJoinOperator<? extends MapJoinDesc>> listMapJoinsNoRed = ctx.getListMapJoinsNoRed();
        if (listMapJoinsNoRed == null) {
            listMapJoinsNoRed = new ArrayList<AbstractMapJoinOperator<? extends MapJoinDesc>>();
        }
        if (!listMapJoinsNoRed.contains(mapJoin)) {
            listMapJoinsNoRed.add(mapJoin);
        }
        ctx.setListMapJoins(listMapJoinsNoRed);
    }

    private static void addRejectMapJoinToCtx(MapJoinWalkerCtx ctx, AbstractMapJoinOperator<? extends MapJoinDesc> mapjoin) {
        if (mapjoin == null) {
            return;
        }
        List<AbstractMapJoinOperator<? extends MapJoinDesc>> listRejectedMapJoins = ctx.getListRejectedMapJoins();
        if (listRejectedMapJoins == null) {
            listRejectedMapJoins = new ArrayList<AbstractMapJoinOperator<? extends MapJoinDesc>>();
        }
        if (!listRejectedMapJoins.contains(mapjoin)) {
            listRejectedMapJoins.add(mapjoin);
        }
        if (ctx.getListMapJoinsNoRed() != null && ctx.getListMapJoinsNoRed().contains(mapjoin)) {
            ctx.getListMapJoinsNoRed().remove(mapjoin);
        }
        ctx.setListRejectedMapJoins(listRejectedMapJoins);
    }

    public static SemanticNodeProcessor getMapJoinFS() {
        return new MapJoinFS();
    }

    public static SemanticNodeProcessor getMapJoinDefault() {
        return new MapJoinDefault();
    }

    public static SemanticNodeProcessor getDefault() {
        return new Default();
    }

    public static SemanticNodeProcessor getCurrentMapJoin() {
        return new CurrentMapJoin();
    }

    public static Pair<List<ReduceSinkOperator>, Map<Byte, List<ExprNodeDesc>>> getKeys(boolean leftInputJoin, String[] baseSrc, JoinOperator op) {
        ArrayList<ReduceSinkOperator> oldReduceSinkParentOps = new ArrayList<ReduceSinkOperator>(op.getNumParent());
        if (leftInputJoin) {
            Operator<OperatorDesc> parentOp = op.getParentOperators().get(0);
            assert (parentOp.getParentOperators().size() == 1);
            oldReduceSinkParentOps.add((ReduceSinkOperator)parentOp);
        }
        byte pos = 0;
        for (String src : baseSrc) {
            if (src != null) {
                Operator<OperatorDesc> parentOp = op.getParentOperators().get(pos);
                assert (parentOp.getParentOperators().size() == 1);
                oldReduceSinkParentOps.add((ReduceSinkOperator)parentOp);
            }
            pos = (byte)(pos + 1);
        }
        HashMap<Byte, List<ExprNodeDesc>> keyExprMap = new HashMap<Byte, List<ExprNodeDesc>>();
        for (pos = 0; pos < op.getParentOperators().size(); pos = (byte)(pos + 1)) {
            ReduceSinkOperator inputRS = (ReduceSinkOperator)oldReduceSinkParentOps.get(pos);
            List<ExprNodeDesc> keyCols = ((ReduceSinkDesc)inputRS.getConf()).getKeyCols();
            keyExprMap.put(pos, keyCols);
        }
        return Pair.of(oldReduceSinkParentOps, keyExprMap);
    }

    public static MapJoinDesc getMapJoinDesc(HiveConf hconf, JoinOperator op, boolean leftInputJoin, String[] baseSrc, List<String> mapAliases, int mapJoinPos, boolean noCheckOuterJoin, boolean adjustParentsChildren) throws SemanticException {
        JoinDesc desc = (JoinDesc)op.getConf();
        JoinCondDesc[] condns = desc.getConds();
        Byte[] tagOrder = desc.getTagOrder();
        if (!noCheckOuterJoin && MapJoinProcessor.checkMapJoin(mapJoinPos, condns) < 0) {
            throw new SemanticException(ErrorMsg.NO_OUTER_MAPJOIN.getMsg());
        }
        Map<String, ExprNodeDesc> colExprMap = op.getColumnExprMap();
        ArrayList<ColumnInfo> schema = new ArrayList<ColumnInfo>(op.getSchema().getSignature());
        Map<Byte, List<ExprNodeDesc>> valueExprs = ((JoinDesc)op.getConf()).getExprs();
        Map<Object, Object> newValueExprs = new HashMap();
        Pair<List<ReduceSinkOperator>, Map<Byte, List<ExprNodeDesc>>> pair = MapJoinProcessor.getKeys(leftInputJoin, baseSrc, op);
        List oldReduceSinkParentOps = (List)pair.getLeft();
        for (Map.Entry<Byte, List<ExprNodeDesc>> entry : valueExprs.entrySet()) {
            byte tag = entry.getKey();
            Operator terminal = (Operator)oldReduceSinkParentOps.get(tag);
            List<ExprNodeDesc> list = entry.getValue();
            ArrayList<ExprNodeDesc> newValues = ExprNodeDescUtils.backtrack(list, op, terminal);
            newValueExprs.put(tag, newValues);
            for (int i = 0; i < schema.size(); ++i) {
                ExprNodeDesc expr;
                int index;
                ColumnInfo column = (ColumnInfo)schema.get(i);
                if (column == null || (index = ExprNodeDescUtils.indexOf(expr = colExprMap.get(column.getInternalName()), list)) < 0) continue;
                schema.set(i, null);
                if (!adjustParentsChildren) continue;
                colExprMap.put(column.getInternalName(), (ExprNodeDesc)newValues.get(index));
            }
        }
        HashMap<Byte, int[]> valueIndices = new HashMap<Byte, int[]>();
        HashMap<Byte, List<ExprNodeDesc>> keyExprMap = (HashMap<Byte, List<ExprNodeDesc>>)pair.getRight();
        if (!adjustParentsChildren) {
            newValueExprs = valueExprs;
            HashMap<Byte, List<ExprNodeDesc>> newKeyExprMap = new HashMap<Byte, List<ExprNodeDesc>>();
            for (Map.Entry entry : keyExprMap.entrySet()) {
                Byte pos = (Byte)entry.getKey();
                ReduceSinkOperator rsParent = (ReduceSinkOperator)oldReduceSinkParentOps.get(pos.byteValue());
                List<ExprNodeDesc> keyExprList = ExprNodeDescUtils.resolveJoinKeysAsRSColumns((List)entry.getValue(), rsParent);
                if (keyExprList == null) {
                    LOG.warn("Error resolving join keys {} in {} {}", new Object[]{entry.getValue(), rsParent, rsParent.getColumnExprMap()});
                    return null;
                }
                newKeyExprMap.put(pos, keyExprList);
            }
            keyExprMap = newKeyExprMap;
        }
        ArrayList<TableDesc> valueTableDescs = new ArrayList<TableDesc>();
        ArrayList<TableDesc> valueFilteredTableDescs = new ArrayList<TableDesc>();
        int[][] nArray = desc.getFilterMap();
        for (byte pos = 0; pos < op.getParentOperators().size(); pos = (byte)(pos + 1)) {
            ArrayList<ExprNodeDesc> valueCols = (ArrayList<ExprNodeDesc>)newValueExprs.get(pos);
            if (pos != mapJoinPos) {
                int[] valueIndex = new int[valueCols.size()];
                ArrayList<ExprNodeDesc> valueColsInValueExpr = new ArrayList<ExprNodeDesc>();
                for (int i = 0; i < valueIndex.length; ++i) {
                    ExprNodeDesc expr = (ExprNodeDesc)valueCols.get(i);
                    int kindex = ExprNodeDescUtils.indexOf(expr, (List)keyExprMap.get(pos));
                    if (kindex >= 0) {
                        valueIndex[i] = kindex;
                        continue;
                    }
                    valueIndex[i] = -valueColsInValueExpr.size() - 1;
                    valueColsInValueExpr.add(expr);
                }
                if (MapJoinProcessor.needValueIndex(valueIndex)) {
                    valueIndices.put(pos, valueIndex);
                }
                valueCols = valueColsInValueExpr;
            }
            Iterator<Map.Entry<Byte, List<ExprNodeDesc>>> valueFilteredCols = ExprNodeDescUtils.clone((List<ExprNodeDesc>)valueCols);
            if (nArray != null && nArray[pos] != null && pos != mapJoinPos) {
                ExprNodeColumnDesc isFilterDesc = new ExprNodeColumnDesc((TypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"smallint"), "filter", "filter", false);
                valueFilteredCols.add((Map.Entry<Byte, List<ExprNodeDesc>>)((Object)isFilterDesc));
            }
            TableDesc valueTableDesc = PlanUtils.getMapJoinValueTableDesc(PlanUtils.getFieldSchemasFromColumnList((List<ExprNodeDesc>)valueCols, "mapjoinvalue"));
            TableDesc valueFilteredTableDesc = PlanUtils.getMapJoinValueTableDesc(PlanUtils.getFieldSchemasFromColumnList(valueFilteredCols, "mapjoinvalue"));
            valueTableDescs.add(valueTableDesc);
            valueFilteredTableDescs.add(valueFilteredTableDesc);
        }
        Map<Byte, List<ExprNodeDesc>> filters = desc.getFilters();
        if (adjustParentsChildren) {
            HashMap<Byte, List<ExprNodeDesc>> newFilters = new HashMap<Byte, List<ExprNodeDesc>>();
            for (Map.Entry<Byte, List<ExprNodeDesc>> entry : filters.entrySet()) {
                byte srcTag = entry.getKey();
                List<ExprNodeDesc> filter = entry.getValue();
                Operator terminal = (Operator)oldReduceSinkParentOps.get(srcTag);
                newFilters.put(srcTag, ExprNodeDescUtils.backtrack(filter, op, terminal));
            }
            filters = newFilters;
            desc.setFilters(filters);
        }
        Object dumpFilePrefix = "";
        if (mapAliases != null) {
            for (String mapAlias : mapAliases) {
                dumpFilePrefix = (String)dumpFilePrefix + mapAlias;
            }
            dumpFilePrefix = (String)dumpFilePrefix + "-" + PlanUtils.getCountForMapJoinDumpFilePrefix();
        } else {
            dumpFilePrefix = "mapfile" + PlanUtils.getCountForMapJoinDumpFilePrefix();
        }
        List keyCols = (List)keyExprMap.get((byte)mapJoinPos);
        if (keyCols == null) {
            return null;
        }
        List<String> outputColumnNames = ((JoinDesc)op.getConf()).getOutputColumnNames();
        TableDesc keyTableDesc = PlanUtils.getMapJoinKeyTableDesc((Configuration)hconf, PlanUtils.getFieldSchemasFromColumnList(keyCols, MAPJOINKEY_FIELDPREFIX));
        JoinCondDesc[] joinCondns = ((JoinDesc)op.getConf()).getConds();
        MapJoinDesc mapJoinDescriptor = new MapJoinDesc(keyExprMap, keyTableDesc, newValueExprs, valueTableDescs, valueFilteredTableDescs, outputColumnNames, mapJoinPos, joinCondns, filters, ((JoinDesc)op.getConf()).getNoOuterJoin(), (String)dumpFilePrefix, ((JoinDesc)op.getConf()).getMemoryMonitorInfo(), ((JoinDesc)op.getConf()).getInMemoryDataSize());
        mapJoinDescriptor.setStatistics(((JoinDesc)op.getConf()).getStatistics());
        mapJoinDescriptor.setTagOrder(tagOrder);
        mapJoinDescriptor.setNullSafes(desc.getNullSafes());
        mapJoinDescriptor.setFilterMap(desc.getFilterMap());
        mapJoinDescriptor.setResidualFilterExprs(desc.getResidualFilterExprs());
        mapJoinDescriptor.setColumnExprMap(colExprMap);
        if (!valueIndices.isEmpty()) {
            mapJoinDescriptor.setValueIndices(valueIndices);
        }
        return mapJoinDescriptor;
    }

    public static MapJoinDesc getMapJoinDesc(HiveConf hconf, JoinOperator op, boolean leftInputJoin, String[] baseSrc, List<String> mapAliases, int mapJoinPos, boolean noCheckOuterJoin) throws SemanticException {
        return MapJoinProcessor.getMapJoinDesc(hconf, op, leftInputJoin, baseSrc, mapAliases, mapJoinPos, noCheckOuterJoin, true);
    }

    public static class MapJoinWalkerCtx
    implements NodeProcessorCtx {
        private ParseContext pGraphContext;
        private List<AbstractMapJoinOperator<? extends MapJoinDesc>> listMapJoinsNoRed;
        private List<AbstractMapJoinOperator<? extends MapJoinDesc>> listRejectedMapJoins;
        private AbstractMapJoinOperator<? extends MapJoinDesc> currMapJoinOp;

        public MapJoinWalkerCtx(List<AbstractMapJoinOperator<? extends MapJoinDesc>> listMapJoinsNoRed, ParseContext pGraphContext) {
            this.listMapJoinsNoRed = listMapJoinsNoRed;
            this.currMapJoinOp = null;
            this.listRejectedMapJoins = new ArrayList<AbstractMapJoinOperator<? extends MapJoinDesc>>();
            this.pGraphContext = pGraphContext;
        }

        public List<AbstractMapJoinOperator<? extends MapJoinDesc>> getListMapJoinsNoRed() {
            return this.listMapJoinsNoRed;
        }

        public void setListMapJoins(List<AbstractMapJoinOperator<? extends MapJoinDesc>> listMapJoinsNoRed) {
            this.listMapJoinsNoRed = listMapJoinsNoRed;
        }

        public AbstractMapJoinOperator<? extends MapJoinDesc> getCurrMapJoinOp() {
            return this.currMapJoinOp;
        }

        public void setCurrMapJoinOp(AbstractMapJoinOperator<? extends MapJoinDesc> currMapJoinOp) {
            this.currMapJoinOp = currMapJoinOp;
        }

        public List<AbstractMapJoinOperator<? extends MapJoinDesc>> getListRejectedMapJoins() {
            return this.listRejectedMapJoins;
        }

        public void setListRejectedMapJoins(List<AbstractMapJoinOperator<? extends MapJoinDesc>> listRejectedMapJoins) {
            this.listRejectedMapJoins = listRejectedMapJoins;
        }

        public ParseContext getpGraphContext() {
            return this.pGraphContext;
        }

        public void setpGraphContext(ParseContext pGraphContext) {
            this.pGraphContext = pGraphContext;
        }
    }

    public static class MapJoinFS
    implements SemanticNodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            MapJoinWalkerCtx ctx = (MapJoinWalkerCtx)procCtx;
            AbstractMapJoinOperator<? extends MapJoinDesc> mapJoin = ctx.getCurrMapJoinOp();
            List<AbstractMapJoinOperator<? extends MapJoinDesc>> listRejectedMapJoins = ctx.getListRejectedMapJoins();
            if (listRejectedMapJoins != null && listRejectedMapJoins.contains(mapJoin)) {
                return null;
            }
            MapJoinProcessor.addNoReducerMapJoinToCtx(ctx, mapJoin);
            return null;
        }
    }

    public static class MapJoinDefault
    implements SemanticNodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            MapJoinWalkerCtx ctx = (MapJoinWalkerCtx)procCtx;
            AbstractMapJoinOperator<? extends MapJoinDesc> mapJoin = ctx.getCurrMapJoinOp();
            MapJoinProcessor.addRejectMapJoinToCtx(ctx, mapJoin);
            return null;
        }
    }

    public static class Default
    implements SemanticNodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            return null;
        }
    }

    public static class CurrentMapJoin
    implements SemanticNodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            MapJoinWalkerCtx ctx = (MapJoinWalkerCtx)procCtx;
            MapJoinOperator mapJoin = (MapJoinOperator)nd;
            if (ctx.getListRejectedMapJoins() != null && !ctx.getListRejectedMapJoins().contains(mapJoin)) {
                Boolean bigBranch = this.findGrandChildSubqueryMapjoin(ctx, mapJoin);
                if (bigBranch == null) {
                    ctx.setCurrMapJoinOp(mapJoin);
                    return null;
                }
                if (bigBranch.booleanValue()) {
                    MapJoinProcessor.addNoReducerMapJoinToCtx(ctx, mapJoin);
                } else {
                    MapJoinProcessor.addRejectMapJoinToCtx(ctx, mapJoin);
                }
            } else {
                ctx.setCurrMapJoinOp(mapJoin);
            }
            return null;
        }

        private Boolean findGrandChildSubqueryMapjoin(MapJoinWalkerCtx ctx, MapJoinOperator mapJoin) {
            Operator parent = mapJoin;
            while (parent.getChildOperators() != null && parent.getChildOperators().size() == 1) {
                Operator<OperatorDesc> ch = parent.getChildOperators().get(0);
                if (ch instanceof MapJoinOperator) {
                    if (!this.nonSubqueryMapJoin((MapJoinOperator)ch, mapJoin) && ch.getParentOperators().indexOf(parent) == ((MapJoinDesc)((MapJoinOperator)ch).getConf()).getPosBigTable()) {
                        return true;
                    }
                    return false;
                }
                if (ch instanceof JoinOperator || ch instanceof UnionOperator || ch instanceof ReduceSinkOperator || ch instanceof LateralViewJoinOperator || ch instanceof GroupByOperator || ch instanceof ScriptOperator) {
                    return null;
                }
                parent = ch;
            }
            return null;
        }

        private boolean nonSubqueryMapJoin(MapJoinOperator mapJoin, MapJoinOperator parentMapJoin) {
            return mapJoin.getParentOperators().contains(parentMapJoin);
        }
    }
}

