/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.common.ValidTxnWriteIdList;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.io.HdfsUtils;
import org.apache.hadoop.hive.metastore.ColumnType;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.PartFilterExprUtil;
import org.apache.hadoop.hive.metastore.PartitionDropOptions;
import org.apache.hadoop.hive.metastore.PartitionExpressionProxy;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.AggrStats;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.CreateTableRequest;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.DeleteColumnStatisticsRequest;
import org.apache.hadoop.hive.metastore.api.DropPartitionsExpr;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.ForeignKeysRequest;
import org.apache.hadoop.hive.metastore.api.ForeignKeysResponse;
import org.apache.hadoop.hive.metastore.api.GetPartitionNamesPsRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionNamesPsResponse;
import org.apache.hadoop.hive.metastore.api.GetPartitionRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionResponse;
import org.apache.hadoop.hive.metastore.api.GetPartitionsByNamesRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionsByNamesResult;
import org.apache.hadoop.hive.metastore.api.GetPartitionsPsWithAuthRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionsPsWithAuthResponse;
import org.apache.hadoop.hive.metastore.api.GetPartitionsRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionsResponse;
import org.apache.hadoop.hive.metastore.api.GetProjectionsSpec;
import org.apache.hadoop.hive.metastore.api.GetTableRequest;
import org.apache.hadoop.hive.metastore.api.GetValidWriteIdsRequest;
import org.apache.hadoop.hive.metastore.api.HiveObjectRef;
import org.apache.hadoop.hive.metastore.api.HiveObjectType;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.NotNullConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.NotNullConstraintsResponse;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionListComposingSpec;
import org.apache.hadoop.hive.metastore.api.PartitionSpec;
import org.apache.hadoop.hive.metastore.api.PartitionValuesRequest;
import org.apache.hadoop.hive.metastore.api.PartitionValuesResponse;
import org.apache.hadoop.hive.metastore.api.PartitionValuesRow;
import org.apache.hadoop.hive.metastore.api.PartitionsByExprRequest;
import org.apache.hadoop.hive.metastore.api.PartitionsRequest;
import org.apache.hadoop.hive.metastore.api.PartitionsResponse;
import org.apache.hadoop.hive.metastore.api.PartitionsStatsRequest;
import org.apache.hadoop.hive.metastore.api.PrimaryKeysRequest;
import org.apache.hadoop.hive.metastore.api.PrimaryKeysResponse;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.RequestPartsSpec;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLNotNullConstraint;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.SQLUniqueConstraint;
import org.apache.hadoop.hive.metastore.api.SetPartitionsStatsRequest;
import org.apache.hadoop.hive.metastore.api.TableMeta;
import org.apache.hadoop.hive.metastore.api.TableValidWriteIds;
import org.apache.hadoop.hive.metastore.api.UniqueConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.UniqueConstraintsResponse;
import org.apache.hadoop.hive.metastore.cache.CachedStore;
import org.apache.hadoop.hive.metastore.client.MetaStoreClientWrapper;
import org.apache.hadoop.hive.metastore.client.ThriftHiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.client.builder.PartitionBuilder;
import org.apache.hadoop.hive.metastore.client.utils.HiveMetaStoreClientUtils;
import org.apache.hadoop.hive.metastore.parser.ExpressionTree;
import org.apache.hadoop.hive.metastore.partition.spec.PartitionSpecProxy;
import org.apache.hadoop.hive.metastore.txn.TxnCommonUtils;
import org.apache.hadoop.hive.metastore.utils.FileUtils;
import org.apache.hadoop.hive.metastore.utils.MetaStoreServerUtils;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.utils.SecurityUtils;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.metadata.TempTable;
import org.apache.hadoop.hive.ql.metadata.client.MetaStoreClientCacheUtils;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.stats.StatsUtils;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionHiveMetaStoreClient
extends MetaStoreClientWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(SessionHiveMetaStoreClient.class);
    private volatile Warehouse wh = null;

    public static SessionHiveMetaStoreClient newClient(Configuration conf, IMetaStoreClient delegate) {
        return new SessionHiveMetaStoreClient(conf, delegate);
    }

    public SessionHiveMetaStoreClient(Configuration conf, IMetaStoreClient delegate) {
        super(delegate, conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Warehouse getWh() throws MetaException {
        if (this.wh == null) {
            SessionHiveMetaStoreClient sessionHiveMetaStoreClient = this;
            synchronized (sessionHiveMetaStoreClient) {
                if (this.wh == null) {
                    this.wh = new Warehouse(this.conf);
                }
            }
        }
        return this.wh;
    }

    private boolean isDefaultCatalog(String catName) {
        return catName == null || catName.isEmpty() || MetaStoreUtils.getDefaultCatalog((Configuration)this.conf).equals(catName);
    }

    public org.apache.hadoop.hive.metastore.api.Table getTable(GetTableRequest req) throws TException {
        org.apache.hadoop.hive.metastore.api.Table tempTable;
        if (this.isDefaultCatalog(req.getCatName()) && (tempTable = this.getTempTable(req.getDbName(), req.getTblName())) != null) {
            return HiveMetaStoreClientUtils.deepCopy((org.apache.hadoop.hive.metastore.api.Table)tempTable);
        }
        String[] processorCapabilities = ThriftHiveMetaStoreClient.getProcessorCapabilities();
        if (processorCapabilities != null) {
            req.setProcessorCapabilities(Arrays.asList(processorCapabilities));
        }
        req.setProcessorIdentifier(ThriftHiveMetaStoreClient.getProcessorIdentifier());
        Map<Object, Object> queryCache = this.getQueryCache();
        if (queryCache != null) {
            MetaStoreClientCacheUtils.CacheKey cacheKeyTableId = new MetaStoreClientCacheUtils.CacheKey(MetaStoreClientCacheUtils.KeyType.TABLE_ID, req.getCatName(), req.getDbName(), req.getTblName());
            long tableId = -1L;
            if (queryCache.containsKey(cacheKeyTableId)) {
                tableId = (Long)queryCache.get(cacheKeyTableId);
            }
            req.setId(tableId);
            MetaStoreClientCacheUtils.CacheKey cacheKey = new MetaStoreClientCacheUtils.CacheKey(MetaStoreClientCacheUtils.KeyType.TABLE, req);
            org.apache.hadoop.hive.metastore.api.Table table = (org.apache.hadoop.hive.metastore.api.Table)queryCache.get(cacheKey);
            if (table == null) {
                table = this.delegate.getTable(req);
                if (tableId == -1L) {
                    queryCache.put(cacheKeyTableId, table.getId());
                    req.setId(table.getId());
                    cacheKey = new MetaStoreClientCacheUtils.CacheKey(MetaStoreClientCacheUtils.KeyType.TABLE, req);
                }
                queryCache.put(cacheKey, table);
            }
            return table;
        }
        return this.delegate.getTable(req);
    }

    public List<String> getTables(String catName, String dbName, String tablePattern) throws TException {
        ArrayList tableNames = this.delegate.getTables(catName, dbName, tablePattern);
        if (this.isDefaultCatalog(catName)) {
            Map<String, Table> tables = SessionHiveMetaStoreClient.getTempTablesForDatabase(dbName = dbName.toLowerCase(), tablePattern = tablePattern.toLowerCase());
            if (tables == null || tables.size() == 0) {
                return tableNames;
            }
            tablePattern = tablePattern.replaceAll("(?<!\\.)\\*", ".*");
            Pattern pattern = Pattern.compile(tablePattern);
            Matcher matcher = pattern.matcher("");
            HashSet<String> combinedTableNames = new HashSet<String>();
            for (String tableName : tables.keySet()) {
                matcher.reset(tableName);
                if (!matcher.matches()) continue;
                combinedTableNames.add(tableName);
            }
            combinedTableNames.addAll(tableNames);
            tableNames = new ArrayList(combinedTableNames);
            Collections.sort(tableNames);
        }
        return tableNames;
    }

    public List<String> getTables(String catName, String dbname, String tablePattern, TableType tableType) throws TException {
        ArrayList tableNames = this.delegate.getTables(dbname, tablePattern, tableType);
        if (this.isDefaultCatalog(catName) && (tableType == TableType.MANAGED_TABLE || tableType == TableType.EXTERNAL_TABLE)) {
            Map<String, Table> tables = SessionHiveMetaStoreClient.getTempTablesForDatabase(dbname = dbname.toLowerCase(), tablePattern = tablePattern.toLowerCase());
            if (tables == null || tables.size() == 0) {
                return tableNames;
            }
            tablePattern = tablePattern.replaceAll("(?<!\\.)\\*", ".*");
            Pattern pattern = Pattern.compile(tablePattern);
            Matcher matcher = pattern.matcher("");
            HashSet combinedTableNames = new HashSet();
            combinedTableNames.addAll(tableNames);
            for (Map.Entry<String, Table> tableData : tables.entrySet()) {
                matcher.reset(tableData.getKey());
                if (!matcher.matches()) continue;
                if (tableData.getValue().getTableType() == tableType) {
                    combinedTableNames.add(tableData.getKey());
                    continue;
                }
                combinedTableNames.remove(tableData.getKey());
            }
            tableNames = new ArrayList(combinedTableNames);
            Collections.sort(tableNames);
        }
        return tableNames;
    }

    public List<org.apache.hadoop.hive.metastore.api.Table> getTables(String catName, String dbName, List<String> tableNames, GetProjectionsSpec projectionsSpec) throws TException {
        if (this.isDefaultCatalog(catName) && projectionsSpec == null) {
            ArrayList<org.apache.hadoop.hive.metastore.api.Table> tables = new ArrayList<org.apache.hadoop.hive.metastore.api.Table>();
            for (String tableName : tableNames) {
                tables.add(this.getTable(catName, dbName, tableName));
            }
            return tables;
        }
        return this.delegate.getTables(catName, dbName, tableNames, projectionsSpec);
    }

    public boolean tableExists(String catName, String dbName, String tableName) throws TException {
        org.apache.hadoop.hive.metastore.api.Table tempTable;
        if (this.isDefaultCatalog(catName) && (tempTable = this.getTempTable(dbName, tableName)) != null) {
            return true;
        }
        return this.delegate.tableExists(catName, dbName, tableName);
    }

    public List<FieldSchema> getSchema(String catName, String dbName, String tableName) throws TException {
        org.apache.hadoop.hive.metastore.api.Table tempTable;
        if (this.isDefaultCatalog(catName) && (tempTable = this.getTempTable(dbName, tableName)) != null) {
            return HiveMetaStoreClientUtils.deepCopyFieldSchemas((List)tempTable.getSd().getCols());
        }
        return this.delegate.getSchema(catName, dbName, tableName);
    }

    public List<ColumnStatisticsObj> getTableColumnStatistics(String catName, String dbName, String tableName, List<String> colNames, String engine, String validWriteIdList) throws TException {
        if (this.isDefaultCatalog(catName) && this.getTempTable(dbName, tableName) != null) {
            return this.getTempTableColumnStats(dbName, tableName, colNames);
        }
        Map<Object, Object> queryCache = this.getQueryCache();
        if (queryCache != null) {
            MapWrapper cache = new MapWrapper(queryCache);
            Pair<List<ColumnStatisticsObj>, List<String>> p = MetaStoreClientCacheUtils.getTableColumnStatisticsCache(cache, catName, dbName, tableName, colNames, engine, validWriteIdList, null);
            List colStatsMissing = (List)p.getRight();
            List colStats = (List)p.getLeft();
            if (colStatsMissing.isEmpty()) {
                return colStats;
            }
            List newColStats = this.delegate.getTableColumnStatistics(catName, dbName, tableName, colStatsMissing, engine, validWriteIdList);
            MetaStoreClientCacheUtils.loadTableColumnStatisticsCache(cache, newColStats, catName, dbName, tableName, engine, validWriteIdList, null);
            List<ColumnStatisticsObj> result = MetaStoreClientCacheUtils.computeTableColumnStatisticsFinal(colNames, colStats, newColStats);
            return result;
        }
        return this.delegate.getTableColumnStatistics(catName, dbName, tableName, colNames, engine, validWriteIdList);
    }

    public List<Partition> listPartitionsWithAuthInfo(String catName, String dbName, String tableName, List<String> partialPvals, int maxParts, String userName, List<String> groupNames) throws TException {
        org.apache.hadoop.hive.metastore.api.Table tmpTable;
        if (this.isDefaultCatalog(catName) && (tmpTable = this.getTempTable(dbName, tableName)) != null) {
            TempTable tt = this.getPartitionedTempTable(tmpTable);
            List<Partition> parts = tt.listPartitionsByPartitionValsWithAuthInfo(partialPvals, userName, groupNames);
            return this.getPartitionsForMaxParts(parts, maxParts);
        }
        Map<Object, Object> queryCache = this.getQueryCache();
        if (queryCache != null) {
            MetaStoreClientCacheUtils.CacheKey cacheKey = new MetaStoreClientCacheUtils.CacheKey(MetaStoreClientCacheUtils.KeyType.LIST_PARTITIONS_AUTH_INFO, catName, dbName, tableName, partialPvals, maxParts, userName, groupNames);
            List v = (List)queryCache.get(cacheKey);
            if (v == null) {
                v = this.delegate.listPartitionsWithAuthInfo(catName, dbName, tableName, partialPvals, maxParts, userName, groupNames);
                queryCache.put(cacheKey, v);
            } else {
                LOG.debug("Query level HMS cache: method=listPartitionsWithAuthInfoInternal, dbName={}, tblName={}, partVals={}", new Object[]{dbName, tableName, partialPvals});
            }
            return v;
        }
        return this.delegate.listPartitionsWithAuthInfo(catName, dbName, tableName, partialPvals, maxParts, userName, groupNames);
    }

    public List<Partition> listPartitionsWithAuthInfo(String catName, String dbName, String tableName, int maxParts, String userName, List<String> groupNames) throws TException {
        org.apache.hadoop.hive.metastore.api.Table tmpTable;
        if (this.isDefaultCatalog(catName) && (tmpTable = this.getTempTable(dbName, tableName)) != null) {
            TempTable tt = this.getPartitionedTempTable(tmpTable);
            List<Partition> parts = tt.listPartitionsWithAuthInfo(userName, groupNames);
            return this.getPartitionsForMaxParts(parts, maxParts);
        }
        Map<Object, Object> queryCache = this.getQueryCache();
        if (queryCache != null) {
            MetaStoreClientCacheUtils.CacheKey cacheKey = new MetaStoreClientCacheUtils.CacheKey(MetaStoreClientCacheUtils.KeyType.LIST_PARTITIONS_AUTH_INFO_ALL, catName, dbName, tableName, maxParts, userName, groupNames);
            List v = (List)queryCache.get(cacheKey);
            if (v == null) {
                v = this.delegate.listPartitionsWithAuthInfo(catName, dbName, tableName, maxParts, userName, groupNames);
                queryCache.put(cacheKey, v);
            } else {
                LOG.debug("Query level HMS cache: method=listPartitionsWithAuthInfoInternalAll, dbName={}, tblName={}", (Object)dbName, (Object)tableName);
            }
            return v;
        }
        return this.delegate.listPartitionsWithAuthInfo(catName, dbName, tableName, maxParts, userName, groupNames);
    }

    public GetPartitionsPsWithAuthResponse listPartitionsWithAuthInfoRequest(GetPartitionsPsWithAuthRequest req) throws TException {
        org.apache.hadoop.hive.metastore.api.Table tmpTable;
        if (this.isDefaultCatalog(req.getCatName()) && (tmpTable = this.getTempTable(req.getDbName(), req.getTblName())) != null) {
            TempTable tt = this.getPartitionedTempTable(tmpTable);
            List<Partition> partitions = tt.listPartitionsWithAuthInfo(req.getUserName(), req.getGroupNames());
            GetPartitionsPsWithAuthResponse response = new GetPartitionsPsWithAuthResponse();
            response.setPartitions(this.getPartitionsForMaxParts(partitions, req.getMaxParts()));
            return response;
        }
        if (req.getValidWriteIdList() == null) {
            req.setValidWriteIdList(this.getValidWriteIdList(req.getDbName(), req.getTblName()));
        }
        req.setMaxParts(HiveMetaStoreClientUtils.shrinkMaxtoShort((int)req.getMaxParts()));
        Map<Object, Object> queryCache = this.getQueryCache();
        if (queryCache != null) {
            MetaStoreClientCacheUtils.CacheKey cacheKey = new MetaStoreClientCacheUtils.CacheKey(MetaStoreClientCacheUtils.KeyType.LIST_PARTITIONS_AUTH_INFO_REQ, req);
            GetPartitionsPsWithAuthResponse v = (GetPartitionsPsWithAuthResponse)queryCache.get(cacheKey);
            if (v == null) {
                v = this.delegate.listPartitionsWithAuthInfoRequest(req);
                queryCache.put(cacheKey, v);
            } else {
                LOG.debug("Query level HMS cache: method=listPartitionsWithAuthInfoRequestInternal, dbName={}, tblName={}, partVals={}", new Object[]{req.getDbName(), req.getTblName(), req.getPartVals()});
            }
            return v;
        }
        return this.delegate.listPartitionsWithAuthInfoRequest(req);
    }

    public List<String> listPartitionNames(String catName, String dbName, String tableName, int maxParts) throws TException {
        org.apache.hadoop.hive.metastore.api.Table tmpTable;
        if (this.isDefaultCatalog(catName) && (tmpTable = this.getTempTable(dbName, tableName)) != null) {
            TempTable tt = this.getPartitionedTempTable(tmpTable);
            List<Partition> partitions = tt.listPartitions();
            ArrayList<String> result = new ArrayList<String>();
            int lastIndex = maxParts < 0 || maxParts > partitions.size() ? partitions.size() : maxParts;
            for (int i = 0; i < lastIndex; ++i) {
                result.add(Warehouse.makePartName((List)tmpTable.getPartitionKeys(), (List)partitions.get(i).getValues()));
            }
            Collections.sort(result);
            return result;
        }
        Map<Object, Object> queryCache = this.getQueryCache();
        if (queryCache != null) {
            MetaStoreClientCacheUtils.CacheKey cacheKey = new MetaStoreClientCacheUtils.CacheKey(MetaStoreClientCacheUtils.KeyType.LIST_PARTITIONS_ALL, catName, dbName, tableName, maxParts);
            List v = (List)queryCache.get(cacheKey);
            if (v == null) {
                v = this.delegate.listPartitionNames(catName, dbName, tableName, maxParts);
                queryCache.put(cacheKey, v);
            } else {
                LOG.debug("Query level HMS cache: method=listPartitionNamesInternalAll, dbName={}, tableName={}", (Object)dbName, (Object)tableName);
            }
            return v;
        }
        return this.delegate.listPartitionNames(catName, dbName, tableName, maxParts);
    }

    public GetPartitionNamesPsResponse listPartitionNamesRequest(GetPartitionNamesPsRequest req) throws TException {
        Map<Object, Object> queryCache;
        org.apache.hadoop.hive.metastore.api.Table tmpTable;
        if (this.isDefaultCatalog(req.getCatName()) && (tmpTable = this.getTempTable(req.getDbName(), req.getTblName())) != null) {
            TempTable tt = this.getPartitionedTempTable(tmpTable);
            List<Partition> partitions = tt.getPartitionsByPartitionVals(req.getPartValues());
            short maxParts = req.getMaxParts();
            int lastIndex = maxParts < 0 || maxParts > partitions.size() ? partitions.size() : (int)maxParts;
            ArrayList<String> result = new ArrayList<String>();
            for (int i = 0; i < lastIndex; ++i) {
                result.add(Warehouse.makePartName((List)tmpTable.getPartitionKeys(), (List)partitions.get(i).getValues()));
            }
            Collections.sort(result);
            GetPartitionNamesPsResponse response = new GetPartitionNamesPsResponse();
            response.setNames(result);
            return response;
        }
        if (req.getValidWriteIdList() == null) {
            req.setValidWriteIdList(this.getValidWriteIdList(req.getDbName(), req.getTblName()));
        }
        if ((queryCache = this.getQueryCache()) != null) {
            MetaStoreClientCacheUtils.CacheKey cacheKey = new MetaStoreClientCacheUtils.CacheKey(MetaStoreClientCacheUtils.KeyType.LIST_PARTITIONS_REQ, req);
            GetPartitionNamesPsResponse v = (GetPartitionNamesPsResponse)queryCache.get(cacheKey);
            if (v == null) {
                v = this.delegate.listPartitionNamesRequest(req);
                queryCache.put(cacheKey, v);
            } else {
                LOG.debug("Query level HMS cache: method=listPartitionNamesRequestInternal, dbName={}, tblName={}, partValues={}", new Object[]{req.getDbName(), req.getTblName(), req.getPartValues()});
            }
            return v;
        }
        return this.delegate.listPartitionNamesRequest(req);
    }

    public boolean listPartitionsByExpr(PartitionsByExprRequest req, List<Partition> result) throws TException {
        Map<Object, Object> queryCache;
        org.apache.hadoop.hive.metastore.api.Table tmpTable;
        if (this.isDefaultCatalog(req.getCatName()) && (tmpTable = this.getTempTable(req.getDbName(), req.getTblName())) != null) {
            assert (result != null);
            result.addAll(this.getPartitionsForMaxParts(this.getPartitionedTempTable(tmpTable).listPartitionsByFilter(this.generateJDOFilter(tmpTable, req.getExpr(), req.getDefaultPartitionName())), req.getMaxParts()));
            return result.isEmpty();
        }
        if (!req.isSetValidWriteIdList()) {
            req.setValidWriteIdList(this.getValidWriteIdList(req.getDbName(), req.getTblName()));
        }
        if ((queryCache = this.getQueryCache()) != null) {
            MetaStoreClientCacheUtils.CacheKey cacheKey = new MetaStoreClientCacheUtils.CacheKey(MetaStoreClientCacheUtils.KeyType.PARTITIONS_BY_EXPR, req);
            MetaStoreClientCacheUtils.PartitionsWrapper v = (MetaStoreClientCacheUtils.PartitionsWrapper)queryCache.get(cacheKey);
            if (v == null) {
                ArrayList<Partition> parts = new ArrayList<Partition>();
                boolean hasUnknownPart = this.delegate.listPartitionsByExpr(req, parts);
                v = new MetaStoreClientCacheUtils.PartitionsWrapper(parts, hasUnknownPart);
                queryCache.put(cacheKey, v);
            } else {
                LOG.debug("Query level HMS cache: method=getPartitionsByExprInternal, dbName={}, tblName={}", (Object)req.getDbName(), (Object)req.getTblName());
            }
            result.addAll(v.partitions);
            return v.hasUnknownPartition;
        }
        return this.delegate.listPartitionsByExpr(req, result);
    }

    public boolean listPartitionsSpecByExpr(PartitionsByExprRequest req, List<PartitionSpec> result) throws TException {
        Map<Object, Object> queryCache;
        org.apache.hadoop.hive.metastore.api.Table tmpTable;
        if (this.isDefaultCatalog(req.getCatName()) && (tmpTable = this.getTempTable(req.getDbName(), req.getTblName())) != null) {
            assert (result != null);
            result.addAll(MetaStoreServerUtils.getPartitionspecsGroupedByStorageDescriptor((org.apache.hadoop.hive.metastore.api.Table)tmpTable, this.getPartitionsForMaxParts(this.getPartitionedTempTable(tmpTable).listPartitionsByFilter(this.generateJDOFilter(tmpTable, req.getExpr(), req.getDefaultPartitionName())), req.getMaxParts())));
            return result.isEmpty();
        }
        if (!req.isSetValidWriteIdList()) {
            req.setValidWriteIdList(this.getValidWriteIdList(req.getDbName(), req.getTblName()));
        }
        if ((queryCache = this.getQueryCache()) != null) {
            MetaStoreClientCacheUtils.CacheKey cacheKey = new MetaStoreClientCacheUtils.CacheKey(MetaStoreClientCacheUtils.KeyType.PARTITIONS_SPEC_BY_EXPR, req);
            MetaStoreClientCacheUtils.PartitionSpecsWrapper v = (MetaStoreClientCacheUtils.PartitionSpecsWrapper)queryCache.get(cacheKey);
            if (v == null) {
                ArrayList<PartitionSpec> parts = new ArrayList<PartitionSpec>();
                boolean hasUnknownPart = this.delegate.listPartitionsSpecByExpr(req, parts);
                v = new MetaStoreClientCacheUtils.PartitionSpecsWrapper(parts, hasUnknownPart);
                queryCache.put(cacheKey, v);
            } else {
                LOG.debug("Query level HMS cache: method=getPartitionsSpecByExprInternal, dbName={}, tblName={}", (Object)req.getDbName(), (Object)req.getTblName());
            }
            result.addAll(v.partitionSpecs);
            return v.hasUnknownPartition;
        }
        return this.delegate.listPartitionsSpecByExpr(req, result);
    }

    public GetPartitionsByNamesResult getPartitionsByNames(GetPartitionsByNamesRequest req) throws TException {
        org.apache.hadoop.hive.metastore.api.Table tmpTable;
        String[] parsedNames = MetaStoreUtils.parseDbName((String)req.getDb_name(), (Configuration)this.conf);
        if (this.isDefaultCatalog(parsedNames[0]) && (tmpTable = this.getTempTable(req.getDb_name(), req.getTbl_name())) != null) {
            TempTable tt = this.getPartitionedTempTable(tmpTable);
            GetPartitionsByNamesResult result = new GetPartitionsByNamesResult();
            result.setPartitions(HiveMetaStoreClientUtils.deepCopyPartitions(tt.getPartitionsByNames(req.getNames())));
            return result;
        }
        Map<Object, Object> queryCache = this.getQueryCache();
        if (queryCache != null) {
            MapWrapper cache = new MapWrapper(queryCache);
            Pair<List<Partition>, List<String>> p = MetaStoreClientCacheUtils.getPartitionsByNamesCache(cache, req, null);
            List partitionsMissing = (List)p.getRight();
            List partitions = (List)p.getLeft();
            if (partitionsMissing.isEmpty()) {
                return new GetPartitionsByNamesResult(partitions);
            }
            GetPartitionsByNamesRequest newRqst = new GetPartitionsByNamesRequest(req);
            newRqst.setNames(partitionsMissing);
            GetPartitionsByNamesResult r = this.delegate.getPartitionsByNames(newRqst);
            List<Partition> newPartitions = MetaStoreClientCacheUtils.loadPartitionsByNamesCache(cache, r, req, null);
            return MetaStoreClientCacheUtils.computePartitionsByNamesFinal(req, partitions, newPartitions);
        }
        return this.delegate.getPartitionsByNames(req);
    }

    public void createTable(CreateTableRequest request) throws TException {
        org.apache.hadoop.hive.metastore.api.Table tbl = request.getTable();
        if (tbl.isTemporary()) {
            this.createTempTable(tbl);
        } else {
            this.delegate.createTable(request);
        }
    }

    /*
     * WARNING - void declaration
     */
    public List<TableMeta> getTableMeta(String catName, String dbPatterns, String tablePatterns, List<String> tableTypes) throws TException {
        List tableMetas = this.delegate.getTableMeta(dbPatterns, tablePatterns, tableTypes);
        if (this.isDefaultCatalog(catName)) {
            void var10_12;
            Map<String, Map<String, Table>> tmpTables = SessionHiveMetaStoreClient.getTempTables("dbPatterns='" + dbPatterns + "' tablePatterns='" + tablePatterns + "'");
            if (tmpTables.isEmpty()) {
                return tableMetas;
            }
            ArrayList<Matcher> dbPatternList = new ArrayList<Matcher>();
            String[] stringArray = dbPatterns.split("\\|");
            int n = stringArray.length;
            boolean bl = false;
            while (var10_12 < n) {
                String element = stringArray[var10_12];
                dbPatternList.add(Pattern.compile(element.replace("*", ".*")).matcher(""));
                ++var10_12;
            }
            ArrayList<Matcher> tblPatternList = new ArrayList<Matcher>();
            for (String element : tablePatterns.split("\\|")) {
                tblPatternList.add(Pattern.compile(element.replace("*", ".*")).matcher(""));
            }
            for (Map.Entry entry : tmpTables.entrySet()) {
                if (!this.matchesAny((String)entry.getKey(), dbPatternList)) continue;
                for (Map.Entry inner : ((Map)entry.getValue()).entrySet()) {
                    Table table = (Table)inner.getValue();
                    String tableName = table.getTableName();
                    String typeString = table.getTableType().name();
                    if (tableTypes != null && !tableTypes.contains(typeString) || !this.matchesAny((String)inner.getKey(), tblPatternList)) continue;
                    TableMeta tableMeta = new TableMeta(table.getDbName(), tableName, typeString);
                    tableMeta.setComments(table.getProperty("comment"));
                    tableMetas.add(tableMeta);
                }
            }
        }
        return tableMetas;
    }

    private boolean matchesAny(String string, List<Matcher> matchers) {
        for (Matcher matcher : matchers) {
            if (!matcher.reset(string).matches()) continue;
            return true;
        }
        return matchers.isEmpty();
    }

    public List<String> getAllTables(String catName, String dbName) throws TException {
        Map<String, Table> tables;
        ArrayList tableNames = this.delegate.getAllTables(catName, dbName);
        if (this.isDefaultCatalog(catName) && (tables = SessionHiveMetaStoreClient.getTempTablesForDatabase(dbName, "?")) != null && tables.size() != 0) {
            Set<String> tempTableNames = tables.keySet();
            HashSet allTableNames = new HashSet(tableNames.size() + tempTableNames.size());
            allTableNames.addAll(tableNames);
            allTableNames.addAll(tempTableNames);
            tableNames = new ArrayList(allTableNames);
            Collections.sort(tableNames);
        }
        return tableNames;
    }

    public void dropTable(org.apache.hadoop.hive.metastore.api.Table table, boolean deleteData, boolean ignoreUnknownTable, boolean ifPurge) throws TException {
        if (table.isTemporary()) {
            this.dropTempTable(table, deleteData, ifPurge);
        } else {
            this.delegate.dropTable(table, deleteData, ignoreUnknownTable, ifPurge);
        }
    }

    public void truncateTable(String catName, String dbName, String tableName, String ref, List<String> partNames, String validWriteIds, long writeId, boolean deleteData, EnvironmentContext context) throws TException {
        org.apache.hadoop.hive.metastore.api.Table table;
        if (this.isDefaultCatalog(catName) && (table = this.getTempTable(dbName, tableName)) != null) {
            this.truncateTempTable(table);
            return;
        }
        this.delegate.truncateTable(catName, dbName, tableName, ref, partNames, validWriteIds, writeId, deleteData, context);
    }

    public void alter_table(String catName, String dbName, String tbl_name, org.apache.hadoop.hive.metastore.api.Table new_tbl, EnvironmentContext envContext, String validWriteIds) throws TException {
        org.apache.hadoop.hive.metastore.api.Table old_tbl;
        if (this.isDefaultCatalog(catName) && (old_tbl = this.getTempTable(dbName, tbl_name)) != null) {
            this.alterTempTable(dbName, tbl_name, old_tbl, new_tbl);
            return;
        }
        this.delegate.alter_table(catName, dbName, tbl_name, new_tbl, envContext, validWriteIds);
    }

    public PrincipalPrivilegeSet get_privilege_set(HiveObjectRef hiveObject, String userName, List<String> groupNames) throws TException {
        org.apache.hadoop.hive.metastore.api.Table table;
        if (hiveObject.getObjectType() == HiveObjectType.TABLE && this.isDefaultCatalog(hiveObject.getCatName()) && (table = this.getTempTable(hiveObject.getDbName(), hiveObject.getObjectName())) != null) {
            return HiveMetaStoreClientUtils.deepCopy((PrincipalPrivilegeSet)table.getPrivileges());
        }
        return this.delegate.get_privilege_set(hiveObject, userName, groupNames);
    }

    public boolean setPartitionColumnStatistics(SetPartitionsStatsRequest request) throws TException {
        String tableName;
        ColumnStatistics colStats;
        ColumnStatisticsDesc desc;
        String dbName;
        if (request.getColStatsSize() == 1 && this.getTempTable(dbName = (desc = (colStats = (ColumnStatistics)request.getColStatsIterator().next()).getStatsDesc()).getDbName().toLowerCase(), tableName = desc.getTableName().toLowerCase()) != null) {
            return this.updateTempTableColumnStats(dbName, tableName, colStats);
        }
        return this.delegate.setPartitionColumnStatistics(request);
    }

    public boolean deleteColumnStatistics(DeleteColumnStatisticsRequest req) throws TException {
        String tableName;
        String dbName;
        org.apache.hadoop.hive.metastore.api.Table table;
        if (this.isDefaultCatalog(req.getCat_name()) && (table = this.getTempTable(dbName = req.getDb_name(), tableName = req.getTbl_name())) != null) {
            List colNames = req.getCol_names();
            if (table.getPartitionKeysSize() == 0) {
                if (colNames == null || colNames.isEmpty()) {
                    colNames = table.getSd().getCols().stream().map(FieldSchema::getName).collect(Collectors.toList());
                }
                for (String colName : colNames) {
                    this.deleteTempTableColumnStats(dbName, tableName, colName);
                }
            } else {
                throw new UnsupportedOperationException("Not implemented yet");
            }
            return true;
        }
        return this.delegate.deleteColumnStatistics(req);
    }

    private void createTempTable(org.apache.hadoop.hive.metastore.api.Table tbl) throws TException {
        Path tblPath;
        String tblName;
        boolean isVirtualTable = tbl.getTableName().startsWith("Values__Tmp__Table__");
        SessionState ss = SessionState.get();
        if (ss == null) {
            throw new MetaException("No current SessionState, cannot create temporary table: " + Warehouse.getQualifiedName((org.apache.hadoop.hive.metastore.api.Table)tbl));
        }
        String dbName = (tbl = this.deepCopyAndLowerCaseTable(tbl)).getDbName();
        Map<String, Table> tables = SessionHiveMetaStoreClient.getTempTablesForDatabase(dbName, tblName = tbl.getTableName());
        if (tables != null && tables.containsKey(tblName)) {
            throw new MetaException("Temporary table " + StatsUtils.getFullyQualifiedTableName(dbName, tblName) + " already exists");
        }
        Warehouse wh = this.getWh();
        if (tbl.getSd().getLocation() == null) {
            tbl.getSd().setLocation(SessionState.generateTempTableLocation(this.conf));
        }
        if ((tblPath = wh.getDnsPath(new Path(tbl.getSd().getLocation()))) == null) {
            throw new MetaException("Temp table path not set for " + tbl.getTableName());
        }
        if (!wh.isDir(tblPath) && !wh.mkdirs(tblPath)) {
            throw new MetaException(String.valueOf(tblPath) + " is not a directory or unable to create one");
        }
        tbl.getSd().setLocation(tblPath.toString());
        Table tTable = new Table(tbl);
        if (!isVirtualTable) {
            StatsSetupConst.setStatsStateForCreateTable((Map)tbl.getParameters(), (List)MetaStoreUtils.getColumnNamesForTable((org.apache.hadoop.hive.metastore.api.Table)tbl), (String)"true");
        }
        if (tables == null) {
            tables = new HashMap<String, Table>();
            ss.getTempTables().put(dbName, tables);
        }
        tables.put(tblName, tTable);
        this.createPartitionedTempTable(tbl);
    }

    private org.apache.hadoop.hive.metastore.api.Table getTempTable(String dbName, String tableName) throws MetaException {
        Table table;
        String parsedDbName = MetaStoreUtils.parseDbName((String)dbName, (Configuration)this.conf)[1];
        if (parsedDbName == null) {
            throw new MetaException("Db name cannot be null");
        }
        if (tableName == null) {
            throw new MetaException("Table name cannot be null");
        }
        Map<String, Table> tables = SessionHiveMetaStoreClient.getTempTablesForDatabase(parsedDbName.toLowerCase(), tableName.toLowerCase());
        if (tables != null && (table = tables.get(tableName.toLowerCase())) != null) {
            return table.getTTable();
        }
        return null;
    }

    private void alterTempTable(String dbname, String tbl_name, org.apache.hadoop.hive.metastore.api.Table oldt, org.apache.hadoop.hive.metastore.api.Table newt) throws TException {
        dbname = dbname.toLowerCase();
        tbl_name = tbl_name.toLowerCase();
        boolean shouldDeleteColStats = false;
        if (!newt.getSd().getLocation().equals(oldt.getSd().getLocation())) {
            throw new MetaException("Temp table location cannot be changed");
        }
        org.apache.hadoop.hive.metastore.api.Table newtCopy = this.deepCopyAndLowerCaseTable(newt);
        Table newTable = new Table(newtCopy);
        String newDbName = newTable.getDbName();
        String newTableName = newTable.getTableName();
        if (!newDbName.equals(oldt.getDbName()) || !newTableName.equals(oldt.getTableName())) {
            if (this.getTempTable(newDbName, newTableName) != null) {
                throw new MetaException("Cannot rename temporary table to " + newTableName + " - temporary table already exists with the same name");
            }
            Map<String, Table> tables = SessionHiveMetaStoreClient.getTempTablesForDatabase(dbname, tbl_name);
            if (tables == null || tables.remove(tbl_name) == null) {
                throw new MetaException("Could not find temp table entry for " + dbname + "." + tbl_name);
            }
            shouldDeleteColStats = true;
            tables = SessionHiveMetaStoreClient.getTempTablesForDatabase(newDbName, tbl_name);
            if (tables == null) {
                tables = new HashMap<String, Table>();
                SessionState.get().getTempTables().put(newDbName, tables);
            }
            tables.put(newTableName, newTable);
        } else {
            if (SessionHiveMetaStoreClient.haveTableColumnsChanged(oldt, newt)) {
                shouldDeleteColStats = true;
            }
            SessionHiveMetaStoreClient.getTempTablesForDatabase(dbname, tbl_name).put(tbl_name, newTable);
        }
        if (shouldDeleteColStats) {
            try {
                this.deleteTempTableColumnStatsForTable(dbname, tbl_name);
            }
            catch (NoSuchObjectException err) {
                LOG.info(err.getMessage());
            }
        }
    }

    private static boolean haveTableColumnsChanged(org.apache.hadoop.hive.metastore.api.Table oldt, org.apache.hadoop.hive.metastore.api.Table newt) {
        List oldCols = oldt.getSd().getCols();
        List newCols = newt.getSd().getCols();
        if (oldCols.size() != newCols.size()) {
            return true;
        }
        Iterator oldColsIter = oldCols.iterator();
        Iterator newColsIter = newCols.iterator();
        while (oldColsIter.hasNext()) {
            if (SessionHiveMetaStoreClient.fieldSchemaEqualsIgnoreComment((FieldSchema)oldColsIter.next(), (FieldSchema)newColsIter.next())) continue;
            return true;
        }
        return false;
    }

    private static boolean fieldSchemaEqualsIgnoreComment(FieldSchema left, FieldSchema right) {
        if (!left.getName().equals(right.getName())) {
            return true;
        }
        return !left.getType().equals(right.getType());
    }

    private boolean needToUpdateStats(Map<String, String> props) {
        if (null == props) {
            return false;
        }
        boolean statsPresent = false;
        for (String stat : StatsSetupConst.SUPPORTED_STATS) {
            String statVal = props.get(stat);
            if (statVal == null || Long.parseLong(statVal) <= 0L) continue;
            statsPresent = true;
            props.put(stat, "0");
        }
        StatsSetupConst.setBasicStatsState(props, (String)"true");
        StatsSetupConst.clearColumnStatsState(props);
        return statsPresent;
    }

    private void truncateTempTable(org.apache.hadoop.hive.metastore.api.Table table) throws TException {
        boolean isSkipTrash = MetaStoreUtils.isSkipTrash((Map)table.getParameters());
        try {
            Path location = new Path(table.getSd().getLocation());
            FileSystem fs = location.getFileSystem(this.conf);
            HadoopShims.HdfsEncryptionShim shim = ShimLoader.getHadoopShims().createHdfsEncryptionShim(fs, this.conf);
            if (!shim.isPathEncrypted(location)) {
                HdfsUtils.HadoopFileStatus status = HdfsUtils.HadoopFileStatus.createInstance((Configuration)this.conf, (FileSystem)fs, (Path)location);
                FileStatus targetStatus = fs.getFileStatus(location);
                String targetGroup = targetStatus == null ? null : targetStatus.getGroup();
                FileUtils.deleteDir((FileSystem)fs, (Path)location, (boolean)isSkipTrash, (Configuration)this.conf);
                fs.mkdirs(location);
                HdfsUtils.setFullFileStatus((Configuration)this.conf, (HdfsUtils.HadoopFileStatus)status, (String)targetGroup, (FileSystem)fs, (Path)location, (boolean)false);
            } else {
                boolean success;
                FileStatus[] statuses = fs.listStatus(location, org.apache.hadoop.hive.common.FileUtils.HIDDEN_FILES_PATH_FILTER);
                if (statuses != null && statuses.length > 0 && !(success = Hive.trashFiles(fs, statuses, this.conf, isSkipTrash))) {
                    throw new HiveException("Error in deleting the contents of " + location.toString());
                }
            }
            if (this.needToUpdateStats(table.getParameters())) {
                this.alterTempTable(table.getDbName(), table.getTableName(), table, table);
            }
        }
        catch (Exception e) {
            throw new MetaException(e.getMessage());
        }
    }

    private void dropTempTable(org.apache.hadoop.hive.metastore.api.Table table, boolean deleteData, boolean ifPurge) throws TException, UnsupportedOperationException {
        Map<String, Table> tables;
        try {
            this.deleteTempTableColumnStatsForTable(table.getDbName(), table.getTableName());
        }
        catch (NoSuchObjectException err) {
            LOG.info(err.getMessage());
        }
        String dbName = table.getDbName().toLowerCase();
        String tableName = table.getTableName().toLowerCase();
        Path tablePath = null;
        String pathStr = table.getSd().getLocation();
        if (pathStr != null) {
            try {
                tablePath = new Path(table.getSd().getLocation());
                if (deleteData && !MetaStoreUtils.isExternalTable((org.apache.hadoop.hive.metastore.api.Table)table) && !this.getWh().isWritable(tablePath.getParent())) {
                    throw new MetaException("Table metadata not deleted since " + String.valueOf(tablePath.getParent()) + " is not writable by " + SecurityUtils.getUser());
                }
            }
            catch (IOException err) {
                MetaException metaException = new MetaException("Error checking temp table path for " + table.getTableName());
                metaException.initCause((Throwable)err);
                throw metaException;
            }
        }
        if ((tables = SessionHiveMetaStoreClient.getTempTablesForDatabase(dbName, tableName)) == null || tables.remove(tableName) == null) {
            throw new MetaException("Could not find temp table entry for " + StatsUtils.getFullyQualifiedTableName(dbName, tableName));
        }
        this.removePartitionedTempTable(table);
        if (deleteData && !MetaStoreUtils.isExternalTable((org.apache.hadoop.hive.metastore.api.Table)table)) {
            try {
                this.getWh().deleteDir(tablePath, ifPurge, false);
            }
            catch (Exception err) {
                LOG.error("Failed to delete temp table directory: " + String.valueOf(tablePath), (Throwable)err);
            }
        }
    }

    private org.apache.hadoop.hive.metastore.api.Table deepCopyAndLowerCaseTable(org.apache.hadoop.hive.metastore.api.Table tbl) {
        org.apache.hadoop.hive.metastore.api.Table newCopy = HiveMetaStoreClientUtils.deepCopy((org.apache.hadoop.hive.metastore.api.Table)tbl);
        newCopy.setDbName(newCopy.getDbName().toLowerCase());
        newCopy.setTableName(newCopy.getTableName().toLowerCase());
        return newCopy;
    }

    public static Map<String, Table> getTempTablesForDatabase(String dbName, String tblName) {
        return SessionHiveMetaStoreClient.getTempTables(Warehouse.getQualifiedName((String)dbName, (String)tblName)).get(dbName);
    }

    private static Map<String, Map<String, Table>> getTempTables(String msg) {
        SessionState ss = SessionState.get();
        if (ss == null) {
            LOG.debug("No current SessionState, skipping temp tables for " + msg);
            return Collections.emptyMap();
        }
        return ss.getTempTables();
    }

    private Map<String, ColumnStatisticsObj> getTempTableColumnStatsForTable(String dbName, String tableName) {
        SessionState ss = SessionState.get();
        if (ss == null) {
            LOG.debug("No current SessionState, skipping temp tables for " + Warehouse.getQualifiedName((String)dbName, (String)tableName));
            return null;
        }
        String lookupName = StatsUtils.getFullyQualifiedTableName(dbName.toLowerCase(), tableName.toLowerCase());
        return ss.getTempTableColStats().get(lookupName);
    }

    private List<ColumnStatisticsObj> getTempTableColumnStats(String dbName, String tableName, List<String> colNames) {
        Map<String, ColumnStatisticsObj> tableColStats = this.getTempTableColumnStatsForTable(dbName, tableName);
        ArrayList<ColumnStatisticsObj> retval = new ArrayList<ColumnStatisticsObj>();
        if (tableColStats != null) {
            for (String colName : colNames) {
                if (!tableColStats.containsKey(colName = colName.toLowerCase())) continue;
                retval.add(new ColumnStatisticsObj(tableColStats.get(colName)));
            }
        }
        return retval;
    }

    private boolean updateTempTableColumnStats(String dbName, String tableName, ColumnStatistics colStats) throws MetaException {
        SessionState ss = SessionState.get();
        if (ss == null) {
            throw new MetaException("No current SessionState, cannot update temporary table stats for " + StatsUtils.getFullyQualifiedTableName(dbName, tableName));
        }
        Map<String, ColumnStatisticsObj> ssTableColStats = this.getTempTableColumnStatsForTable(dbName, tableName);
        if (ssTableColStats == null) {
            ssTableColStats = new HashMap<String, ColumnStatisticsObj>();
            ss.getTempTableColStats().put(StatsUtils.getFullyQualifiedTableName(dbName, tableName), ssTableColStats);
        }
        SessionHiveMetaStoreClient.mergeColumnStats(ssTableColStats, colStats);
        ArrayList<String> colNames = new ArrayList<String>();
        for (ColumnStatisticsObj obj : colStats.getStatsObj()) {
            colNames.add(obj.getColName());
        }
        org.apache.hadoop.hive.metastore.api.Table table = this.getTempTable(dbName, tableName);
        StatsSetupConst.setColumnStatsState((Map)table.getParameters(), colNames);
        return true;
    }

    private static void mergeColumnStats(Map<String, ColumnStatisticsObj> oldStats, ColumnStatistics newStats) {
        List newColList = newStats.getStatsObj();
        if (newColList != null) {
            for (ColumnStatisticsObj colStat : newColList) {
                oldStats.put(colStat.getColName().toLowerCase(), colStat);
            }
        }
    }

    private boolean deleteTempTableColumnStatsForTable(String dbName, String tableName) throws NoSuchObjectException {
        Map<String, ColumnStatisticsObj> deletedEntry = this.getTempTableColumnStatsForTable(dbName, tableName);
        if (deletedEntry == null) {
            throw new NoSuchObjectException("Column stats doesn't exist for db=" + dbName + " temp table=" + tableName);
        }
        SessionState.get().getTempTableColStats().remove(StatsUtils.getFullyQualifiedTableName(dbName, tableName));
        return true;
    }

    private boolean deleteTempTableColumnStats(String dbName, String tableName, String columnName) throws NoSuchObjectException {
        ColumnStatisticsObj deletedEntry = null;
        Map<String, ColumnStatisticsObj> ssTableColStats = this.getTempTableColumnStatsForTable(dbName, tableName);
        if (ssTableColStats != null) {
            deletedEntry = ssTableColStats.remove(columnName.toLowerCase());
        }
        if (deletedEntry == null) {
            throw new NoSuchObjectException("Column stats doesn't exist for db=" + dbName + " temp table=" + tableName);
        }
        return true;
    }

    public Partition add_partition(Partition partition) throws TException {
        org.apache.hadoop.hive.metastore.api.Table table;
        if (partition == null) {
            throw new MetaException("Partition cannot be null");
        }
        if (this.isDefaultCatalog(partition.getCatName()) && (table = this.getTempTable(partition.getDbName(), partition.getTableName())) != null) {
            TempTable tt = this.getPartitionedTempTable(table);
            this.checkPartitionProperties(partition);
            Path partitionLocation = this.getPartitionLocation(table, partition, false);
            Partition result = tt.addPartition(HiveMetaStoreClientUtils.deepCopy((Partition)partition));
            this.createAndSetLocationForAddedPartition(result, partitionLocation);
            return result;
        }
        return this.delegate.add_partition(partition);
    }

    public int add_partitions_pspec(PartitionSpecProxy partitionSpec) throws TException {
        org.apache.hadoop.hive.metastore.api.Table table;
        if (partitionSpec == null) {
            throw new MetaException("PartitionSpec cannot be null.");
        }
        if (partitionSpec.size() == 0) {
            return 0;
        }
        if (this.isDefaultCatalog(partitionSpec.getCatName()) && (table = this.getTempTable(partitionSpec.getDbName(), partitionSpec.getTableName())) != null) {
            this.assertTempTablePartitioned(table);
            PartitionSpecProxy.PartitionIterator partitionIterator = partitionSpec.getPartitionIterator();
            ArrayList<Partition> partitionsToAdd = new ArrayList<Partition>(partitionSpec.size());
            while (partitionIterator.hasNext()) {
                partitionsToAdd.add((Partition)partitionIterator.next());
            }
            List<Partition> addedPartitions = this.addPartitionsToTempTable(partitionsToAdd, partitionSpec.getDbName(), partitionSpec.getTableName(), false);
            if (addedPartitions != null) {
                return addedPartitions.size();
            }
        }
        return this.delegate.add_partitions_pspec(partitionSpec);
    }

    public List<Partition> add_partitions(List<Partition> partitions, boolean ifNotExists, boolean needResults) throws TException {
        List<Partition> addedPartitions;
        if (partitions == null || partitions.contains(null)) {
            throw new MetaException("Partitions cannot be null");
        }
        if (partitions.isEmpty()) {
            return needResults ? new ArrayList() : null;
        }
        if (this.isDefaultCatalog(partitions.get(0).getCatName()) && this.getTempTable(partitions.get(0).getDbName(), partitions.get(0).getTableName()) != null && (addedPartitions = this.addPartitionsToTempTable(partitions, null, null, ifNotExists)) != null) {
            return needResults ? addedPartitions : null;
        }
        return this.delegate.add_partitions(partitions, ifNotExists, needResults);
    }

    public Partition getPartition(String catName, String dbName, String tblName, String name) throws TException {
        org.apache.hadoop.hive.metastore.api.Table table;
        if (this.isDefaultCatalog(catName) && (table = this.getTempTable(dbName, tblName)) != null) {
            TempTable tt = this.getPartitionedTempTable(table);
            Partition partition = tt.getPartition(name);
            if (partition == null) {
                throw new NoSuchObjectException("Partition with name " + name + " for table " + tblName + " in database " + dbName + " is not found.");
            }
            return HiveMetaStoreClientUtils.deepCopy((Partition)partition);
        }
        return this.delegate.getPartition(catName, dbName, tblName, name);
    }

    public Partition getPartition(String catName, String dbName, String tblName, List<String> partVals) throws TException {
        org.apache.hadoop.hive.metastore.api.Table table;
        if (this.isDefaultCatalog(catName) && (table = this.getTempTable(dbName, tblName)) != null) {
            TempTable tt = this.getPartitionedTempTable(table);
            Partition partition = tt.getPartition(partVals);
            if (partition == null) {
                throw new NoSuchObjectException("Partition with partition values " + (partVals != null ? Arrays.toString(partVals.toArray()) : "null") + " for table " + tblName + " in database " + dbName + " is not found.");
            }
            return HiveMetaStoreClientUtils.deepCopy((Partition)partition);
        }
        return this.delegate.getPartition(catName, dbName, tblName, partVals);
    }

    public GetPartitionsResponse getPartitionsWithSpecs(GetPartitionsRequest request) throws TException {
        org.apache.hadoop.hive.metastore.api.Table table;
        if (this.isDefaultCatalog(request.getCatName()) && (table = this.getTempTable(request.getDbName(), request.getTblName())) != null) {
            TempTable tt = this.getPartitionedTempTable(table);
            return tt.getPartitionsWithSpecs(request);
        }
        return this.delegate.getPartitionsWithSpecs(request);
    }

    public List<String> listPartitionNames(PartitionsByExprRequest req) throws TException {
        org.apache.hadoop.hive.metastore.api.Table table;
        if (this.isDefaultCatalog(req.getCatName()) && (table = this.getTempTable(req.getDbName(), req.getTblName())) != null) {
            boolean isEmptyFilter;
            List<Partition> partitionList = this.getPartitionedTempTable(table).listPartitions();
            if (partitionList.isEmpty()) {
                return Collections.emptyList();
            }
            byte[] expr = req.getExpr();
            boolean bl = isEmptyFilter = expr == null || expr.length == 1 && expr[0] == -1;
            if (!isEmptyFilter) {
                partitionList = this.getPartitionedTempTable(table).listPartitionsByFilter(this.generateJDOFilter(table, expr, req.getDefaultPartitionName()));
            }
            ArrayList<String> results = new ArrayList<String>();
            Collections.sort(partitionList, new PartitionNamesComparator(table, req));
            short maxParts = req.getMaxParts();
            int numPartitions = maxParts < 0 || maxParts > partitionList.size() ? partitionList.size() : (int)maxParts;
            for (int i = 0; i < numPartitions; ++i) {
                results.add(Warehouse.makePartName((List)table.getPartitionKeys(), (List)partitionList.get(i).getValues()));
            }
            return results;
        }
        return this.delegate.listPartitionNames(req);
    }

    public List<Partition> listPartitions(String catName, String dbName, String tblName, int maxParts) throws TException {
        org.apache.hadoop.hive.metastore.api.Table table;
        if (this.isDefaultCatalog(catName) && (table = this.getTempTable(dbName, tblName)) != null) {
            TempTable tt = this.getPartitionedTempTable(table);
            return this.getPartitionsForMaxParts(tt.listPartitions(), maxParts);
        }
        return this.delegate.listPartitions(catName, dbName, tblName, maxParts);
    }

    public List<Partition> listPartitions(String catName, String dbName, String tblName, List<String> partVals, int maxParts) throws TException {
        org.apache.hadoop.hive.metastore.api.Table table;
        if (this.isDefaultCatalog(catName) && (table = this.getTempTable(dbName, tblName)) != null) {
            TempTable tt = this.getPartitionedTempTable(table);
            return this.getPartitionsForMaxParts(tt.getPartitionsByPartitionVals(partVals), maxParts);
        }
        return this.delegate.listPartitions(catName, dbName, tblName, partVals, maxParts);
    }

    public PartitionSpecProxy listPartitionSpecs(String catName, String dbName, String tableName, int maxParts) throws TException {
        org.apache.hadoop.hive.metastore.api.Table table;
        if (this.isDefaultCatalog(catName) && (table = this.getTempTable(dbName, tableName)) != null) {
            TempTable tt = this.getPartitionedTempTable(table);
            return this.getPartitionSpecProxy(table, tt.listPartitions(), maxParts);
        }
        return this.delegate.listPartitionSpecs(catName, dbName, tableName, maxParts);
    }

    public Partition getPartitionWithAuthInfo(String catName, String dbName, String tableName, List<String> pvals, String userName, List<String> groupNames) throws TException {
        org.apache.hadoop.hive.metastore.api.Table table;
        if (this.isDefaultCatalog(catName) && (table = this.getTempTable(dbName, tableName)) != null) {
            TempTable tt = this.getPartitionedTempTable(table);
            Partition partition = tt.getPartitionWithAuthInfo(pvals, userName, groupNames);
            if (partition == null) {
                throw new NoSuchObjectException("Partition with partition values " + (pvals != null ? Arrays.toString(pvals.toArray()) : "null") + " for table " + tableName + " in database " + dbName + " and for user " + userName + " and group names " + (groupNames != null ? Arrays.toString(groupNames.toArray()) : "null") + " is not found.");
            }
            return HiveMetaStoreClientUtils.deepCopy((Partition)partition);
        }
        return this.delegate.getPartitionWithAuthInfo(catName, dbName, tableName, pvals, userName, groupNames);
    }

    public boolean dropPartition(String catName, String dbName, String tblName, List<String> partVals, PartitionDropOptions options) throws TException {
        org.apache.hadoop.hive.metastore.api.Table table;
        if (this.isDefaultCatalog(catName) && (table = this.getTempTable(dbName, tblName)) != null) {
            boolean deleteData;
            if (partVals == null || partVals.isEmpty() || partVals.contains(null)) {
                throw new MetaException("Partition values cannot be null, empty or contain null values");
            }
            TempTable tt = this.getPartitionedTempTable(table);
            if (tt == null) {
                throw new IllegalStateException("TempTable not found for " + Warehouse.getCatalogQualifiedTableName((org.apache.hadoop.hive.metastore.api.Table)table));
            }
            Partition droppedPartition = tt.dropPartition(partVals);
            boolean result = droppedPartition != null;
            boolean purgeData = options != null ? options.purgeData : true;
            boolean bl = deleteData = options != null ? options.deleteData : true;
            if (deleteData && !tt.isExternal()) {
                result &= this.deletePartitionLocation(droppedPartition, purgeData);
            }
            return result;
        }
        return this.delegate.dropPartition(catName, dbName, tblName, partVals, options);
    }

    public boolean dropPartition(String catName, String dbName, String tableName, String partitionName, boolean deleteData) throws TException {
        org.apache.hadoop.hive.metastore.api.Table table;
        if (this.isDefaultCatalog(catName) && (table = this.getTempTable(dbName, tableName)) != null) {
            boolean result;
            TempTable tt = this.getPartitionedTempTable(table);
            Partition droppedPartition = tt.dropPartition(partitionName);
            boolean bl = result = droppedPartition != null;
            if (deleteData && !tt.isExternal()) {
                result &= this.deletePartitionLocation(droppedPartition, true);
            }
            return result;
        }
        return this.delegate.dropPartition(catName, dbName, tableName, partitionName, deleteData);
    }

    public List<Partition> dropPartitions(TableName tableName, RequestPartsSpec partsSpec, PartitionDropOptions options, EnvironmentContext context) throws TException {
        org.apache.hadoop.hive.metastore.api.Table table;
        if (this.isDefaultCatalog(tableName.getCat()) && (table = this.getTempTable(tableName.getDb(), tableName.getTable())) != null) {
            TempTable tt = this.getPartitionedTempTable(table);
            ArrayList<List> partValues = new ArrayList<List>();
            if (partsSpec.isSetExprs()) {
                List exprs = partsSpec.getExprs();
                for (DropPartitionsExpr expr : exprs) {
                    String filter = this.generateJDOFilter(table, expr.getExpr(), this.conf.get(HiveConf.ConfVars.DEFAULT_PARTITION_NAME.varname));
                    List<Partition> partitions = tt.listPartitionsByFilter(filter);
                    for (Partition p : partitions) {
                        partValues.add(p.getValues());
                    }
                }
            } else if (partsSpec.isSetNames()) {
                List partNames = partsSpec.getNames();
                for (String partName : partNames) {
                    partValues.add(CachedStore.partNameToVals((String)partName));
                }
            }
            boolean purgeData = options != null ? options.purgeData : true;
            boolean deleteData = options != null ? options.deleteData : true;
            ArrayList<Partition> result = new ArrayList<Partition>();
            for (List partValue : partValues) {
                Partition droppedPartition = tt.dropPartition(partValue);
                if (droppedPartition == null) continue;
                result.add(droppedPartition);
                if (!deleteData || tt.isExternal()) continue;
                this.deletePartitionLocation(droppedPartition, purgeData);
            }
            return result;
        }
        return this.delegate.dropPartitions(tableName, partsSpec, options, context);
    }

    public Partition exchange_partition(Map<String, String> partitionSpecs, String sourceCatName, String sourceDbName, String sourceTableName, String destCatName, String destDbName, String destTableName) throws TException {
        TempTable destTT;
        TempTable sourceTT;
        List<Partition> partitions;
        org.apache.hadoop.hive.metastore.api.Table sourceTempTable = null;
        org.apache.hadoop.hive.metastore.api.Table destTempTable = null;
        if (this.isDefaultCatalog(sourceCatName)) {
            sourceTempTable = this.getTempTable(sourceDbName, sourceTableName);
        }
        if (this.isDefaultCatalog(destCatName)) {
            destTempTable = this.getTempTable(destDbName, destTableName);
        }
        if (sourceTempTable == null && destTempTable == null) {
            return this.delegate.exchange_partition(partitionSpecs, sourceCatName, sourceDbName, sourceTableName, destCatName, destDbName, destTableName);
        }
        if (sourceTempTable != null && destTempTable != null && !(partitions = this.exchangePartitions(partitionSpecs, sourceTempTable, sourceTT = this.getPartitionedTempTable(sourceTempTable), destTempTable, destTT = this.getPartitionedTempTable(destTempTable))).isEmpty()) {
            return partitions.get(0);
        }
        throw new MetaException("Exchanging partitions between temporary and non-temporary tables is not supported.");
    }

    public List<Partition> exchange_partitions(Map<String, String> partitionSpecs, String sourceCatName, String sourceDbName, String sourceTableName, String destCatName, String destDbName, String destTableName) throws TException {
        org.apache.hadoop.hive.metastore.api.Table sourceTempTable = null;
        org.apache.hadoop.hive.metastore.api.Table destTempTable = null;
        if (this.isDefaultCatalog(sourceCatName)) {
            sourceTempTable = this.getTempTable(sourceDbName, sourceTableName);
        }
        if (this.isDefaultCatalog(destCatName)) {
            destTempTable = this.getTempTable(destDbName, destTableName);
        }
        if (sourceTempTable == null && destTempTable == null) {
            return this.delegate.exchange_partitions(partitionSpecs, sourceCatName, sourceDbName, sourceTableName, destCatName, destDbName, destTableName);
        }
        if (sourceTempTable != null && destTempTable != null) {
            return this.exchangePartitions(partitionSpecs, sourceTempTable, this.getPartitionedTempTable(sourceTempTable), destTempTable, this.getPartitionedTempTable(destTempTable));
        }
        throw new MetaException("Exchanging partitions between temporary and non-temporary tables is not supported.");
    }

    public void alter_partition(String catName, String dbName, String tblName, Partition newPart, EnvironmentContext environmentContext, String writeIdList) throws TException {
        org.apache.hadoop.hive.metastore.api.Table table;
        if (this.isDefaultCatalog(catName) && (table = this.getTempTable(dbName, tblName)) != null) {
            TempTable tt = this.getPartitionedTempTable(table);
            tt.alterPartition(newPart);
            return;
        }
        this.delegate.alter_partition(catName, dbName, tblName, newPart, environmentContext, writeIdList);
    }

    public void alter_partitions(String catName, String dbName, String tblName, List<Partition> newParts, EnvironmentContext environmentContext, String writeIdList, long writeId) throws TException {
        org.apache.hadoop.hive.metastore.api.Table table;
        if (this.isDefaultCatalog(catName) && (table = this.getTempTable(dbName, tblName)) != null) {
            TempTable tt = this.getPartitionedTempTable(table);
            tt.alterPartitions(newParts);
            return;
        }
        this.delegate.alter_partitions(catName, dbName, tblName, newParts, environmentContext, writeIdList, writeId);
    }

    public void renamePartition(String catName, String dbname, String tableName, List<String> partitionVals, Partition newPart, String validWriteIds, long txnId, boolean makeCopy) throws TException {
        org.apache.hadoop.hive.metastore.api.Table table;
        if (this.isDefaultCatalog(catName) && (table = this.getTempTable(dbname, tableName)) != null) {
            TempTable tt = this.getPartitionedTempTable(table);
            tt.renamePartition(partitionVals, newPart);
            return;
        }
        this.delegate.renamePartition(catName, dbname, tableName, partitionVals, newPart, validWriteIds, txnId, makeCopy);
    }

    public Partition appendPartition(String catName, String dbName, String tableName, List<String> partVals) throws TException {
        org.apache.hadoop.hive.metastore.api.Table table;
        if (this.isDefaultCatalog(catName) && (table = this.getTempTable(dbName, tableName)) != null) {
            if (partVals == null || partVals.isEmpty()) {
                throw new MetaException("The partition values must be not null or empty.");
            }
            this.assertTempTablePartitioned(table);
            Partition partition = new PartitionBuilder().inTable(table).setValues(partVals).build(this.conf);
            return this.appendPartitionToTempTable(table, partition);
        }
        return this.delegate.appendPartition(catName, dbName, tableName, partVals);
    }

    public Partition appendPartition(String catName, String dbName, String tableName, String partitionName) throws TException {
        org.apache.hadoop.hive.metastore.api.Table table;
        if (this.isDefaultCatalog(catName) && (table = this.getTempTable(dbName, tableName)) != null) {
            if (partitionName == null || partitionName.isEmpty()) {
                throw new MetaException("The partition must be not null or empty.");
            }
            this.assertTempTablePartitioned(table);
            LinkedHashMap specFromName = Warehouse.makeSpecFromName((String)partitionName);
            if (specFromName == null || specFromName.isEmpty()) {
                throw new InvalidObjectException("Invalid partition name " + partitionName);
            }
            ArrayList<String> pVals = new ArrayList<String>();
            for (FieldSchema field : table.getPartitionKeys()) {
                String val = (String)specFromName.get(field.getName());
                if (val == null) {
                    throw new InvalidObjectException("Partition name " + partitionName + " and table partition keys " + Arrays.toString(table.getPartitionKeys().toArray()) + " does not match");
                }
                pVals.add(val);
            }
            Partition partition = new PartitionBuilder().inTable(table).setValues(pVals).build(this.conf);
            return this.appendPartitionToTempTable(table, partition);
        }
        return this.delegate.appendPartition(catName, dbName, tableName, partitionName);
    }

    public List<Partition> listPartitionsByFilter(String catName, String dbName, String tableName, String filter, int maxParts) throws TException {
        org.apache.hadoop.hive.metastore.api.Table table;
        if (this.isDefaultCatalog(catName) && (table = this.getTempTable(dbName, tableName)) != null) {
            return this.getPartitionsForMaxParts(this.getPartitionedTempTable(table).listPartitionsByFilter(this.generateJDOFilter(table, filter)), maxParts);
        }
        return this.delegate.listPartitionsByFilter(catName, dbName, tableName, filter, maxParts);
    }

    public int getNumPartitionsByFilter(String catName, String dbName, String tableName, String filter) throws TException {
        org.apache.hadoop.hive.metastore.api.Table table;
        if (this.isDefaultCatalog(catName) && (table = this.getTempTable(dbName, tableName)) != null) {
            return this.getPartitionedTempTable(table).getNumPartitionsByFilter(this.generateJDOFilter(table, filter));
        }
        return this.delegate.getNumPartitionsByFilter(catName, dbName, tableName, filter);
    }

    public PartitionSpecProxy listPartitionSpecsByFilter(String catName, String dbName, String tblName, String filter, int maxParts) throws TException {
        org.apache.hadoop.hive.metastore.api.Table table;
        if (this.isDefaultCatalog(catName) && (table = this.getTempTable(dbName, tblName)) != null) {
            return this.getPartitionSpecProxy(table, this.getPartitionedTempTable(table).listPartitionsByFilter(this.generateJDOFilter(table, filter)), maxParts);
        }
        return this.delegate.listPartitionSpecsByFilter(catName, dbName, tblName, filter, maxParts);
    }

    public PartitionValuesResponse listPartitionValues(PartitionValuesRequest request) throws TException {
        org.apache.hadoop.hive.metastore.api.Table table;
        if (request == null || request.getPartitionKeys() == null || request.getPartitionKeys().isEmpty()) {
            return this.delegate.listPartitionValues(request);
        }
        if (this.isDefaultCatalog(request.getCatName()) && (table = this.getTempTable(request.getDbName(), request.getTblName())) != null) {
            TempTable tt = this.getPartitionedTempTable(table);
            List<Partition> partitions = request.isSetFilter() ? tt.listPartitionsByFilter(this.generateJDOFilter(table, request.getFilter())) : tt.listPartitions();
            ArrayList<String> partitionNames = new ArrayList<String>();
            for (Partition p : partitions) {
                partitionNames.add(Warehouse.makePartName((List)table.getPartitionKeys(), (List)p.getValues()));
            }
            if (partitionNames.isEmpty() && partitions.isEmpty()) {
                throw new MetaException("Cannot obtain list of partition by filter:\"" + request.getFilter() + "\" for " + Warehouse.getCatalogQualifiedTableName((org.apache.hadoop.hive.metastore.api.Table)table));
            }
            if (request.isSetAscending()) {
                if (request.isAscending()) {
                    Collections.sort(partitionNames);
                } else {
                    Collections.sort(partitionNames, Collections.reverseOrder());
                }
            }
            PartitionValuesResponse response = new PartitionValuesResponse();
            response.setPartitionValues(new ArrayList(partitionNames.size()));
            for (String partName : partitionNames) {
                ArrayList<Object> vals = new ArrayList<Object>(Collections.nCopies(table.getPartitionKeysSize(), null));
                PartitionValuesRow row = new PartitionValuesRow();
                Warehouse.makeValsFromName((String)partName, vals);
                vals.forEach((Consumer<Object>)((Consumer<String>)arg_0 -> ((PartitionValuesRow)row).addToRow(arg_0)));
                response.addToPartitionValues(row);
            }
            return response;
        }
        return this.delegate.listPartitionValues(request);
    }

    private PartitionSpecProxy getPartitionSpecProxy(org.apache.hadoop.hive.metastore.api.Table table, List<Partition> partitions, int maxParts) throws MetaException {
        PartitionSpec partitionSpec = new PartitionSpec();
        PartitionListComposingSpec partitionListComposingSpec = new PartitionListComposingSpec(new ArrayList());
        for (int i = 0; i < (maxParts < 0 || maxParts > partitions.size() ? partitions.size() : maxParts); ++i) {
            partitionListComposingSpec.addToPartitions(HiveMetaStoreClientUtils.deepCopy((Partition)partitions.get(i)));
        }
        partitionSpec.setCatName(table.getCatName());
        partitionSpec.setDbName(table.getDbName());
        partitionSpec.setTableName(table.getTableName());
        partitionSpec.setRootPath(table.getSd().getLocation());
        partitionSpec.setPartitionList(partitionListComposingSpec);
        List<PartitionSpec> partitionSpecs = Arrays.asList(partitionSpec);
        return PartitionSpecProxy.Factory.get(partitionSpecs);
    }

    private List<Partition> getPartitionsForMaxParts(List<Partition> parts, int maxParts) {
        ArrayList<Partition> matchedParts = new ArrayList<Partition>();
        for (int i = 0; i < (maxParts < 0 || maxParts > parts.size() ? parts.size() : maxParts); ++i) {
            matchedParts.add(HiveMetaStoreClientUtils.deepCopy((Partition)parts.get(i)));
        }
        return matchedParts;
    }

    private String generateJDOFilter(org.apache.hadoop.hive.metastore.api.Table table, String filter) throws MetaException {
        ExpressionTree exprTree = StringUtils.isNotEmpty((CharSequence)filter) ? PartFilterExprUtil.parseFilterTree((String)filter) : ExpressionTree.EMPTY_TREE;
        return this.generateJDOFilter(table, exprTree);
    }

    private String generateJDOFilter(org.apache.hadoop.hive.metastore.api.Table table, byte[] expr, String defaultPartitionName) throws MetaException {
        ExpressionTree expressionTree = PartFilterExprUtil.makeExpressionTree((PartitionExpressionProxy)PartFilterExprUtil.createExpressionProxy((Configuration)this.conf), (byte[])expr, (String)defaultPartitionName, (Configuration)this.conf);
        return this.generateJDOFilter(table, expressionTree == null ? ExpressionTree.EMPTY_TREE : expressionTree);
    }

    private String generateJDOFilter(org.apache.hadoop.hive.metastore.api.Table table, ExpressionTree exprTree) throws MetaException {
        assert (table != null);
        ExpressionTree.FilterBuilder filterBuilder = new ExpressionTree.FilterBuilder(true);
        HashMap params = new HashMap();
        exprTree.accept((ExpressionTree.TreeVisitor)new ExpressionTree.JDOFilterGenerator(this.conf, table.getPartitionKeys(), filterBuilder, params));
        StringBuilder stringBuilder = new StringBuilder(filterBuilder.getFilter());
        params.entrySet().stream().forEach(e -> {
            int index = stringBuilder.indexOf((String)e.getKey());
            stringBuilder.replace(index, index + ((String)e.getKey()).length(), "\"" + e.getValue().toString() + "\"");
        });
        return stringBuilder.toString();
    }

    private Partition appendPartitionToTempTable(org.apache.hadoop.hive.metastore.api.Table table, Partition partition) throws MetaException, AlreadyExistsException {
        TempTable tt = this.getPartitionedTempTable(table);
        if (tt == null) {
            throw new IllegalStateException("TempTable not found for " + Warehouse.getCatalogQualifiedTableName((org.apache.hadoop.hive.metastore.api.Table)table));
        }
        Path partitionLocation = this.getPartitionLocation(table, partition, false);
        partition = tt.addPartition(HiveMetaStoreClientUtils.deepCopy((Partition)partition));
        this.createAndSetLocationForAddedPartition(partition, partitionLocation);
        return partition;
    }

    private List<Partition> exchangePartitions(Map<String, String> partitionSpecs, org.apache.hadoop.hive.metastore.api.Table sourceTable, TempTable sourceTempTable, org.apache.hadoop.hive.metastore.api.Table destTable, TempTable destTempTable) throws TException {
        if (partitionSpecs == null || partitionSpecs.isEmpty()) {
            throw new MetaException("PartitionSpecs cannot be null or empty.");
        }
        List partitionVals = MetaStoreUtils.getPvals((List)sourceTable.getPartitionKeys(), partitionSpecs);
        if (partitionVals.stream().allMatch(String::isEmpty)) {
            throw new MetaException("Invalid partition key & values; keys " + Arrays.toString(sourceTable.getPartitionKeys().toArray()) + ", values " + Arrays.toString(partitionVals.toArray()));
        }
        List<Partition> partitionsToExchange = sourceTempTable.getPartitionsByPartitionVals(partitionVals);
        if (partitionSpecs == null) {
            throw new MetaException("The partition specs must be not null.");
        }
        if (partitionsToExchange.isEmpty()) {
            throw new MetaException("No partition is found with the values " + String.valueOf(partitionSpecs) + " for the table " + sourceTable.getTableName());
        }
        boolean sameColumns = MetaStoreUtils.compareFieldColumns((List)sourceTable.getSd().getCols(), (List)destTable.getSd().getCols());
        boolean samePartitions = MetaStoreUtils.compareFieldColumns((List)sourceTable.getPartitionKeys(), (List)destTable.getPartitionKeys());
        if (!sameColumns || !samePartitions) {
            throw new MetaException("The tables have different schemas. Their partitions cannot be exchanged.");
        }
        for (Partition partition : partitionsToExchange) {
            String partToExchangeName = Warehouse.makePartName((List)destTable.getPartitionKeys(), (List)partition.getValues());
            if (destTempTable.getPartition(partToExchangeName) == null) continue;
            throw new MetaException("The partition " + partToExchangeName + " already exists in the table " + destTable.getTableName());
        }
        ArrayList<Partition> result = new ArrayList<Partition>();
        for (Partition partition : partitionsToExchange) {
            Partition destPartition = new Partition(partition);
            destPartition.setCatName(destTable.getCatName());
            destPartition.setDbName(destTable.getDbName());
            destPartition.setTableName(destTable.getTableName());
            destPartition.getSd().setLocation(this.getPartitionLocation(destTable, destPartition, true).toString());
            this.wh.renameDir(new Path(partition.getSd().getLocation()), new Path(destPartition.getSd().getLocation()), false);
            destPartition = destTempTable.addPartition(destPartition);
            this.dropPartition(null, sourceTable.getDbName(), sourceTable.getTableName(), partition.getValues(), PartitionDropOptions.instance().deleteData(true));
            result.add(destPartition);
        }
        return result;
    }

    private TempTable getPartitionedTempTable(org.apache.hadoop.hive.metastore.api.Table t) throws MetaException {
        String qualifiedTableName = Warehouse.getQualifiedName((String)t.getDbName().toLowerCase(), (String)t.getTableName().toLowerCase());
        SessionState ss = SessionState.get();
        if (ss == null) {
            LOG.warn("No current SessionState, failed to get temp partitions for " + qualifiedTableName);
            return null;
        }
        this.assertTempTablePartitioned(t);
        TempTable tt = ss.getTempPartitions().get(qualifiedTableName);
        if (tt == null) {
            throw new IllegalStateException("TempTable not found for " + Warehouse.getCatalogQualifiedTableName((org.apache.hadoop.hive.metastore.api.Table)t));
        }
        return tt;
    }

    private void removePartitionedTempTable(org.apache.hadoop.hive.metastore.api.Table t) {
        String qualifiedTableName = Warehouse.getQualifiedName((String)t.getDbName().toLowerCase(), (String)t.getTableName().toLowerCase());
        SessionState ss = SessionState.get();
        if (ss == null) {
            LOG.warn("No current SessionState, skip removing temp partitions for " + qualifiedTableName);
            return;
        }
        ss.getTempPartitions().remove(Warehouse.getQualifiedName((org.apache.hadoop.hive.metastore.api.Table)t));
    }

    private void createPartitionedTempTable(org.apache.hadoop.hive.metastore.api.Table t) {
        if (t.getPartitionKeysSize() <= 0) {
            return;
        }
        String qualifiedTableName = Warehouse.getQualifiedName((String)t.getDbName().toLowerCase(), (String)t.getTableName().toLowerCase());
        SessionState ss = SessionState.get();
        if (ss == null) {
            LOG.warn("No current SessionState, skip creating temp partitions for " + qualifiedTableName);
            return;
        }
        TempTable tt = new TempTable(t);
        if (ss.getTempPartitions().putIfAbsent(qualifiedTableName, tt) != null) {
            throw new IllegalStateException("TempTable for " + qualifiedTableName + " already exists");
        }
    }

    private void createAndSetLocationForAddedPartition(Partition partition, Path partitionLocation) throws MetaException {
        if (partitionLocation != null) {
            partition.getSd().setLocation(partitionLocation.toString());
            if (!this.getWh().isDir(partitionLocation) && !this.getWh().mkdirs(partitionLocation)) {
                throw new MetaException(String.valueOf(partitionLocation) + " is not a directory or unable to create one");
            }
        }
    }

    private void checkPartitionProperties(Partition partition) throws MetaException {
        if (partition.getDbName() == null) {
            throw new MetaException("Database name cannot be null. " + String.valueOf(partition));
        }
        if (partition.getTableName() == null) {
            throw new MetaException("Table name cannot be null. " + String.valueOf(partition));
        }
        if (partition.getValues() == null) {
            throw new MetaException("Partition values cannot be null. " + String.valueOf(partition));
        }
        if (partition.getSd() == null) {
            throw new MetaException("Storage descriptor for partition cannot be null. " + String.valueOf(partition));
        }
        if (partition.getSd().getCols() == null) {
            return;
        }
        for (FieldSchema schema : partition.getSd().getCols()) {
            if (schema.getType() == null) {
                throw new MetaException("Storage descriptor column type for partition cannot be null. " + String.valueOf(partition));
            }
            if (schema.getName() != null) continue;
            throw new MetaException("Storage descriptor column name for partition cannot be null. " + String.valueOf(partition));
        }
        if (partition.getSd().getSerdeInfo() == null) {
            throw new MetaException("Storage descriptor serde info for partition cannot be null. " + String.valueOf(partition));
        }
    }

    private Path getPartitionLocation(org.apache.hadoop.hive.metastore.api.Table table, Partition partition, boolean forceOverwrite) throws MetaException {
        Path partLocation = null;
        String partLocationStr = null;
        if (partition.getSd() != null) {
            partLocationStr = partition.getSd().getLocation();
        }
        if (partLocationStr == null || partLocationStr.isEmpty() || forceOverwrite) {
            if (table.getSd().getLocation() != null) {
                partLocation = new Path(table.getSd().getLocation(), Warehouse.makePartName((List)table.getPartitionKeys(), (List)partition.getValues()));
            }
        } else {
            if (table.getSd().getLocation() == null) {
                throw new MetaException("Cannot specify location for a view partition");
            }
            try {
                partLocation = this.getWh().getDnsPath(new Path(partLocationStr));
            }
            catch (IllegalArgumentException e) {
                throw new MetaException("Partition path is invalid. " + e.getLocalizedMessage());
            }
        }
        return partLocation;
    }

    private List<Partition> addPartitionsToTempTable(List<Partition> partitions, String dbName, String tableName, boolean ifNotExists) throws MetaException, AlreadyExistsException {
        org.apache.hadoop.hive.metastore.api.Table table;
        TempTable tt;
        if (!this.validatePartitions(partitions, dbName, tableName)) {
            return null;
        }
        if (dbName == null) {
            dbName = partitions.get(0).getDbName();
        }
        if (tableName == null) {
            tableName = partitions.get(0).getTableName();
        }
        if ((tt = this.getPartitionedTempTable(table = this.getTempTable(dbName, tableName))) == null) {
            throw new IllegalStateException("TempTable not found for " + Warehouse.getCatalogQualifiedTableName((org.apache.hadoop.hive.metastore.api.Table)table));
        }
        List<Partition> result = tt.addPartitions(HiveMetaStoreClientUtils.deepCopyPartitions(partitions), ifNotExists);
        for (Partition p : result) {
            this.createAndSetLocationForAddedPartition(p, this.getPartitionLocation(table, p, false));
        }
        return result;
    }

    private boolean validatePartitions(List<Partition> partitions, String dbName, String tableName) throws MetaException {
        HashSet<List> partitionVals = new HashSet<List>();
        for (Partition p : partitions) {
            if (p.getDbName() == null) {
                throw new MetaException("Database for partition cannot be null. " + p.toString());
            }
            if (p.getTableName() == null) {
                throw new MetaException("Table for partition cannot be null. " + p.toString());
            }
            if (dbName != null && !dbName.equals(p.getDbName())) {
                throw new MetaException("Partition tables doesn't belong to the same database " + Arrays.toString(partitions.toArray()));
            }
            dbName = p.getDbName();
            if (tableName != null && !tableName.equals(p.getTableName())) {
                throw new MetaException("New partitions doesn't belong to the same table " + Arrays.toString(partitions.toArray()));
            }
            tableName = p.getTableName();
            if (partitionVals.contains(p.getValues())) {
                throw new MetaException("Partition values contains duplicate entries. " + Arrays.toString(partitions.toArray()));
            }
            partitionVals.add(p.getValues());
            org.apache.hadoop.hive.metastore.api.Table table = this.getTempTable(p.getDbName(), p.getTableName());
            if (table == null) {
                return false;
            }
            this.checkPartitionProperties(p);
            this.getPartitionLocation(table, p, false);
        }
        return true;
    }

    private void assertTempTablePartitioned(org.apache.hadoop.hive.metastore.api.Table table) throws MetaException {
        if (table.getPartitionKeysSize() <= 0) {
            throw new MetaException(Warehouse.getCatalogQualifiedTableName((org.apache.hadoop.hive.metastore.api.Table)table) + " is not partitioned");
        }
    }

    private boolean deletePartitionLocation(Partition partition, boolean purgeData) throws MetaException {
        String location = partition.getSd().getLocation();
        if (location != null) {
            Path path = this.getWh().getDnsPath(new Path(location));
            try {
                do {
                    if (!this.getWh().deleteDir(path, purgeData, false)) {
                        throw new MetaException("Unable to delete partition at " + location);
                    }
                    path = path.getParent();
                } while (this.getWh().isEmptyDir(path));
            }
            catch (IOException e) {
                throw new MetaException("Unable to delete partition at " + path.toString());
            }
            return true;
        }
        return false;
    }

    public org.apache.hadoop.hive.metastore.api.Table getTranslateTableDryrun(org.apache.hadoop.hive.metastore.api.Table tbl) throws TException {
        if (tbl.isTemporary()) {
            org.apache.hadoop.hive.metastore.api.Table table = this.getTempTable(tbl.getDbName(), tbl.getTableName());
            return table != null ? HiveMetaStoreClientUtils.deepCopy((org.apache.hadoop.hive.metastore.api.Table)table) : tbl;
        }
        return this.delegate.getTranslateTableDryrun(tbl);
    }

    public String getConfigValue(String name, String defaultValue) throws TException {
        Map<Object, Object> queryCache = this.getQueryCache();
        if (queryCache != null) {
            MetaStoreClientCacheUtils.CacheKey cacheKey = new MetaStoreClientCacheUtils.CacheKey(MetaStoreClientCacheUtils.KeyType.CONFIG_VALUE, name, defaultValue);
            String v = (String)queryCache.get(cacheKey);
            if (v == null) {
                v = this.delegate.getConfigValue(name, defaultValue);
                queryCache.put(cacheKey, v);
            } else {
                LOG.debug("Query level HMS cache: method=getConfigValueInternal, name={}", (Object)name);
            }
            return v;
        }
        return this.delegate.getConfigValue(name, defaultValue);
    }

    public Database getDatabase(String catalogName, String databaseName) throws TException {
        Map<Object, Object> queryCache = this.getQueryCache();
        if (queryCache != null) {
            MetaStoreClientCacheUtils.CacheKey cacheKey = new MetaStoreClientCacheUtils.CacheKey(MetaStoreClientCacheUtils.KeyType.DATABASE, catalogName, databaseName);
            Database v = (Database)queryCache.get(cacheKey);
            if (v == null) {
                v = this.delegate.getDatabase(catalogName, databaseName);
                queryCache.put(cacheKey, v);
            } else {
                LOG.debug("Query level HMS cache: method=getDatabaseInternal, name={}", (Object)databaseName);
            }
            return v;
        }
        return this.delegate.getDatabase(catalogName, databaseName);
    }

    public List<SQLPrimaryKey> getPrimaryKeys(PrimaryKeysRequest req) throws TException {
        Map<Object, Object> queryCache = this.getQueryCache();
        if (queryCache != null) {
            MetaStoreClientCacheUtils.CacheKey cacheKey = new MetaStoreClientCacheUtils.CacheKey(MetaStoreClientCacheUtils.KeyType.PRIMARY_KEYS, req);
            PrimaryKeysResponse v = (PrimaryKeysResponse)queryCache.get(cacheKey);
            if (v == null) {
                v = new PrimaryKeysResponse(this.delegate.getPrimaryKeys(req));
                queryCache.put(cacheKey, v);
            } else {
                LOG.debug("Query level HMS cache: method=getPrimaryKeysInternal, dbName={}, tblName={}", (Object)req.getDb_name(), (Object)req.getTbl_name());
            }
            return v.getPrimaryKeys();
        }
        return this.delegate.getPrimaryKeys(req);
    }

    public List<SQLForeignKey> getForeignKeys(ForeignKeysRequest req) throws TException {
        Map<Object, Object> queryCache = this.getQueryCache();
        if (queryCache != null) {
            MetaStoreClientCacheUtils.CacheKey cacheKey = new MetaStoreClientCacheUtils.CacheKey(MetaStoreClientCacheUtils.KeyType.FOREIGN_KEYS, req);
            ForeignKeysResponse v = (ForeignKeysResponse)queryCache.get(cacheKey);
            if (v == null) {
                v = new ForeignKeysResponse(this.delegate.getForeignKeys(req));
                queryCache.put(cacheKey, v);
            } else {
                LOG.debug("Query level HMS cache: method=getForeignKeysInternal, dbName={}, tblName={}", (Object)req.getForeign_db_name(), (Object)req.getForeign_tbl_name());
            }
            return v.getForeignKeys();
        }
        return this.delegate.getForeignKeys(req);
    }

    public List<SQLUniqueConstraint> getUniqueConstraints(UniqueConstraintsRequest req) throws TException {
        Map<Object, Object> queryCache = this.getQueryCache();
        if (queryCache != null) {
            MetaStoreClientCacheUtils.CacheKey cacheKey = new MetaStoreClientCacheUtils.CacheKey(MetaStoreClientCacheUtils.KeyType.UNIQUE_CONSTRAINTS, req);
            UniqueConstraintsResponse v = (UniqueConstraintsResponse)queryCache.get(cacheKey);
            if (v == null) {
                v = new UniqueConstraintsResponse(this.delegate.getUniqueConstraints(req));
                queryCache.put(cacheKey, v);
            } else {
                LOG.debug("Query level HMS cache: method=getUniqueConstraintsInternal, dbName={}, tblName={}", (Object)req.getDb_name(), (Object)req.getTbl_name());
            }
            return v.getUniqueConstraints();
        }
        return this.delegate.getUniqueConstraints(req);
    }

    public List<SQLNotNullConstraint> getNotNullConstraints(NotNullConstraintsRequest req) throws TException {
        Map<Object, Object> queryCache = this.getQueryCache();
        if (queryCache != null) {
            MetaStoreClientCacheUtils.CacheKey cacheKey = new MetaStoreClientCacheUtils.CacheKey(MetaStoreClientCacheUtils.KeyType.NOT_NULL_CONSTRAINTS, req);
            NotNullConstraintsResponse v = (NotNullConstraintsResponse)queryCache.get(cacheKey);
            if (v == null) {
                v = new NotNullConstraintsResponse(this.delegate.getNotNullConstraints(req));
                queryCache.put(cacheKey, v);
            } else {
                LOG.debug("Query level HMS cache: method=getNotNullConstraintsInternal, dbName={}, tblName={}", (Object)req.getDb_name(), (Object)req.getTbl_name());
            }
            return v.getNotNullConstraints();
        }
        return this.delegate.getNotNullConstraints(req);
    }

    public AggrStats getAggrColStatsFor(String catName, String dbName, String tblName, List<String> colNames, List<String> partNames, String engine) throws TException {
        return this.getAggrColStatsFor(catName, dbName, tblName, colNames, partNames, engine, this.getValidWriteIdList(dbName, tblName));
    }

    public AggrStats getAggrColStatsFor(String catName, String dbName, String tblName, List<String> colNames, List<String> partNames, String engine, String writeIdList) throws TException {
        Map<Object, Object> queryCache = this.getQueryCache();
        if (queryCache != null) {
            PartitionsStatsRequest req = new PartitionsStatsRequest(dbName, tblName, colNames, partNames);
            req.setEngine(engine);
            req.setCatName(catName);
            req.setValidWriteIdList(writeIdList);
            MetaStoreClientCacheUtils.CacheKey cacheKey = new MetaStoreClientCacheUtils.CacheKey(MetaStoreClientCacheUtils.KeyType.AGGR_COL_STATS, req);
            AggrStats v = (AggrStats)queryCache.get(cacheKey);
            if (v == null) {
                v = this.delegate.getAggrColStatsFor(catName, dbName, tblName, colNames, partNames, engine, writeIdList);
                queryCache.put(cacheKey, v);
            } else {
                LOG.debug("Query level HMS cache: method=getAggrStatsForInternal, dbName={}, tblName={}, partNames={}", new Object[]{req.getDbName(), req.getTblName(), req.getPartNames()});
            }
            return v;
        }
        return this.delegate.getAggrColStatsFor(catName, dbName, tblName, colNames, partNames, engine, writeIdList);
    }

    public ValidWriteIdList getValidWriteIds(String fullTableName) throws TException {
        Map<Object, Object> queryCache = this.getQueryCache();
        if (queryCache != null) {
            MetaStoreClientCacheUtils.CacheKey cacheKey = new MetaStoreClientCacheUtils.CacheKey(MetaStoreClientCacheUtils.KeyType.VALID_WRITE_ID, fullTableName);
            ValidWriteIdList v = (ValidWriteIdList)queryCache.get(cacheKey);
            if (v == null) {
                v = this.delegate.getValidWriteIds(fullTableName);
                queryCache.put(cacheKey, v);
            }
            return v;
        }
        return this.delegate.getValidWriteIds(fullTableName);
    }

    public ValidWriteIdList getValidWriteIds(String fullTableName, Long writeId) throws TException {
        Map<Object, Object> queryCache = this.getQueryCache();
        if (queryCache != null) {
            MetaStoreClientCacheUtils.CacheKey cacheKey = new MetaStoreClientCacheUtils.CacheKey(MetaStoreClientCacheUtils.KeyType.VALID_WRITE_ID, fullTableName, writeId);
            ValidWriteIdList v = (ValidWriteIdList)queryCache.get(cacheKey);
            if (v == null) {
                v = this.delegate.getValidWriteIds(fullTableName, writeId);
                queryCache.put(cacheKey, v);
            }
            return v;
        }
        return this.delegate.getValidWriteIds(fullTableName, writeId);
    }

    public List<TableValidWriteIds> getValidWriteIds(List<String> tablesList, String validTxnList) throws TException {
        Map<Object, Object> queryCache = this.getQueryCache();
        if (queryCache != null) {
            GetValidWriteIdsRequest rqst = new GetValidWriteIdsRequest(tablesList);
            rqst.setValidTxnList(validTxnList);
            MapWrapper cache = new MapWrapper(queryCache);
            Pair<List<TableValidWriteIds>, List<String>> p = this.getValidWriteIdsCache(cache, rqst);
            List fullTableNamesMissing = (List)p.getRight();
            List tblValidWriteIds = (List)p.getLeft();
            if (fullTableNamesMissing.isEmpty()) {
                return tblValidWriteIds;
            }
            List r = this.delegate.getValidWriteIds(fullTableNamesMissing, validTxnList);
            List<TableValidWriteIds> newTblValidWriteIds = this.loadValidWriteIdsCache(cache, r, rqst);
            return this.computeValidWriteIdsFinal(rqst, tblValidWriteIds, newTblValidWriteIds);
        }
        return this.delegate.getValidWriteIds(tablesList, validTxnList);
    }

    private Pair<List<TableValidWriteIds>, List<String>> getValidWriteIdsCache(MetaStoreClientCacheUtils.CacheI cache, GetValidWriteIdsRequest rqst) {
        ArrayList<String> fullTableNamesMissing = new ArrayList<String>();
        ArrayList<TableValidWriteIds> tblValidWriteIds = new ArrayList<TableValidWriteIds>();
        for (String fullTableName : rqst.getFullTableNames()) {
            MetaStoreClientCacheUtils.CacheKey cacheKey = new MetaStoreClientCacheUtils.CacheKey(MetaStoreClientCacheUtils.KeyType.VALID_WRITE_IDS, fullTableName, rqst.getValidTxnList(), rqst.getWriteId());
            TableValidWriteIds v = (TableValidWriteIds)cache.get(cacheKey);
            if (v == null) {
                fullTableNamesMissing.add(fullTableName);
                continue;
            }
            LOG.debug("Query level HMS cache: method=getValidWriteIdsInternal, fullTableName={}", (Object)fullTableName);
            tblValidWriteIds.add(v);
        }
        return Pair.of(tblValidWriteIds, fullTableNamesMissing);
    }

    private List<TableValidWriteIds> loadValidWriteIdsCache(MetaStoreClientCacheUtils.CacheI cache, List<TableValidWriteIds> r, GetValidWriteIdsRequest rqst) {
        ArrayList<TableValidWriteIds> newTblValidWriteIds = new ArrayList<TableValidWriteIds>();
        for (TableValidWriteIds tableValidWriteIds : r) {
            newTblValidWriteIds.add(tableValidWriteIds);
            MetaStoreClientCacheUtils.CacheKey cacheKey = new MetaStoreClientCacheUtils.CacheKey(MetaStoreClientCacheUtils.KeyType.VALID_WRITE_IDS, tableValidWriteIds.getFullTableName(), rqst.getValidTxnList(), rqst.getWriteId());
            cache.put(cacheKey, tableValidWriteIds);
        }
        return newTblValidWriteIds;
    }

    private List<TableValidWriteIds> computeValidWriteIdsFinal(GetValidWriteIdsRequest rqst, List<TableValidWriteIds> tblValidWriteIds, List<TableValidWriteIds> newTblValidWriteIds) {
        ArrayList<TableValidWriteIds> result = new ArrayList<TableValidWriteIds>();
        int i = 0;
        int j = 0;
        for (String fullTableName : rqst.getFullTableNames()) {
            if (i >= tblValidWriteIds.size() || j >= newTblValidWriteIds.size()) break;
            if (tblValidWriteIds.get(i).getFullTableName().equals(fullTableName)) {
                result.add(tblValidWriteIds.get(i));
                ++i;
                continue;
            }
            if (!newTblValidWriteIds.get(j).getFullTableName().equals(fullTableName)) continue;
            result.add(newTblValidWriteIds.get(j));
            ++j;
        }
        while (i < tblValidWriteIds.size()) {
            result.add(tblValidWriteIds.get(i));
            ++i;
        }
        while (j < newTblValidWriteIds.size()) {
            result.add(newTblValidWriteIds.get(j));
            ++j;
        }
        return result;
    }

    private Map<Object, Object> getQueryCache() {
        SessionState ss;
        String queryId = MetaStoreClientCacheUtils.getQueryId();
        if (queryId != null && (ss = SessionState.get()) != null) {
            return ss.getQueryCache(queryId);
        }
        return null;
    }

    private String getValidWriteIdList(String dbName, String tblName) {
        try {
            String validTxnsList = Hive.get().getConf().get("hive.txn.valid.txns");
            if (validTxnsList == null) {
                return HiveMetaStoreClientUtils.getValidWriteIdList((String)dbName, (String)tblName, (Configuration)this.conf);
            }
            if (!AcidUtils.isTransactionalTable(this.getTable(dbName, tblName))) {
                return null;
            }
            String validWriteIds = Hive.get().getConf().get("hive.txn.tables.valid.writeids");
            String fullTableName = TableName.getDbTable((String)dbName, (String)tblName);
            ValidTxnWriteIdList validTxnWriteIdList = validWriteIds != null ? ValidTxnWriteIdList.fromValue((String)validWriteIds) : TxnCommonUtils.createValidTxnWriteIdList((Long)SessionState.get().getTxnMgr().getCurrentTxnId(), this.getValidWriteIds((List<String>)ImmutableList.of((Object)fullTableName), validTxnsList));
            ValidWriteIdList writeIdList = validTxnWriteIdList.getTableValidWriteIdList(fullTableName);
            return writeIdList != null ? writeIdList.toString() : null;
        }
        catch (Exception e) {
            throw new RuntimeException("Exception getting valid write id list", e);
        }
    }

    public Map<String, List<ColumnStatisticsObj>> getPartitionColumnStatistics(String catName, String dbName, String tableName, List<String> partNames, List<String> colNames, String engine, String validWriteIdList) throws TException {
        if (validWriteIdList == null) {
            validWriteIdList = this.getValidWriteIdList(dbName, tableName);
        }
        return this.delegate.getPartitionColumnStatistics(catName, dbName, tableName, partNames, colNames, engine, validWriteIdList);
    }

    public GetPartitionResponse getPartitionRequest(GetPartitionRequest req) throws TException {
        if (req.getValidWriteIdList() == null) {
            req.setValidWriteIdList(this.getValidWriteIdList(req.getDbName(), req.getTblName()));
        }
        return this.delegate.getPartitionRequest(req);
    }

    public PartitionsResponse getPartitionsRequest(PartitionsRequest req) throws TException {
        if (req.getValidWriteIdList() == null) {
            req.setValidWriteIdList(this.getValidWriteIdList(req.getDbName(), req.getTblName()));
        }
        return this.delegate.getPartitionsRequest(req);
    }

    private static class MapWrapper
    implements MetaStoreClientCacheUtils.CacheI {
        final Map<Object, Object> m;

        protected MapWrapper(Map<Object, Object> m) {
            this.m = m;
        }

        @Override
        public void put(Object k, Object v) {
            this.m.put(k, v);
        }

        @Override
        public Object get(Object k) {
            return this.m.get(k);
        }
    }

    private static final class PartitionNamesComparator
    implements Comparator<Partition> {
        private org.apache.hadoop.hive.metastore.api.Table table;
        private PartitionsByExprRequest req;

        PartitionNamesComparator(org.apache.hadoop.hive.metastore.api.Table table, PartitionsByExprRequest req) {
            this.table = table;
            this.req = req;
        }

        @Override
        public int compare(Partition o1, Partition o2) {
            List orders = MetaStoreUtils.makeOrderSpecs((String)this.req.getOrder());
            for (Object[] order : orders) {
                String partVal2;
                int partKeyIndex = (Integer)order[0];
                boolean isAsc = "asc".equalsIgnoreCase((String)order[1]);
                String partVal1 = (String)o1.getValues().get(partKeyIndex);
                int val = partVal1.compareTo(partVal2 = (String)o2.getValues().get(partKeyIndex));
                if (val == 0) continue;
                if (partVal1.equals(this.req.getDefaultPartitionName())) {
                    return isAsc ? 1 : -1;
                }
                if (partVal2.equals(this.req.getDefaultPartitionName())) {
                    return isAsc ? -1 : 1;
                }
                String type = ((FieldSchema)this.table.getPartitionKeys().get(partKeyIndex)).getType();
                if (ColumnType.IntegralTypes.contains(type)) {
                    val = Double.valueOf(partVal1) - Double.valueOf(partVal2) > 0.0 ? 1 : -1;
                }
                return isAsc ? val : -val;
            }
            try {
                return Warehouse.makePartName((List)this.table.getPartitionKeys(), (List)o1.getValues()).compareTo(Warehouse.makePartName((List)this.table.getPartitionKeys(), (List)o2.getValues()));
            }
            catch (MetaException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

