/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.lockmgr.zookeeper;

import org.apache.curator.framework.CuratorFramework;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.common.util.ShutdownHookManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CuratorFrameworkSingleton {
    private static HiveConf conf = null;
    private static CuratorFramework sharedClient = null;
    static final Logger LOG = LoggerFactory.getLogger((String)"CuratorFrameworkSingleton");

    public static synchronized CuratorFramework getInstance(HiveConf hiveConf) {
        if (sharedClient == null) {
            conf = hiveConf == null ? new HiveConf() : hiveConf;
            sharedClient = conf.getZKConfig().getNewZookeeperClient();
            sharedClient.start();
        }
        return sharedClient;
    }

    public static synchronized void closeAndReleaseInstance() {
        if (sharedClient != null) {
            sharedClient.close();
            sharedClient = null;
            String shutdownMsg = "Closing ZooKeeper client.";
            LOG.info(shutdownMsg);
        }
    }

    static {
        ShutdownHookManager.addShutdownHook((Runnable)new Runnable(){

            @Override
            public void run() {
                CuratorFrameworkSingleton.closeAndReleaseInstance();
            }
        });
    }
}

