/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.timestamp;

import java.math.BigInteger;
import java.time.ZoneId;
import java.time.ZoneOffset;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.parquet.schema.LogicalTypeAnnotation;

public class ParquetTimestampUtils {
    private static final long MILLI = 1000L;
    private static final long MICRO = 1000000L;
    private static final long NANO = 1000000000L;

    public static Timestamp getTimestamp(long value, LogicalTypeAnnotation.TimeUnit timeUnit, boolean isAdjustedToUTC) {
        ZoneId zone = ZoneOffset.UTC;
        if (isAdjustedToUTC) {
            zone = ZoneId.systemDefault();
        }
        long seconds = 0L;
        long nanoseconds = 0L;
        switch (timeUnit) {
            case MILLIS: {
                seconds = value / 1000L;
                nanoseconds = value % 1000L * 1000000L;
                break;
            }
            case MICROS: {
                seconds = value / 1000000L;
                nanoseconds = value % 1000000L * 1000L;
                break;
            }
            case NANOS: {
                seconds = value / 1000000000L;
                nanoseconds = value % 1000000000L;
                break;
            }
        }
        return Timestamp.ofEpochSecond((long)seconds, (long)nanoseconds, (ZoneId)zone);
    }

    public static Long getInt64(Timestamp timestamp, LogicalTypeAnnotation.TimeUnit timeUnit) {
        switch (timeUnit) {
            case NANOS: {
                try {
                    BigInteger nanos = BigInteger.valueOf(timestamp.toEpochSecond()).multiply(BigInteger.valueOf(1000000000L)).add(BigInteger.valueOf(timestamp.getNanos()));
                    return nanos.longValueExact();
                }
                catch (ArithmeticException e) {
                    return null;
                }
            }
            case MICROS: {
                long secondsInMilli = timestamp.toEpochSecond() * 1000000L;
                return secondsInMilli + (long)timestamp.getNanos() / 1000L;
            }
            case MILLIS: {
                return timestamp.toEpochMilli();
            }
        }
        throw new IllegalArgumentException("Time unit not recognized");
    }
}

