/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc.encoded;

public class OrcBatchKey {
    public Object fileKey;
    public int stripeIx;
    public int rgIx;

    public OrcBatchKey(long file, int stripeIx, int rgIx) {
        this.set(file, stripeIx, rgIx);
    }

    public OrcBatchKey(Object file, int stripeIx, int rgIx) {
        this.set(file, stripeIx, rgIx);
    }

    public void set(Object file, int stripeIx, int rgIx) {
        this.fileKey = file;
        this.stripeIx = stripeIx;
        this.rgIx = rgIx;
    }

    public String toString() {
        return "[" + String.valueOf(this.fileKey) + ", stripe " + this.stripeIx + ", rgIx " + this.rgIx + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 31 + this.fileKey.hashCode();
        return (31 * result + this.rgIx) * 31 + this.stripeIx;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OrcBatchKey)) {
            return false;
        }
        OrcBatchKey other = (OrcBatchKey)obj;
        return this.stripeIx == other.stripeIx && this.rgIx == other.rgIx && (this.fileKey == null ? other.fileKey == null : this.fileKey.equals(other.fileKey));
    }

    public OrcBatchKey clone() throws CloneNotSupportedException {
        return new OrcBatchKey(this.fileKey, this.stripeIx, this.rgIx);
    }
}

