/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.wrapper;

import org.apache.hadoop.hive.ql.exec.vector.wrapper.VectorHashKeyWrapperBase;
import org.apache.hadoop.hive.ql.exec.vector.wrapper.VectorHashKeyWrapperEmpty;
import org.apache.hadoop.hive.ql.exec.vector.wrapper.VectorHashKeyWrapperGeneral;
import org.apache.hadoop.hive.ql.exec.vector.wrapper.VectorHashKeyWrapperSingleLong;
import org.apache.hadoop.hive.ql.exec.vector.wrapper.VectorHashKeyWrapperTwoLong;

public class VectorHashKeyWrapperFactory {
    public static VectorHashKeyWrapperBase allocate(VectorHashKeyWrapperBase.HashContext ctx, int longValuesCount, int doubleValuesCount, int byteValuesCount, int decimalValuesCount, int timestampValuesCount, int intervalDayTimeValuesCount, int keyCount) {
        int nonLongBytesCount = doubleValuesCount + decimalValuesCount + timestampValuesCount + intervalDayTimeValuesCount;
        if (nonLongBytesCount == 0 && byteValuesCount == 0) {
            if (longValuesCount == 1) {
                return new VectorHashKeyWrapperSingleLong();
            }
            if (longValuesCount == 2) {
                return new VectorHashKeyWrapperTwoLong();
            }
            if (longValuesCount == 0) {
                return VectorHashKeyWrapperEmpty.EMPTY_KEY_WRAPPER;
            }
        }
        return new VectorHashKeyWrapperGeneral(ctx, longValuesCount, doubleValuesCount, byteValuesCount, decimalValuesCount, timestampValuesCount, intervalDayTimeValuesCount, keyCount);
    }
}

