/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.ptf;

import com.google.common.base.Preconditions;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorBase;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;

public class VectorPTFEvaluatorStreamingLongAvg
extends VectorPTFEvaluatorBase {
    protected boolean isNull;
    protected long sum;
    private int nonNullGroupCount;
    protected double avg;

    public VectorPTFEvaluatorStreamingLongAvg(WindowFrameDef windowFrameDef, VectorExpression inputVecExpr, int outputColumnNum) {
        super(windowFrameDef, inputVecExpr, outputColumnNum);
        this.resetEvaluator();
    }

    @Override
    public void evaluateGroupBatch(VectorizedRowBatch batch) throws HiveException {
        this.evaluateInputExpr(batch);
        Preconditions.checkState((!batch.selectedInUse ? 1 : 0) != 0);
        int size = batch.size;
        if (size == 0) {
            return;
        }
        LongColumnVector longColVector = (LongColumnVector)batch.cols[this.inputColumnNum];
        DoubleColumnVector outputColVector = (DoubleColumnVector)batch.cols[this.outputColumnNum];
        double[] outputVector = outputColVector.vector;
        if (longColVector.isRepeating) {
            if (longColVector.noNulls || !longColVector.isNull[0]) {
                this.isNull = false;
                double repeatedValue = longColVector.vector[0];
                for (int i = 0; i < size; ++i) {
                    this.sum = (long)((double)this.sum + repeatedValue);
                    ++this.nonNullGroupCount;
                    outputVector[i] = this.avg = (double)(this.sum / (long)this.nonNullGroupCount);
                }
            } else {
                if (this.isNull) {
                    outputColVector.isNull[0] = true;
                    outputColVector.noNulls = false;
                } else {
                    outputVector[0] = this.avg;
                }
                outputColVector.isRepeating = true;
            }
        } else if (longColVector.noNulls) {
            this.isNull = false;
            long[] vector = longColVector.vector;
            for (int i = 0; i < size; ++i) {
                this.sum += vector[i];
                ++this.nonNullGroupCount;
                outputVector[i] = this.avg = (double)(this.sum / (long)this.nonNullGroupCount);
            }
        } else {
            boolean[] batchIsNull = longColVector.isNull;
            int i = 0;
            while (batchIsNull[i]) {
                outputColVector.isNull[i] = true;
                outputColVector.noNulls = false;
                if (++i < size) continue;
                return;
            }
            this.isNull = false;
            long[] vector = longColVector.vector;
            this.sum += vector[i];
            ++this.nonNullGroupCount;
            this.avg = this.sum / (long)this.nonNullGroupCount;
            outputVector[i++] = this.avg;
            while (i < size) {
                if (!batchIsNull[i]) {
                    this.sum += vector[i];
                    ++this.nonNullGroupCount;
                    outputVector[i] = this.avg = (double)(this.sum / (long)this.nonNullGroupCount);
                } else {
                    outputVector[i] = this.avg;
                }
                ++i;
            }
        }
    }

    @Override
    public boolean streamsResult() {
        return true;
    }

    @Override
    public ColumnVector.Type getResultColumnVectorType() {
        return ColumnVector.Type.DOUBLE;
    }

    @Override
    public void resetEvaluator() {
        this.isNull = true;
        this.sum = 0L;
        this.nonNullGroupCount = 0;
        this.avg = 0.0;
    }
}

