/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.ptf;

import com.google.common.base.Preconditions;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorBase;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;

public class VectorPTFEvaluatorLongLastValue
extends VectorPTFEvaluatorBase {
    protected boolean isGroupResultNull;
    protected Long lastValue = null;

    public VectorPTFEvaluatorLongLastValue(WindowFrameDef windowFrameDef, VectorExpression inputVecExpr, int outputColumnNum) {
        super(windowFrameDef, inputVecExpr, outputColumnNum);
        this.resetEvaluator();
    }

    @Override
    public void evaluateGroupBatch(VectorizedRowBatch batch) throws HiveException {
        this.evaluateInputExpr(batch);
        Preconditions.checkState((!batch.selectedInUse ? 1 : 0) != 0);
        int size = batch.size;
        if (size == 0) {
            return;
        }
        LongColumnVector longColVector = (LongColumnVector)batch.cols[this.inputColumnNum];
        if (longColVector.isRepeating) {
            if (longColVector.noNulls || !longColVector.isNull[0]) {
                this.lastValue = longColVector.vector[0];
                this.isGroupResultNull = false;
            } else {
                this.isGroupResultNull = this.doesRespectNulls() || this.lastValue == null;
            }
        } else if (longColVector.noNulls) {
            this.lastValue = longColVector.vector[size - 1];
            this.isGroupResultNull = false;
        } else if (this.doesRespectNulls()) {
            int lastBatchIndex = size - 1;
            if (!longColVector.isNull[lastBatchIndex]) {
                this.lastValue = longColVector.vector[lastBatchIndex];
                this.isGroupResultNull = false;
            } else {
                this.isGroupResultNull = true;
            }
        } else {
            this.isGroupResultNull = this.lastValue == null;
            for (int i = size - 1; i >= 0; --i) {
                if (longColVector.isNull[i]) continue;
                this.lastValue = longColVector.vector[i];
                this.isGroupResultNull = false;
                break;
            }
        }
    }

    @Override
    public boolean streamsResult() {
        return false;
    }

    @Override
    public boolean isGroupResultNull() {
        return this.isGroupResultNull;
    }

    @Override
    public ColumnVector.Type getResultColumnVectorType() {
        return ColumnVector.Type.LONG;
    }

    @Override
    public Object getGroupResult() {
        return this.lastValue;
    }

    @Override
    public void resetEvaluator() {
        this.isGroupResultNull = true;
        this.lastValue = null;
    }

    @Override
    public boolean isCacheableForRange() {
        return false;
    }
}

