/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.ptf;

import com.google.common.base.Preconditions;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorBase;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;

public class VectorPTFEvaluatorDecimalLastValue
extends VectorPTFEvaluatorBase {
    protected boolean isGroupResultNull;
    protected HiveDecimalWritable lastValue;

    public VectorPTFEvaluatorDecimalLastValue(WindowFrameDef windowFrameDef, VectorExpression inputVecExpr, int outputColumnNum) {
        super(windowFrameDef, inputVecExpr, outputColumnNum);
        this.resetEvaluator();
    }

    @Override
    public void evaluateGroupBatch(VectorizedRowBatch batch) throws HiveException {
        this.evaluateInputExpr(batch);
        Preconditions.checkState((!batch.selectedInUse ? 1 : 0) != 0);
        int size = batch.size;
        if (size == 0) {
            return;
        }
        DecimalColumnVector decimalColVector = (DecimalColumnVector)batch.cols[this.inputColumnNum];
        if (decimalColVector.isRepeating) {
            if (decimalColVector.noNulls || !decimalColVector.isNull[0]) {
                this.lastValue.set(decimalColVector.vector[0]);
                this.isGroupResultNull = false;
            } else {
                this.isGroupResultNull = this.doesRespectNulls() || !this.lastValue.isSet();
            }
        } else if (decimalColVector.noNulls) {
            this.lastValue.set(decimalColVector.vector[size - 1]);
            this.isGroupResultNull = false;
        } else if (this.doesRespectNulls()) {
            int lastBatchIndex = size - 1;
            if (!decimalColVector.isNull[lastBatchIndex]) {
                this.lastValue.set(decimalColVector.vector[lastBatchIndex]);
                this.isGroupResultNull = false;
            } else {
                this.isGroupResultNull = true;
            }
        } else {
            this.isGroupResultNull = !this.lastValue.isSet();
            for (int i = size - 1; i >= 0; --i) {
                if (decimalColVector.isNull[i]) continue;
                this.lastValue.set(decimalColVector.vector[i]);
                this.isGroupResultNull = false;
                break;
            }
        }
    }

    @Override
    public boolean streamsResult() {
        return false;
    }

    @Override
    public boolean isGroupResultNull() {
        return this.isGroupResultNull;
    }

    @Override
    public ColumnVector.Type getResultColumnVectorType() {
        return ColumnVector.Type.DECIMAL;
    }

    @Override
    public Object getGroupResult() {
        return this.lastValue;
    }

    @Override
    public void resetEvaluator() {
        this.isGroupResultNull = true;
        this.lastValue = new HiveDecimalWritable();
    }

    @Override
    public boolean isCacheableForRange() {
        return false;
    }
}

