/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.ptf;

import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorBase;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFGroupBatches;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;
import org.apache.hadoop.hive.ql.udf.ptf.Range;

public abstract class VectorPTFEvaluatorAbstractSum<T>
extends VectorPTFEvaluatorBase {
    protected boolean isGroupResultNull;
    protected T sum;
    protected T previousSum = null;
    protected Range previousRange = null;

    public VectorPTFEvaluatorAbstractSum(WindowFrameDef windowFrameDef, VectorExpression inputVecExpr, int outputColumnNum) {
        super(windowFrameDef, inputVecExpr, outputColumnNum);
    }

    @Override
    public boolean canRunOptimizedCalculation(int rowNum, Range range) {
        return this.previousRange != null && range.getSize() > range.getDiff(this.previousRange);
    }

    @Override
    public Object runOnRange(int rowNum, Range range, VectorPTFGroupBatches batches) throws HiveException {
        Range r1 = new Range(this.previousRange.getStart(), range.getStart(), batches);
        Range r2 = new Range(this.previousRange.getEnd(), range.getEnd(), batches);
        Object sum1 = batches.runEvaluatorOnRange(this, r1);
        Object sum2 = batches.runEvaluatorOnRange(this, r2);
        Object partial = this.previousSum == null && sum1 == null ? null : this.minus(this.computeValue(this.previousSum), this.computeValue(sum1));
        return partial == null && sum2 == null ? null : this.plus(this.computeValue(partial), this.computeValue(sum2));
    }

    @Override
    public boolean isGroupResultNull() {
        return this.isGroupResultNull;
    }

    public T getGroupResult() {
        return this.sum;
    }

    @Override
    public void onResultCalculated(Object result, Range range) {
        this.previousSum = result;
        this.previousRange = range;
    }

    @Override
    public void onPartitionEnd() {
        this.previousSum = null;
        this.previousRange = null;
    }

    @Override
    public boolean streamsResult() {
        return false;
    }

    protected abstract T plus(T var1, T var2);

    protected abstract T minus(T var1, T var2);

    protected abstract T computeValue(T var1);
}

