/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.DataTypePhysicalVariation;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.HashTableLoaderFactory;
import org.apache.hadoop.hive.ql.exec.HashTableLoader;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinTableContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinTableContainerSerDe;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorColumnMapping;
import org.apache.hadoop.hive.ql.exec.vector.VectorColumnOutputMapping;
import org.apache.hadoop.hive.ql.exec.vector.VectorColumnSourceMapping;
import org.apache.hadoop.hive.ql.exec.vector.VectorCopyRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorDeserializeRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContextRegion;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationOperator;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedBatchUtil;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastHashTableLoader;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashTable;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinTableContainer;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.optimized.VectorMapJoinOptimizedCreateHashTable;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.VectorDesc;
import org.apache.hadoop.hive.ql.plan.VectorMapJoinDesc;
import org.apache.hadoop.hive.ql.plan.VectorMapJoinInfo;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.serde2.binarysortable.fast.BinarySortableDeserializeRead;
import org.apache.hadoop.hive.serde2.lazybinary.fast.LazyBinaryDeserializeRead;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VectorMapJoinCommonOperator
extends MapJoinOperator
implements VectorizationOperator,
VectorizationContextRegion {
    private static final long serialVersionUID = 1L;
    private static final String CLASS_NAME = VectorMapJoinCommonOperator.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLASS_NAME);
    protected transient String loggingPrefix;
    protected VectorMapJoinDesc vectorDesc;
    protected VectorMapJoinInfo vectorMapJoinInfo;
    protected boolean isOuterJoin;
    protected byte posSingleVectorMapJoinSmallTable;
    protected VectorizationContext vContext;
    protected VectorizationContext vOutContext;
    protected VectorMapJoinDesc.VectorMapJoinVariation vectorMapJoinVariation;
    protected VectorMapJoinDesc.HashTableKind hashTableKind;
    protected VectorMapJoinDesc.HashTableKeyType hashTableKeyType;
    protected int[] outputProjection;
    protected TypeInfo[] outputTypeInfos;
    protected VectorExpression[] bigTableFilterExpressions;
    protected VectorExpression[] bigTableKeyExpressions;
    protected VectorExpression[] bigTableValueExpressions;
    protected int[] bigTableKeyColumnMap;
    protected String[] bigTableKeyColumnNames;
    protected TypeInfo[] bigTableKeyTypeInfos;
    protected int[] bigTableValueColumnMap;
    protected String[] bigTableValueColumnNames;
    protected TypeInfo[] bigTableValueTypeInfos;
    protected int[] bigTableRetainColumnMap;
    protected TypeInfo[] bigTableRetainTypeInfos;
    protected int[] nonOuterSmallTableKeyColumnMap;
    protected TypeInfo[] nonOuterSmallTableKeyTypeInfos;
    protected VectorColumnOutputMapping outerSmallTableKeyMapping;
    protected VectorColumnSourceMapping fullOuterSmallTableKeyMapping;
    protected VectorColumnSourceMapping smallTableValueMapping;
    protected VectorColumnSourceMapping projectionMapping;
    protected int[] outerSmallTableKeyColumnMap;
    protected int[] smallTableValueColumnMap;
    protected int[] bigTableByteColumnVectorColumns;
    protected int[] nonOuterSmallTableKeyByteColumnVectorColumns;
    protected int[] outerSmallTableKeyByteColumnVectorColumns;
    protected int[] smallTableByteColumnVectorColumns;
    protected transient boolean useOverflowRepeatedThreshold;
    protected transient int overflowRepeatedThreshold;
    protected transient VectorCopyRow bigTableRetainedVectorCopy;
    protected int[] allSmallTableKeyColumnNums;
    protected boolean[] allSmallTableKeyColumnIncluded;
    protected transient VectorDeserializeRow<BinarySortableDeserializeRead> smallTableKeyOuterVectorDeserializeRow;
    protected transient VectorCopyRow nonOuterSmallTableKeyVectorCopy;
    protected transient VectorCopyRow outerSmallTableKeyVectorCopy;
    protected transient VectorDeserializeRow<LazyBinaryDeserializeRead> smallTableValueVectorDeserializeRow;
    protected transient VectorizedRowBatch overflowBatch;
    protected transient VectorizedRowBatch spillReplayBatch;
    protected transient boolean needCommonSetup;
    protected transient boolean needFirstBatchSetup;
    protected transient boolean needHashTableSetup;
    protected transient VectorMapJoinHashTable vectorMapJoinHashTable;
    protected transient long batchCounter;
    protected transient long rowCounter;

    protected abstract String getLoggingPrefix();

    protected String getLoggingPrefix(String className) {
        if (this.loggingPrefix == null) {
            this.initLoggingPrefix(className);
        }
        return this.loggingPrefix;
    }

    protected void initLoggingPrefix(String className) {
        this.loggingPrefix = className;
    }

    protected VectorMapJoinCommonOperator() {
    }

    public VectorMapJoinCommonOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    public VectorMapJoinCommonOperator(CompilationOpContext ctx, OperatorDesc conf, VectorizationContext vContext, VectorDesc vectorDesc) throws HiveException {
        super(ctx);
        MapJoinDesc desc = (MapJoinDesc)conf;
        this.conf = desc;
        this.vectorDesc = (VectorMapJoinDesc)vectorDesc;
        this.vectorMapJoinInfo = this.vectorDesc.getVectorMapJoinInfo();
        Preconditions.checkState((this.vectorMapJoinInfo != null ? 1 : 0) != 0);
        this.vContext = vContext;
        this.vOutContext = new VectorizationContext(this.getName(), this.vContext);
        this.order = desc.getTagOrder();
        this.posBigTable = (byte)desc.getPosBigTable();
        this.posSingleVectorMapJoinSmallTable = this.order[0] == this.posBigTable ? this.order[1] : this.order[0];
        this.isOuterJoin = !desc.getNoOuterJoin();
        this.vectorMapJoinVariation = this.vectorDesc.getVectorMapJoinVariation();
        this.hashTableKind = this.vectorDesc.getHashTableKind();
        this.hashTableKeyType = this.vectorDesc.getHashTableKeyType();
        this.bigTableKeyColumnMap = this.vectorMapJoinInfo.getBigTableKeyColumnMap();
        this.bigTableKeyColumnNames = this.vectorMapJoinInfo.getBigTableKeyColumnNames();
        this.bigTableKeyTypeInfos = this.vectorMapJoinInfo.getBigTableKeyTypeInfos();
        this.bigTableKeyExpressions = this.vectorMapJoinInfo.getSlimmedBigTableKeyExpressions();
        this.bigTableValueColumnMap = this.vectorMapJoinInfo.getBigTableValueColumnMap();
        this.bigTableValueColumnNames = this.vectorMapJoinInfo.getBigTableValueColumnNames();
        this.bigTableValueTypeInfos = this.vectorMapJoinInfo.getBigTableValueTypeInfos();
        this.bigTableValueExpressions = this.vectorMapJoinInfo.getSlimmedBigTableValueExpressions();
        this.bigTableFilterExpressions = this.vectorMapJoinInfo.getBigTableFilterExpressions();
        this.bigTableRetainColumnMap = this.vectorMapJoinInfo.getBigTableRetainColumnMap();
        this.bigTableRetainTypeInfos = this.vectorMapJoinInfo.getBigTableRetainTypeInfos();
        this.nonOuterSmallTableKeyColumnMap = this.vectorMapJoinInfo.getNonOuterSmallTableKeyColumnMap();
        this.nonOuterSmallTableKeyTypeInfos = this.vectorMapJoinInfo.getNonOuterSmallTableKeyTypeInfos();
        this.outerSmallTableKeyMapping = this.vectorMapJoinInfo.getOuterSmallTableKeyMapping();
        this.fullOuterSmallTableKeyMapping = this.vectorMapJoinInfo.getFullOuterSmallTableKeyMapping();
        this.smallTableValueMapping = this.vectorMapJoinInfo.getSmallTableValueMapping();
        this.projectionMapping = this.vectorMapJoinInfo.getProjectionMapping();
        this.determineCommonInfo(this.isOuterJoin);
    }

    protected void determineCommonInfo(boolean isOuter) throws HiveException {
        this.outerSmallTableKeyColumnMap = this.outerSmallTableKeyMapping.getOutputColumns();
        this.smallTableValueColumnMap = this.smallTableValueMapping.getOutputColumns();
        this.bigTableByteColumnVectorColumns = this.getByteColumnVectorColumns(this.bigTableRetainColumnMap, this.bigTableRetainTypeInfos);
        this.nonOuterSmallTableKeyByteColumnVectorColumns = this.getByteColumnVectorColumns(this.nonOuterSmallTableKeyColumnMap, this.nonOuterSmallTableKeyTypeInfos);
        this.outerSmallTableKeyByteColumnVectorColumns = this.getByteColumnVectorColumns(this.outerSmallTableKeyMapping);
        this.smallTableByteColumnVectorColumns = this.getByteColumnVectorColumns(this.smallTableValueMapping);
        this.outputProjection = this.projectionMapping.getOutputColumns();
        this.outputTypeInfos = this.projectionMapping.getTypeInfos();
        if (LOG.isInfoEnabled()) {
            int[] orderDisplayable = new int[this.order.length];
            for (int i = 0; i < this.order.length; ++i) {
                orderDisplayable[i] = this.order[i].byteValue();
            }
            LOG.info(this.getLoggingPrefix() + " order " + Arrays.toString(orderDisplayable));
            LOG.info(this.getLoggingPrefix() + " posBigTable " + this.posBigTable);
            LOG.info(this.getLoggingPrefix() + " posSingleVectorMapJoinSmallTable " + this.posSingleVectorMapJoinSmallTable);
            LOG.info(this.getLoggingPrefix() + " bigTableKeyColumnMap " + Arrays.toString(this.bigTableKeyColumnMap));
            LOG.info(this.getLoggingPrefix() + " bigTableKeyColumnNames " + Arrays.toString(this.bigTableKeyColumnNames));
            LOG.info(this.getLoggingPrefix() + " bigTableKeyTypeInfos " + Arrays.toString(this.bigTableKeyTypeInfos));
            LOG.info(this.getLoggingPrefix() + " bigTableValueColumnMap " + Arrays.toString(this.bigTableValueColumnMap));
            LOG.info(this.getLoggingPrefix() + " bigTableValueColumnNames " + Arrays.toString(this.bigTableValueColumnNames));
            LOG.info(this.getLoggingPrefix() + " bigTableValueTypeNames " + Arrays.toString(this.bigTableValueTypeInfos));
            LOG.info(this.getLoggingPrefix() + " getBigTableRetainColumnMap " + Arrays.toString(this.bigTableRetainColumnMap));
            LOG.info(this.getLoggingPrefix() + " bigTableRetainTypeInfos " + Arrays.toString(this.bigTableRetainTypeInfos));
            LOG.info(this.getLoggingPrefix() + " nonOuterSmallTableKeyColumnMap " + Arrays.toString(this.nonOuterSmallTableKeyColumnMap));
            LOG.info(this.getLoggingPrefix() + " nonOuterSmallTableKeyTypeInfos " + Arrays.toString(this.nonOuterSmallTableKeyTypeInfos));
            LOG.info(this.getLoggingPrefix() + " outerSmallTableKeyMapping " + this.outerSmallTableKeyMapping.toString());
            LOG.info(this.getLoggingPrefix() + " fullOuterSmallTableKeyMapping " + this.fullOuterSmallTableKeyMapping.toString());
            LOG.info(this.getLoggingPrefix() + " smallTableValueMapping " + this.smallTableValueMapping.toString());
            LOG.info(this.getLoggingPrefix() + " bigTableByteColumnVectorColumns " + Arrays.toString(this.bigTableByteColumnVectorColumns));
            LOG.info(this.getLoggingPrefix() + " smallTableByteColumnVectorColumns " + Arrays.toString(this.smallTableByteColumnVectorColumns));
            LOG.info(this.getLoggingPrefix() + " outputProjection " + Arrays.toString(this.outputProjection));
            LOG.info(this.getLoggingPrefix() + " outputTypeInfos " + Arrays.toString(this.outputTypeInfos));
            LOG.info(this.getLoggingPrefix() + " mapJoinDesc.getKeysString " + String.valueOf(((MapJoinDesc)this.conf).getKeysString()));
            if (((MapJoinDesc)this.conf).getValueIndices() != null) {
                for (Map.Entry<Byte, int[]> entry : ((MapJoinDesc)this.conf).getValueIndices().entrySet()) {
                    LOG.info(this.getLoggingPrefix() + " mapJoinDesc.getValueIndices +" + entry.getKey() + " " + Arrays.toString(entry.getValue()));
                }
            }
            LOG.info(this.getLoggingPrefix() + " mapJoinDesc.getExprs " + ((MapJoinDesc)this.conf).getExprs().toString());
            LOG.info(this.getLoggingPrefix() + " mapJoinDesc.getRetainList " + ((MapJoinDesc)this.conf).getRetainList().toString());
        }
        this.setupVOutContext(((MapJoinDesc)this.conf).getOutputColumnNames());
    }

    private int[] getByteColumnVectorColumns(VectorColumnMapping mapping) {
        return this.getByteColumnVectorColumns(mapping.getOutputColumns(), mapping.getTypeInfos());
    }

    private int[] getByteColumnVectorColumns(int[] outputColumns, TypeInfo[] typeInfos) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int count = outputColumns.length;
        for (int i = 0; i < count; ++i) {
            int outputColumn = outputColumns[i];
            String typeName = typeInfos[i].getTypeName();
            if (!VectorizationContext.isStringFamily(typeName)) continue;
            list.add(outputColumn);
        }
        return ArrayUtils.toPrimitive((Integer[])list.toArray(new Integer[0]));
    }

    protected void setupVOutContext(List<String> outputColumnNames) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.getLoggingPrefix() + " outputColumnNames " + String.valueOf(outputColumnNames));
        }
        if (outputColumnNames.size() != this.outputProjection.length) {
            throw new RuntimeException("Output column names " + String.valueOf(outputColumnNames) + " length and output projection " + Arrays.toString(this.outputProjection) + " / " + Arrays.toString(this.outputTypeInfos) + " length mismatch");
        }
        this.vOutContext.resetProjectionColumns();
        for (int i = 0; i < outputColumnNames.size(); ++i) {
            String columnName = outputColumnNames.get(i);
            int outputColumn = this.outputProjection[i];
            this.vOutContext.addProjectionColumn(columnName, outputColumn);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug(this.getLoggingPrefix() + " addProjectionColumn " + i + " columnName " + columnName + " outputColumn " + outputColumn);
        }
    }

    @Override
    protected HashTableLoader getHashTableLoader(Configuration hconf) {
        VectorMapJoinDesc.HashTableImplementationType hashTableImplementationType = this.vectorDesc.getHashTableImplementationType();
        return switch (this.vectorDesc.getHashTableImplementationType()) {
            case VectorMapJoinDesc.HashTableImplementationType.OPTIMIZED -> HashTableLoaderFactory.getLoader(hconf);
            case VectorMapJoinDesc.HashTableImplementationType.FAST -> new VectorMapJoinFastHashTableLoader();
            default -> throw new RuntimeException("Unknown vector map join hash table implementation type " + hashTableImplementationType.name());
        };
    }

    private void initializeFullOuterObjects() throws HiveException {
        TypeInfo[] smallTableKeyTypeInfos = this.bigTableKeyTypeInfos;
        int allKeysSize = smallTableKeyTypeInfos.length;
        this.allSmallTableKeyColumnNums = new int[allKeysSize];
        Arrays.fill(this.allSmallTableKeyColumnNums, -1);
        this.allSmallTableKeyColumnIncluded = new boolean[allKeysSize];
        int outputKeysSize = this.fullOuterSmallTableKeyMapping.getCount();
        int[] outputKeyNums = this.fullOuterSmallTableKeyMapping.getInputColumns();
        int[] outputKeyOutputColumns = this.fullOuterSmallTableKeyMapping.getOutputColumns();
        for (int i = 0; i < outputKeysSize; ++i) {
            int outputKeyNum = outputKeyNums[i];
            this.allSmallTableKeyColumnNums[outputKeyNum] = outputKeyOutputColumns[i];
            this.allSmallTableKeyColumnIncluded[outputKeyNum] = true;
        }
        if (this.hashTableKeyType == VectorMapJoinDesc.HashTableKeyType.MULTI_KEY && outputKeysSize > 0) {
            this.smallTableKeyOuterVectorDeserializeRow = new VectorDeserializeRow<BinarySortableDeserializeRead>(BinarySortableDeserializeRead.with((TypeInfo[])smallTableKeyTypeInfos, (boolean)true, (Properties)((MapJoinDesc)this.getConf()).getKeyTblDesc().getProperties()));
            this.smallTableKeyOuterVectorDeserializeRow.init(this.allSmallTableKeyColumnNums, this.allSmallTableKeyColumnIncluded);
        }
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        super.initializeOp(hconf);
        VectorExpression.doTransientInit(this.bigTableFilterExpressions, hconf);
        VectorExpression.doTransientInit(this.bigTableKeyExpressions, hconf);
        VectorExpression.doTransientInit(this.bigTableValueExpressions, hconf);
        VectorExpression.doTransientInit(this.bigTableValueExpressions, hconf);
        this.overflowRepeatedThreshold = HiveConf.getIntVar((Configuration)hconf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_VECTORIZATION_MAPJOIN_NATIVE_OVERFLOW_REPEATED_THRESHOLD);
        boolean bl = this.useOverflowRepeatedThreshold = this.overflowRepeatedThreshold >= 0;
        if (this.vectorMapJoinVariation == VectorMapJoinDesc.VectorMapJoinVariation.FULL_OUTER) {
            this.initializeFullOuterObjects();
        }
        if (this.smallTableValueMapping.getCount() > 0) {
            this.smallTableValueVectorDeserializeRow = new VectorDeserializeRow<LazyBinaryDeserializeRead>(new LazyBinaryDeserializeRead(this.smallTableValueMapping.getTypeInfos(), true));
            this.smallTableValueVectorDeserializeRow.init(this.smallTableValueMapping.getOutputColumns());
        }
        if (this.bigTableRetainColumnMap.length > 0) {
            this.bigTableRetainedVectorCopy = new VectorCopyRow();
            this.bigTableRetainedVectorCopy.init(this.bigTableRetainColumnMap, this.bigTableRetainTypeInfos);
        }
        if (this.nonOuterSmallTableKeyColumnMap.length > 0) {
            this.nonOuterSmallTableKeyVectorCopy = new VectorCopyRow();
            this.nonOuterSmallTableKeyVectorCopy.init(this.nonOuterSmallTableKeyColumnMap, this.nonOuterSmallTableKeyTypeInfos);
        }
        if (this.outerSmallTableKeyMapping.getCount() > 0) {
            this.outerSmallTableKeyVectorCopy = new VectorCopyRow();
            this.outerSmallTableKeyVectorCopy.init(this.outerSmallTableKeyMapping);
        }
        this.overflowBatch = this.setupOverflowBatch();
        this.needCommonSetup = true;
        this.needFirstBatchSetup = true;
        this.needHashTableSetup = true;
        if (LOG.isDebugEnabled()) {
            int[] currentScratchColumns = this.vOutContext.currentScratchColumns();
            LOG.debug(this.getLoggingPrefix() + " VectorMapJoinCommonOperator initializeOp currentScratchColumns " + Arrays.toString(currentScratchColumns));
            StructObjectInspector structOutputObjectInspector = (StructObjectInspector)this.outputObjInspector;
            List fields = structOutputObjectInspector.getAllStructFieldRefs();
            int i = 0;
            for (StructField field : fields) {
                LOG.debug(this.getLoggingPrefix() + " VectorMapJoinCommonOperator initializeOp " + i + " field " + field.getFieldName() + " type " + field.getFieldObjectInspector().getTypeName());
                ++i;
            }
        }
    }

    @Override
    protected void completeInitializationOp(Object[] os) throws HiveException {
        super.completeInitializationOp(os);
        if (this.isTestingNoHashTableLoad) {
            return;
        }
        MapJoinTableContainer mapJoinTableContainer = this.mapJoinTables[this.posSingleVectorMapJoinSmallTable];
        this.setUpHashTable();
    }

    @Override
    @VisibleForTesting
    public void setTestMapJoinTableContainer(int posSmallTable, MapJoinTableContainer testMapJoinTableContainer, MapJoinTableContainerSerDe mapJoinTableContainerSerDe) {
        this.mapJoinTables[this.posSingleVectorMapJoinSmallTable] = testMapJoinTableContainer;
        this.setUpHashTable();
    }

    private void setUpHashTable() {
        VectorMapJoinDesc.HashTableImplementationType hashTableImplementationType = this.vectorDesc.getHashTableImplementationType();
        switch (this.vectorDesc.getHashTableImplementationType()) {
            case OPTIMIZED: {
                this.vectorMapJoinHashTable = VectorMapJoinOptimizedCreateHashTable.createHashTable((MapJoinDesc)this.conf, this.mapJoinTables[this.posSingleVectorMapJoinSmallTable]);
                break;
            }
            case FAST: {
                VectorMapJoinTableContainer vectorMapJoinTableContainer = (VectorMapJoinTableContainer)this.mapJoinTables[this.posSingleVectorMapJoinSmallTable];
                this.vectorMapJoinHashTable = vectorMapJoinTableContainer.vectorMapJoinHashTable();
                break;
            }
            default: {
                throw new RuntimeException("Unknown vector map join hash table implementation type " + hashTableImplementationType.name());
            }
        }
        LOG.info("Using " + this.vectorMapJoinHashTable.getClass().getSimpleName() + " from " + this.getClass().getSimpleName());
    }

    protected VectorizedRowBatch setupOverflowBatch() throws HiveException {
        int initialColumnCount = this.vContext.firstOutputColumnIndex();
        int totalNumColumns = initialColumnCount + this.vOutContext.getScratchColumnTypeNames().length;
        VectorizedRowBatch overflowBatch = new VectorizedRowBatch(totalNumColumns);
        for (int i = 0; i < this.outputProjection.length; ++i) {
            int outputColumn = this.outputProjection[i];
            String typeName = this.outputTypeInfos[i].getTypeName();
            this.allocateOverflowBatchColumnVector(overflowBatch, outputColumn, typeName, this.vOutContext.getDataTypePhysicalVariation(outputColumn));
        }
        int outputColumn = initialColumnCount;
        for (String typeName : this.vOutContext.getScratchColumnTypeNames()) {
            this.allocateOverflowBatchColumnVector(overflowBatch, outputColumn, typeName, this.vOutContext.getDataTypePhysicalVariation(outputColumn++));
        }
        overflowBatch.projectedColumns = this.outputProjection;
        overflowBatch.projectionSize = this.outputProjection.length;
        overflowBatch.reset();
        return overflowBatch;
    }

    private void allocateOverflowBatchColumnVector(VectorizedRowBatch overflowBatch, int outputColumn, String typeName, DataTypePhysicalVariation dataTypePhysicalVariation) {
        if (overflowBatch.cols[outputColumn] == null) {
            typeName = VectorizationContext.mapTypeNameSynonyms(typeName);
            TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromTypeString((String)typeName);
            overflowBatch.cols[outputColumn] = VectorizedBatchUtil.createColumnVector(typeInfo, dataTypePhysicalVariation);
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.getLoggingPrefix() + " VectorMapJoinCommonOperator initializeOp overflowBatch outputColumn " + outputColumn + " class " + overflowBatch.cols[outputColumn].getClass().getSimpleName());
            }
        }
    }

    protected void commonSetup() throws HiveException {
        BytesColumnVector bytesColumnVector;
        for (int column : this.bigTableByteColumnVectorColumns) {
            bytesColumnVector = (BytesColumnVector)this.overflowBatch.cols[column];
            bytesColumnVector.initBuffer();
        }
        for (int column : this.nonOuterSmallTableKeyByteColumnVectorColumns) {
            bytesColumnVector = (BytesColumnVector)this.overflowBatch.cols[column];
            bytesColumnVector.initBuffer();
        }
        for (int column : this.outerSmallTableKeyByteColumnVectorColumns) {
            bytesColumnVector = (BytesColumnVector)this.overflowBatch.cols[column];
            bytesColumnVector.initBuffer();
        }
        for (int column : this.smallTableByteColumnVectorColumns) {
            bytesColumnVector = (BytesColumnVector)this.overflowBatch.cols[column];
            bytesColumnVector.initBuffer();
        }
        this.batchCounter = 0L;
        this.rowCounter = 0L;
    }

    public void firstBatchSetup(VectorizedRowBatch batch) throws HiveException {
        for (int column : this.smallTableByteColumnVectorColumns) {
            BytesColumnVector bytesColumnVector = (BytesColumnVector)batch.cols[column];
            bytesColumnVector.initBuffer();
        }
        this.spillReplayBatch = VectorizedBatchUtil.makeLike(batch);
    }

    public void hashTableSetup() throws HiveException {
    }

    public abstract void processBatch(VectorizedRowBatch var1) throws HiveException;

    @Override
    public void process(Object row, int tag) throws HiveException {
        VectorizedRowBatch batch = (VectorizedRowBatch)row;
        this.alias = (byte)tag;
        if (this.needCommonSetup) {
            this.commonSetup();
            this.needCommonSetup = false;
        }
        if (this.needFirstBatchSetup) {
            this.firstBatchSetup(batch);
            this.needFirstBatchSetup = false;
        }
        if (this.needHashTableSetup) {
            this.hashTableSetup();
            this.needHashTableSetup = false;
        }
        ++this.batchCounter;
        if (batch.size == 0) {
            return;
        }
        this.rowCounter += (long)batch.size;
        this.processBatch(batch);
    }

    protected void displayBatchColumns(VectorizedRowBatch batch, String batchName) {
        LOG.debug(this.getLoggingPrefix() + " VectorMapJoinCommonOperator commonSetup " + batchName + " column count " + batch.numCols);
        for (int column = 0; column < batch.numCols; ++column) {
            LOG.debug(this.getLoggingPrefix() + " VectorMapJoinCommonOperator commonSetup " + batchName + "     column " + column + " type " + (batch.cols[column] == null ? "NULL" : batch.cols[column].getClass().getSimpleName()));
        }
    }

    @Override
    public OperatorType getType() {
        return OperatorType.MAPJOIN;
    }

    @Override
    public VectorizationContext getInputVectorizationContext() {
        return this.vContext;
    }

    @Override
    public VectorDesc getVectorDesc() {
        return this.vectorDesc;
    }

    @Override
    public VectorizationContext getOutputVectorizationContext() {
        return this.vOutContext;
    }
}

