/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates;

import java.io.Serializable;
import org.apache.hadoop.hive.common.type.DataTypePhysicalVariation;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorAggregationBufferRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorAggregationDesc;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public abstract class VectorAggregateExpression
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final VectorAggregationDesc vecAggrDesc;
    protected final VectorExpression inputExpression;
    protected final TypeInfo inputTypeInfo;
    protected final TypeInfo outputTypeInfo;
    protected final DataTypePhysicalVariation outputDataTypePhysicalVariation;
    protected final GenericUDAFEvaluator.Mode mode;
    public static final int AVERAGE_COUNT_FIELD_INDEX = 0;
    public static final int AVERAGE_SUM_FIELD_INDEX = 1;
    public static final int AVERAGE_SOURCE_FIELD_INDEX = 2;
    public static final int VARIANCE_COUNT_FIELD_INDEX = 0;
    public static final int VARIANCE_SUM_FIELD_INDEX = 1;
    public static final int VARIANCE_VARIANCE_FIELD_INDEX = 2;

    public VectorAggregateExpression() {
        this.vecAggrDesc = null;
        this.inputExpression = null;
        this.inputTypeInfo = null;
        this.outputTypeInfo = null;
        this.outputDataTypePhysicalVariation = null;
        this.mode = null;
    }

    public VectorAggregateExpression(VectorAggregationDesc vecAggrDesc) {
        this.vecAggrDesc = vecAggrDesc;
        this.inputExpression = vecAggrDesc.getInputExpression();
        this.inputTypeInfo = this.inputExpression != null ? this.inputExpression.getOutputTypeInfo() : null;
        this.outputTypeInfo = vecAggrDesc.getOutputTypeInfo();
        this.outputDataTypePhysicalVariation = vecAggrDesc.getOutputDataTypePhysicalVariation();
        this.mode = vecAggrDesc.getUdafEvaluatorMode();
    }

    public VectorExpression getInputExpression() {
        return this.inputExpression;
    }

    public TypeInfo getOutputTypeInfo() {
        return this.outputTypeInfo;
    }

    public DataTypePhysicalVariation getOutputDataTypePhysicalVariation() {
        return this.outputDataTypePhysicalVariation;
    }

    public abstract AggregationBuffer getNewAggregationBuffer() throws HiveException;

    public abstract void aggregateInput(AggregationBuffer var1, VectorizedRowBatch var2) throws HiveException;

    public abstract void aggregateInputSelection(VectorAggregationBufferRow[] var1, int var2, VectorizedRowBatch var3) throws HiveException;

    public abstract void reset(AggregationBuffer var1) throws HiveException;

    public abstract long getAggregationBufferFixedSize();

    public boolean hasVariableSize() {
        return false;
    }

    public abstract boolean matches(String var1, ColumnVector.Type var2, ColumnVector.Type var3, GenericUDAFEvaluator.Mode var4);

    public abstract void assignRowColumn(VectorizedRowBatch var1, int var2, int var3, AggregationBuffer var4) throws HiveException;

    public String toString() {
        return this.vecAggrDesc.toString();
    }

    public void finish(AggregationBuffer aggregationBuffer, boolean aborted) {
    }

    public boolean batchNeedsClone() {
        return false;
    }

    public static interface AggregationBuffer
    extends Serializable {
        public int getVariableSize();

        public void reset();
    }
}

