/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.nio.charset.CharacterCodingException;
import java.text.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFTimestampFieldString;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.InstantFormatter;
import org.apache.hadoop.io.Text;

public final class VectorUDFUnixTimeStampString
extends VectorUDFTimestampFieldString {
    private static final long serialVersionUID = 1L;
    private transient InstantFormatter formatter;

    public VectorUDFUnixTimeStampString(int colNum, int outputColumnNum) {
        super(colNum, outputColumnNum, -1, -1);
    }

    public VectorUDFUnixTimeStampString() {
    }

    @Override
    public void transientInit(Configuration conf) throws HiveException {
        super.transientInit(conf);
        if (this.formatter == null) {
            this.formatter = InstantFormatter.ofConfiguration(conf);
        }
    }

    @Override
    protected long getField(byte[] bytes, int start, int length) throws ParseException {
        try {
            return this.formatter.parse(Text.decode((byte[])bytes, (int)start, (int)length)).getEpochSecond();
        }
        catch (RuntimeException | CharacterCodingException e) {
            throw new ParseException(e.getMessage(), 0);
        }
    }
}

