/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.ConditionalTask;
import org.apache.hadoop.hive.ql.exec.Task;

public class DAGTraversal {
    public static void traverse(List<Task<?>> tasks, Function function) {
        ArrayList<Task<Object>> listOfTasks = new ArrayList(tasks);
        while (!listOfTasks.isEmpty()) {
            HashSet children = new HashSet();
            for (Task task : listOfTasks) {
                if (function.skipProcessing(task)) continue;
                if (task instanceof ConditionalTask) {
                    children.addAll(((ConditionalTask)task).getListTasks());
                }
                if (task.getDependentTasks() != null) {
                    children.addAll(task.getDependentTasks());
                }
                function.process(task);
            }
            listOfTasks = new ArrayList(children);
        }
    }

    public static interface Function {
        public void process(Task<?> var1);

        public boolean skipProcessing(Task<?> var1);
    }
}

