/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.primitives.UnsignedBytes;
import com.google.protobuf.ByteString;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.tez.CustomEdgeConfiguration;
import org.apache.hadoop.hive.ql.exec.tez.CustomPartitionEdge;
import org.apache.hadoop.hive.ql.exec.tez.CustomVertexConfiguration;
import org.apache.hadoop.hive.ql.exec.tez.DataInputByteBuffer;
import org.apache.hadoop.hive.ql.exec.tez.SplitGrouper;
import org.apache.hadoop.hive.ql.exec.tez.Utils;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.apache.hadoop.hive.ql.plan.TezWork;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.serializer.SerializationFactory;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.split.SplitLocationProvider;
import org.apache.hadoop.mapred.split.TezGroupedSplit;
import org.apache.tez.common.TezUtils;
import org.apache.tez.dag.api.EdgeManagerPluginDescriptor;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.api.VertexLocationHint;
import org.apache.tez.dag.api.VertexManagerPlugin;
import org.apache.tez.dag.api.VertexManagerPluginContext;
import org.apache.tez.mapreduce.hadoop.MRInputHelpers;
import org.apache.tez.mapreduce.protos.MRRuntimeProtos;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.InputSpecUpdate;
import org.apache.tez.runtime.api.events.CustomProcessorEvent;
import org.apache.tez.runtime.api.events.InputConfigureVertexTasksEvent;
import org.apache.tez.runtime.api.events.InputDataInformationEvent;
import org.apache.tez.runtime.api.events.InputUpdatePayloadEvent;
import org.apache.tez.runtime.api.events.VertexManagerEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomPartitionVertex
extends VertexManagerPlugin {
    private static final Logger LOG = LoggerFactory.getLogger((String)CustomPartitionVertex.class.getName());
    VertexManagerPluginContext context;
    private InputConfigureVertexTasksEvent configureVertexTaskEvent;
    private int numBuckets = -1;
    private Configuration conf = null;
    private final SplitGrouper grouper = new SplitGrouper();
    private int taskCount = 0;
    private TezWork.VertexType vertexType;
    private String mainWorkName;
    private final Multimap<Integer, Integer> bucketToTaskMap = HashMultimap.create();
    private final Map<String, Multimap<Integer, InputSplit>> inputToGroupedSplitMap = new HashMap<String, Multimap<Integer, InputSplit>>();
    private int numInputsAffectingRootInputSpecUpdate = 1;
    private int numInputsSeenSoFar = 0;
    private final Map<String, EdgeManagerPluginDescriptor> emMap = Maps.newHashMap();
    private final List<InputSplit> finalSplits = Lists.newLinkedList();
    private final Map<String, InputSpecUpdate> inputNameInputSpecMap = new HashMap<String, InputSpecUpdate>();
    private Map<String, Integer> inputToBucketMap;

    public CustomPartitionVertex(VertexManagerPluginContext context) {
        super(context);
    }

    public void initialize() {
        this.context = this.getContext();
        ByteBuffer payload = this.context.getUserPayload().getPayload();
        CustomVertexConfiguration vertexConf = new CustomVertexConfiguration();
        DataInputByteBuffer dibb = new DataInputByteBuffer();
        dibb.reset(payload);
        try {
            vertexConf.readFields(dibb);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.numBuckets = vertexConf.getNumBuckets();
        this.mainWorkName = vertexConf.getInputName();
        this.vertexType = vertexConf.getVertexType();
        this.numInputsAffectingRootInputSpecUpdate = vertexConf.getNumInputs();
        this.inputToBucketMap = vertexConf.getInputToBucketMap();
    }

    public void onVertexStarted(Map<String, List<Integer>> completions) {
        int numTasks = this.context.getVertexNumTasks(this.context.getVertexName());
        ArrayList<VertexManagerPluginContext.TaskWithLocationHint> scheduledTasks = new ArrayList<VertexManagerPluginContext.TaskWithLocationHint>(numTasks);
        for (int i = 0; i < numTasks; ++i) {
            scheduledTasks.add(new VertexManagerPluginContext.TaskWithLocationHint(Integer.valueOf(i), null));
        }
        this.context.scheduleVertexTasks(scheduledTasks);
    }

    public void onSourceTaskCompleted(String srcVertexName, Integer attemptId) {
    }

    public void onVertexManagerEventReceived(VertexManagerEvent vmEvent) {
    }

    public void onRootVertexInitialized(String inputName, InputDescriptor inputDescriptor, List<Event> events) {
        ++this.numInputsSeenSoFar;
        LOG.info("On root vertex initialized " + inputName);
        try {
            MRRuntimeProtos.MRInputUserPayloadProto protoPayload = MRInputHelpers.parseMRInputPayload((UserPayload)inputDescriptor.getUserPayload());
            this.conf = TezUtils.createConfFromByteString((ByteString)protoPayload.getConfigurationBytes());
            MRRuntimeProtos.MRInputUserPayloadProto updatedPayload = MRRuntimeProtos.MRInputUserPayloadProto.newBuilder((MRRuntimeProtos.MRInputUserPayloadProto)protoPayload).setGroupingEnabled(true).build();
            inputDescriptor.setUserPayload(UserPayload.create((ByteBuffer)updatedPayload.toByteString().asReadOnlyByteBuffer()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        boolean dataInformationEventSeen = false;
        TreeMap<Integer, Set<HiveInputFormat.HiveInputSplit>> bucketFileSplitsMap = new TreeMap<Integer, Set<HiveInputFormat.HiveInputSplit>>();
        for (Event event : events) {
            HiveInputFormat.HiveInputSplit inputSplit;
            if (event instanceof InputConfigureVertexTasksEvent) {
                InputConfigureVertexTasksEvent cEvent;
                LOG.info("Got a input configure vertex event for input: " + inputName);
                Preconditions.checkState((!dataInformationEventSeen ? 1 : 0) != 0);
                this.configureVertexTaskEvent = cEvent = (InputConfigureVertexTasksEvent)event;
                LOG.info("Configure task for input name: " + inputName + " num tasks: " + this.configureVertexTaskEvent.getNumTasks());
            }
            if (event instanceof InputUpdatePayloadEvent) {
                Preconditions.checkState((boolean)false);
                continue;
            }
            if (!(event instanceof InputDataInformationEvent)) continue;
            dataInformationEventSeen = true;
            InputDataInformationEvent diEvent = (InputDataInformationEvent)event;
            try {
                inputSplit = this.getInputSplitFromEvent(diEvent);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to get file split for event: " + String.valueOf(diEvent), e);
            }
            int bucketId = inputSplit.getBucketId().orElse(-1);
            Set inputSplits = bucketFileSplitsMap.computeIfAbsent(bucketId, k -> new TreeSet<HiveInputFormat.HiveInputSplit>(new HiveInputSplitComparator()));
            inputSplits.add(inputSplit);
        }
        LOG.debug("Bucket splits map for input name: {} is {}", (Object)inputName, bucketFileSplitsMap);
        Multimap<Integer, InputSplit> bucketToInitialSplitMap = this.getBucketSplitMapForBucket(inputName, bucketFileSplitsMap);
        Preconditions.checkState((boolean)bucketToInitialSplitMap.keySet().stream().allMatch(i -> 0 <= i && i < this.numBuckets));
        try {
            int totalResource = this.context.getTotalAvailableResource().getMemory();
            int taskResource = this.context.getVertexTaskResource().getMemory();
            float waves = this.conf.getFloat("tez.grouping.split-waves", 1.7f);
            int availableSlots = totalResource / taskResource;
            LOG.debug("Grouping splits. {} available slots, {} waves. Bucket initial splits map: {}", new Object[]{availableSlots, Float.valueOf(waves), bucketToInitialSplitMap});
            JobConf jobConf = new JobConf(this.conf);
            ShimLoader.getHadoopShims().getMergedCredentials(jobConf);
            HashMultimap bucketToGroupedSplitMap = HashMultimap.create();
            boolean secondLevelGroupingDone = false;
            if (this.mainWorkName.isEmpty() || inputName.compareTo(this.mainWorkName) == 0) {
                SplitLocationProvider splitLocationProvider = Utils.getSplitLocationProvider(this.conf, LOG);
                for (Integer key : bucketToInitialSplitMap.keySet()) {
                    InputSplit[] inputSplitArray = bucketToInitialSplitMap.get((Object)key).toArray(new InputSplit[0]);
                    Multimap<Integer, InputSplit> groupedSplit = this.grouper.generateGroupedSplits(jobConf, this.conf, inputSplitArray, waves, availableSlots, inputName, this.mainWorkName.isEmpty(), splitLocationProvider);
                    if (!this.mainWorkName.isEmpty()) {
                        HashMultimap singleBucketToGroupedSplit = HashMultimap.create();
                        singleBucketToGroupedSplit.putAll((Object)key, (Iterable)groupedSplit.values());
                        groupedSplit = this.grouper.group((Configuration)jobConf, (Multimap<Integer, InputSplit>)singleBucketToGroupedSplit, availableSlots, HiveConf.getFloatVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.TEZ_SMB_NUMBER_WAVES), null);
                        secondLevelGroupingDone = true;
                    }
                    bucketToGroupedSplitMap.putAll((Object)key, (Iterable)groupedSplit.values());
                }
                this.processAllEvents(inputName, (Multimap<Integer, InputSplit>)bucketToGroupedSplitMap, secondLevelGroupingDone);
            } else {
                SplitLocationProvider splitLocationProvider = Utils.getSplitLocationProvider(this.conf, LOG);
                for (Integer key : bucketToInitialSplitMap.keySet()) {
                    InputSplit[] inputSplitArray = bucketToInitialSplitMap.get((Object)key).toArray(new InputSplit[0]);
                    Multimap<Integer, InputSplit> groupedSplit = this.grouper.generateGroupedSplits(jobConf, this.conf, inputSplitArray, waves, availableSlots, inputName, false, splitLocationProvider);
                    bucketToGroupedSplitMap.putAll((Object)key, (Iterable)groupedSplit.values());
                }
                LOG.info("This is the side work - multi-mr work.");
                this.processAllSideEventsSetParallelism(inputName, (Multimap<Integer, InputSplit>)bucketToGroupedSplitMap);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void processAllSideEventsSetParallelism(String inputName, Multimap<Integer, InputSplit> bucketToGroupedSplitMap) throws IOException {
        LOG.info("Processing events for input " + inputName);
        if (this.inputNameInputSpecMap.get(this.mainWorkName) == null) {
            LOG.info("We don't have a routing table yet. Will need to wait for the main input " + this.mainWorkName + " initialization");
            this.inputToGroupedSplitMap.put(inputName, bucketToGroupedSplitMap);
            return;
        }
        this.processAllSideEvents(inputName, bucketToGroupedSplitMap);
        this.setVertexParallelismAndRootInputSpec(this.inputNameInputSpecMap);
    }

    private void processAllSideEvents(String inputName, Multimap<Integer, InputSplit> bucketToGroupedSplitMap) throws IOException {
        ArrayList<InputDataInformationEvent> taskEvents = new ArrayList<InputDataInformationEvent>();
        LOG.info("We have a routing table and we are going to set the destination tasks for the multi mr inputs. " + String.valueOf(this.bucketToTaskMap));
        Object[] numSplitsForTask = new Integer[this.taskCount];
        Arrays.fill(numSplitsForTask, (Object)0);
        LinkedListMultimap bucketToSerializedSplitMap = LinkedListMultimap.create();
        for (Map.Entry entry : bucketToGroupedSplitMap.asMap().entrySet()) {
            for (InputSplit split : (Collection)entry.getValue()) {
                MRRuntimeProtos.MRSplitProto serializedSplit = MRInputHelpers.createSplitProto((InputSplit)split);
                ByteBuffer bs = serializedSplit.toByteString().asReadOnlyByteBuffer();
                bucketToSerializedSplitMap.put((Object)((Integer)entry.getKey()), (Object)bs);
            }
        }
        for (Map.Entry entry : bucketToSerializedSplitMap.asMap().entrySet()) {
            Collection destTasks = this.bucketToTaskMap.get((Object)((Integer)entry.getKey()));
            if (destTasks == null || destTasks.isEmpty()) continue;
            for (Integer task : destTasks) {
                int count = 0;
                for (ByteBuffer buf : (Collection)entry.getValue()) {
                    InputDataInformationEvent diEvent = InputDataInformationEvent.createWithSerializedPayload((int)(++count), (ByteBuffer)buf);
                    diEvent.setTargetIndex(task.intValue());
                    taskEvents.add(diEvent);
                }
                Object[] objectArray = numSplitsForTask;
                int n = task;
                Integer.valueOf((Integer)objectArray[n] + count);
            }
        }
        this.inputNameInputSpecMap.put(inputName, InputSpecUpdate.createPerTaskInputSpecUpdate(Arrays.asList(numSplitsForTask)));
        LOG.info("For input name: " + inputName + " task events size is " + taskEvents.size());
        this.context.addRootInputEvents(inputName, taskEvents);
    }

    /*
     * WARNING - void declaration
     */
    private void processAllEvents(String inputName, Multimap<Integer, InputSplit> bucketToGroupedSplitMap, boolean secondLevelGroupingDone) throws IOException {
        int totalInputsCount = 0;
        ArrayList<Integer> numSplitsForTask = new ArrayList<Integer>();
        for (Map.Entry entry : bucketToGroupedSplitMap.asMap().entrySet()) {
            int n = (Integer)entry.getKey();
            Collection initialSplits = (Collection)entry.getValue();
            this.finalSplits.addAll(initialSplits);
            for (InputSplit inputSplit : initialSplits) {
                this.bucketToTaskMap.put((Object)n, (Object)this.taskCount);
                if (secondLevelGroupingDone) {
                    TezGroupedSplit groupedSplit = (TezGroupedSplit)inputSplit;
                    numSplitsForTask.add(groupedSplit.getGroupedSplits().size());
                    totalInputsCount += groupedSplit.getGroupedSplits().size();
                } else {
                    numSplitsForTask.add(1);
                    ++totalInputsCount;
                }
                ++this.taskCount;
            }
        }
        this.inputNameInputSpecMap.put(inputName, InputSpecUpdate.createPerTaskInputSpecUpdate(numSplitsForTask));
        EdgeManagerPluginDescriptor hiveEdgeManagerDesc = null;
        if (this.vertexType == TezWork.VertexType.MULTI_INPUT_INITIALIZED_EDGES || this.vertexType == TezWork.VertexType.INITIALIZED_EDGES) {
            hiveEdgeManagerDesc = EdgeManagerPluginDescriptor.create((String)CustomPartitionEdge.class.getName());
            UserPayload payload = this.getBytePayload(this.bucketToTaskMap);
            hiveEdgeManagerDesc.setUserPayload(payload);
        }
        for (Map.Entry entry : this.context.getInputVertexEdgeProperties().entrySet()) {
            if (((EdgeProperty)entry.getValue()).getDataMovementType() != EdgeProperty.DataMovementType.CUSTOM || !((EdgeProperty)entry.getValue()).getEdgeManagerDescriptor().getClassName().equals(CustomPartitionEdge.class.getName())) continue;
            this.emMap.put((String)entry.getKey(), hiveEdgeManagerDesc);
        }
        LOG.info("Task count is " + this.taskCount + " for input name: " + inputName);
        ArrayList taskEvents = Lists.newArrayListWithCapacity((int)totalInputsCount);
        boolean bl = false;
        for (InputSplit inputSplit : this.finalSplits) {
            void var8_11;
            if (secondLevelGroupingDone) {
                TezGroupedSplit tezGroupedSplit = (TezGroupedSplit)inputSplit;
                for (InputSplit subSplit : tezGroupedSplit.getGroupedSplits()) {
                    if (!(subSplit instanceof TezGroupedSplit)) {
                        throw new IOException("Unexpected split type found: " + subSplit.getClass().getCanonicalName());
                    }
                    MRRuntimeProtos.MRSplitProto serializedSplit = MRInputHelpers.createSplitProto((InputSplit)subSplit);
                    InputDataInformationEvent diEvent = InputDataInformationEvent.createWithSerializedPayload((int)var8_11, (ByteBuffer)serializedSplit.toByteString().asReadOnlyByteBuffer());
                    diEvent.setTargetIndex((int)var8_11);
                    taskEvents.add(diEvent);
                }
            } else {
                MRRuntimeProtos.MRSplitProto serializedSplit = MRInputHelpers.createSplitProto((InputSplit)inputSplit);
                InputDataInformationEvent diEvent = InputDataInformationEvent.createWithSerializedPayload((int)var8_11, (ByteBuffer)serializedSplit.toByteString().asReadOnlyByteBuffer());
                diEvent.setTargetIndex((int)var8_11);
                taskEvents.add(diEvent);
            }
            ++var8_11;
        }
        LOG.info("For input name: " + inputName + " task events size is " + taskEvents.size());
        this.context.addRootInputEvents(inputName, (Collection)taskEvents);
        if (!this.inputToGroupedSplitMap.isEmpty()) {
            for (Map.Entry entry : this.inputToGroupedSplitMap.entrySet()) {
                this.processAllSideEvents((String)entry.getKey(), (Multimap<Integer, InputSplit>)((Multimap)entry.getValue()));
            }
            this.setVertexParallelismAndRootInputSpec(this.inputNameInputSpecMap);
            this.inputToGroupedSplitMap.clear();
        }
        if (this.numInputsAffectingRootInputSpecUpdate == 1) {
            this.setVertexParallelismAndRootInputSpec(this.inputNameInputSpecMap);
            this.sendBucketIdsToProcessor();
        }
    }

    private void sendBucketIdsToProcessor() {
        for (Map.Entry entry : this.bucketToTaskMap.asMap().entrySet()) {
            int bucketNum = (Integer)entry.getKey();
            for (Integer taskId : (Collection)entry.getValue()) {
                ByteBuffer buffer = ByteBuffer.allocate(8);
                buffer.putInt(this.numBuckets);
                buffer.putInt(bucketNum);
                buffer.flip();
                CustomProcessorEvent cpEvent = CustomProcessorEvent.create((ByteBuffer)buffer);
                this.context.sendEventToProcessor(Collections.singletonList(cpEvent), taskId.intValue());
            }
        }
    }

    private void setVertexParallelismAndRootInputSpec(Map<String, InputSpecUpdate> rootInputSpecUpdate) throws IOException {
        if (this.numInputsAffectingRootInputSpecUpdate != this.numInputsSeenSoFar) {
            return;
        }
        LOG.info("Setting vertex parallelism since we have seen all inputs.");
        boolean generateConsistentSplits = HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_TEZ_GENERATE_CONSISTENT_SPLITS);
        LOG.info("GenerateConsistenSplitsInHive=" + generateConsistentSplits);
        this.context.setVertexParallelism(this.taskCount, VertexLocationHint.create(this.grouper.createTaskLocationHints(this.finalSplits.toArray(new InputSplit[this.finalSplits.size()]), generateConsistentSplits)), this.emMap, rootInputSpecUpdate);
        this.finalSplits.clear();
    }

    UserPayload getBytePayload(Multimap<Integer, Integer> routingTable) throws IOException {
        CustomEdgeConfiguration edgeConf = new CustomEdgeConfiguration(this.numBuckets, routingTable);
        DataOutputBuffer dob = new DataOutputBuffer();
        edgeConf.write((DataOutput)dob);
        byte[] serialized = dob.getData();
        return UserPayload.create((ByteBuffer)ByteBuffer.wrap(serialized));
    }

    private HiveInputFormat.HiveInputSplit getInputSplitFromEvent(InputDataInformationEvent event) throws IOException {
        InputSplit inputSplit;
        if (event.getDeserializedUserPayload() != null) {
            inputSplit = (InputSplit)event.getDeserializedUserPayload();
        } else {
            MRRuntimeProtos.MRSplitProto splitProto = MRRuntimeProtos.MRSplitProto.parseFrom((ByteString)ByteString.copyFrom((ByteBuffer)event.getUserPayload()));
            SerializationFactory serializationFactory = new SerializationFactory(new Configuration());
            inputSplit = MRInputHelpers.createOldFormatSplitFromUserPayload((MRRuntimeProtos.MRSplitProto)splitProto, (SerializationFactory)serializationFactory);
        }
        if (!(inputSplit instanceof HiveInputFormat.HiveInputSplit)) {
            throw new UnsupportedOperationException("Cannot handle splits other than HiveInputSplit for the moment. Current input split type: " + inputSplit.getClass().getSimpleName());
        }
        return (HiveInputFormat.HiveInputSplit)inputSplit;
    }

    /*
     * Could not resolve type clashes
     */
    private Multimap<Integer, InputSplit> getBucketSplitMapForBucket(String inputName, Map<Integer, Set<HiveInputFormat.HiveInputSplit>> bucketSplitsMap) {
        boolean isSMBJoin = this.numInputsAffectingRootInputSpecUpdate != 1;
        boolean isMainWork = this.mainWorkName.isEmpty() || inputName.compareTo(this.mainWorkName) == 0;
        Preconditions.checkState((isMainWork || isSMBJoin && this.inputToBucketMap != null && this.inputToBucketMap.containsKey(inputName) ? 1 : 0) != 0, (String)"CustomPartitionVertex.inputToBucketMap is not defined for {}", (Object)inputName);
        int inputBucketSize = isMainWork ? this.numBuckets : this.inputToBucketMap.get(inputName);
        ArrayListMultimap bucketToSplitMap = ArrayListMultimap.create();
        boolean fallback = false;
        for (Map.Entry<Integer, Set<HiveInputFormat.HiveInputSplit>> entry : bucketSplitsMap.entrySet()) {
            int bucketId = entry.getKey();
            if (bucketId < 0) {
                fallback = true;
                LOG.info("Fallback to using older sort based logic to assign buckets to splits.");
                bucketToSplitMap.clear();
                break;
            }
            bucketToSplitMap.putAll((Object)(bucketId %= inputBucketSize), (Iterable)entry.getValue());
        }
        if (fallback) {
            int curSplitIndex = 0;
            for (Map.Entry entry : bucketSplitsMap.entrySet()) {
                int bucketId = curSplitIndex % inputBucketSize;
                bucketToSplitMap.putAll((Object)bucketId, (Iterable)entry.getValue());
                ++curSplitIndex;
            }
        }
        if (isSMBJoin && this.numBuckets != inputBucketSize) {
            int gcd = BigInteger.valueOf(this.numBuckets).gcd(BigInteger.valueOf(inputBucketSize)).intValue();
            ArrayListMultimap bucketIdRemainderSplitMap = ArrayListMultimap.create();
            for (Map.Entry entry : bucketToSplitMap.asMap().entrySet()) {
                int smallTableBucketId = (Integer)entry.getKey();
                int remainder = smallTableBucketId % gcd;
                bucketIdRemainderSplitMap.putAll((Object)remainder, (Iterable)entry.getValue());
            }
            ArrayListMultimap redistributedBucketSplitMap = ArrayListMultimap.create();
            for (int bigTableBucketId = 0; bigTableBucketId < this.numBuckets; ++bigTableBucketId) {
                int remainder = bigTableBucketId % gcd;
                redistributedBucketSplitMap.putAll((Object)bigTableBucketId, (Iterable)bucketIdRemainderSplitMap.get((Object)remainder));
            }
            bucketToSplitMap = redistributedBucketSplitMap;
        }
        return bucketToSplitMap;
    }

    private static class HiveInputSplitComparator
    implements Comparator<HiveInputFormat.HiveInputSplit> {
        private HiveInputSplitComparator() {
        }

        @Override
        public int compare(HiveInputFormat.HiveInputSplit inp1, HiveInputFormat.HiveInputSplit inp2) {
            return UnsignedBytes.lexicographicalComparator().compare(inp1.getBytesForEquality(), inp2.getBytesForEquality());
        }
    }
}

