/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import org.apache.atlas.model.impexp.AtlasImportRequest;
import org.apache.atlas.model.impexp.AtlasImportResult;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.utils.SecurityUtils;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.repl.AtlasLoadWork;
import org.apache.hadoop.hive.ql.exec.repl.atlas.AtlasReplInfo;
import org.apache.hadoop.hive.ql.exec.repl.atlas.AtlasRequestBuilder;
import org.apache.hadoop.hive.ql.exec.repl.atlas.AtlasRestClientBuilder;
import org.apache.hadoop.hive.ql.exec.repl.util.ReplUtils;
import org.apache.hadoop.hive.ql.exec.util.Retryable;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.load.log.AtlasLoadLogger;
import org.apache.hadoop.hive.ql.parse.repl.metric.event.Status;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasLoadTask
extends Task<AtlasLoadWork>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(AtlasLoadTask.class);

    public AtlasLoadTask() {
    }

    @VisibleForTesting
    AtlasLoadTask(HiveConf conf, AtlasLoadWork work) {
        this.conf = conf;
        this.work = work;
    }

    @Override
    public int execute() {
        try {
            SecurityUtils.reloginExpiringKeytabUser();
            AtlasReplInfo atlasReplInfo = this.createAtlasReplInfo();
            HashMap<String, Long> metricMap = new HashMap<String, Long>();
            metricMap.put(ReplUtils.MetricName.ENTITIES.name(), 0L);
            ((AtlasLoadWork)this.work).getMetricCollector().reportStageStart(this.getName(), metricMap);
            LOG.info("Loading atlas metadata from srcDb: {} to tgtDb: {} from staging: {}", new Object[]{atlasReplInfo.getSrcDB(), atlasReplInfo.getTgtDB(), atlasReplInfo.getStagingDir()});
            AtlasLoadLogger replLogger = new AtlasLoadLogger(atlasReplInfo.getSrcDB(), atlasReplInfo.getTgtDB(), atlasReplInfo.getStagingDir().toString());
            replLogger.startLog();
            int importCount = this.importAtlasMetadata(atlasReplInfo);
            replLogger.endLog(importCount);
            ((AtlasLoadWork)this.work).getMetricCollector().reportStageProgress(this.getName(), ReplUtils.MetricName.ENTITIES.name(), importCount);
            LOG.info("Atlas entities import count {}", (Object)importCount);
            ((AtlasLoadWork)this.work).getMetricCollector().reportStageEnd(this.getName(), Status.SUCCESS);
            return 0;
        }
        catch (RuntimeException e) {
            LOG.error("RuntimeException while loading atlas metadata", (Throwable)e);
            this.setException(e);
            try {
                ReplUtils.handleException(true, e, ((AtlasLoadWork)this.work).getStagingDir().getParent().toString(), ((AtlasLoadWork)this.work).getMetricCollector(), this.getName(), this.conf);
            }
            catch (Exception ex) {
                LOG.error("Failed to collect replication metrics: ", (Throwable)ex);
            }
            throw e;
        }
        catch (Exception e) {
            LOG.error("Exception while loading atlas metadata", (Throwable)e);
            this.setException(e);
            int errorCode = ErrorMsg.getErrorMsg((String)e.getMessage()).getErrorCode();
            try {
                return ReplUtils.handleException(true, e, ((AtlasLoadWork)this.work).getStagingDir().getParent().toString(), ((AtlasLoadWork)this.work).getMetricCollector(), this.getName(), this.conf);
            }
            catch (Exception ex) {
                LOG.error("Failed to collect replication metrics: ", (Throwable)ex);
                return errorCode;
            }
        }
    }

    AtlasReplInfo createAtlasReplInfo() throws SemanticException, MalformedURLException {
        String errorFormat = "%s is mandatory config for Atlas metadata replication";
        String endpoint = new URL(ReplUtils.getNonEmpty(HiveConf.ConfVars.REPL_ATLAS_ENDPOINT.varname, this.conf, errorFormat)).toString();
        String srcCluster = ReplUtils.getNonEmpty(HiveConf.ConfVars.REPL_SOURCE_CLUSTER_NAME.varname, this.conf, errorFormat);
        String tgtCluster = ReplUtils.getNonEmpty(HiveConf.ConfVars.REPL_TARGET_CLUSTER_NAME.varname, this.conf, errorFormat);
        AtlasReplInfo atlasReplInfo = new AtlasReplInfo(endpoint, ((AtlasLoadWork)this.work).getSrcDB(), ((AtlasLoadWork)this.work).getTgtDB(), srcCluster, tgtCluster, ((AtlasLoadWork)this.work).getStagingDir(), this.conf);
        atlasReplInfo.setSrcFsUri(this.getStoredFsUri(atlasReplInfo.getStagingDir()));
        atlasReplInfo.setTgtFsUri(this.conf.get("fs.defaultFS"));
        return atlasReplInfo;
    }

    private String getStoredFsUri(Path atlasDumpDir) throws SemanticException {
        Path metadataPath = new Path(atlasDumpDir, "_metadata");
        Retryable retryable = Retryable.builder().withHiveConf(this.conf).withRetryOnException(IOException.class).build();
        try {
            return retryable.executeCallable(() -> {
                try (BufferedReader br = null;){
                    FileSystem fs = metadataPath.getFileSystem((Configuration)this.conf);
                    br = new BufferedReader(new InputStreamReader((InputStream)fs.open(metadataPath), Charset.defaultCharset()));
                    String line = br.readLine();
                    if (line == null) {
                        throw new SemanticException(ErrorMsg.REPL_INVALID_INTERNAL_CONFIG_FOR_SERVICE.format(new String[]{"Could not read stored src FS Uri from atlas metadata file", "atlas"}));
                    }
                    String[] lineContents = line.split("\t", 5);
                    String string = lineContents[0];
                    return string;
                }
            });
        }
        catch (Exception e) {
            throw new SemanticException(ErrorMsg.REPL_RETRY_EXHAUSTED.format(e.getMessage()), (Throwable)e);
        }
    }

    private int importAtlasMetadata(AtlasReplInfo atlasReplInfo) throws Exception {
        AtlasRequestBuilder atlasRequestBuilder = new AtlasRequestBuilder();
        AtlasImportRequest importRequest = atlasRequestBuilder.createImportRequest(atlasReplInfo.getSrcDB(), atlasReplInfo.getTgtDB(), atlasReplInfo.getSrcCluster(), atlasReplInfo.getTgtCluster(), atlasReplInfo.getSrcFsUri(), atlasReplInfo.getTgtFsUri());
        AtlasImportResult result = new AtlasRestClientBuilder(atlasReplInfo.getAtlasEndpoint()).getClient(atlasReplInfo.getConf()).importData(importRequest, atlasReplInfo);
        if (result == null || result.getProcessedEntities() == null) {
            LOG.info("No Atlas entity found");
            return 0;
        }
        return result.getProcessedEntities().size();
    }

    @Override
    public StageType getType() {
        return StageType.ATLAS_LOAD;
    }

    public String getName() {
        return "ATLAS_LOAD";
    }

    @Override
    public boolean canExecuteInParallel() {
        return false;
    }
}

