/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.HiveWritableComparator;
import org.apache.hadoop.hive.ql.exec.WritableComparatorFactory;
import org.apache.hadoop.hive.ql.util.NullOrdering;
import org.apache.hadoop.io.WritableComparator;

final class HiveStructComparator
extends HiveWritableComparator {
    private final List<WritableComparator> comparators = new ArrayList<WritableComparator>();

    HiveStructComparator(boolean nullSafe, NullOrdering nullOrdering) {
        super(nullSafe, nullOrdering);
    }

    @Override
    public int compare(Object key1, Object key2) {
        int i;
        int result = this.checkNull(key1, key2);
        if (result != 2) {
            return result;
        }
        List a1 = (List)key1;
        List a2 = (List)key2;
        if (a1.size() != a2.size()) {
            return a1.size() > a2.size() ? 1 : -1;
        }
        if (a1.size() == 0) {
            return 0;
        }
        for (i = this.comparators.size(); i < a1.size(); ++i) {
            this.comparators.add(i, WritableComparatorFactory.get(a1.get(i), this.nullSafe, this.nullOrdering));
        }
        result = 0;
        for (i = 0; i < a1.size(); ++i) {
            result = this.comparators.get(i).compare(a1.get(i), a2.get(i));
            if (result == 0) continue;
            return result;
        }
        return result;
    }
}

