/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.view.materialized.alter.rewrite;

import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.metastore.api.SourceTable;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLDesc;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.view.materialized.alter.rewrite.AlterMaterializedViewRewriteDesc;
import org.apache.hadoop.hive.ql.ddl.view.materialized.update.MaterializedViewUpdateDesc;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;

@DDLSemanticAnalyzerFactory.DDLType(types={916})
public class AlterMaterializedViewRewriteAnalyzer
extends BaseSemanticAnalyzer {
    private DDLDesc.DDLDescWithWriteId ddlDescWithWriteId;

    public AlterMaterializedViewRewriteAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode root) throws SemanticException {
        TableName tableName = AlterMaterializedViewRewriteAnalyzer.getQualifiedTableName((ASTNode)root.getChild(0));
        boolean rewriteEnable = switch (root.getChild(1).getType()) {
            case 1188 -> true;
            case 1187 -> false;
            default -> throw new SemanticException("Invalid alter materialized view expression");
        };
        Table materializedViewTable = this.getTable(tableName, true);
        if (rewriteEnable) {
            for (SourceTable sourceTable : materializedViewTable.getMVMetadata().getSourceTables()) {
                Table table = new Table(sourceTable.getTable());
                if (AcidUtils.isTransactionalTable(sourceTable.getTable()) || table.isNonNative() && table.getStorageHandler().areSnapshotsSupported()) continue;
                throw new SemanticException("Automatic rewriting for materialized view cannot be enabled if the materialized view uses non-transactional tables");
            }
        }
        AlterMaterializedViewRewriteDesc desc = new AlterMaterializedViewRewriteDesc(tableName.getNotEmptyDbTable(), rewriteEnable);
        if (AcidUtils.isTransactionalTable(materializedViewTable)) {
            this.ddlDescWithWriteId = desc;
        }
        this.inputs.add(new ReadEntity(materializedViewTable));
        WriteEntity.WriteType type = MetaStoreUtils.isNonNativeTable((org.apache.hadoop.hive.metastore.api.Table)materializedViewTable.getTTable()) && materializedViewTable.getStorageHandler().areSnapshotsSupported() ? WriteEntity.WriteType.DDL_SHARED : (AcidUtils.isLocklessReadsEnabled(materializedViewTable, this.conf) ? WriteEntity.WriteType.DDL_EXCL_WRITE : WriteEntity.WriteType.DDL_EXCLUSIVE);
        this.outputs.add(new WriteEntity(materializedViewTable, type));
        DDLWork work = new DDLWork(this.getInputs(), this.getOutputs(), desc);
        Task<DDLWork> targetTask = TaskFactory.get(work);
        MaterializedViewUpdateDesc materializedViewUpdateDesc = new MaterializedViewUpdateDesc(tableName.getNotEmptyDbTable(), rewriteEnable, !rewriteEnable, false);
        DDLWork updateDdlWork = new DDLWork(this.getInputs(), this.getOutputs(), materializedViewUpdateDesc);
        targetTask.addDependentTask(TaskFactory.get(updateDdlWork, this.conf));
        this.rootTasks.add(targetTask);
    }

    @Override
    public DDLDesc.DDLDescWithWriteId getAcidDdlDesc() {
        return this.ddlDescWithWriteId;
    }
}

