/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.view.create;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.ddl.DDLDescWithTableProperties;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Explain(displayName="Create Materialized View", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class CreateMaterializedViewDesc
extends DDLDescWithTableProperties
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(CreateMaterializedViewDesc.class);
    private String viewName;
    private String originalText;
    private String expandedText;
    private boolean rewriteEnabled;
    private Set<TableName> tablesUsed;
    private List<String> sortColNames;
    private List<FieldSchema> sortCols;
    private List<String> distributeColNames;
    private List<FieldSchema> distributeCols;

    public CreateMaterializedViewDesc(String viewName, List<FieldSchema> schema, String comment, Map<String, String> tblProps, List<String> partColNames, List<String> sortColNames, List<String> distributeColNames, boolean ifNotExists, boolean rewriteEnabled, String inputFormat, String outputFormat, String location, String serde, String storageHandler, Map<String, String> serdeProps) {
        super(schema, null, comment, inputFormat, outputFormat, location, serde, storageHandler, serdeProps, tblProps, ifNotExists);
        this.viewName = viewName;
        this.partColNames = partColNames;
        this.sortColNames = sortColNames;
        this.distributeColNames = distributeColNames;
        this.rewriteEnabled = rewriteEnabled;
    }

    @Explain(displayName="name", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getViewName() {
        return this.viewName;
    }

    @Override
    public TableName getFullTableName() {
        return TableName.fromString((String)this.viewName, null, null);
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    @Explain(displayName="original text", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getViewOriginalText() {
        return this.originalText;
    }

    public void setViewOriginalText(String originalText) {
        this.originalText = originalText;
    }

    @Explain(displayName="expanded text")
    public String getViewExpandedText() {
        return this.expandedText;
    }

    public void setViewExpandedText(String expandedText) {
        this.expandedText = expandedText;
    }

    @Explain(displayName="rewrite enabled", displayOnlyOnTrue=true)
    public boolean isRewriteEnabled() {
        return this.rewriteEnabled;
    }

    public void setRewriteEnabled(boolean rewriteEnabled) {
        this.rewriteEnabled = rewriteEnabled;
    }

    public boolean isOrganized() {
        return this.sortColNames != null && !this.sortColNames.isEmpty() || this.distributeColNames != null && !this.distributeColNames.isEmpty();
    }

    @Explain(displayName="sort columns")
    public List<String> getSortColsString() {
        return Utilities.getFieldSchemaString(this.sortCols);
    }

    public List<FieldSchema> getSortCols() {
        return this.sortCols;
    }

    public void setSortCols(List<FieldSchema> sortCols) {
        this.sortCols = sortCols;
    }

    public List<String> getSortColNames() {
        return this.sortColNames;
    }

    public void setSortColNames(List<String> sortColNames) {
        this.sortColNames = sortColNames;
    }

    @Explain(displayName="distribute columns")
    public List<String> getDistributeColsString() {
        return Utilities.getFieldSchemaString(this.distributeCols);
    }

    public List<FieldSchema> getDistributeCols() {
        return this.distributeCols;
    }

    public void setDistributeCols(List<FieldSchema> distributeCols) {
        this.distributeCols = distributeCols;
    }

    public List<String> getDistributeColNames() {
        return this.distributeColNames;
    }

    public void setDistributeColNames(List<String> distributeColNames) {
        this.distributeColNames = distributeColNames;
    }

    public Set<TableName> getTablesUsed() {
        return this.tablesUsed;
    }

    public void setTablesUsed(Set<TableName> tablesUsed) {
        this.tablesUsed = tablesUsed;
    }

    public Table toTable(HiveConf conf) throws HiveException {
        String serDeClassName;
        String[] names = Utilities.getDbTableName(this.getViewName());
        String databaseName = names[0];
        String tableName = names[1];
        Table tbl = new Table(databaseName, tableName);
        tbl.setViewOriginalText(this.getViewOriginalText());
        tbl.setViewExpandedText(this.getViewExpandedText());
        tbl.setRewriteEnabled(this.isRewriteEnabled());
        tbl.setTableType(TableType.MATERIALIZED_VIEW);
        tbl.setSerializationLib(null);
        tbl.clearSerDeInfo();
        if (this.getComment() != null) {
            tbl.setProperty("comment", this.getComment());
        }
        if (this.tblProps != null) {
            tbl.getParameters().putAll(this.tblProps);
        }
        if (!CollectionUtils.isEmpty(this.sortColNames)) {
            tbl.setProperty("materializedview.sort.columns", Utilities.encodeColumnNames(this.sortColNames));
        }
        if (!CollectionUtils.isEmpty(this.distributeColNames)) {
            tbl.setProperty("materializedview.distribute.columns", Utilities.encodeColumnNames(this.distributeColNames));
        }
        if (this.getInputFormat() != null) {
            tbl.setInputFormatClass(this.getInputFormat());
        }
        if (this.getOutputFormat() != null) {
            tbl.setOutputFormatClass(this.getOutputFormat());
        }
        if (this.getLocation() != null) {
            tbl.setDataLocation(new Path(this.getLocation()));
        }
        if (this.getStorageHandler() != null) {
            tbl.setProperty("storage_handler", this.getStorageHandler());
        }
        if (this.getSerdeProps() != null) {
            for (Map.Entry<String, String> entry : this.getSerdeProps().entrySet()) {
                tbl.setSerdeParam(entry.getKey(), entry.getValue());
            }
        }
        HiveStorageHandler storageHandler = tbl.getStorageHandler();
        DDLUtils.setColumnsAndStorePartitionTransformSpecOfTable(this.getCols(), this.getPartCols(), conf, tbl);
        if (this.getSerde() == null) {
            if (storageHandler == null) {
                serDeClassName = PlanUtils.getDefaultSerDe().getName();
                LOG.info("Default to {} for materialized view {}", (Object)serDeClassName, (Object)this.getViewName());
            } else {
                serDeClassName = storageHandler.getSerDeClass().getName();
                LOG.info("Use StorageHandler-supplied {} for materialized view {}", (Object)serDeClassName, (Object)this.getViewName());
            }
        } else {
            serDeClassName = this.getSerde();
            DDLUtils.validateSerDe(serDeClassName, conf);
        }
        tbl.setSerializationLib(serDeClassName);
        tbl.setInputFormatClass(this.getInputFormat());
        tbl.setOutputFormatClass(this.getOutputFormat());
        if (this.getInputFormat() != null && !this.getInputFormat().isEmpty()) {
            tbl.getSd().setInputFormat(tbl.getInputFormatClass().getName());
        }
        if (this.getOutputFormat() != null && !this.getOutputFormat().isEmpty()) {
            tbl.getSd().setOutputFormat(tbl.getOutputFormatClass().getName());
        }
        if (this.ownerName != null) {
            tbl.setOwner(this.ownerName);
        }
        StatsSetupConst.setStatsStateForCreateTable((Map)tbl.getTTable().getParameters(), null, (String)"false");
        return tbl;
    }
}

