/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.storage.compact;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.ServerUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.CompactionRequest;
import org.apache.hadoop.hive.metastore.api.CompactionResponse;
import org.apache.hadoop.hive.metastore.api.ShowCompactRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponseElement;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.utils.JavaUtils;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.ddl.table.storage.compact.AlterTableCompactDesc;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorUtil;
import org.apache.hadoop.hive.ql.txn.compactor.MetadataCache;

public class AlterTableCompactOperation
extends DDLOperation<AlterTableCompactDesc> {
    private static MetadataCache metadataCache = new MetadataCache(true);

    public AlterTableCompactOperation(DDLOperationContext context, AlterTableCompactDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws Exception {
        Table table = this.context.getDb().getTable(((AlterTableCompactDesc)this.desc).getTableName());
        if (!AcidUtils.isTransactionalTable(table) && !AcidUtils.isNonNativeAcidTable(table)) {
            throw new HiveException(ErrorMsg.NONACID_COMPACTION_NOT_SUPPORTED, new String[]{table.getDbName(), table.getTableName()});
        }
        if (((AlterTableCompactDesc)this.desc).getFilterExpr() != null) {
            if (!DDLUtils.isIcebergTable(table)) {
                throw new HiveException(ErrorMsg.NONICEBERG_COMPACTION_WITH_FILTER_NOT_SUPPORTED, new String[]{table.getDbName(), table.getTableName()});
            }
            if (((AlterTableCompactDesc)this.desc).getPartitionSpec() != null) {
                throw new HiveException(ErrorMsg.ICEBERG_COMPACTION_WITH_PART_SPEC_AND_FILTER_NOT_SUPPORTED, new String[]{table.getDbName(), table.getTableName()});
            }
        }
        if (((AlterTableCompactDesc)this.desc).getPartitionSpec() != null && DDLUtils.hasTransformsInPartitionSpec(table)) {
            throw new HiveException(ErrorMsg.COMPACTION_NON_IDENTITY_PARTITION_SPEC, new String[]{table.getDbName(), table.getTableName()});
        }
        Map<String, org.apache.hadoop.hive.metastore.api.Partition> partitionMap = this.convertPartitionsFromThriftToDB(this.getPartitions(table));
        TxnStore txnHandler = TxnUtils.getTxnStore((Configuration)this.context.getConf());
        CompactionRequest compactionRequest = new CompactionRequest(table.getDbName(), table.getTableName(), AcidUtils.compactionTypeStr2ThriftType(((AlterTableCompactDesc)this.desc).getCompactionType()));
        String poolName = (String)ObjectUtils.defaultIfNull((Object)((AlterTableCompactDesc)this.desc).getPoolName(), (Object)CompactorUtil.getPoolName(this.context.getConf(), table.getTTable(), metadataCache));
        compactionRequest.setPoolName(poolName);
        compactionRequest.setProperties(((AlterTableCompactDesc)this.desc).getProperties());
        compactionRequest.setInitiatorId(JavaUtils.hostname() + "-manual");
        compactionRequest.setInitiatorVersion(HiveMetaStoreClient.class.getPackage().getImplementationVersion());
        compactionRequest.setOrderByClause(((AlterTableCompactDesc)this.desc).getOrderByClause());
        if (((AlterTableCompactDesc)this.desc).getNumberOfBuckets() > 0) {
            compactionRequest.setNumberOfBuckets(((AlterTableCompactDesc)this.desc).getNumberOfBuckets());
        }
        if (((AlterTableCompactDesc)this.desc).getPartitionSpec() == null && ((AlterTableCompactDesc)this.desc).getFilterExpr() != null && !table.getStorageHandler().hasDataMatchingFilterExpr(table, ((AlterTableCompactDesc)this.desc).getFilterExpr())) {
            return 0;
        }
        if (((AlterTableCompactDesc)this.desc).getPartitionSpec() != null || !table.isPartitioned()) {
            if (((AlterTableCompactDesc)this.desc).getPartitionSpec() != null) {
                Optional partitionName = partitionMap.keySet().stream().findFirst();
                partitionName.ifPresent(arg_0 -> ((CompactionRequest)compactionRequest).setPartitionname(arg_0));
            }
            CompactionResponse compactionResponse = txnHandler.compact(compactionRequest);
            this.parseCompactionResponse(compactionResponse, table, compactionRequest.getPartitionname());
        } else {
            for (Map.Entry<String, org.apache.hadoop.hive.metastore.api.Partition> partitionMapEntry : partitionMap.entrySet()) {
                compactionRequest.setPartitionname(partitionMapEntry.getKey());
                CompactionResponse compactionResponse = CompactorUtil.initiateCompactionForPartition(table.getTTable(), partitionMapEntry.getValue(), compactionRequest, ServerUtils.hostname(), txnHandler, this.context.getConf());
                this.parseCompactionResponse(compactionResponse, table, partitionMapEntry.getKey());
            }
            if (DDLUtils.isIcebergTable(table) && table.getStorageHandler().hasUndergonePartitionEvolution(table) && (((AlterTableCompactDesc)this.desc).getFilterExpr() == null || !table.getStorageHandler().getPartitionsByExpr(table, ((AlterTableCompactDesc)this.desc).getFilterExpr(), false).isEmpty())) {
                compactionRequest.setPartitionname(null);
                CompactionResponse compactionResponse = txnHandler.compact(compactionRequest);
                this.parseCompactionResponse(compactionResponse, table, compactionRequest.getPartitionname());
            }
        }
        return 0;
    }

    private void parseCompactionResponse(CompactionResponse compactionResponse, Table table, String partitionName) throws HiveException {
        if (compactionResponse == null) {
            this.context.getConsole().printInfo("Not enough deltas to initiate compaction for table=" + table.getTableName() + "partition=" + partitionName);
            return;
        }
        if (!compactionResponse.isAccepted()) {
            if (compactionResponse.isSetErrormessage()) {
                throw new HiveException(ErrorMsg.COMPACTION_REFUSED, new String[]{table.getDbName(), table.getTableName(), partitionName == null ? "" : " partition(" + partitionName + ")", compactionResponse.getErrormessage()});
            }
            this.context.getConsole().printInfo("Compaction already enqueued with id " + compactionResponse.getId() + "; State is " + compactionResponse.getState());
            return;
        }
        this.context.getConsole().printInfo("Compaction enqueued with id " + compactionResponse.getId());
        if (((AlterTableCompactDesc)this.desc).isBlocking() && compactionResponse.isAccepted()) {
            this.waitForCompactionToFinish(compactionResponse, this.context);
        }
    }

    private List<Partition> getPartitions(Table table) throws HiveException {
        List<Partition> partitions = new ArrayList<Partition>();
        if (((AlterTableCompactDesc)this.desc).getPartitionSpec() == null && table.isPartitioned()) {
            if (DDLUtils.isIcebergTable(table)) {
                HiveStorageHandler sh = table.getStorageHandler();
                partitions = ((AlterTableCompactDesc)this.desc).getFilterExpr() != null ? sh.getPartitionsByExpr(table, ((AlterTableCompactDesc)this.desc).getFilterExpr(), true) : sh.getPartitions(table, Maps.newHashMap(), true);
            } else {
                partitions = this.context.getDb().getPartitions(table);
            }
        } else if (((AlterTableCompactDesc)this.desc).getPartitionSpec() != null) {
            Map<String, String> partitionSpec = ((AlterTableCompactDesc)this.desc).getPartitionSpec();
            partitions = this.context.getDb().getPartitions(table, partitionSpec);
            if (partitions.isEmpty()) {
                throw new HiveException(ErrorMsg.INVALID_PARTITION_SPEC);
            }
            if ((partitions = partitions.stream().filter(part -> part.getSpec().size() == partitionSpec.size()).collect(Collectors.toList())).size() != 1) {
                throw new HiveException(ErrorMsg.TOO_MANY_COMPACTION_PARTITIONS);
            }
        }
        return partitions;
    }

    private Map<String, org.apache.hadoop.hive.metastore.api.Partition> convertPartitionsFromThriftToDB(List<Partition> partitions) {
        LinkedHashMap<String, org.apache.hadoop.hive.metastore.api.Partition> partitionMap = new LinkedHashMap<String, org.apache.hadoop.hive.metastore.api.Partition>();
        partitions.forEach(partition -> partitionMap.put(partition.getName(), partition.getTPartition()));
        return partitionMap;
    }

    private void waitForCompactionToFinish(CompactionResponse resp, DDLOperationContext context) throws HiveException {
        block10: {
            block11: {
                ShowCompactResponseElement comp;
                StringBuilder progressDots = new StringBuilder();
                long waitTimeMs = 1000L;
                long waitTimeOut = HiveConf.getLongVar((Configuration)context.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_COMPACTOR_WAIT_TIMEOUT);
                block9: while (true) {
                    waitTimeMs *= 2L;
                    waitTimeMs = Math.min(waitTimeMs, waitTimeOut);
                    try {
                        Thread.sleep(waitTimeMs);
                    }
                    catch (InterruptedException ex) {
                        context.getConsole().printInfo("Interrupted while waiting for compaction with id=" + resp.getId());
                        break block10;
                    }
                    ShowCompactRequest request = new ShowCompactRequest();
                    request.setId(resp.getId());
                    ShowCompactResponse compaction = context.getDb().showCompactions(request);
                    if (compaction.getCompactsSize() != 1) break block11;
                    comp = (ShowCompactResponseElement)compaction.getCompacts().get(0);
                    LOG.debug("Response for cid: " + comp.getId() + " is " + comp.getState());
                    switch (comp.getState()) {
                        case "working": 
                        case "initiated": {
                            context.getConsole().printInfo(progressDots.toString());
                            progressDots.append(".");
                            continue block9;
                        }
                    }
                    break;
                }
                context.getConsole().printInfo("Compaction with id " + resp.getId() + " finished with status: " + comp.getState());
                break block10;
            }
            throw new HiveException("No suitable compaction found");
        }
    }
}

