/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.storage.cluster;

import java.util.List;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.table.AbstractAlterTableOperation;
import org.apache.hadoop.hive.ql.ddl.table.storage.cluster.AlterTableClusteredByDesc;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;

public class AlterTableClusteredByOperation
extends AbstractAlterTableOperation<AlterTableClusteredByDesc> {
    public AlterTableClusteredByOperation(DDLOperationContext context, AlterTableClusteredByDesc desc) {
        super(context, desc);
    }

    @Override
    protected void doAlteration(Table table, Partition partition) throws HiveException {
        StorageDescriptor sd = this.getStorageDescriptor(table, partition);
        List<String> columns = Utilities.getColumnNamesFromFieldSchema(table.getCols());
        Utilities.validateColumnNames(columns, ((AlterTableClusteredByDesc)this.desc).getBucketColumns());
        if (((AlterTableClusteredByDesc)this.desc).getSortColumns() != null) {
            Utilities.validateColumnNames(columns, Utilities.getColumnNamesFromSortCols(((AlterTableClusteredByDesc)this.desc).getSortColumns()));
        }
        sd.setBucketCols(((AlterTableClusteredByDesc)this.desc).getBucketColumns());
        sd.setNumBuckets(((AlterTableClusteredByDesc)this.desc).getNumberBuckets());
        sd.setSortCols(((AlterTableClusteredByDesc)this.desc).getSortColumns());
    }
}

