/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.storage.archive;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.ReplChangeManager;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.table.storage.archive.AlterTableArchiveUtils;
import org.apache.hadoop.hive.ql.ddl.table.storage.archive.AlterTableUnarchiveDesc;
import org.apache.hadoop.hive.ql.exec.ArchiveUtils;
import org.apache.hadoop.hive.ql.io.HdfsUtils;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class AlterTableUnarchiveOperation
extends DDLOperation<AlterTableUnarchiveDesc> {
    public AlterTableUnarchiveOperation(DDLOperationContext context, AlterTableUnarchiveDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException, URISyntaxException {
        Table table = this.context.getDb().getTable(((AlterTableUnarchiveDesc)this.desc).getTableName());
        if (table.getTableType() != TableType.MANAGED_TABLE) {
            throw new HiveException("UNARCHIVE can only be performed on managed tables");
        }
        Map<String, String> partitionSpec = ((AlterTableUnarchiveDesc)this.desc).getPartitionSpec();
        if (partitionSpec == null) {
            throw new HiveException("UNARCHIVE is for partitions only");
        }
        ArchiveUtils.PartSpecInfo partitionSpecInfo = ArchiveUtils.PartSpecInfo.create(table, partitionSpec);
        List<Partition> partitions = this.context.getDb().getPartitions(table, partitionSpec);
        Path originalDir = this.getOriginalDir(table, partitionSpecInfo, partitions);
        Path intermediateArchivedDir = AlterTableArchiveUtils.getInterMediateDir(originalDir, (Configuration)this.context.getConf(), HiveConf.ConfVars.METASTORE_INT_ARCHIVED);
        Path intermediateExtractedDir = AlterTableArchiveUtils.getInterMediateDir(originalDir, (Configuration)this.context.getConf(), HiveConf.ConfVars.METASTORE_INT_EXTRACTED);
        boolean recovery = this.isRecovery(intermediateArchivedDir, intermediateExtractedDir);
        for (Partition partition : partitions) {
            this.checkArchiveProperty(partitionSpec.size(), recovery, partition);
        }
        Path archivePath = new Path(originalDir, "data.har");
        URI archiveUri = archivePath.toUri();
        URI originalUri = ArchiveUtils.addSlash(originalDir.toUri());
        ArchiveUtils.HarPathHelper harHelper = new ArchiveUtils.HarPathHelper(this.context.getConf(), archiveUri, originalUri);
        URI sourceUri = harHelper.getHarUri(originalUri);
        Path sourceDir = new Path(sourceUri.getScheme(), sourceUri.getAuthority(), sourceUri.getPath());
        if (!HdfsUtils.pathExists(intermediateArchivedDir, (Configuration)this.context.getConf()) && !HdfsUtils.pathExists(archivePath, (Configuration)this.context.getConf())) {
            throw new HiveException("Haven't found any archive where it should be");
        }
        Path tmpPath = this.context.getContext().getExternalTmpPath(originalDir);
        FileSystem fs = null;
        try {
            fs = tmpPath.getFileSystem((Configuration)this.context.getConf());
        }
        catch (IOException e) {
            throw new HiveException((Throwable)e);
        }
        if (!recovery) {
            this.extractArchiveToIntermediateDir(intermediateExtractedDir, sourceDir, tmpPath, fs);
        }
        this.moveOriginalDirToIntermediateDir(originalDir, intermediateArchivedDir, fs);
        this.moveIntermediateExtractedDirToOriginalParent(originalDir, intermediateExtractedDir, fs);
        this.writeUnarchivationToMetastore(partitions);
        this.deleteIntermediateArchivedDir(table, intermediateArchivedDir);
        if (recovery) {
            this.context.getConsole().printInfo("Recovery after UNARCHIVE succeeded");
        }
        return 0;
    }

    private Path getOriginalDir(Table table, ArchiveUtils.PartSpecInfo partitionSpecInfo, List<Partition> partitions) throws HiveException {
        Path originalDir = null;
        if (partitions.isEmpty()) {
            throw new HiveException("No partition matches the specification");
        }
        if (partitionSpecInfo.values.size() != table.getPartCols().size()) {
            for (Partition partition : partitions) {
                if (!AlterTableArchiveUtils.partitionInCustomLocation(table, partition)) continue;
                String message = String.format("UNARCHIVE cannot run for partition groups with custom locations like %s", partition.getLocation());
                throw new HiveException(message);
            }
            originalDir = partitionSpecInfo.createPath(table);
        } else {
            Partition partition = partitions.get(0);
            originalDir = ArchiveUtils.isArchived(partition) ? new Path(AlterTableArchiveUtils.getOriginalLocation(partition)) : new Path(partition.getLocation());
        }
        return originalDir;
    }

    private boolean isRecovery(Path intermediateArchivedDir, Path intermediateExtractedDir) throws HiveException {
        if (HdfsUtils.pathExists(intermediateArchivedDir, (Configuration)this.context.getConf()) || HdfsUtils.pathExists(intermediateExtractedDir, (Configuration)this.context.getConf())) {
            this.context.getConsole().printInfo("Starting recovery after failed UNARCHIVE");
            return true;
        }
        return false;
    }

    private void checkArchiveProperty(int partitionSpecLevel, boolean recovery, Partition partition) throws HiveException {
        if (!ArchiveUtils.isArchived(partition) && !recovery) {
            throw new HiveException("Partition " + partition.getName() + " is not archived.");
        }
        int archiveLevel = ArchiveUtils.getArchivingLevel(partition);
        if (partitionSpecLevel > archiveLevel) {
            throw new HiveException("Partition " + partition.getName() + " is archived at level " + archiveLevel + ", and given partspec only has " + partitionSpecLevel + " specs.");
        }
    }

    private void extractArchiveToIntermediateDir(Path intermediateExtractedDir, Path sourceDir, Path tmpPath, FileSystem fs) throws HiveException {
        try {
            String copySource = sourceDir.toString();
            String copyDest = tmpPath.toString();
            ImmutableList args = ImmutableList.of((Object)"-cp", (Object)copySource, (Object)copyDest);
            this.context.getConsole().printInfo("Copying " + copySource + " to " + copyDest);
            FileSystem srcFs = FileSystem.get((URI)sourceDir.toUri(), (Configuration)this.context.getConf());
            srcFs.initialize(sourceDir.toUri(), (Configuration)this.context.getConf());
            FsShell fss = new FsShell((Configuration)this.context.getConf());
            int ret = 0;
            try {
                ret = ToolRunner.run((Tool)fss, (String[])args.toArray(new String[0]));
            }
            catch (Exception e) {
                throw new HiveException((Throwable)e);
            }
            if (ret != 0) {
                throw new HiveException("Error while copying files from archive, return code=" + ret);
            }
            this.context.getConsole().printInfo("Successfully Copied " + copySource + " to " + copyDest);
            this.context.getConsole().printInfo("Moving " + String.valueOf(tmpPath) + " to " + String.valueOf(intermediateExtractedDir));
            if (fs.exists(intermediateExtractedDir)) {
                throw new HiveException("Invalid state: the intermediate extracted  directory already exists.");
            }
            fs.rename(tmpPath, intermediateExtractedDir);
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    private void moveOriginalDirToIntermediateDir(Path originalDir, Path intermediateArchivedDir, FileSystem fs) throws HiveException {
        if (!HdfsUtils.pathExists(intermediateArchivedDir, (Configuration)this.context.getConf())) {
            try {
                this.context.getConsole().printInfo("Moving " + String.valueOf(originalDir) + " to " + String.valueOf(intermediateArchivedDir));
                fs.rename(originalDir, intermediateArchivedDir);
            }
            catch (IOException e) {
                throw new HiveException((Throwable)e);
            }
        } else {
            this.context.getConsole().printInfo(String.valueOf(intermediateArchivedDir) + " already exists. Assuming it contains the archived version of the partition");
        }
    }

    private void moveIntermediateExtractedDirToOriginalParent(Path originalDir, Path intermediateExtractedDir, FileSystem fs) throws HiveException {
        if (!HdfsUtils.pathExists(originalDir, (Configuration)this.context.getConf())) {
            try {
                this.context.getConsole().printInfo("Moving " + String.valueOf(intermediateExtractedDir) + " to " + String.valueOf(originalDir));
                fs.rename(intermediateExtractedDir, originalDir);
            }
            catch (IOException e) {
                throw new HiveException((Throwable)e);
            }
        } else {
            this.context.getConsole().printInfo(String.valueOf(originalDir) + " already exists. Assuming it contains the extracted files in the partition");
        }
    }

    private void writeUnarchivationToMetastore(List<Partition> partitions) throws HiveException {
        for (Partition partition : partitions) {
            this.setUnArchived(partition);
            try {
                this.context.getDb().alterPartition(((AlterTableUnarchiveDesc)this.desc).getTableName(), partition, null, true);
            }
            catch (InvalidOperationException e) {
                throw new HiveException((Throwable)e);
            }
        }
    }

    private void setUnArchived(Partition partition) {
        assert (ArchiveUtils.isArchived(partition));
        String parentDir = AlterTableArchiveUtils.getOriginalLocation(partition);
        AlterTableArchiveUtils.setIsArchived(partition, false, 0);
        AlterTableArchiveUtils.setOriginalLocation(partition, null);
        assert (parentDir != null);
        partition.setLocation(parentDir);
    }

    private void deleteIntermediateArchivedDir(Table table, Path intermediateArchivedDir) throws HiveException {
        if (HdfsUtils.pathExists(intermediateArchivedDir, (Configuration)this.context.getConf())) {
            boolean shouldEnableCm = ReplChangeManager.shouldEnableCm((Database)this.context.getDb().getDatabase(table.getDbName()), (org.apache.hadoop.hive.metastore.api.Table)table.getTTable());
            AlterTableArchiveUtils.deleteDir(intermediateArchivedDir, shouldEnableCm, (Configuration)this.context.getConf());
        }
    }
}

