/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.misc.truncate;

import java.util.ArrayList;
import java.util.Map;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.TaskQueue;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.ddl.table.misc.truncate.TruncateTableDesc;
import org.apache.hadoop.hive.ql.io.rcfile.truncate.ColumnTruncateTask;
import org.apache.hadoop.hive.ql.io.rcfile.truncate.ColumnTruncateWork;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;

public class TruncateTableOperation
extends DDLOperation<TruncateTableDesc> {
    public TruncateTableOperation(DDLOperationContext context, TruncateTableDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException {
        if (((TruncateTableDesc)this.desc).getColumnIndexes() != null) {
            ColumnTruncateWork truncateWork = new ColumnTruncateWork(((TruncateTableDesc)this.desc).getColumnIndexes(), ((TruncateTableDesc)this.desc).getInputDir(), ((TruncateTableDesc)this.desc).getOutputDir());
            truncateWork.setListBucketingCtx(((TruncateTableDesc)this.desc).getLbCtx());
            truncateWork.setMapperCannotSpanPartns(true);
            TaskQueue taskQueue = new TaskQueue();
            ColumnTruncateTask taskExec = new ColumnTruncateTask();
            taskExec.initialize(this.context.getQueryState(), null, taskQueue, null);
            taskExec.setWork(truncateWork);
            taskExec.setQueryPlan(this.context.getQueryPlan());
            int ret = taskExec.execute();
            if (taskExec.getException() != null) {
                this.context.getTask().setException(taskExec.getException());
            }
            return ret;
        }
        String tableName = ((TruncateTableDesc)this.desc).getTableName();
        Map<String, String> partSpec = ((TruncateTableDesc)this.desc).getPartSpec();
        ReplicationSpec replicationSpec = ((TruncateTableDesc)this.desc).getReplicationSpec();
        if (!DDLUtils.allowOperationInReplicationScope(this.context.getDb(), tableName, partSpec, replicationSpec)) {
            LOG.debug("DDLTask: Truncate Table/Partition is skipped as table {} / partition {} is newer than update", (Object)tableName, (Object)(partSpec == null ? "null" : FileUtils.makePartName(new ArrayList<String>(partSpec.keySet()), new ArrayList<String>(partSpec.values()))));
            return 0;
        }
        try {
            this.context.getDb().truncateTable(tableName, partSpec, replicationSpec != null && replicationSpec.isInReplicationScope() ? ((TruncateTableDesc)this.desc).getWriteId() : 0L);
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e, ErrorMsg.GENERIC_ERROR);
        }
        return 0;
    }
}

