/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.misc.owner;

import java.util.Map;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.privilege.PrincipalDesc;
import org.apache.hadoop.hive.ql.ddl.table.AbstractAlterTableAnalyzer;
import org.apache.hadoop.hive.ql.ddl.table.misc.owner.AlterTableSetOwnerDesc;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.authorization.AuthorizationParseUtils;

@DDLSemanticAnalyzerFactory.DDLType(types={886})
public class AlterTableSetOwnerAnalyzer
extends AbstractAlterTableAnalyzer {
    public AlterTableSetOwnerAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    protected void analyzeCommand(TableName tableName, Map<String, String> partitionSpecFromFramework, ASTNode command) throws SemanticException {
        PrincipalDesc ownerPrincipal = AuthorizationParseUtils.getPrincipalDesc((ASTNode)command.getChild(0));
        if (ownerPrincipal.getType() == null) {
            throw new SemanticException("Owner type can't be null in alter table set owner command");
        }
        if (ownerPrincipal.getName() == null) {
            throw new SemanticException("Owner name can't be null in alter table set owner command");
        }
        AlterTableSetOwnerDesc desc = new AlterTableSetOwnerDesc(tableName, ownerPrincipal);
        this.addInputsOutputsAlterTable(tableName, null, desc, desc.getType(), false);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc), this.conf));
        this.setAcidDdlDesc(this.getTable(tableName), desc);
    }
}

