/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.lock.show;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.metastore.api.ShowLocksRequest;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponse;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponseElement;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.ShowUtils;
import org.apache.hadoop.hive.ql.ddl.table.lock.show.ShowLocksDesc;
import org.apache.hadoop.hive.ql.lockmgr.DbLockManager;
import org.apache.hadoop.hive.ql.lockmgr.HiveLock;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockManager;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockMode;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockObject;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManager;
import org.apache.hadoop.hive.ql.lockmgr.LockException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.SessionState;

public class ShowLocksOperation
extends DDLOperation<ShowLocksDesc> {
    public ShowLocksOperation(DDLOperationContext context, ShowLocksDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException {
        Context ctx = this.context.getContext();
        HiveTxnManager txnManager = ctx.getHiveTxnManager();
        HiveLockManager lockMgr = txnManager.getLockManager();
        if (((ShowLocksDesc)this.desc).isNewFormat()) {
            return this.showLocksNewFormat(lockMgr);
        }
        return this.showLocksOldFormat(lockMgr);
    }

    private int showLocksOldFormat(HiveLockManager lockMgr) throws HiveException {
        if (lockMgr == null) {
            throw new HiveException("show Locks LockManager not specified");
        }
        try (DataOutputStream os = ShowUtils.getOutputStream(new Path(((ShowLocksDesc)this.desc).getResFile()), this.context);){
            List<HiveLock> locks = this.getLocksForOldFormat(lockMgr);
            this.writeLocksInOldFormat(os, locks);
        }
        catch (IOException e) {
            LOG.warn("show function: ", (Throwable)e);
            return 1;
        }
        catch (Exception e) {
            throw new HiveException(e.toString(), (Throwable)e);
        }
        return 0;
    }

    private List<HiveLock> getLocksForOldFormat(HiveLockManager lockMgr) throws LockException, HiveException {
        List<HiveLock> locks = null;
        if (((ShowLocksDesc)this.desc).getTableName() == null) {
            locks = lockMgr.getLocks(false, ((ShowLocksDesc)this.desc).isExt());
        } else {
            HiveLockObject lockObject = HiveLockObject.createFrom(this.context.getDb(), ((ShowLocksDesc)this.desc).getTableName(), ((ShowLocksDesc)this.desc).getPartSpec());
            locks = lockMgr.getLocks(lockObject, true, ((ShowLocksDesc)this.desc).isExt());
        }
        Collections.sort(locks, new Comparator<HiveLock>(this){

            @Override
            public int compare(HiveLock o1, HiveLock o2) {
                int cmp = o1.getHiveLockObject().getName().compareTo(o2.getHiveLockObject().getName());
                if (cmp != 0) {
                    return cmp;
                }
                if (o1.getHiveLockMode() == o2.getHiveLockMode()) {
                    return 0;
                }
                return o1.getHiveLockMode() == HiveLockMode.EXCLUSIVE ? -1 : 1;
            }
        });
        return locks;
    }

    private void writeLocksInOldFormat(DataOutputStream os, List<HiveLock> locks) throws IOException {
        for (HiveLock lock : locks) {
            HiveLockObject.HiveLockObjectData lockData;
            os.writeBytes(lock.getHiveLockObject().getDisplayName());
            os.write(9);
            os.writeBytes(lock.getHiveLockMode().toString());
            if (((ShowLocksDesc)this.desc).isExt() && (lockData = lock.getHiveLockObject().getData()) != null) {
                os.write(10);
                os.writeBytes("LOCK_QUERYID:" + lockData.getQueryId());
                os.write(10);
                os.writeBytes("LOCK_TIME:" + lockData.getLockTime());
                os.write(10);
                os.writeBytes("LOCK_MODE:" + lockData.getLockMode());
                os.write(10);
                os.writeBytes("LOCK_QUERYSTRING:" + lockData.getQueryStr());
            }
            os.write(10);
        }
    }

    private int showLocksNewFormat(HiveLockManager lockMgr) throws HiveException {
        ShowLocksResponse response = this.getLocksForNewFormat(lockMgr);
        try (DataOutputStream os = ShowUtils.getOutputStream(new Path(((ShowLocksDesc)this.desc).getResFile()), this.context);){
            ShowLocksOperation.dumpLockInfo(os, response);
        }
        catch (IOException e) {
            LOG.warn("show function: ", (Throwable)e);
            return 1;
        }
        catch (Exception e) {
            throw new HiveException(e.toString());
        }
        return 0;
    }

    private ShowLocksResponse getLocksForNewFormat(HiveLockManager lockMgr) throws HiveException, LockException {
        if (!(lockMgr instanceof DbLockManager)) {
            throw new HiveException("New lock format only supported with db lock manager.");
        }
        ShowLocksRequest request = new ShowLocksRequest();
        if (((ShowLocksDesc)this.desc).getDbName() == null && ((ShowLocksDesc)this.desc).getTableName() != null) {
            request.setDbname(SessionState.get().getCurrentDatabase());
        } else {
            request.setDbname(((ShowLocksDesc)this.desc).getDbName());
        }
        request.setTablename(((ShowLocksDesc)this.desc).getTableName());
        if (((ShowLocksDesc)this.desc).getPartSpec() != null) {
            ArrayList<String> keyList = new ArrayList<String>();
            ArrayList<String> valList = new ArrayList<String>();
            for (String partKey : ((ShowLocksDesc)this.desc).getPartSpec().keySet()) {
                String partVal = ((ShowLocksDesc)this.desc).getPartSpec().get(partKey);
                keyList.add(partKey);
                valList.add(partVal);
            }
            String partName = FileUtils.makePartName(keyList, valList);
            request.setPartname(partName);
        }
        return ((DbLockManager)lockMgr).getLocks(request);
    }

    public static void dumpLockInfo(DataOutputStream os, ShowLocksResponse response) throws IOException {
        List locks;
        SessionState sessionState = SessionState.get();
        if (!sessionState.isHiveServerQuery()) {
            os.writeBytes("Lock ID");
            os.write(9);
            os.writeBytes("Database");
            os.write(9);
            os.writeBytes("Table");
            os.write(9);
            os.writeBytes("Partition");
            os.write(9);
            os.writeBytes("State");
            os.write(9);
            os.writeBytes("Blocked By");
            os.write(9);
            os.writeBytes("Type");
            os.write(9);
            os.writeBytes("Transaction ID");
            os.write(9);
            os.writeBytes("Last Heartbeat");
            os.write(9);
            os.writeBytes("Acquired At");
            os.write(9);
            os.writeBytes("User");
            os.write(9);
            os.writeBytes("Hostname");
            os.write(9);
            os.writeBytes("Agent Info");
            os.write(10);
        }
        if ((locks = response.getLocks()) != null) {
            for (ShowLocksResponseElement lock : locks) {
                if (lock.isSetLockIdInternal()) {
                    os.writeBytes(Long.toString(lock.getLockid()) + "." + Long.toString(lock.getLockIdInternal()));
                } else {
                    os.writeBytes(Long.toString(lock.getLockid()));
                }
                os.write(9);
                os.writeBytes(lock.getDbname());
                os.write(9);
                os.writeBytes(lock.getTablename() == null ? "NULL" : lock.getTablename());
                os.write(9);
                os.writeBytes(lock.getPartname() == null ? "NULL" : lock.getPartname());
                os.write(9);
                os.writeBytes(lock.getState().toString());
                os.write(9);
                if (lock.isSetBlockedByExtId()) {
                    os.writeBytes(Long.toString(lock.getBlockedByExtId()) + "." + Long.toString(lock.getBlockedByIntId()));
                } else {
                    os.writeBytes("            ");
                }
                os.write(9);
                os.writeBytes(lock.getType().toString());
                os.write(9);
                os.writeBytes(lock.getTxnid() == 0L ? "NULL" : Long.toString(lock.getTxnid()));
                os.write(9);
                os.writeBytes(Long.toString(lock.getLastheartbeat()));
                os.write(9);
                os.writeBytes(lock.getAcquiredat() == 0L ? "NULL" : Long.toString(lock.getAcquiredat()));
                os.write(9);
                os.writeBytes(lock.getUser());
                os.write(9);
                os.writeBytes(lock.getHostname());
                os.write(9);
                os.writeBytes(lock.getAgentInfo() == null ? "NULL" : lock.getAgentInfo());
                os.write(10);
            }
        }
    }
}

