/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.info.desc.formatter;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.MaterializationSnapshot;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.common.ValidTxnWriteIdList;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.common.type.SnapshotContext;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.SourceTable;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.ql.ddl.ShowUtils;
import org.apache.hadoop.hive.ql.ddl.table.info.desc.DescTableDesc;
import org.apache.hadoop.hive.ql.ddl.table.info.desc.formatter.DescTableFormatter;
import org.apache.hadoop.hive.ql.metadata.CheckConstraint;
import org.apache.hadoop.hive.ql.metadata.DefaultConstraint;
import org.apache.hadoop.hive.ql.metadata.ForeignKeyInfo;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.NotNullConstraint;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.PrimaryKeyInfo;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.metadata.UniqueConstraint;
import org.apache.hadoop.hive.ql.parse.TransformSpec;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hive.common.util.HiveStringUtils;

class TextDescTableFormatter
extends DescTableFormatter {
    TextDescTableFormatter() {
    }

    @Override
    public void describeTable(HiveConf conf, DataOutputStream out, String columnPath, String tableName, Table table, Partition partition, List<FieldSchema> columns, boolean isFormatted, boolean isExtended, boolean isOutputPadded, List<ColumnStatisticsObj> columnStats) throws HiveException {
        try {
            boolean isIcebergMetaTable;
            this.addStatsData(out, conf, columnPath, columns, isFormatted, columnStats, isOutputPadded);
            this.addPartitionData(out, conf, columnPath, table, isFormatted, isOutputPadded);
            boolean bl = isIcebergMetaTable = table.getMetaTable() != null;
            if (columnPath == null && !isIcebergMetaTable) {
                this.addPartitionTransformData(out, table, isOutputPadded);
                if (isFormatted) {
                    this.addFormattedTableData(out, table, partition, isOutputPadded);
                }
                if (isExtended) {
                    out.write(10);
                    this.addExtendedTableData(out, table, partition);
                    this.addExtendedConstraintData(out, table);
                    this.addExtendedStorageData(out, table);
                }
            }
        }
        catch (IOException e) {
            throw new HiveException((Throwable)e);
        }
    }

    private void addPartitionTransformData(DataOutputStream out, Table table, boolean isOutputPadded) throws IOException {
        List<TransformSpec> partSpecs;
        Object partitionTransformOutput = "";
        if (table.isNonNative() && table.getStorageHandler() != null && table.getStorageHandler().supportsPartitionTransform() && (partSpecs = table.getStorageHandler().getPartitionTransformSpec(table)) != null && !partSpecs.isEmpty()) {
            ShowUtils.TextMetaDataTable metaDataTable = new ShowUtils.TextMetaDataTable();
            partitionTransformOutput = (String)partitionTransformOutput + "\n# Partition Transform Information\n# ";
            metaDataTable.addRow("col_name,transform_type#string:string".split("#")[0].split(","));
            for (TransformSpec spec : partSpecs) {
                String[] row = new String[]{spec.getColumnName(), spec.transformTypeString()};
                metaDataTable.addRow(row);
            }
            partitionTransformOutput = (String)partitionTransformOutput + metaDataTable.renderTable(isOutputPadded);
        }
        out.write(((String)partitionTransformOutput).getBytes(StandardCharsets.UTF_8));
    }

    private void addStatsData(DataOutputStream out, HiveConf conf, String columnPath, List<FieldSchema> columns, boolean isFormatted, List<ColumnStatisticsObj> columnStats, boolean isOutputPadded) throws IOException {
        Object statsData = "";
        ShowUtils.TextMetaDataTable metaDataTable = new ShowUtils.TextMetaDataTable();
        boolean needColStats = isFormatted && columnPath != null;
        boolean histogramEnabled = MetastoreConf.getBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.STATS_FETCH_KLL);
        if (needColStats) {
            metaDataTable.addRow(DescTableDesc.getColumnStatisticsHeaders(histogramEnabled).toArray(new String[0]));
        } else if (isFormatted && !SessionState.get().isHiveServerQuery()) {
            statsData = (String)statsData + "# ";
            metaDataTable.addRow("col_name,data_type,comment#string:string:string".split("#")[0].split(","));
        }
        for (FieldSchema column : columns) {
            metaDataTable.addRow(ShowUtils.extractColumnValues(column, needColStats, this.getColumnStatisticsObject(column.getName(), column.getType(), columnStats), histogramEnabled));
        }
        if (needColStats) {
            metaDataTable.transpose();
        }
        statsData = (String)statsData + metaDataTable.renderTable(isOutputPadded);
        out.write(((String)statsData).getBytes(StandardCharsets.UTF_8));
    }

    private ColumnStatisticsObj getColumnStatisticsObject(String columnName, String columnType, List<ColumnStatisticsObj> columnStats) {
        if (CollectionUtils.isNotEmpty(columnStats)) {
            for (ColumnStatisticsObj columnStat : columnStats) {
                if (!columnStat.getColName().equalsIgnoreCase(columnName) || !columnStat.getColType().equalsIgnoreCase(columnType)) continue;
                return columnStat;
            }
        }
        return null;
    }

    private void addPartitionData(DataOutputStream out, HiveConf conf, String columnPath, Table table, boolean isFormatted, boolean isOutputPadded) throws IOException {
        Object partitionData = "";
        if (columnPath == null) {
            List<FieldSchema> partitionColumns;
            List<FieldSchema> list = partitionColumns = table.isPartitioned() ? table.getPartCols() : null;
            if (CollectionUtils.isNotEmpty(partitionColumns) && conf.getBoolVar(HiveConf.ConfVars.HIVE_DISPLAY_PARTITION_COLUMNS_SEPARATELY)) {
                ShowUtils.TextMetaDataTable metaDataTable = new ShowUtils.TextMetaDataTable();
                boolean histogramEnabled = MetastoreConf.getBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.STATS_FETCH_KLL);
                partitionData = (String)partitionData + "\n# Partition Information\n# ";
                metaDataTable.addRow("col_name,data_type,comment#string:string:string".split("#")[0].split(","));
                for (FieldSchema partitionColumn : partitionColumns) {
                    metaDataTable.addRow(ShowUtils.extractColumnValues(partitionColumn, false, null, histogramEnabled));
                }
                partitionData = (String)partitionData + metaDataTable.renderTable(isOutputPadded);
            }
        } else {
            String statsState = table.getParameters().get("COLUMN_STATS_ACCURATE");
            if (table.getParameters() != null && statsState != null) {
                StringBuilder stringBuilder = new StringBuilder();
                ShowUtils.formatOutput("COLUMN_STATS_ACCURATE", isFormatted ? StringEscapeUtils.escapeJava((String)statsState) : HiveStringUtils.escapeJava((String)statsState), stringBuilder, isOutputPadded);
                partitionData = (String)partitionData + stringBuilder.toString();
            }
        }
        out.write(((String)partitionData).getBytes(StandardCharsets.UTF_8));
    }

    private void addFormattedTableData(DataOutputStream out, Table table, Partition partition, boolean isOutputPadded) throws IOException, UnsupportedEncodingException {
        Object formattedTableInfo = null;
        formattedTableInfo = partition != null ? this.getPartitionInformation(table, partition) : this.getTableInformation(table, isOutputPadded);
        if (table.getTableConstraintsInfo().isTableConstraintsInfoNotEmpty()) {
            formattedTableInfo = (String)formattedTableInfo + this.getConstraintsInformation(table);
        }
        out.write(((String)formattedTableInfo).getBytes(StandardCharsets.UTF_8));
    }

    private String getTableInformation(Table table, boolean isOutputPadded) {
        StringBuilder tableInfo = new StringBuilder(2048);
        tableInfo.append("\n").append("# Detailed Table Information").append("\n");
        this.getTableMetaDataInformation(tableInfo, table, isOutputPadded);
        tableInfo.append("\n").append("# Storage Information").append("\n");
        this.getStorageDescriptorInfo(tableInfo, table, table.getTTable().getSd());
        if (table.isView() || table.isMaterializedView()) {
            String viewInfoTitle = "# " + (table.isView() ? "" : "Materialized ") + "View Information";
            tableInfo.append("\n").append(viewInfoTitle).append("\n");
            this.getViewInfo(tableInfo, table, isOutputPadded);
        }
        return tableInfo.toString();
    }

    private String getPartitionInformation(Table table, Partition partition) {
        StringBuilder tableInfo = new StringBuilder(2048);
        tableInfo.append("\n").append("# Detailed Partition Information").append("\n");
        this.getPartitionMetaDataInformation(tableInfo, partition);
        if (partition.getTable().getTableType() != TableType.VIRTUAL_VIEW) {
            tableInfo.append("\n").append("# Storage Information").append("\n");
            this.getStorageDescriptorInfo(tableInfo, table, partition.getTPartition().getSd());
        }
        return tableInfo.toString();
    }

    private void getViewInfo(StringBuilder tableInfo, Table table, boolean isOutputPadded) {
        ShowUtils.formatOutput("Original Query:", table.getViewOriginalText(), tableInfo);
        ShowUtils.formatOutput("Expanded Query:", table.getViewExpandedText(), tableInfo);
        if (table.isMaterializedView()) {
            TextDescTableFormatter.getMaterializedViewInfo(tableInfo, table, isOutputPadded);
        }
    }

    private static void getMaterializedViewInfo(StringBuilder tableInfo, Table table, boolean isOutputPadded) {
        ShowUtils.formatOutput("Rewrite Enabled:", table.isRewriteEnabled() ? "Yes" : "No", tableInfo);
        ShowUtils.formatOutput("Outdated for Rewriting:", table.isOutdatedForRewriting() == null ? "Unknown" : (table.isOutdatedForRewriting() != false ? "Yes" : "No"), tableInfo);
        tableInfo.append("\n").append("# Materialized View Source table information").append("\n");
        ShowUtils.TextMetaDataTable metaDataTable = new ShowUtils.TextMetaDataTable();
        metaDataTable.addRow("Table name", "Snapshot");
        ArrayList<SourceTable> sourceTableList = new ArrayList<SourceTable>(table.getMVMetadata().getSourceTables());
        sourceTableList.sort(Comparator.comparing(sourceTable -> sourceTable.getTable().getDbName()).thenComparing(sourceTable -> sourceTable.getTable().getTableName()));
        MaterializationSnapshotFormatter snapshotFormatter = TextDescTableFormatter.createMaterializationSnapshotFormatter(table.getMVMetadata().getSnapshot());
        for (SourceTable sourceTable2 : sourceTableList) {
            String qualifiedTableName = TableName.getDbTable((String)sourceTable2.getTable().getDbName(), (String)sourceTable2.getTable().getTableName());
            metaDataTable.addRow(qualifiedTableName, snapshotFormatter.getSnapshotOf(qualifiedTableName));
        }
        tableInfo.append(metaDataTable.renderTable(isOutputPadded));
    }

    private static MaterializationSnapshotFormatter createMaterializationSnapshotFormatter(MaterializationSnapshot snapshot) {
        if (snapshot != null && snapshot.getTableSnapshots() != null && !snapshot.getTableSnapshots().isEmpty()) {
            return qualifiedTableName -> {
                SnapshotContext snapshotContext = (SnapshotContext)snapshot.getTableSnapshots().get(qualifiedTableName);
                if (snapshotContext == null) {
                    return "Unknown";
                }
                return String.format("SnapshotContext{snapshotId=%d}", snapshotContext.getSnapshotId());
            };
        }
        if (snapshot != null && snapshot.getValidTxnList() != null) {
            ValidTxnWriteIdList validReaderWriteIdList = ValidTxnWriteIdList.fromValue((String)snapshot.getValidTxnList());
            return qualifiedTableName -> {
                ValidWriteIdList writeIdList = validReaderWriteIdList.getTableValidWriteIdList(qualifiedTableName);
                return writeIdList != null ? writeIdList.toString().replace(qualifiedTableName, "") : "Unknown";
            };
        }
        return qualifiedTableName -> "N/A";
    }

    private void getStorageDescriptorInfo(StringBuilder tableInfo, Table table, StorageDescriptor storageDesc) {
        ShowUtils.formatOutput("SerDe Library:", storageDesc.getSerdeInfo().getSerializationLib(), tableInfo);
        ShowUtils.formatOutput("InputFormat:", storageDesc.getInputFormat(), tableInfo);
        ShowUtils.formatOutput("OutputFormat:", storageDesc.getOutputFormat(), tableInfo);
        ShowUtils.formatOutput("Compressed:", storageDesc.isCompressed() ? "Yes" : "No", tableInfo);
        if (!table.isNonNative() || table.getStorageHandler() == null || !table.getStorageHandler().supportsPartitionTransform()) {
            ShowUtils.formatOutput("Num Buckets:", String.valueOf(storageDesc.getNumBuckets()), tableInfo);
            ShowUtils.formatOutput("Bucket Columns:", storageDesc.getBucketCols().toString(), tableInfo);
        }
        String sortColumnsInfo = table.isNonNative() && table.getStorageHandler() != null && table.getStorageHandler().supportsSortColumns() ? table.getStorageHandler().sortColumns(table).toString() : storageDesc.getSortCols().toString();
        ShowUtils.formatOutput("Sort Columns:", sortColumnsInfo, tableInfo);
        if (storageDesc.isStoredAsSubDirectories()) {
            ShowUtils.formatOutput("Stored As SubDirectories:", "Yes", tableInfo);
        }
        if (storageDesc.getSkewedInfo() != null) {
            if (CollectionUtils.isNotEmpty((Collection)storageDesc.getSkewedInfo().getSkewedColNames())) {
                List skewedCoumnNames = storageDesc.getSkewedInfo().getSkewedColNames().stream().sorted().collect(Collectors.toList());
                ShowUtils.formatOutput("Skewed Columns:", skewedCoumnNames.toString(), tableInfo);
            }
            if (CollectionUtils.isNotEmpty((Collection)storageDesc.getSkewedInfo().getSkewedColValues())) {
                List skewedColumnValues = storageDesc.getSkewedInfo().getSkewedColValues().stream().sorted(new VectorComparator(this)).collect(Collectors.toList());
                ShowUtils.formatOutput("Skewed Values:", skewedColumnValues.toString(), tableInfo);
            }
            TreeMap skewedColMap = new TreeMap(new VectorComparator(this));
            skewedColMap.putAll(storageDesc.getSkewedInfo().getSkewedColValueLocationMaps());
            if (MapUtils.isNotEmpty(skewedColMap)) {
                ShowUtils.formatOutput("Skewed Value to Path:", ((Object)skewedColMap).toString(), tableInfo);
                TreeMap truncatedSkewedColMap = new TreeMap(new VectorComparator(this));
                Set entries = skewedColMap.entrySet();
                for (Map.Entry entry : entries) {
                    truncatedSkewedColMap.put((List)entry.getKey(), PlanUtils.removePrefixFromWarehouseConfig((String)entry.getValue()));
                }
                ShowUtils.formatOutput("Skewed Value to Truncated Path:", ((Object)truncatedSkewedColMap).toString(), tableInfo);
            }
        }
        if (storageDesc.getSerdeInfo().getParametersSize() > 0) {
            tableInfo.append("Storage Desc Params:").append("\n");
            this.displayAllParameters(storageDesc.getSerdeInfo().getParameters(), tableInfo);
        }
    }

    private void getTableMetaDataInformation(StringBuilder tableInfo, Table table, boolean isOutputPadded) {
        ShowUtils.formatOutput("Database:", table.getDbName(), tableInfo);
        ShowUtils.formatOutput("OwnerType:", table.getOwnerType() != null ? table.getOwnerType().name() : "null", tableInfo);
        ShowUtils.formatOutput("Owner:", table.getOwner(), tableInfo);
        ShowUtils.formatOutput("CreateTime:", this.formatDate(table.getTTable().getCreateTime()), tableInfo);
        ShowUtils.formatOutput("LastAccessTime:", this.formatDate(table.getTTable().getLastAccessTime()), tableInfo);
        ShowUtils.formatOutput("Retention:", Integer.toString(table.getRetention()), tableInfo);
        if (!table.isView()) {
            ShowUtils.formatOutput("Location:", table.getDataLocation().toString(), tableInfo);
        }
        ShowUtils.formatOutput("Table Type:", table.getTableType().name(), tableInfo);
        if (table.getParameters().size() > 0) {
            tableInfo.append("Table Parameters:").append("\n");
            this.displayAllParameters(table.getParameters(), tableInfo, false, isOutputPadded);
        }
    }

    private void getPartitionMetaDataInformation(StringBuilder tableInfo, Partition partition) {
        ShowUtils.formatOutput("Partition Value:", partition.getValues().toString(), tableInfo);
        ShowUtils.formatOutput("Database:", partition.getTPartition().getDbName(), tableInfo);
        ShowUtils.formatOutput("Table:", partition.getTable().getTableName(), tableInfo);
        ShowUtils.formatOutput("CreateTime:", this.formatDate(partition.getTPartition().getCreateTime()), tableInfo);
        ShowUtils.formatOutput("LastAccessTime:", this.formatDate(partition.getTPartition().getLastAccessTime()), tableInfo);
        ShowUtils.formatOutput("Location:", partition.getLocation(), tableInfo);
        if (partition.getTPartition().getParameters().size() > 0) {
            tableInfo.append("Partition Parameters:").append("\n");
            this.displayAllParameters(partition.getTPartition().getParameters(), tableInfo);
        }
    }

    private String formatDate(long timeInSeconds) {
        if (timeInSeconds != 0L) {
            Date date = new Date(timeInSeconds * 1000L);
            return date.toString();
        }
        return "UNKNOWN";
    }

    private void displayAllParameters(Map<String, String> params, StringBuilder tableInfo) {
        this.displayAllParameters(params, tableInfo, true, false);
    }

    private void displayAllParameters(Map<String, String> params, StringBuilder tableInfo, boolean escapeUnicode, boolean isOutputPadded) {
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            String value = params.get(key);
            if ("created_with_ctas".equals(key) || key.equals("numFilesErasureCoded") && "0".equals(value)) continue;
            tableInfo.append("\t");
            ShowUtils.formatOutput(key, escapeUnicode ? StringEscapeUtils.escapeJava((String)value) : HiveStringUtils.escapeJava((String)value), tableInfo, isOutputPadded);
        }
    }

    private String getConstraintsInformation(Table table) {
        StringBuilder constraintsInfo = new StringBuilder(2048);
        constraintsInfo.append("\n").append("# Constraints").append("\n");
        if (PrimaryKeyInfo.isNotEmpty(table.getPrimaryKeyInfo())) {
            constraintsInfo.append("\n").append("# Primary Key").append("\n");
            this.getPrimaryKeyInformation(constraintsInfo, table.getPrimaryKeyInfo());
        }
        if (ForeignKeyInfo.isNotEmpty(table.getForeignKeyInfo())) {
            constraintsInfo.append("\n").append("# Foreign Keys").append("\n");
            this.getForeignKeysInformation(constraintsInfo, table.getForeignKeyInfo());
        }
        if (UniqueConstraint.isNotEmpty(table.getUniqueKeyInfo())) {
            constraintsInfo.append("\n").append("# Unique Constraints").append("\n");
            this.getUniqueConstraintsInformation(constraintsInfo, table.getUniqueKeyInfo());
        }
        if (NotNullConstraint.isNotEmpty(table.getNotNullConstraint())) {
            constraintsInfo.append("\n").append("# Not Null Constraints").append("\n");
            this.getNotNullConstraintsInformation(constraintsInfo, table.getNotNullConstraint());
        }
        if (DefaultConstraint.isNotEmpty(table.getDefaultConstraint())) {
            constraintsInfo.append("\n").append("# Default Constraints").append("\n");
            this.getDefaultConstraintsInformation(constraintsInfo, table.getDefaultConstraint());
        }
        if (CheckConstraint.isNotEmpty(table.getCheckConstraint())) {
            constraintsInfo.append("\n").append("# Check Constraints").append("\n");
            this.getCheckConstraintsInformation(constraintsInfo, table.getCheckConstraint());
        }
        return constraintsInfo.toString();
    }

    private void getPrimaryKeyInformation(StringBuilder constraintsInfo, PrimaryKeyInfo constraint) {
        ShowUtils.formatOutput("Table:", constraint.getDatabaseName() + "." + constraint.getTableName(), constraintsInfo);
        ShowUtils.formatOutput("Constraint Name:", constraint.getConstraintName(), constraintsInfo);
        Map<Integer, String> columnNames = constraint.getColNames();
        String title = "Column Name:";
        for (String columnName : columnNames.values()) {
            constraintsInfo.append(String.format("%-20s", title) + "\t");
            ShowUtils.formatOutput(new String[]{columnName}, constraintsInfo);
        }
    }

    private void getForeignKeysInformation(StringBuilder constraintsInfo, ForeignKeyInfo constraint) {
        ShowUtils.formatOutput("Table:", constraint.getChildDatabaseName() + "." + constraint.getChildTableName(), constraintsInfo);
        Map<String, List<ForeignKeyInfo.ForeignKeyCol>> foreignKeys = constraint.getForeignKeys();
        if (MapUtils.isNotEmpty(foreignKeys)) {
            for (Map.Entry<String, List<ForeignKeyInfo.ForeignKeyCol>> entry : foreignKeys.entrySet()) {
                this.getForeignKeyRelInformation(constraintsInfo, entry.getKey(), entry.getValue());
            }
        }
    }

    private void getForeignKeyRelInformation(StringBuilder constraintsInfo, String constraintName, List<ForeignKeyInfo.ForeignKeyCol> columns) {
        ShowUtils.formatOutput("Constraint Name:", constraintName, constraintsInfo);
        if (CollectionUtils.isNotEmpty(columns)) {
            for (ForeignKeyInfo.ForeignKeyCol column : columns) {
                String[] fields = new String[]{"Parent Column Name:" + column.parentDatabaseName + "." + column.parentTableName + "." + column.parentColName, "Column Name:" + column.childColName, "Key Sequence:" + column.position};
                ShowUtils.formatOutput(fields, constraintsInfo);
            }
        }
        constraintsInfo.append("\n");
    }

    private void getUniqueConstraintsInformation(StringBuilder constraintsInfo, UniqueConstraint constraint) {
        ShowUtils.formatOutput("Table:", constraint.getDatabaseName() + "." + constraint.getTableName(), constraintsInfo);
        Map<String, List<UniqueConstraint.UniqueConstraintCol>> uniqueConstraints = constraint.getUniqueConstraints();
        if (MapUtils.isNotEmpty(uniqueConstraints)) {
            for (Map.Entry<String, List<UniqueConstraint.UniqueConstraintCol>> entry : uniqueConstraints.entrySet()) {
                this.getUniqueConstraintRelInformation(constraintsInfo, entry.getKey(), entry.getValue());
            }
        }
    }

    private void getUniqueConstraintRelInformation(StringBuilder constraintsInfo, String constraintName, List<UniqueConstraint.UniqueConstraintCol> columns) {
        ShowUtils.formatOutput("Constraint Name:", constraintName, constraintsInfo);
        if (CollectionUtils.isNotEmpty(columns)) {
            for (UniqueConstraint.UniqueConstraintCol column : columns) {
                String[] fields = new String[]{"Column Name:" + column.colName, "Key Sequence:" + column.position};
                ShowUtils.formatOutput(fields, constraintsInfo);
            }
        }
        constraintsInfo.append("\n");
    }

    private void getNotNullConstraintsInformation(StringBuilder constraintsInfo, NotNullConstraint constraint) {
        ShowUtils.formatOutput("Table:", constraint.getDatabaseName() + "." + constraint.getTableName(), constraintsInfo);
        Map<String, String> notNullConstraints = constraint.getNotNullConstraints();
        if (MapUtils.isNotEmpty(notNullConstraints)) {
            for (Map.Entry<String, String> entry : notNullConstraints.entrySet()) {
                ShowUtils.formatOutput("Constraint Name:", entry.getKey(), constraintsInfo);
                ShowUtils.formatOutput("Column Name:", entry.getValue(), constraintsInfo);
                constraintsInfo.append("\n");
            }
        }
    }

    private void getDefaultConstraintsInformation(StringBuilder constraintsInfo, DefaultConstraint constraint) {
        ShowUtils.formatOutput("Table:", constraint.getDatabaseName() + "." + constraint.getTableName(), constraintsInfo);
        Map<String, List<DefaultConstraint.DefaultConstraintCol>> defaultConstraints = constraint.getDefaultConstraints();
        if (MapUtils.isNotEmpty(defaultConstraints)) {
            for (Map.Entry<String, List<DefaultConstraint.DefaultConstraintCol>> entry : defaultConstraints.entrySet()) {
                this.getDefaultConstraintRelInformation(constraintsInfo, entry.getKey(), entry.getValue());
            }
        }
    }

    private void getDefaultConstraintRelInformation(StringBuilder constraintsInfo, String constraintName, List<DefaultConstraint.DefaultConstraintCol> columns) {
        ShowUtils.formatOutput("Constraint Name:", constraintName, constraintsInfo);
        if (CollectionUtils.isNotEmpty(columns)) {
            for (DefaultConstraint.DefaultConstraintCol column : columns) {
                String[] fields = new String[]{"Column Name:" + column.colName, "Default Value:" + column.defaultVal};
                ShowUtils.formatOutput(fields, constraintsInfo);
            }
        }
        constraintsInfo.append("\n");
    }

    private void getCheckConstraintsInformation(StringBuilder constraintsInfo, CheckConstraint constraint) {
        ShowUtils.formatOutput("Table:", constraint.getDatabaseName() + "." + constraint.getTableName(), constraintsInfo);
        Map<String, List<CheckConstraint.CheckConstraintCol>> checkConstraints = constraint.getCheckConstraints();
        if (MapUtils.isNotEmpty(checkConstraints)) {
            for (Map.Entry<String, List<CheckConstraint.CheckConstraintCol>> entry : checkConstraints.entrySet()) {
                this.getCheckConstraintRelInformation(constraintsInfo, entry.getKey(), entry.getValue());
            }
        }
    }

    private void getCheckConstraintRelInformation(StringBuilder constraintsInfo, String constraintName, List<CheckConstraint.CheckConstraintCol> columns) {
        ShowUtils.formatOutput("Constraint Name:", constraintName, constraintsInfo);
        if (CollectionUtils.isNotEmpty(columns)) {
            for (CheckConstraint.CheckConstraintCol column : columns) {
                String[] fields = new String[]{"Column Name:" + column.getColName(), "Check Value:" + column.getCheckExpression()};
                ShowUtils.formatOutput(fields, constraintsInfo);
            }
        }
        constraintsInfo.append("\n");
    }

    private void addExtendedTableData(DataOutputStream out, Table table, Partition partition) throws IOException {
        if (partition != null) {
            out.write("Detailed Partition Information".getBytes(StandardCharsets.UTF_8));
            out.write(9);
            out.write(partition.getTPartition().toString().getBytes(StandardCharsets.UTF_8));
            out.write(9);
            out.write(10);
        } else {
            out.write("Detailed Table Information".getBytes(StandardCharsets.UTF_8));
            out.write(9);
            String tableDesc = HiveStringUtils.escapeJava((String)table.getTTable().toString());
            out.write(tableDesc.getBytes(StandardCharsets.UTF_8));
            out.write(9);
            out.write(10);
        }
    }

    private void addExtendedConstraintData(DataOutputStream out, Table table) throws IOException, UnsupportedEncodingException {
        if (table.getTableConstraintsInfo().isTableConstraintsInfoNotEmpty()) {
            out.write("Constraints".getBytes(StandardCharsets.UTF_8));
            out.write(9);
            if (PrimaryKeyInfo.isNotEmpty(table.getPrimaryKeyInfo())) {
                out.write(table.getPrimaryKeyInfo().toString().getBytes(StandardCharsets.UTF_8));
                out.write(10);
            }
            if (ForeignKeyInfo.isNotEmpty(table.getForeignKeyInfo())) {
                out.write(table.getForeignKeyInfo().toString().getBytes(StandardCharsets.UTF_8));
                out.write(10);
            }
            if (UniqueConstraint.isNotEmpty(table.getUniqueKeyInfo())) {
                out.write(table.getUniqueKeyInfo().toString().getBytes(StandardCharsets.UTF_8));
                out.write(10);
            }
            if (NotNullConstraint.isNotEmpty(table.getNotNullConstraint())) {
                out.write(table.getNotNullConstraint().toString().getBytes(StandardCharsets.UTF_8));
                out.write(10);
            }
            if (DefaultConstraint.isNotEmpty(table.getDefaultConstraint())) {
                out.write(table.getDefaultConstraint().toString().getBytes(StandardCharsets.UTF_8));
                out.write(10);
            }
            if (CheckConstraint.isNotEmpty(table.getCheckConstraint())) {
                out.write(table.getCheckConstraint().toString().getBytes(StandardCharsets.UTF_8));
                out.write(10);
            }
        }
    }

    private void addExtendedStorageData(DataOutputStream out, Table table) throws IOException, UnsupportedEncodingException {
        if (table.getStorageHandlerInfo() != null) {
            out.write("StorageHandlerInfo".getBytes(StandardCharsets.UTF_8));
            out.write(10);
            out.write(table.getStorageHandlerInfo().formatAsText().getBytes(StandardCharsets.UTF_8));
            out.write(10);
        }
    }

    private static interface MaterializationSnapshotFormatter {
        public String getSnapshotOf(String var1);
    }

    private class VectorComparator<T extends Comparable<T>>
    implements Comparator<List<T>> {
        private VectorComparator(TextDescTableFormatter textDescTableFormatter) {
        }

        @Override
        public int compare(List<T> listA, List<T> listB) {
            for (int i = 0; i < listA.size() && i < listB.size(); ++i) {
                Comparable valA = (Comparable)listA.get(i);
                Comparable valB = (Comparable)listB.get(i);
                if (valA != null) {
                    int ret = valA.compareTo(valB);
                    if (ret == 0) continue;
                    return ret;
                }
                if (valB == null) continue;
                return -1;
            }
            return Integer.compare(listA.size(), listB.size());
        }
    }
}

