/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.database.create;

import java.io.Serializable;
import java.util.Map;
import org.apache.hadoop.hive.metastore.api.DatabaseType;
import org.apache.hadoop.hive.ql.ddl.DDLDesc;
import org.apache.hadoop.hive.ql.plan.Explain;

@Explain(displayName="Create Database", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class CreateDatabaseDesc
implements DDLDesc,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String databaseName;
    private final String comment;
    private final String locationUri;
    private final String managedLocationUri;
    private final boolean ifNotExists;
    private final DatabaseType dbType;
    private final String connectorName;
    private final String remoteDbName;
    private final Map<String, String> dbProperties;

    public CreateDatabaseDesc(String databaseName, String comment, String locationUri, String managedLocationUri, boolean ifNotExists, Map<String, String> dbProperties) {
        this(databaseName, comment, locationUri, managedLocationUri, ifNotExists, dbProperties, "NATIVE", null, null);
    }

    public CreateDatabaseDesc(String databaseName, String comment, String locationUri, String managedLocationUri, boolean ifNotExists, Map<String, String> dbProperties, String dbtype, String connectorName, String remoteDbName) {
        this.databaseName = databaseName;
        this.comment = comment;
        if (dbtype != null && dbtype.equalsIgnoreCase("REMOTE")) {
            this.dbType = DatabaseType.REMOTE;
            this.connectorName = connectorName;
            this.remoteDbName = remoteDbName;
            this.locationUri = null;
            this.managedLocationUri = null;
        } else {
            this.dbType = DatabaseType.NATIVE;
            this.locationUri = locationUri;
            this.managedLocationUri = managedLocationUri;
            this.connectorName = null;
            this.remoteDbName = null;
        }
        this.ifNotExists = ifNotExists;
        this.dbProperties = dbProperties;
    }

    @Explain(displayName="if not exists", displayOnlyOnTrue=true)
    public boolean getIfNotExists() {
        return this.ifNotExists;
    }

    public Map<String, String> getDatabaseProperties() {
        return this.dbProperties;
    }

    @Explain(displayName="name", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getName() {
        return this.databaseName;
    }

    @Explain(displayName="comment")
    public String getComment() {
        return this.comment;
    }

    @Explain(displayName="locationUri")
    public String getLocationUri() {
        return this.locationUri;
    }

    @Explain(displayName="managed location uri")
    public String getManagedLocationUri() {
        return this.managedLocationUri;
    }

    @Explain(displayName="database type")
    public DatabaseType getDatabaseType() {
        return this.dbType;
    }

    @Explain(displayName="connector name")
    public String getConnectorName() {
        return this.connectorName;
    }

    @Explain(displayName="remote database name")
    public String getRemoteDbName() {
        return this.remoteDbName;
    }
}

