/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.catalog.desc;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.hive.common.type.CalendarUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.ddl.ShowUtils;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.formatting.MapBuilder;
import org.apache.hadoop.hive.ql.metadata.formatting.MetaDataFormatUtils;
import org.apache.hive.common.util.HiveStringUtils;

abstract class DescCatalogFormatter {
    DescCatalogFormatter() {
    }

    static DescCatalogFormatter getFormatter(HiveConf hiveConf) {
        if (MetaDataFormatUtils.isJson(hiveConf)) {
            return new JsonDescCatalogFormatter();
        }
        return new TextDescCatalogFormatter();
    }

    abstract void showCatalogDescription(DataOutputStream var1, String var2, String var3, String var4, int var5) throws HiveException;

    static class JsonDescCatalogFormatter
    extends DescCatalogFormatter {
        JsonDescCatalogFormatter() {
        }

        @Override
        void showCatalogDescription(DataOutputStream out, String catalog, String comment, String location, int createTime) throws HiveException {
            MapBuilder builder = MapBuilder.create().put("catalog", catalog).put("comment", comment).put("location", location);
            if (createTime != 0) {
                builder.put("createTime", CalendarUtils.formatTimestamp((long)((long)createTime * 1000L), (boolean)true));
            }
            ShowUtils.asJson(out, builder.build());
        }
    }

    static class TextDescCatalogFormatter
    extends DescCatalogFormatter {
        TextDescCatalogFormatter() {
        }

        @Override
        void showCatalogDescription(DataOutputStream out, String catalog, String comment, String location, int createTime) throws HiveException {
            try {
                this.writeLine(out, "Catalog Name", catalog);
                if (comment != null) {
                    this.writeLine(out, "Comment", HiveStringUtils.escapeJava((String)comment));
                }
                if (location != null) {
                    this.writeLine(out, "Location", location);
                }
                if (createTime != 0) {
                    String createTimeStr = CalendarUtils.formatTimestamp((long)((long)createTime * 1000L), (boolean)true);
                    this.writeLine(out, "CreateTime", createTimeStr);
                }
            }
            catch (IOException e) {
                throw new HiveException((Throwable)e);
            }
        }

        private void writeLine(DataOutputStream out, String label, String value) throws IOException {
            out.write(label.getBytes(StandardCharsets.UTF_8));
            out.write(9);
            out.write(value.getBytes(StandardCharsets.UTF_8));
            out.write(10);
        }
    }
}

