/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.cleanup;

import java.io.IOException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.cleanup.CleanupService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncCleanupService
implements CleanupService {
    private static final Logger LOG = LoggerFactory.getLogger((String)SyncCleanupService.class.getName());
    public static SyncCleanupService INSTANCE = new SyncCleanupService();

    private SyncCleanupService() {
    }

    @Override
    public void start() {
    }

    @Override
    public boolean deleteRecursive(Path path, FileSystem fileSystem) throws IOException {
        fileSystem.cancelDeleteOnExit(path);
        if (fileSystem.delete(path, true)) {
            LOG.info("Deleted directory: {} on fs with scheme {}", (Object)path, (Object)fileSystem.getScheme());
            return true;
        }
        return false;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void shutdownNow() {
    }
}

