/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import java.util.function.Supplier;
import org.apache.hadoop.hive.conf.HiveConf;

public class ServiceContext {
    private final String clusterId;
    private final Supplier<String> host;
    private final Supplier<Integer> port;

    public ServiceContext(Supplier<String> host, Supplier<Integer> port) {
        this.host = host;
        this.port = port;
        this.clusterId = ServiceContext.findClusterId();
    }

    public static String findClusterId() {
        return System.getProperty("hive.cluster.id", ServiceContext.getClusterIdFromEnv());
    }

    private static String getClusterIdFromEnv() {
        return System.getenv("HIVE_CLUSTER_ID") == null ? "" : System.getenv("HIVE_CLUSTER_ID");
    }

    public void setClusterIdInConf(HiveConf hiveConf) {
        hiveConf.set("hive.cluster.id", this.clusterId);
    }

    public String getHost() {
        return this.host.get();
    }

    public int getPort() {
        return this.port.get();
    }

    public String getClusterId() {
        return this.clusterId;
    }
}

