/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.io.CacheTag;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.LlapUtil;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.HdfsUtils;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.mapred.JobConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LlapHiveUtils {
    public static final Logger LOG = LoggerFactory.getLogger(LlapHiveUtils.class);

    private LlapHiveUtils() {
    }

    public static PartitionDesc partitionDescForPath(Path path, Map<Path, PartitionDesc> partitionDescMap) {
        assert (partitionDescMap != null);
        Path parentPath = path;
        PartitionDesc part = partitionDescMap.get(parentPath);
        while (!parentPath.isRoot() && part == null) {
            parentPath = parentPath.getParent();
            part = partitionDescMap.get(parentPath);
        }
        return part;
    }

    public static CacheTag getDbAndTableNameForMetrics(Path path, boolean includeParts, PartitionDesc part) {
        if (part == null) {
            return CacheTag.build((String)LlapUtil.getDbAndTableNameForMetrics((Path)path, (boolean)includeParts));
        }
        if (!includeParts || !part.isPartitioned()) {
            return CacheTag.build((String)part.getTableName());
        }
        return CacheTag.build((String)part.getTableName(), part.getPartSpec());
    }

    public static int getSchemaHash(PartitionDesc part) {
        if (part == null) {
            return -1;
        }
        Object columnTypes = part.getProperties().get("columns.types");
        if (columnTypes != null) {
            return columnTypes.toString().hashCode();
        }
        return -1;
    }

    public static MapWork findMapWork(JobConf job) {
        String inputName = job.get("iocontext.input.name", null);
        LOG.debug("Initializing for input {}", (Object)inputName);
        String prefixes = job.get("hive.tez.merge.file.prefixes");
        if (prefixes != null && !StringUtils.isBlank((CharSequence)prefixes)) {
            return null;
        }
        BaseWork work = null;
        if (!(inputName == null || prefixes != null && Lists.newArrayList((Object[])prefixes.split(",")).contains(inputName))) {
            inputName = null;
        }
        if (inputName != null) {
            work = Utilities.getMergeWork((Configuration)job, inputName);
        }
        if (!(work instanceof MapWork)) {
            work = Utilities.getMapWork((Configuration)job);
        }
        return (MapWork)work;
    }

    public static void throwIfCacheOnlyRead(boolean isCacheOnlyRead) throws IOException {
        if (isCacheOnlyRead) {
            throw new IOException("LLAP cache miss happened while reading. Aborting query as cache only reading is set. Set " + HiveConf.ConfVars.LLAP_IO_CACHE_ONLY.varname + " to false and repeat query if this was unintended.");
        }
    }

    public static boolean isLlapMode(Configuration conf) {
        return "llap".equalsIgnoreCase(HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_EXECUTION_MODE));
    }

    public static Object createFileIdUsingFS(FileSystem fs, Path path, Configuration daemonConf) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Will invoke HdfsUtils.getFileId - this is costly on cloud file systems. Turn on TRACE level logging to show call trace.");
            if (LOG.isTraceEnabled()) {
                LOG.trace(Arrays.deepToString(Thread.currentThread().getStackTrace()));
            }
        }
        boolean allowSynthetic = HiveConf.getBoolVar((Configuration)daemonConf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_CACHE_ALLOW_SYNTHETIC_FILEID);
        boolean checkDefaultFs = HiveConf.getBoolVar((Configuration)daemonConf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_CACHE_DEFAULT_FS_FILE_ID);
        boolean forceSynthetic = !HiveConf.getBoolVar((Configuration)daemonConf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_IO_USE_FILEID_PATH);
        return HdfsUtils.getFileId(fs, path, allowSynthetic, checkDefaultFs, forceSynthetic);
    }
}

